/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles;

import com.brandon3055.draconicevolution.client.render.Particles;
import com.brandon3055.draconicevolution.common.blocks.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.core.handler.ParticleHandler;
import com.brandon3055.draconicevolution.common.core.utills.LogHelper;
import com.brandon3055.draconicevolution.common.entity.EntityCustomDragon;
import com.brandon3055.draconicevolution.common.entity.ExtendedPlayer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class TileEnderResurrection
extends TileEntity {
    private MultiblockHelper.TileLocation[] diamondPillars = new MultiblockHelper.TileLocation[4];
    private MultiblockHelper.TileLocation[] draconiumPillars = new MultiblockHelper.TileLocation[4];
    private ExtendedPlayer playerProps;
    private EntityPlayer owner;
    private boolean spawnInProgress = false;
    private int timer = 0;
    private double level = 0.0;

    public TileEnderResurrection() {
        int i;
        for (i = 0; i < this.diamondPillars.length; ++i) {
            this.diamondPillars[i] = new MultiblockHelper.TileLocation();
        }
        for (i = 0; i < this.draconiumPillars.length; ++i) {
            this.draconiumPillars[i] = new MultiblockHelper.TileLocation();
        }
    }

    public void func_145845_h() {
        if (this.spawnInProgress) {
            if (this.timer % 10 == 0 && !this.arePillarsValid() || !this.isBaseValid()) {
                this.spawnInProgress = false;
            }
            this.effectDrive();
            this.findAndActivateChrystals(this.timer - 200, true);
            if (this.timer > 2390 && this.arePillarsValid() && this.isBaseValid()) {
                this.spawn();
                this.spawnInProgress = false;
            }
            this.timer = this.timer < 556 || this.timer > 2300 ? ++this.timer : (this.timer += 2);
        }
    }

    private void spawn() {
        int i;
        if (this.owner == null) {
            return;
        }
        for (i = 0; i < this.diamondPillars.length; ++i) {
            if (this.diamondPillars[i] == null) {
                return;
            }
            this.field_145850_b.func_147468_f(this.diamondPillars[i].getXCoord(), this.diamondPillars[i].getYCoord(), this.diamondPillars[i].getZCoord());
            if (this.field_145850_b.field_72995_K) continue;
            this.field_145850_b.func_72876_a((Entity)this.owner, (double)this.diamondPillars[i].getXCoord() + 0.5, (double)this.diamondPillars[i].getYCoord() + 0.5, (double)this.diamondPillars[i].getZCoord() + 0.5, 3.0f, true);
        }
        for (i = 0; i < this.draconiumPillars.length; ++i) {
            if (this.draconiumPillars[i] == null) {
                return;
            }
            this.field_145850_b.func_147468_f(this.draconiumPillars[i].getXCoord(), this.draconiumPillars[i].getYCoord(), this.draconiumPillars[i].getZCoord());
            if (this.field_145850_b.field_72995_K) continue;
            this.field_145850_b.func_72876_a((Entity)this.owner, (double)this.draconiumPillars[i].getXCoord() + 0.5, (double)this.draconiumPillars[i].getYCoord() + 0.5, (double)this.draconiumPillars[i].getZCoord() + 0.5, 3.0f, true);
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72876_a((Entity)this.owner, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 3.0f, true);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 10.0f, false);
        }
        if (this.level > 10.0) {
            this.level = 10.0;
        }
        EntityCustomDragon dragon = new EntityCustomDragon(this.field_145850_b, 200.0 + this.level * 50.0, 10.0f + (float)this.level * 5.0f);
        dragon.func_70107_b(this.field_145851_c, this.field_145848_d + 60, this.field_145849_e);
        dragon.func_110161_a(null);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72838_d((Entity)dragon);
        }
        this.playerProps.setSpawnCount(this.playerProps.getSpawnCount() + 1);
    }

    private void lEffects() {
        int x = -100 + this.field_145850_b.field_73012_v.nextInt(200);
        int z = -100 + this.field_145850_b.field_73012_v.nextInt(200);
        EntityLightningBolt bolt = new EntityLightningBolt(this.field_145850_b, (double)x, (double)(this.field_145850_b.func_72825_h(z, z) - 1), (double)z);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72942_c((Entity)bolt);
        }
        EntityPlayer p = this.field_145850_b.func_72977_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 100.0);
        float yaw = p.field_70177_z;
        float pitch = p.field_70125_A;
        float mod = 0.1f;
        yaw += this.field_145850_b.field_73012_v.nextBoolean() ? mod : -mod;
        pitch += this.field_145850_b.field_73012_v.nextBoolean() ? mod : -mod;
        if (this.field_145850_b.field_72995_K) {
            p.func_70012_b(p.field_70165_t, p.field_70163_u - 1.6, p.field_70161_v, yaw, pitch);
        }
    }

    private void effectDrive() {
        if (this.timer == 1 || this.field_145850_b.field_73012_v.nextInt(50) == 0) {
            this.randomBolt();
        }
        if (this.timer > 100 && this.field_145850_b.field_73012_v.nextInt(Math.max(1, 50 - this.timer / 40)) == 0) {
            this.randomBolt();
        }
        if (this.timer == 10 || this.timer == 20 || this.timer == 30 || this.timer == 40) {
            this.draconiumStrikes(this.timer / 10);
        }
        if (this.field_145850_b.field_73012_v.nextInt(50) == 0) {
            this.draconiumStrikes(this.field_145850_b.field_73012_v.nextInt(4) + 1);
        }
        if (this.timer > 60 && this.field_145850_b.field_72995_K) {
            this.coreParticles();
        }
        this.findAndActivateChrystals(this.timer, false);
        this.findAndActivateChrystals(this.timer - 50, false);
        this.findAndActivateChrystals(this.timer - 100, false);
        if (this.field_145850_b.field_73012_v.nextInt(50) == 0 && this.timer < 300) {
            this.centreStrike();
        }
    }

    private void draconiumStrikes(int pillar) {
        if (pillar != 1 && pillar != 2 && pillar != 3 && pillar != 4) {
            return;
        }
        if (this.draconiumPillars[--pillar] == null) {
            return;
        }
        EntityLightningBolt bolt = new EntityLightningBolt(this.field_145850_b, (double)this.draconiumPillars[pillar].getXCoord(), (double)this.draconiumPillars[pillar].getYCoord(), (double)this.draconiumPillars[pillar].getZCoord());
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72942_c((Entity)bolt);
        }
    }

    private void findAndActivateChrystals(int y, boolean spawnCrystal) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (y < 0 || y > 250) {
            return;
        }
        for (int x = -200; x < 200; ++x) {
            for (int z = -200; z < 200; ++z) {
                if (this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150357_h) continue;
                boolean flag = true;
                for (int x1 = x - 1; x1 <= x + 1; ++x1) {
                    for (int y1 = y - 1; y1 <= y + 1; ++y1) {
                        for (int z1 = z - 1; z1 <= z + 1; ++z1) {
                            if (x1 == x && y1 == y && z1 == z || this.field_145850_b.func_147439_a(x1, y1, z1) != Blocks.field_150357_h) continue;
                            flag = false;
                        }
                    }
                }
                if (!flag || this.field_145850_b.field_72995_K) continue;
                if (spawnCrystal) {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    nbttagcompound.func_74778_a("id", "EnderCrystal");
                    Entity crystal = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)this.field_145850_b);
                    crystal.func_70107_b((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
                    this.field_145850_b.func_72838_d(crystal);
                    continue;
                }
                this.field_145850_b.func_72942_c((Entity)new EntityLightningBolt(this.field_145850_b, (double)x, (double)(y + 1), (double)z));
            }
        }
    }

    private void centreStrike() {
        EntityLightningBolt bolt = new EntityLightningBolt(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72942_c((Entity)bolt);
        }
    }

    private void randomBolt() {
        int x = -100 + this.field_145850_b.field_73012_v.nextInt(200);
        int z = -100 + this.field_145850_b.field_73012_v.nextInt(200);
        EntityLightningBolt bolt = new EntityLightningBolt(this.field_145850_b, (double)x, (double)(this.field_145850_b.func_72825_h(z, z) - 1), (double)z);
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72942_c((Entity)bolt);
        }
    }

    public boolean onActivated(EntityPlayer player) {
        boolean flag = true;
        if (player.field_71093_bK != 1) {
            return true;
        }
        if (this.field_145851_c > 80 || this.field_145849_e > 80 || this.field_145851_c < -80 || this.field_145849_e < -80) {
            if (this.field_145850_b.field_72995_K) {
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("msg.SpawnDragonToFarFrom00.txt", new Object[0]));
            }
            return false;
        }
        this.playerProps = ExtendedPlayer.get(player);
        this.owner = player;
        if (this.spawnInProgress) {
            for (int i = 0; i < this.draconiumPillars.length; ++i) {
                if (this.draconiumPillars[i] == null || !this.arePillarsValid()) {
                    return false;
                }
                this.field_145850_b.func_147449_b(this.draconiumPillars[i].getXCoord(), this.draconiumPillars[i].getYCoord(), this.draconiumPillars[i].getZCoord(), (Block)ModBlocks.draconium);
            }
            flag = false;
        }
        if (!this.isBaseValid()) {
            flag = false;
        }
        if (!this.findPillars()) {
            flag = false;
        }
        if (!this.arePillarsValid()) {
            flag = false;
        }
        if (!this.spawnInProgress && flag) {
            this.timer = 0;
        }
        this.spawnInProgress = flag;
        this.level = (double)this.playerProps.getSpawnCount() / 2.0;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (flag && !this.field_145850_b.field_72995_K) {
            LogHelper.info("Starting Ritual of Ender Resurrection (Level " + this.level + ")");
        }
        return flag;
    }

    private boolean isBaseValid() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e) != Blocks.field_150343_Z || this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e) != Blocks.field_150343_Z || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1) != Blocks.field_150343_Z || this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1) != Blocks.field_150343_Z) {
            return false;
        }
        return this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 1) == Blocks.field_150426_aN && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 1) == Blocks.field_150426_aN && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 1) == Blocks.field_150426_aN && this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 1) == Blocks.field_150426_aN;
    }

    private boolean arePillarsValid() {
        int i;
        for (i = 0; i < this.diamondPillars.length; ++i) {
            if (this.diamondPillars[i] == null) {
                return false;
            }
            if (this.field_145850_b.func_147439_a(this.diamondPillars[i].getXCoord(), this.diamondPillars[i].getYCoord(), this.diamondPillars[i].getZCoord()) == Blocks.field_150484_ah && this.field_145850_b.func_147439_a(this.diamondPillars[i].getXCoord(), this.diamondPillars[i].getYCoord() - 1, this.diamondPillars[i].getZCoord()) == Blocks.field_150371_ca) continue;
            return false;
        }
        for (i = 0; i < this.draconiumPillars.length; ++i) {
            if (this.draconiumPillars[i] == null) {
                return false;
            }
            if ((this.field_145850_b.func_147439_a(this.draconiumPillars[i].getXCoord(), this.draconiumPillars[i].getYCoord(), this.draconiumPillars[i].getZCoord()) == ModBlocks.draconium || this.field_145850_b.func_72805_g(this.draconiumPillars[i].getXCoord(), this.draconiumPillars[i].getYCoord(), this.draconiumPillars[i].getZCoord()) == 2) && this.field_145850_b.func_147439_a(this.draconiumPillars[i].getXCoord(), this.draconiumPillars[i].getYCoord() - 1, this.draconiumPillars[i].getZCoord()) == Blocks.field_150371_ca && this.field_145850_b.func_147439_a(this.draconiumPillars[i].getXCoord(), this.draconiumPillars[i].getYCoord() - 2, this.draconiumPillars[i].getZCoord()) == Blocks.field_150371_ca) continue;
            return false;
        }
        return true;
    }

    private boolean findPillars() {
        int z;
        int y;
        int x;
        int xzRange = 6;
        int draconiumCount = 0;
        int diamondCount = 0;
        for (x = this.field_145851_c - xzRange; x < this.field_145851_c + xzRange; ++x) {
            for (y = this.field_145848_d + 2; y < this.field_145848_d + 5; ++y) {
                for (z = this.field_145849_e - xzRange; z < this.field_145849_e + xzRange; ++z) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.draconium || !this.isPillarValid(0, x, y, z) || this.field_145850_b.func_72805_g(x, y, z) != 2 || draconiumCount >= 4) continue;
                    this.draconiumPillars[draconiumCount] = new MultiblockHelper.TileLocation(x, y, z);
                    ++draconiumCount;
                }
            }
        }
        for (x = this.field_145851_c - xzRange; x < this.field_145851_c + xzRange; ++x) {
            for (y = this.field_145848_d + 1; y < this.field_145848_d + 4; ++y) {
                for (z = this.field_145849_e - xzRange; z < this.field_145849_e + xzRange; ++z) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != Blocks.field_150484_ah || !this.isPillarValid(1, x, y, z) || diamondCount >= 4) continue;
                    this.diamondPillars[diamondCount] = new MultiblockHelper.TileLocation(x, y, z);
                    ++diamondCount;
                }
            }
        }
        return draconiumCount == 4 && diamondCount == 4;
    }

    @SideOnly(value=Side.CLIENT)
    private void coreParticles() {
        Random rand = new Random();
        float mM = 0.4f;
        for (int i = 0; i < this.draconiumPillars.length; ++i) {
            if (this.draconiumPillars[i] == null) {
                return;
            }
            Particles.AdvancedSeekerParticle particle = new Particles.AdvancedSeekerParticle(this.field_145850_b, (double)this.draconiumPillars[i].getXCoord() + 0.5, (double)this.draconiumPillars[i].getYCoord() + 0.5, (double)this.draconiumPillars[i].getZCoord() + 0.5, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 2, 0.0f, 1.0f, 1.0f, 100);
            Particles.AdvancedSeekerParticle particle2 = this.timer < 300 ? new Particles.AdvancedSeekerParticle(this.field_145850_b, (double)this.draconiumPillars[i].getXCoord() + 0.5, (double)this.draconiumPillars[i].getYCoord() + 0.5, (double)this.draconiumPillars[i].getZCoord() + 0.5, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 1, 1.0f, 0.0f, 0.0f, 40) : new Particles.AdvancedSeekerParticle(this.field_145850_b, (double)this.draconiumPillars[i].getXCoord() + 0.5, (double)this.draconiumPillars[i].getYCoord() + 0.5, (double)this.draconiumPillars[i].getZCoord() + 0.5, (float)this.field_145851_c + rand.nextFloat(), (float)(this.field_145848_d + 3) + rand.nextFloat(), (float)this.field_145849_e + rand.nextFloat(), 3, 1.0f, 0.0f, 0.0f, 70, this.timer);
            if (this.timer > 2000) {
                Particles.AdvancedSeekerParticle toDiamond = new Particles.AdvancedSeekerParticle(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, (float)this.diamondPillars[i].getXCoord() + rand.nextFloat(), (float)this.diamondPillars[i].getYCoord() + rand.nextFloat(), (float)this.diamondPillars[i].getZCoord() + rand.nextFloat(), 3, 0.0f, 1.0f, 0.0f, 100);
                ParticleHandler.spawnCustomParticle(toDiamond, 250.0);
                if (this.timer > 2100) {
                    Particles.AdvancedSeekerParticle toSpawn = new Particles.AdvancedSeekerParticle(this.field_145850_b, (float)this.diamondPillars[i].getXCoord() + rand.nextFloat(), (float)this.diamondPillars[i].getYCoord() + rand.nextFloat(), (float)this.diamondPillars[i].getZCoord() + rand.nextFloat(), (double)this.field_145851_c - 3.5 + (double)(rand.nextFloat() * 7.0f), this.field_145848_d + 60 + rand.nextInt(5), (double)this.field_145849_e - 3.5 + (double)(rand.nextFloat() * 7.0f), 3, 0.0f, 1.0f, 0.0f, 100, this.timer);
                    ParticleHandler.spawnCustomParticle(toSpawn, 250.0);
                }
            }
            particle.field_70159_w = ((double)rand.nextFloat() - 0.5) * (double)mM;
            particle.field_70179_y = ((double)rand.nextFloat() - 0.5) * (double)mM;
            particle2.field_70159_w = ((double)rand.nextFloat() - 0.5) * (double)mM;
            particle2.field_70179_y = ((double)rand.nextFloat() - 0.5) * (double)mM;
            ParticleHandler.spawnCustomParticle(particle, 250.0);
            ParticleHandler.spawnCustomParticle(particle2, 250.0);
        }
        if (this.timer > 300) {
            int t = this.timer > 700 ? this.timer : 700;
            Particles.AdvancedSeekerParticle particle3 = new Particles.AdvancedSeekerParticle(this.field_145850_b, (float)this.field_145851_c + rand.nextFloat(), (double)this.field_145848_d + 0.5, (float)this.field_145849_e + rand.nextFloat(), (float)this.field_145851_c + rand.nextFloat(), (float)(this.field_145848_d + 3) + rand.nextFloat(), (float)this.field_145849_e + rand.nextFloat(), 3, 0.0f, 1.0f, 1.0f, 70, t);
            ParticleHandler.spawnCustomParticle(particle3, 250.0);
        }
        if (this.timer > 1000) {
            float blue;
            float f = rand.nextFloat() * 0.6f + 0.4f;
            float green = blue = 1.0f * f;
            float red = blue;
            Particles.AdvancedSeekerParticle particle4 = new Particles.AdvancedSeekerParticle(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 3.5, (double)this.field_145849_e + 0.5, (float)this.field_145851_c + rand.nextFloat(), (float)(this.field_145848_d + 3) + rand.nextFloat(), (float)this.field_145849_e + rand.nextFloat(), 1, red *= 0.9f, green *= 0.3f, blue, 100);
            particle4.field_70159_w = ((double)rand.nextFloat() - 0.5) * (double)mM;
            particle4.field_70179_y = ((double)rand.nextFloat() - 0.5) * (double)mM;
            ParticleHandler.spawnCustomParticle(particle4, 250.0);
        }
    }

    private boolean isPillarValid(int type, int x, int y, int z) {
        return type == 0 ? this.field_145850_b.func_147439_a(x, y - 1, z) == Blocks.field_150371_ca && this.field_145850_b.func_147439_a(x, y - 2, z) == Blocks.field_150371_ca && this.field_145850_b.func_72805_g(x, y - 1, z) == 2 && this.field_145850_b.func_72805_g(x, y - 2, z) == 2 : type == 1 && this.field_145850_b.func_147439_a(x, y - 1, z) == Blocks.field_150371_ca && this.field_145850_b.func_72805_g(x, y - 1, z) == 2;
    }

    public void func_145841_b(NBTTagCompound compound) {
        int i;
        super.func_145841_b(compound);
        compound.func_74757_a("SpawnInProgress", this.spawnInProgress);
        compound.func_74768_a("Timer", this.timer);
        for (i = 0; i < this.diamondPillars.length; ++i) {
            if (this.diamondPillars[i] == null) continue;
            this.diamondPillars[i].writeToNBT(compound, String.valueOf(i));
        }
        for (i = 0; i < this.draconiumPillars.length; ++i) {
            if (this.draconiumPillars[i] == null) continue;
            this.draconiumPillars[i].writeToNBT(compound, "D" + String.valueOf(i));
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        int i;
        super.func_145839_a(compound);
        this.spawnInProgress = compound.func_74767_n("SpawnInProgress");
        this.timer = compound.func_74762_e("Timer");
        for (i = 0; i < this.diamondPillars.length; ++i) {
            if (this.diamondPillars[i] == null) continue;
            this.diamondPillars[i].readFromNBT(compound, String.valueOf(i));
        }
        for (i = 0; i < this.draconiumPillars.length; ++i) {
            if (this.draconiumPillars[i] == null) continue;
            this.draconiumPillars[i].readFromNBT(compound, "D" + String.valueOf(i));
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.func_145841_b(tagCompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, tagCompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

