/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.tileentities.multiblocktiles;

import cofh.api.energy.IEnergyHandler;
import com.brandon3055.draconicevolution.client.render.Particles;
import com.brandon3055.draconicevolution.common.blocks.ModBlocks;
import com.brandon3055.draconicevolution.common.blocks.multiblock.MultiblockHelper;
import com.brandon3055.draconicevolution.common.core.handler.ParticleHandler;
import com.brandon3055.draconicevolution.common.core.utills.EnergyStorage;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileEnergyStorageCore;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEnergyPylon
extends TileEntity
implements IEnergyHandler {
    protected EnergyStorage storage = new EnergyStorage(500000, 0, 0);
    public boolean active = false;
    public boolean input = false;
    public float modelRotation = 0.0f;
    public float modelScale = 0.0f;
    private MultiblockHelper.TileLocation masterLocation = new MultiblockHelper.TileLocation();
    private int particleRate = 0;
    private int updateDelay = 0;
    private boolean nextUpdate = false;

    public void func_145845_h() {
        if (this.nextUpdate) {
            this.updateDelay = 0;
            this.nextUpdate = false;
        }
        if (this.active && this.field_145850_b.field_72995_K) {
            this.modelRotation = (float)((double)this.modelRotation + 1.5);
            this.modelScale += this.input ? -0.01f : 0.01f;
            if (this.modelScale < 0.0f && this.input) {
                this.modelScale = 10000.0f;
            }
            if (this.modelScale < 0.0f && !this.input) {
                this.modelScale = 0.0f;
            }
            this.spawnParticles();
        } else if (this.field_145850_b.field_72995_K) {
            this.modelScale = 0.5f;
        }
        if (this.active && this.input) {
            this.updateInput();
        } else if (this.active) {
            this.updateOutput();
        }
    }

    public void onActivated() {
        if (!this.active) {
            this.active = this.isValidStructure();
        }
        this.findMaster();
        if (this.input) {
            this.storage.setMaxReceive(0);
            this.storage.setMaxExtract(500000);
        } else {
            this.storage.setMaxReceive(500000);
            this.storage.setMaxExtract(0);
        }
    }

    private void updateInput() {
        if (this.updateDelay > 0) {
            --this.updateDelay;
            if (this.particleRate > 0) {
                --this.particleRate;
            }
        } else if (this.getMaster() != null && this.getMaster().isOnline() && this.storage.getEnergyStored() < this.storage.getMaxEnergyStored() && this.getMaster().getEnergyStored() > 0.0) {
            int maxRecived = (int)Math.min((double)(this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()), this.getMaster().getEnergyStored());
            this.storage.modifyEnergyStored(maxRecived);
            this.getMaster().extractEnergy(maxRecived, false);
            this.particleRate = maxRecived / 80;
            if (this.particleRate > 100) {
                this.particleRate = 100;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            if (this.particleRate > 0) {
                --this.particleRate;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.updateDelay = 20;
        }
        if (this.storage.getEnergyStored() > 0) {
            for (int i = 0; i < 6; ++i) {
                TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + ForgeDirection.getOrientation((int)i).offsetX, this.field_145848_d + ForgeDirection.getOrientation((int)i).offsetY, this.field_145849_e + ForgeDirection.getOrientation((int)i).offsetZ);
                if (tile == null || !(tile instanceof IEnergyHandler)) continue;
                this.storage.extractEnergy(((IEnergyHandler)tile).receiveEnergy(ForgeDirection.getOrientation((int)i).getOpposite(), this.storage.extractEnergy(this.storage.getMaxExtract(), true), false), false);
            }
        }
    }

    private void updateOutput() {
        if (this.getMaster() == null || !this.getMaster().isOnline()) {
            return;
        }
        if (this.updateDelay > 0) {
            --this.updateDelay;
            if (this.particleRate > 0) {
                --this.particleRate;
            }
        } else if (this.storage.getEnergyStored() > 0 && this.getMaster().isOnline() && this.getMaster().getEnergyStored() < this.getMaster().getMaxEnergyStored()) {
            int maxSent = (int)Math.min(this.getMaster().getMaxEnergyStored() - this.getMaster().getEnergyStored(), (double)this.storage.getEnergyStored());
            this.storage.modifyEnergyStored(-maxSent);
            this.getMaster().receiveEnergy(maxSent, false);
            this.particleRate = maxSent / 80;
            if (this.particleRate > 100) {
                this.particleRate = 100;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else {
            if (this.particleRate > 0) {
                --this.particleRate;
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.updateDelay = 20;
        }
    }

    private TileEnergyStorageCore getMaster() {
        return this.field_145850_b.func_147438_o(this.masterLocation.getXCoord(), this.masterLocation.getYCoord(), this.masterLocation.getZCoord()) != null && this.field_145850_b.func_147438_o(this.masterLocation.getXCoord(), this.masterLocation.getYCoord(), this.masterLocation.getZCoord()) instanceof TileEnergyStorageCore ? (TileEnergyStorageCore)this.field_145850_b.func_147438_o(this.masterLocation.getXCoord(), this.masterLocation.getYCoord(), this.masterLocation.getZCoord()) : null;
    }

    private void findMaster() {
        int yMod = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? 3 : -3;
        int range = 15;
        for (int x = this.field_145851_c - range; x <= this.field_145851_c + range; ++x) {
            for (int y = this.field_145848_d + yMod - range / 4; y <= this.field_145848_d + yMod + range / 4; ++y) {
                for (int z = this.field_145849_e - range; z <= this.field_145849_e + range; ++z) {
                    if (this.field_145850_b.func_147439_a(x, y, z) != ModBlocks.energyStorageCore) continue;
                    this.masterLocation = new MultiblockHelper.TileLocation(x, y, z);
                    return;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        float disMod;
        TileEnergyStorageCore master;
        Random rand = new Random();
        int x = this.masterLocation.getXCoord();
        int y = this.masterLocation.getYCoord();
        int z = this.masterLocation.getZCoord();
        int cYCoord = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 1 ? this.field_145848_d + 1 : this.field_145848_d - 1;
        TileEnergyStorageCore tileEnergyStorageCore = master = this.field_145850_b.func_147438_o(x, y, z) != null && this.field_145850_b.func_147438_o(x, y, z) instanceof TileEnergyStorageCore ? (TileEnergyStorageCore)this.field_145850_b.func_147438_o(x, y, z) : null;
        if (master == null || !master.isOnline()) {
            return;
        }
        float f = master.getTier() == 0 ? 0.5f : (master.getTier() == 1 ? 1.0f : (master.getTier() == 2 ? 1.0f : (master.getTier() == 3 ? 2.0f : (master.getTier() == 4 ? 2.0f : (disMod = master.getTier() == 5 ? 3.0f : 4.0f)))));
        if (this.particleRate > 20) {
            this.particleRate = 20;
        }
        if (this.input) {
            Particles.EnergyTransferParticle passiveParticle;
            double spawnX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double spawnY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double spawnZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double targetX = (double)this.field_145851_c + 0.5;
            double targetY = (double)cYCoord + 0.5;
            double targetZ = (double)this.field_145849_e + 0.5;
            if (rand.nextFloat() < 0.05f) {
                passiveParticle = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, true);
                ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
            }
            if (this.particleRate > 0) {
                if (this.particleRate > 10) {
                    for (int i = 0; i <= this.particleRate / 10; ++i) {
                        spawnX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        spawnY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        spawnZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        Particles.EnergyTransferParticle passiveParticle2 = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, false);
                        ParticleHandler.spawnCustomParticle(passiveParticle2, 35.0);
                    }
                } else if (rand.nextInt(Math.max(1, 10 - this.particleRate)) == 0) {
                    spawnX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    spawnY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    spawnZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    passiveParticle = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, false);
                    ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
                }
            }
        } else {
            Particles.EnergyTransferParticle passiveParticle;
            double targetX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double targetY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double targetZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
            double spawnX = (double)this.field_145851_c + 0.5;
            double spawnY = (double)cYCoord + 0.5;
            double spawnZ = (double)this.field_145849_e + 0.5;
            if (rand.nextFloat() < 0.05f) {
                passiveParticle = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, true);
                ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
            }
            if (this.particleRate > 0) {
                if (this.particleRate > 10) {
                    for (int i = 0; i <= this.particleRate / 10; ++i) {
                        targetX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        targetY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        targetZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                        Particles.EnergyTransferParticle passiveParticle3 = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, false);
                        ParticleHandler.spawnCustomParticle(passiveParticle3, 35.0);
                    }
                } else if (rand.nextInt(Math.max(1, 10 - this.particleRate)) == 0) {
                    targetX = (double)x + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    targetY = (double)y + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    targetZ = (double)z + 0.5 - (double)disMod + (double)(rand.nextFloat() * (disMod * 2.0f));
                    passiveParticle = new Particles.EnergyTransferParticle(this.field_145850_b, spawnX, spawnY, spawnZ, targetX, targetY, targetZ, false);
                    ParticleHandler.spawnCustomParticle(passiveParticle, 35.0);
                }
            }
        }
    }

    private boolean isValidStructure() {
        return !(!this.isGlass(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && !this.isGlass(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) || this.isGlass(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e) && this.isGlass(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e));
    }

    private boolean isGlass(int x, int y, int z) {
        return this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.invisibleMultiblock && this.field_145850_b.func_72805_g(x, y, z) == 2;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.storage.readFromNBT(compound);
        this.active = compound.func_74767_n("Active");
        this.input = compound.func_74767_n("Input");
        this.masterLocation.readFromNBT(compound, "Master");
        this.particleRate = compound.func_74765_d("ParticleRate");
        if (this.input) {
            this.storage.setMaxReceive(0);
            this.storage.setMaxExtract(500000);
        } else {
            this.storage.setMaxReceive(500000);
            this.storage.setMaxExtract(0);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        this.storage.writeToNBT(compound);
        compound.func_74757_a("Active", this.active);
        compound.func_74757_a("Input", this.input);
        this.masterLocation.writeToNBT(compound, "Master");
        compound.func_74777_a("ParticleRate", (short)this.particleRate);
    }

    public Packet func_145844_m() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.func_145841_b(nbttagcompound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbttagcompound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        this.nextUpdate = true;
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        this.nextUpdate = true;
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

