/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.world;

import com.brandon3055.draconicevolution.common.blocks.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenEnderComet
extends WorldGenerator {
    private int spawnX;
    private int spawnY;
    private int spawnZ;
    private int tailX;
    private int tailY;
    private int tailZ;
    private int size;

    private void initialize(Random rand, int x, int y, int z) {
        this.spawnX = x;
        this.spawnY = y;
        this.spawnZ = z;
        double rotation = rand.nextInt();
        double xmod = Math.sin(rotation);
        double zmod = Math.cos(rotation);
        int distMod = 150 + rand.nextInt(50);
        this.tailX = x + (int)(xmod * (double)distMod);
        this.tailY = y + 40 + rand.nextInt(40);
        this.tailZ = z + (int)(zmod * (double)distMod);
        this.size = 2 + rand.nextInt(8);
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        this.initialize(random, x, y, z);
        this.generateCore(world, random, this.size);
        this.generateTrail(world, random);
        return true;
    }

    private void generateCore(World world, Random rand, int r) {
        for (int x = this.spawnX - r; x <= this.spawnX + r; ++x) {
            for (int z = this.spawnZ - r; z <= this.spawnZ + r; ++z) {
                for (int y = this.spawnY - r; y <= this.spawnY + r; ++y) {
                    if ((int)WorldGenEnderComet.getDistance(x, y, z, this.spawnX, this.spawnY, this.spawnZ) > r) continue;
                    float genP = rand.nextFloat();
                    if (0.1f > genP) {
                        world.func_147465_d(x, y, z, (Block)ModBlocks.draconiumOre, 0, 2);
                        continue;
                    }
                    if (0.4f > genP) {
                        world.func_147465_d(x, y, z, Blocks.field_150343_Z, 0, 2);
                        continue;
                    }
                    world.func_147465_d(x, y, z, Blocks.field_150377_bs, 0, 2);
                }
            }
        }
    }

    private void generateTrail(World world, Random rand) {
        int xDiff = this.tailX - this.spawnX;
        int yDiff = this.tailY - this.spawnY;
        int zDiff = this.tailZ - this.spawnZ;
        for (int p = 0; p < 100; p += 2) {
            int cX = this.spawnX + (int)((float)p / 100.0f * (float)xDiff);
            int cY = this.spawnY + (int)((float)p / 100.0f * (float)yDiff);
            int cZ = this.spawnZ + (int)((float)p / 100.0f * (float)zDiff);
            float pc = (float)p / 100.0f;
            int density = 500 - (int)(pc * 550.0f);
            if (density < 20) {
                density = 20;
            }
            WorldGenEnderComet.generateTrailSphere(world, cX, cY, cZ, this.size + 3 - (int)(pc * (float)(this.size - 2)), density, rand);
            density = 1000 - (int)(pc * 10000.0f);
            WorldGenEnderComet.generateTrailSphere(world, cX, cY, cZ, this.size + 3 - (int)(pc * (float)(this.size - 2)), density, rand);
        }
    }

    public static void generateTrailSphere(World world, int xi, int yi, int zi, int r, int density, Random rand) {
        if (density <= 0) {
            return;
        }
        if (density > 10000) {
            density = 10000;
        }
        for (int x = xi - r; x <= xi + r; ++x) {
            for (int z = zi - r; z <= zi + r; ++z) {
                for (int y = yi - r; y <= yi + r; ++y) {
                    if (density < rand.nextInt(10000) || !world.func_147437_c(x, y, z) || (int)WorldGenEnderComet.getDistance(x, y, z, xi, yi, zi) != r) continue;
                    if (0.9f >= rand.nextFloat()) {
                        world.func_147465_d(x, y, z, Blocks.field_150377_bs, 0, 2);
                        continue;
                    }
                    if (rand.nextBoolean()) {
                        world.func_147465_d(x, y, z, Blocks.field_150343_Z, 0, 2);
                        continue;
                    }
                    world.func_147465_d(x, y, z, (Block)ModBlocks.draconiumOre, 0, 2);
                }
            }
        }
    }

    public static double getDistance(int x1, int y1, int z1, int x2, int y2, int z2) {
        int dx = x1 - x2;
        int dy = y1 - y2;
        int dz = z1 - z2;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }
}

