/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.wands.foci;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.IWandFocus;
import thaumcraft.api.wands.ItemFocusBasic;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.items.wands.ItemWandCasting;

public class ItemFocusFire
extends ItemFocusBasic {
    private static final AspectList cost = new AspectList().add(Aspect.FIRE, 10);
    long soundDelay = 0L;

    public ItemFocusFire() {
        this.func_77637_a(Thaumcraft.tabTC);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("thaumcraft:focus_fire");
    }

    @Override
    public String getSortingHelper(ItemStack itemstack) {
        return "AF" + super.getSortingHelper(itemstack);
    }

    @Override
    public int getFocusColor() {
        return 15028484;
    }

    @Override
    public AspectList getVisCost() {
        return cost;
    }

    @Override
    public boolean isVisCostPerTick() {
        return true;
    }

    @Override
    public ItemStack onFocusRightClick(ItemStack itemstack, World world, EntityPlayer player, MovingObjectPosition movingobjectposition) {
        player.func_71008_a(itemstack, Integer.MAX_VALUE);
        return itemstack;
    }

    @Override
    public void onUsingFocusTick(ItemStack itemstack, EntityPlayer p, int count) {
        ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
        if (!wand.consumeAllVis(itemstack, p, this.getVisCost(), false, false)) {
            p.func_71034_by();
            return;
        }
        int range = 17;
        Vec3 vec3d = p.func_70676_i((float)range);
        if (!p.field_70170_p.field_72995_K && this.soundDelay < System.currentTimeMillis()) {
            p.field_70170_p.func_72956_a((Entity)p, "thaumcraft:fireloop", 0.25f, 2.0f);
            this.soundDelay = System.currentTimeMillis() + 500L;
        }
        if (p.field_70170_p.field_72995_K) {
            UtilsFX.shootFire(p.field_70170_p, p, true, range);
        } else if (wand.consumeAllVis(itemstack, p, this.getVisCost(), true, false)) {
            this.getTargets(itemstack, p.field_70170_p, vec3d, p, range);
        }
    }

    private void getTargets(ItemStack itemstack, World world, Vec3 tvec, EntityPlayer p, double range) {
        ItemWandCasting wand = (ItemWandCasting)itemstack.func_77973_b();
        int potency = wand.getFocusPotency(itemstack);
        Entity pointedEntity = null;
        Vec3 vec3d = Vec3.func_72443_a((double)p.field_70165_t, (double)p.field_70163_u, (double)p.field_70161_v);
        Vec3 vec3d2 = vec3d.func_72441_c(tvec.field_72450_a * range, tvec.field_72448_b * range, tvec.field_72449_c * range);
        float f1 = 1.0f;
        List list = world.func_72839_b((Entity)p, p.field_70121_D.func_72321_a(tvec.field_72450_a * range, tvec.field_72448_b * range, tvec.field_72449_c * range).func_72314_b((double)f1, (double)f1, (double)f1));
        for (int i = 0; i < list.size(); ++i) {
            float f2;
            AxisAlignedBB axisalignedbb;
            MovingObjectPosition movingobjectposition;
            Entity entity = (Entity)list.get(i);
            if (!entity.func_70067_L() || (movingobjectposition = (axisalignedbb = entity.field_70121_D.func_72314_b((double)(f2 = Math.max(1.0f, entity.func_70111_Y())), (double)(f2 * 1.25f), (double)f2)).func_72327_a(vec3d, vec3d2)) == null || (pointedEntity = entity) == null || !p.func_70685_l(pointedEntity) || pointedEntity.func_70045_F() || pointedEntity instanceof EntityPlayer && !MinecraftServer.func_71276_C().func_71219_W()) continue;
            pointedEntity.func_70015_d(4 + potency);
            pointedEntity.func_70097_a((DamageSource)new EntityDamageSource("inFire", (Entity)p), (float)(2 + potency));
        }
    }

    @Override
    public IWandFocus.WandFocusAnimation getAnimation() {
        return IWandFocus.WandFocusAnimation.CHARGE;
    }
}

