/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.items.equipment;

import com.google.common.collect.ImmutableSet;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.IRepairable;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.lib.utils.BlockUtils;
import thaumcraft.common.lib.utils.InventoryUtils;

public class ItemElementalShovel
extends ItemSpade
implements IRepairable {
    private static final Block[] isEffective = new Block[]{Blocks.field_150349_c, Blocks.field_150346_d, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150431_aC, Blocks.field_150433_aE, Blocks.field_150435_aG, Blocks.field_150458_ak, Blocks.field_150425_aM, Blocks.field_150391_bh};
    public IIcon icon;
    int side = 0;

    public ItemElementalShovel(Item.ToolMaterial enumtoolmaterial) {
        super(enumtoolmaterial);
        this.func_77637_a(Thaumcraft.tabTC);
    }

    public Set<String> getToolClasses(ItemStack stack) {
        return ImmutableSet.of((Object)"shovel");
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return 3;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.icon = ir.func_94245_a("thaumcraft:elementalshovel");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int par1) {
        return this.icon;
    }

    public EnumRarity func_77613_e(ItemStack itemstack) {
        return EnumRarity.rare;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77969_a(new ItemStack(ConfigItems.itemResource, 1, 2)) ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    public boolean func_77648_a(ItemStack itemstack, EntityPlayer player, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        int xm = ForgeDirection.getOrientation((int)side).offsetX;
        int ym = ForgeDirection.getOrientation((int)side).offsetY;
        int zm = ForgeDirection.getOrientation((int)side).offsetZ;
        Block bi = world.func_147439_a(x, y, z);
        int md = world.func_72805_g(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (te == null) {
            for (int aa = -1; aa <= 1; ++aa) {
                for (int bb = -1; bb <= 1; ++bb) {
                    int xx = 0;
                    int yy = 0;
                    int zz = 0;
                    if (side <= 1) {
                        xx = aa;
                        zz = bb;
                    } else if (side <= 3) {
                        xx = aa;
                        yy = bb;
                    } else {
                        zz = aa;
                        yy = bb;
                    }
                    Block b2 = world.func_147439_a(x + xx + xm, y + yy + ym, z + zz + zm);
                    if (!world.func_147437_c(x + xx + xm, y + yy + ym, z + zz + zm) && b2 != Blocks.field_150395_bd && b2 != Blocks.field_150329_H && b2.func_149688_o() != Material.field_151586_h && b2 != Blocks.field_150330_I && !b2.isReplaceable((IBlockAccess)world, x + xx + xm, y + yy + ym, z + zz + zm)) continue;
                    if (InventoryUtils.consumeInventoryItem(player, Item.func_150898_a((Block)bi), md)) {
                        world.func_72980_b((double)(x + xx + xm), (double)(y + yy + ym), (double)(z + zz + zm), bi.field_149762_H.func_150496_b(), 0.6f, 0.9f + world.field_73012_v.nextFloat() * 0.2f, false);
                        world.func_147465_d(x + xx + xm, y + yy + ym, z + zz + zm, bi, md, 3);
                        itemstack.func_77972_a(1, (EntityLivingBase)player);
                        Thaumcraft.proxy.blockSparkle(world, x + xx + xm, y + yy + ym, z + zz + zm, 3, 4);
                        player.func_71038_i();
                        continue;
                    }
                    if (bi != Blocks.field_150349_c || !InventoryUtils.consumeInventoryItem(player, Item.func_150898_a((Block)Blocks.field_150346_d), 0)) continue;
                    world.func_72980_b((double)(x + xx + xm), (double)(y + yy + ym), (double)(z + zz + zm), bi.field_149762_H.func_150496_b(), 0.6f, 0.9f + world.field_73012_v.nextFloat() * 0.2f, false);
                    world.func_147465_d(x + xx + xm, y + yy + ym, z + zz + zm, Blocks.field_150346_d, 0, 3);
                    itemstack.func_77972_a(1, (EntityLivingBase)player);
                    Thaumcraft.proxy.blockSparkle(world, x + xx + xm, y + yy + ym, z + zz + zm, 3, 4);
                    player.func_71038_i();
                }
            }
        }
        return false;
    }

    private boolean isEffectiveAgainst(Block block) {
        int var3 = 0;
        while (true) {
            if (var3 >= isEffective.length) break;
            if (isEffective[var3] == block) {
                return true;
            }
            ++var3;
        }
        return false;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        MovingObjectPosition movingobjectposition = BlockUtils.getTargetBlock(player.field_70170_p, (Entity)player, true);
        if (movingobjectposition != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.side = movingobjectposition.field_72310_e;
        }
        return super.onBlockStartBreak(itemstack, X, Y, Z, player);
    }

    public boolean func_150894_a(ItemStack stack, World world, Block bi, int x, int y, int z, EntityLivingBase ent) {
        int md;
        if (ent.func_70093_af()) {
            return super.func_150894_a(stack, world, bi, x, y, z, ent);
        }
        if (!ent.field_70170_p.field_72995_K && (ForgeHooks.isToolEffective((ItemStack)stack, (Block)bi, (int)(md = world.func_72805_g(x, y, z))) || this.isEffectiveAgainst(bi))) {
            for (int aa = -1; aa <= 1; ++aa) {
                for (int bb = -1; bb <= 1; ++bb) {
                    int xx = 0;
                    int yy = 0;
                    int zz = 0;
                    if (this.side <= 1) {
                        xx = aa;
                        zz = bb;
                    } else if (this.side <= 3) {
                        xx = aa;
                        yy = bb;
                    } else {
                        zz = aa;
                        yy = bb;
                    }
                    if (ent instanceof EntityPlayer && !world.func_72962_a((EntityPlayer)ent, x + xx, y + yy, z + zz)) continue;
                    Block bl = world.func_147439_a(x + xx, y + yy, z + zz);
                    md = world.func_72805_g(x + xx, y + yy, z + zz);
                    if (!(bl.func_149712_f(world, x + xx, y + yy, z + zz) >= 0.0f) || !ForgeHooks.isToolEffective((ItemStack)stack, (Block)bl, (int)md) && !this.isEffectiveAgainst(bl)) continue;
                    stack.func_77972_a(1, ent);
                    BlockUtils.harvestBlock(world, (EntityPlayer)ent, x + xx, y + yy, z + zz, true, 3);
                }
            }
        }
        return true;
    }
}

