/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.renderer.GLAllocation;
import org.lwjgl.opengl.GL11;

public class GLTextureBufferedImage
extends BufferedImage {
    private static final ByteBuffer buffer = GLAllocation.func_74524_c((int)262144);
    private static final HashMap<Integer, GLTextureBufferedImage> registerImage = new HashMap();
    private static final Lock lock = new ReentrantLock();
    public byte[] data;
    private int register;
    private boolean magFiltering;
    private boolean minFiltering;
    private boolean clampTexture;

    private GLTextureBufferedImage(ColorModel cm, WritableRaster raster, boolean isRasterPremultiplied, Hashtable<?, ?> properties) {
        super(cm, raster, isRasterPremultiplied, properties);
        this.data = ((DataBufferByte)raster.getDataBuffer()).getData();
    }

    public static GLTextureBufferedImage create(int w, int h) {
        ColorSpace colorspace1 = ColorSpace.getInstance(1000);
        int[] bits = new int[]{8, 8, 8, 8};
        int[] bandOffsets = new int[]{0, 1, 2, 3};
        ComponentColorModel colorModel = new ComponentColorModel(colorspace1, bits, true, false, 3, 0);
        WritableRaster raster = Raster.createInterleavedRaster(0, w, h, w * 4, 4, bandOffsets, (Point)null);
        return new GLTextureBufferedImage(colorModel, raster, false, (Hashtable)null);
    }

    public static GLTextureBufferedImage create(BufferedImage image) {
        GLTextureBufferedImage img = GLTextureBufferedImage.create(image.getWidth(), image.getHeight());
        Graphics g = img.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int register() {
        int i;
        lock.lock();
        try {
            if (this.register == 0) {
                int i2;
                this.register = GL11.glGenTextures();
                GL11.glBindTexture((int)3553, (int)this.register);
                GL11.glTexParameteri((int)3553, (int)10241, (int)(this.minFiltering ? 9729 : 9728));
                GL11.glTexParameteri((int)3553, (int)10240, (int)(this.magFiltering ? 9729 : 9728));
                int clamp = this.clampTexture ? 10496 : 10497;
                GL11.glTexParameteri((int)3553, (int)10242, (int)clamp);
                GL11.glTexParameteri((int)3553, (int)10243, (int)clamp);
                buffer.clear();
                buffer.put(this.data);
                buffer.flip();
                GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)this.getWidth(), (int)this.getHeight(), (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
                registerImage.put(this.register, this);
                int n = i2 = this.register;
                return n;
            }
            GL11.glBindTexture((int)3553, (int)this.register);
            GL11.glTexParameteri((int)3553, (int)10241, (int)(this.minFiltering ? 9729 : 9728));
            GL11.glTexParameteri((int)3553, (int)10240, (int)(this.magFiltering ? 9729 : 9728));
            int clamp = this.clampTexture ? 10496 : 10497;
            GL11.glTexParameteri((int)3553, (int)10242, (int)clamp);
            GL11.glTexParameteri((int)3553, (int)10243, (int)clamp);
            buffer.clear();
            buffer.put(this.data);
            buffer.flip();
            GL11.glTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)this.getWidth(), (int)this.getHeight(), (int)6408, (int)5121, (ByteBuffer)buffer);
            i = this.register;
        }
        finally {
            lock.unlock();
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean bind() {
        boolean flag;
        lock.lock();
        try {
            if (this.register != 0) {
                boolean flag2;
                GL11.glBindTexture((int)3553, (int)this.register);
                boolean bl = flag2 = true;
                return bl;
            }
            flag = false;
        }
        finally {
            lock.unlock();
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister() {
        lock.lock();
        try {
            if (this.register == 0) {
                return;
            }
            GL11.glDeleteTextures((int)this.register);
            this.register = 0;
            registerImage.remove(this.register);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(int id) {
        lock.lock();
        try {
            GLTextureBufferedImage image = registerImage.get(id);
            if (image != null) {
                image.unregister();
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void setMagFilter(boolean b) {
        this.magFiltering = b;
    }

    public void setMinFilter(boolean b) {
        this.minFiltering = b;
    }

    public int getId() {
        return this.register;
    }

    public boolean getMagFilter() {
        return this.magFiltering;
    }

    public boolean getMinFilter() {
        return this.minFiltering;
    }

    public void setClampTexture(boolean b) {
        this.clampTexture = b;
    }

    public boolean isClampTexture() {
        return this.clampTexture;
    }

    public void setRGBA(int x, int y, byte r, byte g, byte b, byte a) {
        int i = (y * this.getWidth() + x) * 4;
        this.data[i++] = r;
        this.data[i++] = g;
        this.data[i++] = b;
        this.data[i] = a;
    }

    public void setRGB(int x, int y, byte r, byte g, byte b) {
        int i = (y * this.getWidth() + x) * 4;
        this.data[i++] = r;
        this.data[i++] = g;
        this.data[i++] = b;
        this.data[i] = -1;
    }

    @Override
    public void setRGB(int x, int y, int rgb) {
        int i = (y * this.getWidth() + x) * 4;
        this.data[i++] = (byte)(rgb >> 16);
        this.data[i++] = (byte)(rgb >> 8);
        this.data[i++] = (byte)(rgb >> 0);
        this.data[i] = (byte)(rgb >> 24);
    }

    public static void createTexture(int[] data, int w, int h, int name, boolean blur, boolean clamp) {
        byte[] bs = new byte[w * h * 4];
        int j = data.length;
        int k = 0;
        for (int i = 0; i < j; ++i) {
            int pixel = data[i];
            bs[k++] = (byte)(pixel >> 16);
            bs[k++] = (byte)(pixel >> 8);
            bs[k++] = (byte)(pixel >> 0);
            bs[k++] = (byte)(pixel >> 24);
        }
        GLTextureBufferedImage.createTexture(bs, w, h, name, blur, clamp);
    }

    public static void createTexture(byte[] data, int w, int h, int name, boolean blur, boolean clamp) {
        GL11.glBindTexture((int)3553, (int)name);
        GL11.glTexParameteri((int)3553, (int)10241, (int)(blur ? 9729 : 9728));
        GL11.glTexParameteri((int)3553, (int)10240, (int)(blur ? 9729 : 9728));
        GL11.glTexParameteri((int)3553, (int)10242, (int)(clamp ? 10496 : 10497));
        GL11.glTexParameteri((int)3553, (int)10243, (int)(clamp ? 10496 : 10497));
        buffer.clear();
        buffer.put(data);
        buffer.flip();
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)w, (int)h, (int)0, (int)6408, (int)5121, (ByteBuffer)buffer);
    }
}

