/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

public class PixelColor {
    static final float d = 0.003921569f;
    public boolean alphaComposite;
    public float red;
    public float green;
    public float blue;
    public float alpha;

    public PixelColor() {
        this(true);
    }

    public PixelColor(boolean alphaComposite) {
        this.alphaComposite = alphaComposite;
    }

    public void clear() {
        this.alpha = 0.0f;
        this.blue = 0.0f;
        this.green = 0.0f;
        this.red = 0.0f;
    }

    public void composite(int argb) {
        this.composite(argb, 1.0f);
    }

    public void composite(int argb, float light) {
        if (this.alphaComposite) {
            float a = (float)(argb >> 24 & 0xFF) * 0.003921569f;
            float r = (float)(argb >> 16 & 0xFF) * 0.003921569f * light;
            float g = (float)(argb >> 8 & 0xFF) * 0.003921569f * light;
            float b = (float)(argb >> 0 & 0xFF) * 0.003921569f * light;
            this.red += (r - this.red) * a;
            this.green += (g - this.green) * a;
            this.blue += (b - this.blue) * a;
            this.alpha += (1.0f - this.alpha) * a;
        } else {
            this.alpha = (float)(argb >> 24 & 0xFF) * 0.003921569f;
            this.red = (float)(argb >> 16 & 0xFF) * 0.003921569f * light;
            this.green = (float)(argb >> 8 & 0xFF) * 0.003921569f * light;
            this.blue = (float)(argb >> 0 & 0xFF) * 0.003921569f * light;
        }
    }

    public void composite(float alpha, int rgb, float light) {
        if (this.alphaComposite) {
            float r = (float)(rgb >> 16 & 0xFF) * 0.003921569f * light;
            float g = (float)(rgb >> 8 & 0xFF) * 0.003921569f * light;
            float b = (float)(rgb >> 0 & 0xFF) * 0.003921569f * light;
            this.red += (r - this.red) * alpha;
            this.green += (g - this.green) * alpha;
            this.blue += (b - this.blue) * alpha;
            this.alpha += (1.0f - this.alpha) * alpha;
        } else {
            this.alpha = (float)(rgb >> 24 & 0xFF) * 0.003921569f;
            this.red = (float)(rgb >> 16 & 0xFF) * 0.003921569f * light;
            this.green = (float)(rgb >> 8 & 0xFF) * 0.003921569f * light;
            this.blue = (float)(rgb >> 0 & 0xFF) * 0.003921569f * light;
        }
    }

    public void composite(float alpha, int rgb, float lr, float lg, float lb) {
        if (this.alphaComposite) {
            float r = (float)(rgb >> 16 & 0xFF) * 0.003921569f * lr;
            float g = (float)(rgb >> 8 & 0xFF) * 0.003921569f * lg;
            float b = (float)(rgb >> 0 & 0xFF) * 0.003921569f * lb;
            this.red += (r - this.red) * alpha;
            this.green += (g - this.green) * alpha;
            this.blue += (b - this.blue) * alpha;
            this.alpha += (1.0f - this.alpha) * alpha;
        } else {
            this.alpha = (float)(rgb >> 24 & 0xFF) * 0.003921569f;
            this.red = (float)(rgb >> 16 & 0xFF) * 0.003921569f * lr;
            this.green = (float)(rgb >> 8 & 0xFF) * 0.003921569f * lg;
            this.blue = (float)(rgb >> 0 & 0xFF) * 0.003921569f * lb;
        }
    }

    public void composite(float a, float r, float g, float b) {
        if (this.alphaComposite) {
            this.red += (r - this.red) * a;
            this.green += (g - this.green) * a;
            this.blue += (b - this.blue) * a;
            this.alpha += (1.0f - this.alpha) * a;
        } else {
            this.alpha = a;
            this.red = r;
            this.green = g;
            this.blue = b;
        }
    }

    public void composite(float a, float r, float g, float b, float light) {
        if (this.alphaComposite) {
            this.red += (r * light - this.red) * a;
            this.green += (g * light - this.green) * a;
            this.blue += (b * light - this.blue) * a;
            this.alpha += (1.0f - this.alpha) * a;
        } else {
            this.alpha = a;
            this.red = r * light;
            this.green = g * light;
            this.blue = b * light;
        }
    }
}

