/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.awt.Point;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityAmbientCreature;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;
import reifnsk.minimap.BiomeData;
import reifnsk.minimap.BlockColor;
import reifnsk.minimap.BlockDataPack;
import reifnsk.minimap.BlockType;
import reifnsk.minimap.ChunkData;
import reifnsk.minimap.EnumOption;
import reifnsk.minimap.EnumOptionValue;
import reifnsk.minimap.GLTexture;
import reifnsk.minimap.GLTextureBufferedImage;
import reifnsk.minimap.GuiOptionScreen;
import reifnsk.minimap.GuiWaypointEditorScreen;
import reifnsk.minimap.GuiWaypointScreen;
import reifnsk.minimap.KeyInput;
import reifnsk.minimap.MinimapException;
import reifnsk.minimap.PixelColor;
import reifnsk.minimap.StripCounter;
import reifnsk.minimap.Waypoint;
import reifnsk.minimap.WaypointEntity;
import reifnsk.minimap.WaypointEntityRender;
import sedridor.B3M.B3M_Core;

public class ReiMinimap
implements Runnable,
IResourceManagerReloadListener {
    public static final int MC_VERSION_INT = 33621776;
    public static final String MC_1710 = "1.7.10";
    public static final String MC_179 = "1.7.9";
    public static final String MC_172 = "1.7.2";
    public static final String MC_162 = "1.6.2";
    public static final String MC_161 = "1.6.1";
    public static final String MC_152 = "1.5.2";
    public static final String MC_151 = "1.5.1";
    public static final String MC_150 = "1.5";
    public static final String MC_147 = "1.4.7";
    public static final String MC_146 = "1.4.6";
    public static final String MC_145 = "1.4.5";
    public static final String MC_144 = "1.4.4";
    public static final String MC_142 = "1.4.2";
    public static final String MC_141 = "1.4.1";
    public static final String MC_132 = "1.3.2";
    public static final String MC_131P = "1.3.1";
    public static final String MC_125 = "1.2.5";
    public static final String MC_124 = "1.2.4";
    public static final String MC_123 = "1.2.3";
    public static final String MC_110 = "1.1";
    public static final String MC_100 = "1.0.0";
    public static final int MOD_VERSION_INT = 198044;
    public static final String MOD_VERSION = "3.6";
    public static final String MC_VERSION = "1.7.10";
    public static final String version;
    public static final boolean SUPPORT_HEIGHT_MOD = true;
    public static final boolean SUPPORT_NEW_LIGHTING = true;
    private static final double renderZ = 1.0;
    private static final boolean noiseAdded = false;
    private static final float noiseAlpha = 0.1f;
    protected static final File mcDataDir;
    protected static final File optionsDir;
    private float[] lightBrightnessTable = this.generateLightBrightnessTable(0.125f);
    private static final int[] updateFrequencys;
    public static final ReiMinimap instance;
    private static final int TEXTURE_SIZE = 256;
    private int updateCount;
    private static BiomeData[] biomeList;
    protected Minecraft mc;
    protected MinecraftServer server;
    private Tessellator tessellator = Tessellator.field_78398_a;
    private World theWorld;
    private EntityPlayer thePlayer;
    private double playerPosX;
    private double playerPosY;
    private double playerPosZ;
    private float playerRotationYaw;
    private float playerRotationPitch;
    private GuiIngame ingameGUI;
    private ScaledResolution scaledResolution;
    private String errorString;
    private boolean multiplayer;
    private SocketAddress currentServer;
    private String currentLevelName;
    private int currentDimension;
    private int scWidth;
    private int scHeight;
    private GLTextureBufferedImage texture = GLTextureBufferedImage.create(256, 256);
    protected final Thread mcThread;
    private Thread activeThread;
    private Lock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();
    private StripCounter stripCounter = new StripCounter(289);
    private int stripCountMax1 = 0;
    private int stripCountMax2 = 0;
    private GuiScreen guiScreen;
    private int posX;
    private int posY;
    private double posYd;
    private int posZ;
    private int chunkCoordX;
    private int chunkCoordZ;
    private float sin;
    private float cos;
    private int lastX;
    private int lastY;
    private int lastZ;
    private int skylightSubtracted;
    private float sunAngle;
    private boolean isUpdateImage;
    private boolean isCompleteImage;
    private boolean enable = true;
    private boolean showMenuKey = false;
    private boolean filtering = true;
    private int mapPosition = 2;
    private int textureView = 0;
    private float mapOpacity = 1.0f;
    private float largeMapOpacity = 1.0f;
    private boolean largeMapLabel = false;
    private boolean sortedBiomes = false;
    private int lightmap = 0;
    private int lightType = 0;
    private int undulate = 0;
    private float terrainSlopingHeight = 0.8f;
    private int terrainSlopingDirection = 1;
    private boolean transparency = true;
    private boolean waterTransparency = true;
    private boolean environmentColor = true;
    private boolean omitHeightCalc = true;
    private int updateFrequencySetting = 2;
    private boolean threading = false;
    private int threadPriority = 1;
    private boolean preloadedChunks = false;
    private boolean hideSnow = false;
    private boolean showChunkGrid = false;
    private boolean showSlimeChunk = false;
    private boolean heightmap = true;
    private boolean showCoordinate = true;
    private int fontScale = 1;
    private int mapScale = 1;
    private int largeMapScale = 1;
    private int coordinateType = 1;
    private int showClock = 0;
    private boolean showHeading = true;
    private boolean visibleWaypoints = true;
    private boolean caveMapping = true;
    private boolean deathPoint = false;
    private boolean useStencil = false;
    private boolean roundmap = false;
    private boolean fullmap = false;
    private boolean forceUpdate;
    private boolean marker = true;
    private int markerLabel = 0;
    private boolean markerBeam = false;
    private boolean markerIcon = true;
    private boolean markerDistance = true;
    private float markerOpacity = 0.5f;
    private double markerRange = 1000000.0;
    private double markerBeamRange = 10000.0;
    private float minimapWaypointSize = 1.0f;
    private long currentTimeMillis;
    private long currentTime;
    private long previousTime;
    private int renderType = 0;
    private TreeMap<Integer, List<Waypoint>> wayPtsMap = new TreeMap();
    private List<Waypoint> wayPts = new ArrayList<Waypoint>();
    private int waypointDimension;
    private static final double[] ZOOM_LIST;
    private int defaultZoom = 1;
    private int flagZoom = 1;
    private int largeZoom = 0;
    private double targetZoom = 1.0;
    private double currentZoom = 1.0;
    private float zoomVisible;
    private int grassColor;
    private int foliageColor;
    private int foliageColorPine;
    private int foliageColorBirch;
    private int tfOakColor = 4764952;
    private int tfCanopyColor = 6330464;
    private int tfMangroveColor = 8431445;
    private int worldHeight = 255;
    private int[] temperatureColor;
    private int[] humidityColor;
    private HashMap<Integer, String> dimensionName = new HashMap();
    private HashMap<Integer, Double> dimensionScale = new HashMap();
    private boolean chatWelcomed;
    private List<ChatLine> chatLineList;
    private ChatLine chatLineLast;
    private long chatTime;
    private boolean configEntitiesRadar;
    private boolean configEntityPlayer;
    private boolean configEntityAnimal;
    private boolean configEntityMob;
    private boolean configEntitySquid;
    private boolean configEntitySlime;
    private boolean configEntityLiving;
    private boolean configEntityAmbient;
    private boolean configEntityLightning;
    private boolean configEntityDirection;
    private boolean configEntityFilter;
    private boolean allowCavemap;
    private boolean allowEntitiesRadar;
    private boolean allowEntityPlayer;
    private boolean allowEntityAnimal;
    private boolean allowEntityMob;
    private boolean allowEntitySquid;
    private boolean allowEntitySlime;
    private boolean allowEntityLiving;
    private boolean visibleEntitiesRadar;
    private boolean visibleEntityPlayer;
    private boolean visibleEntityAnimal;
    private boolean visibleEntityMob;
    private boolean visibleEntitySquid;
    private boolean visibleEntitySlime;
    private boolean visibleEntityLiving;
    private boolean visibleEntityAmbient;
    private long seed;
    private long ticksExisted;
    private static final int ENTITY_PLAYER_TYPE = 0;
    private static final int ENTITY_MOB_TYPE = 1;
    private static final int ENTITY_ANIMAL_TYPE = 2;
    private static final int ENTITY_SQUID_TYPE = 3;
    private static final int ENTITY_SLIME_TYPE = 4;
    private static final int ENTITY_LIVING_TYPE = 5;
    private static final int ENTITY_AMBIENT_TYPE = 6;
    private List<EntityLivingBase>[] visibleEntities;
    private int[] visibleEntityColor;
    private List<Entity> weatherEffects;
    private float renderPartialTicks;
    protected boolean updateTexture;
    protected long menuOpenTime;
    private long ntime;
    private int count;
    private static float[] temp;
    private float[] lightmapRed;
    private float[] lightmapGreen;
    private float[] lightmapBlue;

    protected boolean getAllowCavemap() {
        return this.allowCavemap;
    }

    protected boolean getAllowEntitiesRadar() {
        return this.allowEntitiesRadar;
    }

    private ReiMinimap() {
        this.dimensionName.put(0, "Overworld");
        this.dimensionScale.put(0, 1.0);
        this.dimensionName.put(-1, "Nether");
        this.dimensionScale.put(-1, 8.0);
        this.dimensionName.put(1, "The Ender");
        this.dimensionScale.put(1, 1.0);
        this.chatTime = 0L;
        this.configEntitiesRadar = false;
        this.configEntityPlayer = true;
        this.configEntityAnimal = true;
        this.configEntityMob = true;
        this.configEntitySquid = true;
        this.configEntitySlime = true;
        this.configEntityLiving = true;
        this.configEntityAmbient = true;
        this.configEntityLightning = true;
        this.configEntityDirection = true;
        this.configEntityFilter = false;
        this.visibleEntities = new ArrayList[7];
        this.visibleEntityColor = new int[]{-16723457, -65536, -1, -16760704, -10444704, -12533632, -256};
        this.weatherEffects = new ArrayList<Entity>(256);
        this.ntime = 0L;
        this.count = 0;
        this.lightmapRed = new float[256];
        this.lightmapGreen = new float[256];
        this.lightmapBlue = new float[256];
        if (!optionsDir.exists()) {
            optionsDir.mkdirs();
        }
        if (!optionsDir.isDirectory()) {
            this.errorString = "[Rei's Minimap] ERROR: Failed to create the rei_minimap folder.";
            ReiMinimap.error(this.errorString);
        }
        this.loadOptions();
        this.mcThread = Thread.currentThread();
        for (int i = 0; i < this.visibleEntities.length; ++i) {
            this.visibleEntities[i] = new ArrayList<EntityLivingBase>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onTickInGame(float f, Minecraft mc) {
        this.renderPartialTicks = f;
        this.currentTimeMillis = System.currentTimeMillis();
        GL11.glPushAttrib((int)1048575);
        GL11.glPushClientAttrib((int)-1);
        GL11.glPushMatrix();
        try {
            EntityPlayer ticksEntity;
            if (mc == null) {
                return;
            }
            if (this.errorString != null) {
                this.scaledResolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
                mc.field_71466_p.func_78261_a(this.errorString, this.scaledResolution.func_78326_a() - mc.field_71466_p.func_78256_a(this.errorString) - 2, 2, -65536);
                return;
            }
            if (this.mc == null) {
                ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)this);
                this.mc = mc;
                this.ingameGUI = this.mc.field_71456_v;
                try {
                    int temp = 0;
                    for (Field field : GuiNewChat.class.getDeclaredFields()) {
                        if (field.getType() != List.class || temp++ != 1) continue;
                        field.setAccessible(true);
                        this.chatLineList = (List)field.get(this.ingameGUI.func_146158_b());
                        break;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.chatLineList = this.chatLineList == null ? new ArrayList() : this.chatLineList;
                try {
                    for (Field field : RenderManager.class.getDeclaredFields()) {
                        if (field.getType() != Map.class) continue;
                        WaypointEntityRender we = new WaypointEntityRender(mc);
                        we.func_76976_a(RenderManager.field_78727_a);
                        field.setAccessible(true);
                        ((Map)field.get(RenderManager.field_78727_a)).put(WaypointEntity.class, we);
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.thePlayer = this.mc.field_71439_g;
            this.playerPosX = this.thePlayer.field_70169_q + (this.thePlayer.field_70165_t - this.thePlayer.field_70169_q) * (double)f;
            this.playerPosY = this.thePlayer.field_70167_r + (this.thePlayer.field_70163_u - this.thePlayer.field_70167_r) * (double)f;
            this.playerPosZ = this.thePlayer.field_70166_s + (this.thePlayer.field_70161_v - this.thePlayer.field_70166_s) * (double)f;
            this.playerRotationYaw = this.thePlayer.field_70126_B + (this.thePlayer.field_70177_z - this.thePlayer.field_70126_B) * f;
            this.playerRotationPitch = this.thePlayer.field_70127_C + (this.thePlayer.field_70125_A - this.thePlayer.field_70127_C) * f;
            if (this.theWorld != this.mc.field_71441_e) {
                this.updateCount = 0;
                this.isUpdateImage = false;
                this.texture.unregister();
                this.theWorld = this.mc.field_71441_e;
                this.theWorld.func_72942_c((Entity)new WaypointEntity(this.mc));
                this.multiplayer = this.mc.func_71401_C() == null;
                Arrays.fill(this.texture.data, (byte)0);
                if (this.theWorld != null) {
                    String levelName;
                    boolean changeWorld;
                    this.worldHeight = this.theWorld.func_72800_K() - 1;
                    ChunkData.init();
                    if (this.multiplayer) {
                        this.seed = 0L;
                        SocketAddress ip = ReiMinimap.getRemoteSocketAddress(this.thePlayer);
                        if (ip == null) {
                            throw new MinimapException("SMP ADDRESS ACQUISITION FAILURE");
                        }
                        boolean bl = changeWorld = this.currentServer != ip;
                        if (changeWorld) {
                            String ipStr = ip.toString().replaceAll("[\r\n]", "");
                            Matcher matcher = Pattern.compile("(.*)/(.*):([0-9]+)").matcher(ipStr);
                            if (!matcher.matches()) {
                                String str = ip.toString().replaceAll("[a-z]", "a").replaceAll("[A-Z]", "A").replaceAll("[0-9]", "*");
                                throw new MinimapException("SMP ADDRESS FORMAT EXCEPTION: " + str);
                            }
                            levelName = matcher.group(1);
                            if (levelName.isEmpty()) {
                                levelName = matcher.group(2);
                            }
                            if (!matcher.group(3).equals("25565")) {
                                levelName = levelName + "[" + matcher.group(3) + "]";
                            }
                            for (char r : ChatAllowedCharacters.field_71567_b) {
                                levelName = levelName.replace(r, '_');
                            }
                            this.currentLevelName = levelName;
                            this.currentServer = ip;
                        }
                    } else {
                        levelName = this.mc.func_71401_C().func_71221_J();
                        if (levelName == null) {
                            throw new MinimapException("WORLD_NAME ACQUISITION FAILURE");
                        }
                        for (char c : ChatAllowedCharacters.field_71567_b) {
                            levelName = levelName.replace(c, '_');
                        }
                        boolean bl = changeWorld = !levelName.equals(this.currentLevelName) || this.currentServer != null;
                        if (changeWorld) {
                            this.currentLevelName = levelName;
                            changeWorld = true;
                        }
                        this.currentServer = null;
                    }
                    if (changeWorld) {
                        this.chatTime = System.currentTimeMillis();
                        this.chatWelcomed = !this.multiplayer;
                        this.allowCavemap = !this.multiplayer;
                        this.allowEntitiesRadar = !this.multiplayer;
                        this.allowEntityPlayer = !this.multiplayer;
                        this.allowEntityAnimal = !this.multiplayer;
                        this.allowEntityMob = !this.multiplayer;
                        this.allowEntitySlime = !this.multiplayer;
                        this.allowEntitySquid = !this.multiplayer;
                        this.allowEntityLiving = !this.multiplayer;
                        this.loadWaypoints();
                    }
                }
                this.stripCounter.reset();
                this.currentDimension = -2147483647;
            }
            if (this.currentDimension != this.thePlayer.field_71093_bK) {
                this.waypointDimension = this.currentDimension = this.thePlayer.field_71093_bK;
                this.wayPts = this.wayPtsMap.get(this.waypointDimension);
                if (this.wayPts == null) {
                    this.wayPts = new ArrayList<Waypoint>();
                    this.wayPtsMap.put(this.waypointDimension, this.wayPts);
                }
            }
            if (!this.chatWelcomed) {
                if (System.currentTimeMillis() < this.chatTime + 5000L) {
                    for (ChatLine cl : this.chatLineList) {
                        if (cl == null || this.chatLineLast == cl) break;
                        Matcher matcher = Pattern.compile("\u00a70\u00a70((?:\u00a7[1-9a-d])+)\u00a7e\u00a7f").matcher(cl.func_151461_a().func_150254_d());
                        while (matcher.find()) {
                            if (!this.chatWelcomed) {
                                this.allowCavemap = true;
                                this.allowEntitiesRadar = true;
                                this.allowEntityPlayer = true;
                                this.allowEntityAnimal = true;
                                this.allowEntityMob = true;
                                this.allowEntitySlime = true;
                                this.allowEntitySquid = true;
                                this.allowEntityLiving = true;
                            }
                            this.chatWelcomed = true;
                            block37: for (char c : matcher.group(1).toCharArray()) {
                                switch (c) {
                                    case '1': {
                                        this.allowCavemap = false;
                                        continue block37;
                                    }
                                    case '2': {
                                        this.allowEntityPlayer = false;
                                        continue block37;
                                    }
                                    case '3': {
                                        this.allowEntityAnimal = false;
                                        continue block37;
                                    }
                                    case '4': {
                                        this.allowEntityMob = false;
                                        continue block37;
                                    }
                                    case '5': {
                                        this.allowEntitySlime = false;
                                        continue block37;
                                    }
                                    case '6': {
                                        this.allowEntitySquid = false;
                                        continue block37;
                                    }
                                    case '7': {
                                        this.allowEntityLiving = false;
                                    }
                                }
                            }
                        }
                    }
                    this.chatLineLast = this.chatLineList.isEmpty() ? null : this.chatLineList.get(0);
                } else {
                    this.chatWelcomed = true;
                    this.allowCavemap = true;
                    this.allowEntitiesRadar = true;
                    this.allowEntityPlayer = true;
                    this.allowEntityAnimal = true;
                    this.allowEntityMob = true;
                    this.allowEntitySlime = true;
                    this.allowEntitySquid = true;
                    this.allowEntityLiving = true;
                }
                if (this.chatWelcomed) {
                    boolean bl = this.allowEntitiesRadar = this.allowEntityPlayer || this.allowEntityAnimal || this.allowEntityMob || this.allowEntitySlime || this.allowEntitySquid || this.allowEntityLiving;
                    if (this.allowCavemap) {
                        this.chatInfo("\u00a7e[Rei's Minimap] enabled: cavemapping");
                    }
                    if (this.allowEntitiesRadar) {
                        StringBuilder sb = new StringBuilder("\u00a7e[Rei's Minimap] enabled: entities radar (");
                        if (this.allowEntityPlayer) {
                            sb.append("\u00a7ePlayer, ");
                        }
                        if (this.allowEntityAnimal) {
                            sb.append("\u00a7eAnimal, ");
                        }
                        if (this.allowEntityMob) {
                            sb.append("\u00a7eMob, ");
                        }
                        if (this.allowEntitySlime) {
                            sb.append("\u00a7eSlime, ");
                        }
                        if (this.allowEntitySquid) {
                            sb.append("\u00a7eSquid, ");
                        }
                        if (this.allowEntityLiving) {
                            sb.append("\u00a7eLiving, ");
                        }
                        sb.setLength(sb.length() - 2);
                        sb.append(")");
                        this.chatInfo(sb.toString());
                    }
                }
            }
            this.visibleEntitiesRadar = this.allowEntitiesRadar && this.configEntitiesRadar;
            this.visibleEntityPlayer = this.allowEntityPlayer && this.configEntityPlayer;
            this.visibleEntityAnimal = this.allowEntityAnimal && this.configEntityAnimal;
            this.visibleEntityMob = this.allowEntityMob && this.configEntityMob;
            this.visibleEntitySlime = this.allowEntitySlime && this.configEntitySlime;
            this.visibleEntitySquid = this.allowEntitySquid && this.configEntitySquid;
            this.visibleEntityLiving = this.allowEntityLiving && this.configEntityLiving;
            this.visibleEntityAmbient = this.allowEntityLiving && this.configEntityAmbient;
            Object object = ticksEntity = this.thePlayer.field_70154_o == null ? this.thePlayer : this.thePlayer.field_70154_o;
            if ((long)ticksEntity.field_70173_aa != this.ticksExisted) {
                if (this.updateTexture) {
                    this.updateTexture = false;
                    ChunkData.updateTexture();
                }
                ++this.updateCount;
                this.ticksExisted = this.thePlayer.field_70173_aa;
                for (int z = -8; z <= 8; ++z) {
                    for (int x = -8; x <= 8; ++x) {
                        ChunkData chunkData = ChunkData.createChunkData(this.thePlayer.field_70176_ah + x, this.thePlayer.field_70164_aj + z);
                        if (chunkData == null) continue;
                        chunkData.updateChunk(this.preloadedChunks);
                    }
                }
                for (List<EntityLivingBase> list : this.visibleEntities) {
                    list.clear();
                }
                this.weatherEffects.clear();
                if (this.visibleEntitiesRadar) {
                    for (Entity entity : this.theWorld.field_72996_f) {
                        int entityType = this.getVisibleEntityType(entity);
                        if (entityType == -1) continue;
                        this.visibleEntities[entityType].add((EntityLivingBase)entity);
                    }
                    this.weatherEffects.addAll(this.theWorld.field_73007_j);
                }
            }
            int displayWidth = this.mc.field_71443_c;
            int displayHeight = this.mc.field_71440_d;
            this.scaledResolution = new ScaledResolution(this.mc, displayWidth, displayHeight);
            GL11.glScaled((double)(1.0 / (double)this.scaledResolution.func_78325_e()), (double)(1.0 / (double)this.scaledResolution.func_78325_e()), (double)1.0);
            this.scWidth = mc.field_71443_c;
            this.scHeight = mc.field_71440_d;
            KeyInput.update();
            if (mc.field_71462_r == null) {
                if (!this.fullmap) {
                    if (KeyInput.TOGGLE_ZOOM.isKeyPush()) {
                        this.flagZoom = this.mc.field_71474_y.field_74311_E.func_151470_d() ? (this.flagZoom == 0 ? ZOOM_LIST.length : this.flagZoom) - 1 : (this.flagZoom + 1) % ZOOM_LIST.length;
                    } else if (KeyInput.ZOOM_IN.isKeyPush() && this.flagZoom < ZOOM_LIST.length - 1) {
                        ++this.flagZoom;
                    } else if (KeyInput.ZOOM_OUT.isKeyPush() && this.flagZoom > 0) {
                        --this.flagZoom;
                    }
                    this.targetZoom = ZOOM_LIST[this.flagZoom];
                } else {
                    if (KeyInput.TOGGLE_ZOOM.isKeyPush()) {
                        this.largeZoom = this.mc.field_71474_y.field_74311_E.func_151470_d() ? (this.largeZoom == 0 ? ZOOM_LIST.length : this.largeZoom) - 1 : (this.largeZoom + 1) % ZOOM_LIST.length;
                    } else if (KeyInput.ZOOM_IN.isKeyPush() && this.largeZoom < ZOOM_LIST.length - 1) {
                        ++this.largeZoom;
                    } else if (KeyInput.ZOOM_OUT.isKeyPush() && this.largeZoom > 0) {
                        --this.largeZoom;
                    }
                    this.targetZoom = ZOOM_LIST[this.largeZoom];
                }
                if (KeyInput.TOGGLE_ENABLE.isKeyPush()) {
                    this.enable = !this.enable;
                    this.stripCounter.reset();
                    this.forceUpdate = true;
                }
                if (KeyInput.TOGGLE_RENDER_TYPE.isKeyPush()) {
                    if (this.mc.field_71474_y.field_74311_E.func_151470_d()) {
                        --this.renderType;
                        if (this.renderType < 0) {
                            this.renderType = EnumOption.RENDER_TYPE.getValueNum() - 1;
                        }
                        if (!this.allowCavemap && EnumOption.RENDER_TYPE.getValue(this.renderType) == EnumOptionValue.CAVE) {
                            --this.renderType;
                        }
                    } else {
                        ++this.renderType;
                        if (!this.allowCavemap && EnumOption.RENDER_TYPE.getValue(this.renderType) == EnumOptionValue.CAVE) {
                            ++this.renderType;
                        }
                        if (this.renderType >= EnumOption.RENDER_TYPE.getValueNum()) {
                            this.renderType = 0;
                        }
                    }
                    this.stripCounter.reset();
                    this.forceUpdate = true;
                }
                if (KeyInput.TOGGLE_WAYPOINTS_DIMENSION.isKeyPush()) {
                    if (this.mc.field_71474_y.field_74311_E.func_151470_d()) {
                        this.prevDimension();
                    } else {
                        this.nextDimension();
                    }
                }
                if (KeyInput.TOGGLE_WAYPOINTS_VISIBLE.isKeyPush()) {
                    boolean bl = this.visibleWaypoints = !this.visibleWaypoints;
                }
                if (KeyInput.TOGGLE_WAYPOINTS_MARKER.isKeyPush()) {
                    boolean bl = this.marker = !this.marker;
                }
                if (KeyInput.TOGGLE_LARGE_MAP.isKeyPush()) {
                    this.fullmap = !this.fullmap;
                    this.currentZoom = this.targetZoom = ZOOM_LIST[this.fullmap ? this.largeZoom : this.flagZoom];
                }
                if (KeyInput.TOGGLE_LARGE_MAP_LABEL.isKeyPush() && this.fullmap) {
                    boolean bl = this.largeMapLabel = !this.largeMapLabel;
                }
                if (this.allowEntitiesRadar && KeyInput.TOGGLE_ENTITIES_RADAR.isKeyPush()) {
                    boolean bl = this.configEntitiesRadar = !this.configEntitiesRadar;
                }
                if (KeyInput.SET_WAYPOINT.isKeyPushUp()) {
                    this.waypointDimension = this.currentDimension;
                    this.wayPts = this.wayPtsMap.get(this.waypointDimension);
                    if (this.wayPts == null) {
                        this.wayPts = new ArrayList<Waypoint>();
                        this.wayPtsMap.put(this.waypointDimension, this.wayPts);
                    }
                    mc.func_147108_a((GuiScreen)new GuiWaypointEditorScreen(mc, (Waypoint)null));
                }
                if (KeyInput.WAYPOINT_LIST.isKeyPushUp()) {
                    mc.func_147108_a((GuiScreen)new GuiWaypointScreen(null));
                }
                if (KeyInput.MENU_KEY.isKeyPush() && this.currentTimeMillis > this.menuOpenTime + 100L) {
                    this.menuOpenTime = System.currentTimeMillis();
                    mc.func_147108_a((GuiScreen)new GuiOptionScreen());
                }
            }
            if (this.chatWelcomed && !this.allowCavemap) {
                if (EnumOption.RENDER_TYPE.getValue(this.renderType) == EnumOptionValue.CAVE) {
                    this.renderType = 0;
                }
                if (this.caveMapping) {
                    this.caveMapping = this.allowCavemap;
                }
            }
            if (this.deathPoint && this.mc.field_71462_r instanceof GuiGameOver && !(this.guiScreen instanceof GuiGameOver)) {
                this.waypointDimension = this.currentDimension;
                this.wayPts = this.wayPtsMap.get(this.currentDimension);
                if (this.wayPts == null) {
                    this.wayPts = new ArrayList<Waypoint>();
                    this.wayPtsMap.put(this.currentDimension, this.wayPts);
                }
                int x = MathHelper.func_76128_c((double)this.playerPosX);
                int y = MathHelper.func_76128_c((double)this.playerPosY);
                int z = MathHelper.func_76128_c((double)this.playerPosZ);
                Random rng = new Random();
                float r = 0.0f;
                float g = 0.0f;
                float b = 0.0f;
                boolean contains = false;
                for (Waypoint wp : this.wayPts) {
                    if (wp.type != 1 || wp.x != x || wp.y != y || wp.z != z || !wp.enable) continue;
                    contains = true;
                    break;
                }
                if (!contains) {
                    this.wayPts.add(new Waypoint("Death Point", x, y, z, true, r, g, b, 1));
                    this.saveWaypoints();
                }
            }
            if (this.thePlayer.func_70089_S()) {
                int waypointDimension = this.waypointDimension;
                this.waypointDimension = this.currentDimension;
                this.wayPts = this.wayPtsMap.get(this.currentDimension);
                if (this.wayPts == null) {
                    this.wayPts = new ArrayList<Waypoint>();
                    this.wayPtsMap.put(this.currentDimension, this.wayPts);
                }
                boolean contains = false;
                Iterator<Waypoint> iter = this.wayPts.iterator();
                while (iter.hasNext()) {
                    double wayY;
                    double wayZ;
                    double wayX;
                    double distance;
                    Waypoint wp = iter.next();
                    if (wp.type != 1 || !((distance = Math.sqrt((wayX = this.playerPosX - (double)wp.x - 0.5) * wayX + (wayZ = this.playerPosZ - (double)wp.z - 0.5) * wayZ + (wayY = this.playerPosY - (double)this.thePlayer.field_70129_M - (double)wp.y - 0.5) * wayY)) < 3.0)) continue;
                    iter.remove();
                    contains = true;
                }
                if (contains) {
                    this.saveWaypoints();
                }
                this.waypointDimension = waypointDimension;
                this.wayPts = this.wayPtsMap.get(this.waypointDimension);
                if (this.wayPts == null) {
                    this.wayPts = new ArrayList<Waypoint>();
                    this.wayPtsMap.put(this.waypointDimension, this.wayPts);
                }
            }
            this.guiScreen = this.mc.field_71462_r;
            if (!this.enable || !ReiMinimap.checkGuiScreen(mc.field_71462_r) || BlockDataPack.defaultBlockColor == null) {
                return;
            }
            if (this.threading) {
                if (this.activeThread == null || !this.activeThread.isAlive()) {
                    this.activeThread = new Thread(this);
                    this.activeThread.setPriority(3 + this.threadPriority);
                    this.activeThread.setDaemon(true);
                    this.activeThread.start();
                }
            } else {
                this.mapCalc(true);
            }
            if (this.lock.tryLock()) {
                try {
                    if (this.isUpdateImage) {
                        this.isUpdateImage = false;
                        this.texture.setMinFilter(this.filtering);
                        this.texture.setMagFilter(this.filtering);
                        this.texture.setClampTexture(true);
                        this.texture.register();
                    }
                    this.condition.signal();
                }
                finally {
                    this.lock.unlock();
                }
            }
            this.currentTime = System.nanoTime();
            double elapseTime = (double)(this.currentTime - this.previousTime) * 1.0E-9;
            this.zoomVisible = (float)((double)this.zoomVisible - elapseTime);
            if (this.currentZoom != this.targetZoom) {
                double d = Math.max(0.0, Math.min(1.0, elapseTime * 4.0));
                this.currentZoom += (this.targetZoom - this.currentZoom) * d;
                if (Math.abs(this.currentZoom - this.targetZoom) < 5.0E-4) {
                    this.currentZoom = this.targetZoom;
                }
                this.zoomVisible = 3.0f;
            }
            this.previousTime = this.currentTime;
            if (this.texture.getId() != 0) {
                int scale = this.fontScale == 0 ? this.scaledResolution.func_78325_e() + 1 >> 1 : this.fontScale;
                switch (this.mapPosition) {
                    case 0: {
                        int x = 37;
                        int y = 37;
                        break;
                    }
                    case 1: {
                        int x = 37;
                        int y = this.scHeight - 37;
                        y -= scale * ((this.showMenuKey | this.showCoordinate ? 2 : 0) + (this.showMenuKey ? 9 : 0) + (this.showCoordinate ? 18 : 0)) / this.scaledResolution.func_78325_e();
                        break;
                    }
                    default: {
                        int x = this.scWidth - 37;
                        int y = 37;
                        break;
                    }
                    case 3: {
                        int x = this.scWidth - 37;
                        int y = this.scHeight - 37;
                        y -= scale * ((this.showMenuKey | this.showCoordinate ? 2 : 0) + (this.showMenuKey ? 9 : 0) + (this.showCoordinate ? 18 : 0)) / this.scaledResolution.func_78325_e();
                    }
                }
                if (this.fullmap) {
                    this.renderFullMap();
                } else if (this.roundmap) {
                    this.renderRoundMap();
                } else {
                    this.renderSquareMap();
                }
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.errorString = "[Rei's Minimap] ERROR: " + e.getMessage();
            ReiMinimap.error("mainloop runtime exception", e);
        }
        finally {
            GL11.glPopMatrix();
            GL11.glPopClientAttrib();
            GL11.glPopAttrib();
        }
        if (this.count != 0) {
            this.mc.field_71466_p.func_78261_a(String.format("%12d", this.ntime / (long)this.count), 2, 12, -1);
        }
        Thread.yield();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.mc != null) {
            Thread currentThread = Thread.currentThread();
            while (true) {
                if (!this.enable || currentThread != this.activeThread || !this.threading) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    this.lock.lock();
                    try {
                        this.condition.await();
                    }
                    catch (InterruptedException e) {
                    }
                    finally {
                        this.lock.unlock();
                    }
                    return;
                    if (currentThread == this.activeThread) continue;
                    return;
                }
                try {
                    if (this.renderType == 0) {
                        Thread.sleep(updateFrequencys[updateFrequencys.length - this.updateFrequencySetting - 1] * 2);
                    } else {
                        Thread.sleep(updateFrequencys[updateFrequencys.length - this.updateFrequencySetting - 1] * 6);
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                this.lock.lock();
                try {
                    this.mapCalc(false);
                    if (!this.isCompleteImage && !this.isUpdateImage) continue;
                    this.condition.await();
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.errorString = "[Rei's Minimap] ERROR: " + e.getMessage();
                    ReiMinimap.error("mainloop runtime exception", e);
                    continue;
                }
                finally {
                    this.lock.unlock();
                    continue;
                }
                break;
            }
            return;
        }
    }

    private void startDrawingQuads() {
        this.tessellator.func_78382_b();
    }

    private void draw() {
        this.tessellator.func_78381_a();
    }

    private void addVertexWithUV(double x, double y, double z, double u, double v) {
        this.tessellator.func_78374_a(x, y, z, u, v);
    }

    private void mapCalc(boolean strip) {
        if (this.theWorld != null && this.thePlayer != null) {
            double d;
            Thread thread = Thread.currentThread();
            if (this.stripCounter.count() == 0) {
                double d2;
                this.posX = MathHelper.func_76128_c((double)this.playerPosX);
                this.posZ = MathHelper.func_76128_c((double)this.playerPosZ);
                this.posY = MathHelper.func_76128_c((double)this.playerPosY);
                this.posYd = this.playerPosY;
                this.chunkCoordX = this.thePlayer.field_70176_ah;
                this.chunkCoordZ = this.thePlayer.field_70164_aj;
                this.skylightSubtracted = this.calculateSkylightSubtracted(this.theWorld.func_72820_D(), 0.0f);
                if (this.lightType == 0) {
                    switch (this.lightmap) {
                        case 0: {
                            this.updateLightmap(this.theWorld.func_72820_D(), 0.0f);
                            break;
                        }
                        case 1: {
                            this.updateLightmap(6000L, 0.0f);
                            break;
                        }
                        case 2: {
                            this.updateLightmap(18000L, 0.0f);
                            break;
                        }
                        case 3: {
                            this.updateLightmap(6000L, 0.0f);
                        }
                    }
                }
                if (this.terrainSlopingDirection == 1) {
                    d2 = 225.0;
                } else if (this.terrainSlopingDirection == 2) {
                    d2 = 135.0;
                } else if (this.terrainSlopingDirection == 3) {
                    d2 = 45.0;
                } else if (this.terrainSlopingDirection == 4) {
                    d2 = -45.0;
                } else if (this.terrainSlopingDirection == 0) {
                    this.sunAngle = this.getSunAngle();
                    d2 = this.sunAngle;
                } else {
                    d2 = 0.0;
                }
                d = Math.toRadians(d2);
                if (this.theWorld.field_73011_w.field_76576_e) {
                    d = Math.toRadians(135.0);
                }
                this.sin = (float)Math.sin(d);
                this.cos = (float)Math.cos(d);
                this.grassColor = ColorizerGrass.func_77480_a((double)0.5, (double)1.0);
                this.foliageColor = ColorizerFoliage.func_77470_a((double)0.5, (double)1.0);
                this.foliageColorPine = ColorizerFoliage.func_77466_a();
                this.foliageColorBirch = ColorizerFoliage.func_77469_b();
            }
            if (this.fullmap) {
                this.stripCountMax1 = 289;
                this.stripCountMax2 = 289;
            } else if (this.currentZoom < this.targetZoom) {
                d = Math.ceil(4.0 / this.currentZoom) * 2.0 + 1.0;
                this.stripCountMax1 = (int)(d * d);
                d = Math.ceil(4.0 / this.targetZoom) * 2.0 + 1.0;
                this.stripCountMax2 = (int)(d * d);
            } else {
                d = Math.ceil(4.0 / this.targetZoom) * 2.0 + 1.0;
                this.stripCountMax1 = this.stripCountMax2 = (int)(d * d);
            }
            if (this.renderType == 1) {
                if (!this.forceUpdate && strip) {
                    this.biomeCalcStrip(thread);
                } else {
                    this.biomeCalc(thread);
                }
            } else if (this.renderType == 2 && this.allowCavemap) {
                if (!this.forceUpdate && strip) {
                    this.caveCalcStrip();
                } else {
                    this.caveCalc();
                }
            } else if (!this.forceUpdate && strip) {
                this.surfaceCalcStrip(thread);
            } else {
                this.surfaceCalc(thread);
            }
            if (this.isCompleteImage) {
                this.forceUpdate = false;
                this.isCompleteImage = false;
                this.stripCounter.reset();
                this.lastX = this.posX;
                this.lastZ = this.posZ;
                this.lastY = this.posY;
            }
        }
    }

    private void surfaceCalc(Thread thread) {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        while (this.stripCounter.count() < limit) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.surfaceCalc(chunkData, thread);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void surfaceCalcStrip(Thread thread) {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        int limit2 = updateFrequencys[this.updateFrequencySetting];
        for (int i = 0; i < limit2 && this.stripCounter.count() < limit; ++i) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.surfaceCalc(chunkData, thread);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void surfaceCalc(ChunkData chunkData, Thread thread) {
        Chunk chunk;
        if (chunkData != null && (chunk = chunkData.getChunk()) != null && !(chunk instanceof EmptyChunk)) {
            int offsetX = 128 + chunk.field_76635_g * 16 - this.posX;
            int offsetZ = 128 + chunk.field_76647_h * 16 - this.posZ;
            boolean slime = this.showSlimeChunk && this.currentDimension == 0 && chunkData.slime;
            PixelColor pixel = new PixelColor(this.transparency);
            ChunkData chunkWest = null;
            ChunkData chunkEast = null;
            ChunkData chunkNorth = null;
            ChunkData chunkSouth = null;
            ChunkData chunkSide = null;
            ChunkData cmx = null;
            ChunkData cpx = null;
            ChunkData cmz = null;
            ChunkData cpz = null;
            if (this.undulate < 2) {
                chunkNorth = ChunkData.getChunkData(chunk.field_76635_g, chunk.field_76647_h - 1);
                chunkSouth = ChunkData.getChunkData(chunk.field_76635_g, chunk.field_76647_h + 1);
                chunkWest = ChunkData.getChunkData(chunk.field_76635_g - 1, chunk.field_76647_h);
                chunkEast = ChunkData.getChunkData(chunk.field_76635_g + 1, chunk.field_76647_h);
                if (this.undulate == 0) {
                    switch (this.terrainSlopingDirection) {
                        case 1: {
                            chunkSide = ChunkData.getChunkData(chunk.field_76635_g - 1, chunk.field_76647_h - 1);
                            break;
                        }
                        case 2: {
                            chunkSide = ChunkData.getChunkData(chunk.field_76635_g + 1, chunk.field_76647_h - 1);
                            break;
                        }
                        default: {
                            chunkSide = ChunkData.getChunkData(chunk.field_76635_g + 1, chunk.field_76647_h + 1);
                            break;
                        }
                        case 4: {
                            chunkSide = ChunkData.getChunkData(chunk.field_76635_g - 1, chunk.field_76647_h + 1);
                            break;
                        }
                        case 0: {
                            chunkSide = chunk.field_76637_e.field_73011_w.field_76576_e ? ChunkData.getChunkData(chunk.field_76635_g + 1, chunk.field_76647_h - 1) : (this.sunAngle >= -90.0f && this.sunAngle <= 0.0f ? ChunkData.getChunkData(chunk.field_76635_g - 1, chunk.field_76647_h + 1) : ChunkData.getChunkData(chunk.field_76635_g + 1, chunk.field_76647_h + 1));
                        }
                    }
                }
            }
            block12: for (int z = 0; z < 16; ++z) {
                int zCoord = offsetZ + z;
                if (zCoord < 0) continue;
                if (zCoord >= 256) break;
                for (int x = 0; x < 16; ++x) {
                    float factor;
                    int height;
                    int xCoord = offsetX + x;
                    if (xCoord < 0) continue;
                    if (xCoord >= 256) continue block12;
                    pixel.clear();
                    boolean solid = false;
                    int n = height = !this.omitHeightCalc && !this.heightmap && this.undulate == 2 ? this.worldHeight : Math.min(this.worldHeight, this.getHeightValue(chunk, x, z));
                    if (height == -1) {
                        height = this.posY - 1;
                        solid = true;
                    }
                    int y = this.omitHeightCalc || this.shouldMapCaves() ? Math.min(this.worldHeight, height) : this.worldHeight;
                    chunkData.setHeightValue(x, z, height);
                    if (y < 0) {
                        if (this.transparency) {
                            this.texture.setRGB(xCoord, zCoord, 0xFF00FF);
                            continue;
                        }
                        this.texture.setRGB(xCoord, zCoord, -16777216);
                        continue;
                    }
                    pixel.alphaComposite = height > 0 && chunk.func_150810_a(x, height - 1, z).func_149688_o() == Material.field_151586_h ? true : this.transparency;
                    this.surfaceCalc(chunkData, x, y, z, pixel, BlockType.AIR, solid, thread);
                    if (this.heightmap) {
                        factor = this.undulate < 2 ? 0.15f : 0.6f;
                        double d1 = (double)height - this.posYd;
                        float d = (float)Math.log10(Math.abs(d1) * 0.125 + 1.0) * factor;
                        if (d1 >= 0.0) {
                            pixel.red += d * (1.0f - pixel.red);
                            pixel.green += d * (1.0f - pixel.green);
                            pixel.blue += d * (1.0f - pixel.blue);
                        } else {
                            d = Math.abs(d);
                            pixel.red -= d * pixel.red;
                            pixel.green -= d * pixel.green;
                            pixel.blue -= d * pixel.blue;
                        }
                    }
                    factor = 1.0f;
                    if (this.undulate == 1) {
                        cmx = x == 0 ? chunkWest : chunkData;
                        cpx = x == 15 ? chunkEast : chunkData;
                        cmz = z == 0 ? chunkNorth : chunkData;
                        cpz = z == 15 ? chunkSouth : chunkData;
                        float mx = cmx == null ? 0.0f : cmx.getHeightValue(x - 1 & 0xF, z);
                        float px = cpx == null ? 0.0f : cpx.getHeightValue(x + 1 & 0xF, z);
                        float mz = cmz == null ? 0.0f : cmz.getHeightValue(x, z - 1 & 0xF);
                        float pz = cpz == null ? 0.0f : cpz.getHeightValue(x, z + 1 & 0xF);
                        factor += Math.max(-4.0f, Math.min(3.0f, (mx - px) * this.sin + (mz - pz) * this.cos)) * 0.14142136f * this.terrainSlopingHeight;
                    } else if (this.undulate == 0) {
                        switch (this.terrainSlopingDirection) {
                            case 1: {
                                cpz = x == 0 && z == 0 ? chunkSide : (x == 0 ? chunkWest : (z == 0 ? chunkNorth : chunkData));
                                float pz = cpz == null ? 0.0f : cpz.getHeightValue(x - 1 & 0xF, z - 1 & 0xF);
                                factor += Math.max(-4.0f, Math.min(3.0f, (pz - (float)height) * this.sin + (pz - (float)height) * this.cos)) * 0.14142136f * this.terrainSlopingHeight;
                                break;
                            }
                            case 2: {
                                cpz = x == 15 && z == 0 ? chunkSide : (x == 15 ? chunkEast : (z == 0 ? chunkNorth : chunkData));
                                float pz = cpz == null ? 0.0f : cpz.getHeightValue(x + 1 & 0xF, z - 1 & 0xF);
                                factor += Math.max(-4.0f, Math.min(3.0f, ((float)height - pz) * this.sin + (pz - (float)height) * this.cos)) * 0.14142136f * this.terrainSlopingHeight;
                                break;
                            }
                            default: {
                                cpz = x == 15 && z == 15 ? chunkSide : (x == 15 ? chunkEast : (z == 15 ? chunkSouth : chunkData));
                                float pz = cpz == null ? 0.0f : cpz.getHeightValue(x + 1 & 0xF, z + 1 & 0xF);
                                factor += Math.max(-4.0f, Math.min(3.0f, ((float)height - pz) * this.sin + ((float)height - pz) * this.cos)) * 0.14142136f * this.terrainSlopingHeight;
                                break;
                            }
                            case 4: {
                                cpz = x == 0 && z == 15 ? chunkSide : (x == 0 ? chunkWest : (z == 15 ? chunkSouth : chunkData));
                                float pz = cpz == null ? 0.0f : cpz.getHeightValue(x - 1 & 0xF, z + 1 & 0xF);
                                factor += Math.max(-4.0f, Math.min(3.0f, (pz - (float)height) * this.sin + ((float)height - pz) * this.cos)) * 0.14142136f * this.terrainSlopingHeight;
                                break;
                            }
                            case 0: {
                                if (chunk.field_76637_e.field_73011_w.field_76576_e) {
                                    cpz = x == 15 && z == 0 ? chunkSide : (x == 15 ? chunkEast : (z == 0 ? chunkNorth : chunkData));
                                    float pz = cpz == null ? 0.0f : cpz.getHeightValue(x + 1 & 0xF, z - 1 & 0xF);
                                    factor += Math.max(-4.0f, Math.min(3.0f, ((float)height - pz) * this.sin + (pz - (float)height) * this.cos)) * 0.14142136f * this.terrainSlopingHeight;
                                    break;
                                }
                                if (this.sunAngle >= -292.5f && this.sunAngle < -225.0f) {
                                    cpz = x == 15 ? chunkEast : chunkData;
                                    float pz = cpz == null ? 0.0f : cpz.getHeightValue(x + 1 & 0xF, z);
                                    factor += Math.max(-4.0f, Math.min(3.0f, ((float)height - pz) * this.sin)) * 0.14142136f * this.terrainSlopingHeight;
                                    break;
                                }
                                if (this.sunAngle >= -337.5f && this.sunAngle < -292.5f) {
                                    cpz = x == 15 && z == 15 ? chunkSide : (x == 15 ? chunkEast : (z == 15 ? chunkSouth : chunkData));
                                    float pz = cpz == null ? 0.0f : cpz.getHeightValue(x + 1 & 0xF, z + 1 & 0xF);
                                    factor += Math.max(-4.0f, Math.min(3.0f, ((float)height - pz) * this.sin + ((float)height - pz) * this.cos)) * 0.14142136f * this.terrainSlopingHeight;
                                    break;
                                }
                                if (this.sunAngle >= -22.5f || this.sunAngle < -337.5f) {
                                    cpz = z == 15 ? chunkSouth : chunkData;
                                    float pz = cpz == null ? 0.0f : cpz.getHeightValue(x, z + 1 & 0xF);
                                    factor += Math.max(-4.0f, Math.min(3.0f, ((float)height - pz) * this.cos)) * 0.14142136f * this.terrainSlopingHeight;
                                    break;
                                }
                                if (this.sunAngle >= -67.5f && this.sunAngle < -22.5f) {
                                    cpz = x == 0 && z == 15 ? chunkSide : (x == 0 ? chunkWest : (z == 15 ? chunkSouth : chunkData));
                                    float pz = cpz == null ? 0.0f : cpz.getHeightValue(x - 1 & 0xF, z + 1 & 0xF);
                                    factor += Math.max(-4.0f, Math.min(3.0f, (pz - (float)height) * this.sin + ((float)height - pz) * this.cos)) * 0.14142136f * this.terrainSlopingHeight;
                                    break;
                                }
                                cpz = x == 0 ? chunkWest : chunkData;
                                float pz = cpz == null ? 0.0f : cpz.getHeightValue(x - 1 & 0xF, z);
                                factor += Math.max(-4.0f, Math.min(3.0f, (pz - (float)height) * this.sin)) * 0.14142136f * this.terrainSlopingHeight;
                            }
                        }
                    }
                    if (slime) {
                        pixel.red = (float)((double)pixel.red * 1.2);
                        pixel.green = (float)((double)pixel.green * 0.5);
                        pixel.blue = (float)((double)pixel.blue * 0.5);
                    }
                    if (this.showChunkGrid && (x == 0 || z == 0)) {
                        if (this.shouldMapCaves()) {
                            pixel.red = (float)((double)(pixel.red + 0.8f) * 0.5);
                            pixel.green = (float)((double)(pixel.green + 0.8f) * 0.5);
                            pixel.blue = (float)((double)(pixel.blue + 0.8f) * 0.5);
                        } else {
                            pixel.red = (float)((double)pixel.red * 0.5);
                            pixel.green = (float)((double)pixel.green * 0.5);
                            pixel.blue = (float)((double)pixel.blue * 0.5);
                        }
                    }
                    byte red = ReiMinimap.ftob(pixel.red * factor);
                    byte green = ReiMinimap.ftob(pixel.green * factor);
                    byte blue = ReiMinimap.ftob(pixel.blue * factor);
                    if (height > 0 && (this.transparency && chunk.func_150810_a(x, height - 1, z).func_149688_o() != Material.field_151586_h || this.waterTransparency && chunk.func_150810_a(x, height - 1, z).func_149688_o() == Material.field_151586_h)) {
                        this.texture.setRGBA(xCoord, zCoord, red, green, blue, ReiMinimap.ftob(pixel.alpha));
                        continue;
                    }
                    this.texture.setRGB(xCoord, zCoord, red, green, blue);
                }
            }
        }
    }

    private void biomeCalc(Thread thread) {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        while (this.stripCounter.count() < limit) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.biomeCalc(chunkData, thread);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void biomeCalcStrip(Thread thread) {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        int limit2 = updateFrequencys[this.updateFrequencySetting];
        for (int i = 0; i < limit2 && this.stripCounter.count() < limit; ++i) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.biomeCalc(chunkData, thread);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void biomeCalc(ChunkData chunkData, Thread thread) {
        if (chunkData != null) {
            int offsetX = 128 + chunkData.xPosition * 16 - this.posX;
            int offsetZ = 128 + chunkData.zPosition * 16 - this.posZ;
            block0: for (int z = 0; z < 16; ++z) {
                int zCoord = z + offsetZ;
                if (zCoord < 0) continue;
                if (zCoord >= 256) break;
                for (int x = 0; x < 16; ++x) {
                    int color;
                    int xCoord = x + offsetX;
                    if (xCoord < 0) continue;
                    if (xCoord >= 256) continue block0;
                    BiomeGenBase bgb = chunkData.biomes[z << 4 | x];
                    int n = color = bgb != null ? BiomeData.getColor(bgb.field_76756_M) : BiomeData.getColor(1);
                    if (color < 0) {
                        color = BiomeData.getColor(1);
                    }
                    byte r = (byte)(color >> 16);
                    byte g = (byte)(color >> 8);
                    byte b = (byte)(color >> 0);
                    this.texture.setRGB(xCoord, zCoord, r, g, b);
                }
            }
        }
    }

    private void temperatureCalc(Thread thread) {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        while (this.stripCounter.count() < limit) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.temperatureCalc(chunkData, thread);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void temperatureCalcStrip(Thread thread) {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        int limit2 = updateFrequencys[this.updateFrequencySetting];
        for (int i = 0; i < limit2 && this.stripCounter.count() < limit; ++i) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.temperatureCalc(chunkData, thread);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void temperatureCalc(ChunkData chunkData, Thread thread) {
        if (chunkData != null) {
            int offsetX = 128 + chunkData.xPosition * 16 - this.posX;
            int offsetZ = 128 + chunkData.zPosition * 16 - this.posZ;
            block0: for (int z = 0; z < 16; ++z) {
                int zCoord = z + offsetZ;
                if (zCoord < 0) continue;
                if (zCoord >= 256) break;
                for (int x = 0; x < 16; ++x) {
                    int xCoord = x + offsetX;
                    if (xCoord < 0) continue;
                    if (xCoord >= 256) continue block0;
                    float temperature = chunkData.biomes[z << 4 | x].field_76750_F;
                    int rgb = (int)(temperature * 255.0f);
                    this.texture.setRGB(xCoord, zCoord, this.temperatureColor[rgb]);
                }
            }
        }
    }

    private void humidityCalc(Thread thread) {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        while (this.stripCounter.count() < limit) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.humidityCalc(chunkData, thread);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void humidityCalcStrip(Thread thread) {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        int limit2 = updateFrequencys[this.updateFrequencySetting];
        for (int i = 0; i < limit2 && this.stripCounter.count() < limit; ++i) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.humidityCalc(chunkData, thread);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void humidityCalc(ChunkData chunkData, Thread thread) {
        if (chunkData != null) {
            int offsetX = 128 + chunkData.xPosition * 16 - this.posX;
            int offsetZ = 128 + chunkData.zPosition * 16 - this.posZ;
            block0: for (int z = 0; z < 16; ++z) {
                int zCoord = z + offsetZ;
                if (zCoord < 0) continue;
                if (zCoord >= 256) break;
                for (int x = 0; x < 16; ++x) {
                    int xCoord = x + offsetX;
                    if (xCoord < 0) continue;
                    if (xCoord >= 256) continue block0;
                    float humidity = chunkData.biomes[z << 4 | x].field_76751_G;
                    int rgb = (int)(humidity * 255.0f);
                    this.texture.setRGB(xCoord, zCoord, this.humidityColor[rgb]);
                }
            }
        }
    }

    private static final byte ftob(float f) {
        return (byte)Math.max(0, Math.min(255, (int)(f * 255.0f)));
    }

    private void surfaceCalc(ChunkData chunkData, int x, int y, int z, PixelColor pixel, BlockType tintType, boolean solid, Thread thread) {
        Chunk chunk = chunkData.getChunk();
        Block block = chunk.func_150810_a(x, y, z);
        int blockID = Block.func_149682_b((Block)block);
        if (!(block.func_149688_o() == Material.field_151579_a || this.hideSnow && block == Block.func_149684_b((String)"snow_layer"))) {
            int metadata = chunk.func_76628_c(x, y, z);
            BlockColor color = BlockDataPack.defaultBlockColor[blockID << 4 | metadata];
            if (color == null) {
                if (y > 0) {
                    this.surfaceCalc(chunkData, x, y - 1, z, pixel, BlockType.AIR, solid, thread);
                }
            } else {
                if (this.transparency && block.func_149688_o() != Material.field_151586_h || this.waterTransparency && block.func_149688_o() == Material.field_151586_h) {
                    if (color.alpha < 1.0f && y > 0) {
                        this.surfaceCalc(chunkData, x, y - 1, z, pixel, color.type, solid, thread);
                        if (color.alpha == 0.0f) {
                            return;
                        }
                    }
                } else if (color.alpha == 0.0f && y > 0) {
                    this.surfaceCalc(chunkData, x, y - 1, z, pixel, color.type, solid, thread);
                    return;
                }
                if (this.lightType == 0) {
                    int skyLight = 15;
                    switch (this.lightmap) {
                        case 3: {
                            skyLight = 15;
                            break;
                        }
                        default: {
                            this.lightmap = 0;
                        }
                        case 0: 
                        case 1: 
                        case 2: {
                            skyLight = y < this.worldHeight ? chunk.func_76614_a(EnumSkyBlock.Sky, x, y + 1, z) : 15;
                        }
                    }
                    int blockLight = Math.max(block.func_149750_m(), chunk.func_76614_a(EnumSkyBlock.Block, x, Math.min(this.worldHeight, y + 1), z));
                    int ptr = skyLight << 4 | blockLight;
                    float r = this.lightmapRed[ptr];
                    float g = this.lightmapGreen[ptr];
                    float b = this.lightmapBlue[ptr];
                    if (color.type.water && tintType.water) {
                        return;
                    }
                    if (solid) {
                        b = 0.0f;
                        g = 0.0f;
                        r = 0.0f;
                    }
                    if (this.environmentColor) {
                        switch (color.type) {
                            case GRASS: {
                                int argb = chunkData.smoothGrassColors[z << 4 | x];
                                pixel.composite(color.alpha, argb, r * color.red, g * color.green, b * color.blue);
                                return;
                            }
                            case SIMPLE_GRASS: {
                                int argb = chunkData.grassColors[z << 4 | x];
                                pixel.composite(color.alpha, argb, r * color.red, g * color.green, b * color.blue);
                                return;
                            }
                            case FOLIAGE: {
                                int argb = chunkData.smoothFoliageColors[z << 4 | x];
                                pixel.composite(color.alpha, argb, r * color.red, g * color.green, b * color.blue);
                                return;
                            }
                            case WATER: {
                                int argb = chunkData.smoothWaterColors[z << 4 | x];
                                pixel.composite(color.alpha, argb, r * color.red, g * color.green, b * color.blue);
                                return;
                            }
                        }
                    } else {
                        switch (color.type) {
                            case GRASS: {
                                pixel.composite(color.alpha, this.grassColor, r * color.red, g * color.green, b * color.blue);
                                return;
                            }
                            case SIMPLE_GRASS: {
                                pixel.composite(color.alpha, this.grassColor, r * color.red * 0.9f, g * color.green * 0.9f, b * color.blue * 0.9f);
                                return;
                            }
                            case FOLIAGE: {
                                pixel.composite(color.alpha, this.foliageColor, r * color.red, g * color.green, b * color.blue);
                                return;
                            }
                        }
                    }
                    if (color.type == BlockType.FOLIAGE_PINE) {
                        pixel.composite(color.alpha, this.foliageColorPine, r * color.red, g * color.green, b * color.blue);
                        return;
                    }
                    if (color.type == BlockType.FOLIAGE_BIRCH) {
                        pixel.composite(color.alpha, this.foliageColorBirch, r * color.red, g * color.green, b * color.blue);
                        return;
                    }
                    if (color.type == BlockType.GLASS && tintType == BlockType.GLASS) {
                        return;
                    }
                    int argb = block.func_149741_i(metadata);
                    if (argb == 0xFFFFFF) {
                        pixel.composite(color.alpha, color.red * r, color.green * g, color.blue * b);
                    } else {
                        pixel.composite(color.alpha, argb, color.red * r, color.green * g, color.blue * b);
                    }
                } else {
                    int lightValue;
                    switch (this.lightmap) {
                        case 1: {
                            lightValue = y < this.worldHeight ? chunk.func_76629_c(x, y + 1, z, 0) : 15;
                            break;
                        }
                        case 2: {
                            lightValue = y < this.worldHeight ? chunk.func_76629_c(x, y + 1, z, 11) : 4;
                            break;
                        }
                        case 3: {
                            lightValue = 15;
                            break;
                        }
                        default: {
                            this.lightmap = 0;
                        }
                        case 0: {
                            lightValue = y < this.worldHeight ? chunk.func_76629_c(x, y + 1, z, this.skylightSubtracted) : 15 - this.skylightSubtracted;
                        }
                    }
                    float lightBrightness = this.lightBrightnessTable[lightValue];
                    if (color.type.water && tintType.water) {
                        return;
                    }
                    if (solid) {
                        lightBrightness = 0.0f;
                    }
                    if (this.environmentColor) {
                        switch (color.type) {
                            case GRASS: {
                                int argb = chunkData.smoothGrassColors[z << 4 | x];
                                pixel.composite(color.alpha, argb, lightBrightness * 0.6f);
                                return;
                            }
                            case SIMPLE_GRASS: {
                                int argb = chunkData.smoothGrassColors[z << 4 | x];
                                pixel.composite(color.alpha, argb, lightBrightness * 0.5f);
                                return;
                            }
                            case FOLIAGE: {
                                int argb = chunkData.smoothFoliageColors[z << 4 | x];
                                pixel.composite(color.alpha, argb, lightBrightness * 0.5f);
                                return;
                            }
                            case WATER: {
                                int argb = chunkData.smoothWaterColors[z << 4 | x];
                                float r = (float)(argb >> 16 & 0xFF) * 0.003921569f;
                                float g = (float)(argb >> 8 & 0xFF) * 0.003921569f;
                                float b = (float)(argb >> 0 & 0xFF) * 0.003921569f;
                                pixel.composite(color.alpha, color.red * r, color.green * g, color.blue * b, lightBrightness);
                                return;
                            }
                        }
                    } else {
                        switch (color.type) {
                            case GRASS: {
                                pixel.composite(color.alpha, this.grassColor, lightBrightness * color.red, lightBrightness * color.green, lightBrightness * color.blue);
                                return;
                            }
                            case SIMPLE_GRASS: {
                                pixel.composite(color.alpha, this.grassColor, lightBrightness * color.red * 0.9f, lightBrightness * color.green * 0.9f, lightBrightness * color.blue * 0.9f);
                                return;
                            }
                            case FOLIAGE: {
                                pixel.composite(color.alpha, this.foliageColor, lightBrightness * color.red, lightBrightness * color.green, lightBrightness * color.blue);
                                return;
                            }
                        }
                    }
                    if (color.type == BlockType.FOLIAGE_PINE) {
                        pixel.composite(color.alpha, this.foliageColorPine, lightBrightness * color.red, lightBrightness * color.green, lightBrightness * color.blue);
                        return;
                    }
                    if (color.type == BlockType.FOLIAGE_BIRCH) {
                        pixel.composite(color.alpha, this.foliageColorBirch, lightBrightness * color.red, lightBrightness * color.green, lightBrightness * color.blue);
                        return;
                    }
                    if (color.type == BlockType.GLASS && tintType == BlockType.GLASS) {
                        return;
                    }
                    int argb = block.func_149741_i(metadata);
                    if (argb == 0xFFFFFF) {
                        pixel.composite(color.alpha, color.red, color.green, color.blue, lightBrightness);
                    } else {
                        pixel.composite(color.alpha, argb, color.red * lightBrightness, color.green * lightBrightness, color.blue * lightBrightness);
                    }
                }
            }
        } else if (y > 0) {
            this.surfaceCalc(chunkData, x, y - 1, z, pixel, BlockType.AIR, solid, thread);
        }
    }

    private void caveCalc() {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        while (this.stripCounter.count() < limit) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.caveCalc(chunkData);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void caveCalcStrip() {
        int limit = Math.max(this.stripCountMax1, this.stripCountMax2);
        int limit2 = updateFrequencys[this.updateFrequencySetting];
        for (int i = 0; i < limit2 && this.stripCounter.count() < limit; ++i) {
            Point point = this.stripCounter.next();
            ChunkData chunkData = ChunkData.getChunkData(this.chunkCoordX + point.x, this.chunkCoordZ + point.y);
            this.caveCalc(chunkData);
        }
        this.isUpdateImage = this.stripCounter.count() >= this.stripCountMax1;
        this.isCompleteImage = this.isUpdateImage && this.stripCounter.count() >= this.stripCountMax2;
    }

    private void caveCalc(ChunkData chunkData) {
        Chunk chunk;
        if (chunkData != null && (chunk = chunkData.getChunk()) != null && !(chunk instanceof EmptyChunk)) {
            int offsetX = 128 + chunk.field_76635_g * 16 - this.posX;
            int offsetZ = 128 + chunk.field_76647_h * 16 - this.posZ;
            block4: for (int z = 0; z < 16; ++z) {
                int zCoord = offsetZ + z;
                if (zCoord < 0) continue;
                if (zCoord >= 256) break;
                for (int x = 0; x < 16; ++x) {
                    int xCoord = offsetX + x;
                    if (xCoord < 0) continue;
                    if (xCoord >= 256) continue block4;
                    float f = 0.0f;
                    switch (this.currentDimension) {
                        case -1: {
                            int _y;
                            int y;
                            for (y = 0; y < temp.length; ++y) {
                                _y = this.posY - y;
                                if (_y >= 0 && _y <= this.worldHeight && chunk.func_150808_b(x, _y, z) == 0 && chunk.func_76629_c(x, _y, z, 12) != 0) {
                                    f += temp[y];
                                }
                                if ((_y = this.posY + y + 1) < 0 || _y > this.worldHeight || chunk.func_150808_b(x, _y, z) != 0 || chunk.func_76629_c(x, _y, z, 12) == 0) continue;
                                f += temp[y];
                            }
                            break;
                        }
                        case 0: {
                            int _y;
                            int y;
                            for (y = 0; y < temp.length; ++y) {
                                _y = this.posY - y;
                                if (_y > this.worldHeight || _y >= 0 && chunk.func_150808_b(x, _y, z) == 0 && chunk.func_76629_c(x, _y, z, 12) != 0) {
                                    f += temp[y];
                                }
                                if ((_y = this.posY + y + 1) <= this.worldHeight && (_y < 0 || chunk.func_150808_b(x, _y, z) != 0 || chunk.func_76629_c(x, _y, z, 12) == 0)) continue;
                                f += temp[y];
                            }
                            break;
                        }
                    }
                    f = 0.8f - f;
                    this.texture.setRGB(xCoord, zCoord, ReiMinimap.ftob(0.0f), ReiMinimap.ftob(f), ReiMinimap.ftob(0.0f));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderRoundMap() {
        String text;
        double distance;
        int centerY;
        int mapscale = 1;
        if (this.mapScale == 0) {
            mapscale = this.scaledResolution.func_78325_e();
        } else if (this.mapScale == 1) {
            while (this.scWidth >= (mapscale + 1) * 320 && this.scHeight >= (mapscale + 1) * 240) {
                ++mapscale;
            }
        } else {
            mapscale = this.mapScale - 1;
        }
        int fscale = this.fontScale - 1;
        if (this.fontScale == 0) {
            fscale = this.scaledResolution.func_78325_e() + 1 >> 1;
        } else if (this.fontScale == 1) {
            fscale = mapscale + 1 >> 1;
        }
        int centerX = (this.mapPosition & 2) == 0 ? 37 * mapscale : this.scWidth - 37 * mapscale;
        int n = centerY = (this.mapPosition & 1) == 0 ? 37 * mapscale : this.scHeight - 37 * mapscale;
        if ((this.mapPosition & 1) == 1) {
            centerY -= ((this.showMenuKey | this.showCoordinate ? 2 : 0) + (this.showMenuKey ? 9 : 0) + (this.showCoordinate ? 18 : 0)) * fscale;
        }
        GL11.glTranslated((double)centerX, (double)centerY, (double)0.0);
        GL11.glScalef((float)mapscale, (float)mapscale, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glEnable((int)2929);
        if (this.useStencil) {
            GL11.glAlphaFunc((int)515, (float)0.1f);
            GL11.glClearStencil((int)0);
            GL11.glClear((int)1024);
            GL11.glEnable((int)2960);
            GL11.glStencilFunc((int)519, (int)1, (int)-1);
            GL11.glStencilOp((int)7680, (int)7681, (int)7681);
            GL11.glDepthMask((boolean)false);
        } else {
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glDepthMask((boolean)true);
        }
        GL11.glPushMatrix();
        GL11.glRotatef((float)(90.0f - this.playerRotationYaw), (float)0.0f, (float)0.0f, (float)1.0f);
        GLTexture.ROUND_MAP_MASK.bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawCenteringRectangle(0.0, 0.0, 1.01, 64.0, 64.0);
        if (this.useStencil) {
            GL11.glStencilOp((int)7680, (int)7680, (int)7680);
            GL11.glStencilFunc((int)514, (int)1, (int)-1);
        }
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        double a = 0.25 / this.currentZoom;
        double slideX = (this.playerPosX - (double)this.lastX) * 0.00390625;
        double slideY = (this.playerPosZ - (double)this.lastZ) * 0.00390625;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.mapOpacity);
        this.texture.bind();
        this.startDrawingQuads();
        this.addVertexWithUV(-32.0, 32.0, 1.0, 0.5 + a + slideX, 0.5 + a + slideY);
        this.addVertexWithUV(32.0, 32.0, 1.0, 0.5 + a + slideX, 0.5 - a + slideY);
        this.addVertexWithUV(32.0, -32.0, 1.0, 0.5 - a + slideX, 0.5 - a + slideY);
        this.addVertexWithUV(-32.0, -32.0, 1.0, 0.5 - a + slideX, 0.5 + a + slideY);
        this.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        if (this.visibleEntitiesRadar) {
            double dist = this.useStencil ? 34.0 : 29.0;
            (this.configEntityDirection ? GLTexture.ENTITY2 : GLTexture.ENTITY).bind();
            for (int i = this.visibleEntities.length - 1; i >= 0; --i) {
                int col = this.visibleEntityColor[i];
                List<EntityLivingBase> entityList = this.visibleEntities[i];
                for (EntityLivingBase entity : entityList) {
                    int color = entity.func_70089_S() ? col : (col & 0xFCFCFC) >> 2 | 0xFF000000;
                    double entityPosX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)this.renderPartialTicks;
                    double entityPosZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)this.renderPartialTicks;
                    double entityPosY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)this.renderPartialTicks;
                    if (this.configEntityFilter && entity.field_70163_u < this.playerPosY - 4.0 && !this.getIsInCave((int)this.playerPosX, (int)this.playerPosY, (int)this.playerPosZ) && this.getIsInCave((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) continue;
                    double wayX = this.playerPosX - entityPosX;
                    double wayZ = this.playerPosZ - entityPosZ;
                    float locate = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
                    double distance2 = Math.sqrt(wayX * wayX + wayZ * wayZ) * this.currentZoom * 0.5;
                    try {
                        GL11.glPushMatrix();
                        if (!(distance2 < dist)) continue;
                        float r = (float)(color >> 16 & 0xFF) * 0.003921569f;
                        float g = (float)(color >> 8 & 0xFF) * 0.003921569f;
                        float b = (float)(color & 0xFF) * 0.003921569f;
                        float alpha = (float)Math.max(0.2, 1.0 - Math.abs(this.playerPosY - entity.field_70163_u) * 0.04);
                        float mul = (float)Math.min(1.0, Math.max(0.5, 1.0 - (this.thePlayer.field_70121_D.field_72338_b - entity.field_70121_D.field_72338_b) * 0.1));
                        GL11.glColor4f((float)(r *= mul), (float)(g *= mul), (float)(b *= mul), (float)alpha);
                        GL11.glRotatef((float)(-locate - this.playerRotationYaw + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glTranslated((double)0.0, (double)(-distance2), (double)0.0);
                        GL11.glRotatef((float)(-(-locate - this.playerRotationYaw + 180.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
                        if (this.configEntityDirection) {
                            float entityRotationYaw = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * this.renderPartialTicks;
                            GL11.glRotatef((float)(entityRotationYaw - this.playerRotationYaw), (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                        this.drawCenteringRectangle(0.0, 0.0, 1.0, 8.0, 8.0);
                    }
                    finally {
                        GL11.glPopMatrix();
                    }
                }
            }
            if (this.configEntityLightning) {
                for (Entity entity : this.weatherEffects) {
                    if (!(entity instanceof EntityLightningBolt)) continue;
                    double wayX = this.playerPosX - entity.field_70165_t;
                    double wayZ = this.playerPosZ - entity.field_70161_v;
                    float locate = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
                    distance = Math.sqrt(wayX * wayX + wayZ * wayZ) * this.currentZoom * 0.5;
                    try {
                        GL11.glPushMatrix();
                        if (!(distance < dist)) continue;
                        float alpha = (float)Math.max(0.2, 1.0 - Math.abs(this.playerPosY - entity.field_70163_u) * 0.04);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                        GL11.glRotatef((float)(-locate - this.playerRotationYaw + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glTranslated((double)0.0, (double)(-distance), (double)0.0);
                        GL11.glRotatef((float)(-(-locate - this.playerRotationYaw + 180.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
                        GLTexture.LIGHTNING.bind();
                        this.drawCenteringRectangle(0.0, 0.0, 1.0, 8.0, 8.0);
                    }
                    finally {
                        GL11.glPopMatrix();
                    }
                }
            }
        }
        if (this.useStencil) {
            GL11.glDisable((int)2960);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.mapOpacity);
        GLTexture.ROUND_MAP.bind();
        this.drawCenteringRectangle(0.0, 0.0, 1.0, 64.0, 64.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.visibleWaypoints) {
            double scale = this.getVisibleDimensionScale();
            for (Waypoint pt : this.wayPts) {
                if (!pt.enable) continue;
                double wayX = this.playerPosX - (double)pt.x * scale - 0.5;
                double wayZ = this.playerPosZ - (double)pt.z * scale - 0.5;
                float locate = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
                distance = Math.sqrt(wayX * wayX + wayZ * wayZ) * this.currentZoom * 0.5;
                try {
                    GL11.glPushMatrix();
                    if (distance < 31.0) {
                        GL11.glColor4f((float)pt.red, (float)pt.green, (float)pt.blue, (float)((float)Math.min(1.0, Math.max(0.4, (distance - 1.0) * 0.5))));
                        Waypoint.FILE[pt.type].bind();
                        GL11.glRotatef((float)(-locate - this.playerRotationYaw + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                        GL11.glTranslated((double)0.0, (double)(-distance), (double)0.0);
                        GL11.glRotatef((float)(-(-locate - this.playerRotationYaw + 180.0f)), (float)0.0f, (float)0.0f, (float)1.0f);
                        this.drawCenteringRectangle(0.0, 0.0, 1.0, 8.0 * (double)this.minimapWaypointSize, 8.0 * (double)this.minimapWaypointSize);
                        continue;
                    }
                    GL11.glColor3f((float)pt.red, (float)pt.green, (float)pt.blue);
                    Waypoint.MARKER[pt.type].bind();
                    GL11.glRotatef((float)(-locate - this.playerRotationYaw + 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)0.0, (double)-34.0, (double)0.0);
                    this.drawCenteringRectangle(0.0, 0.0, 1.0, 8.0, 8.0);
                }
                finally {
                    GL11.glPopMatrix();
                }
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        double s = Math.sin(Math.toRadians(this.playerRotationYaw)) * 28.0;
        double c = Math.cos(Math.toRadians(this.playerRotationYaw)) * 28.0;
        GLTexture.W.bind();
        this.drawCenteringRectangle(c, -s, 1.0, 8.0, 8.0);
        GLTexture.S.bind();
        this.drawCenteringRectangle(-s, -c, 1.0, 8.0, 8.0);
        GLTexture.E.bind();
        this.drawCenteringRectangle(-c, s, 1.0, 8.0, 8.0);
        GLTexture.N.bind();
        this.drawCenteringRectangle(s, c, 1.0, 8.0, 8.0);
        GL11.glScaled((double)(1.0 / (double)mapscale), (double)(1.0 / (double)mapscale), (double)1.0);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        int alpha = (int)(this.zoomVisible * 255.0f);
        if (alpha > 0) {
            text = String.format("%2.2fx", this.currentZoom);
            int width = fontRenderer.func_78256_a(text);
            if (alpha > 255) {
                alpha = 255;
            }
            int tx = 30 * mapscale - width * fscale;
            int ty = 30 * mapscale - 8 * fscale;
            GL11.glTranslatef((float)tx, (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            int rgb = alpha << 24 | 0xFFFFFF;
            fontRenderer.func_78261_a(text, 0, 0, rgb);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(-tx), (float)(-ty), (float)0.0f);
        }
        if (this.visibleWaypoints && this.currentDimension != this.waypointDimension) {
            float tx;
            GL11.glPushMatrix();
            text = this.getDimensionName(this.waypointDimension);
            float width = (float)fontRenderer.func_78256_a(text) * 0.5f * (float)fscale;
            float f = tx = (float)(37 * mapscale) < width ? (float)(37 * mapscale) - width : 0.0f;
            if ((this.mapPosition & 2) == 0) {
                tx = -tx;
            }
            GL11.glTranslated((double)(tx - width), (double)(-30 * mapscale - 12 * fscale), (double)0.0);
            GL11.glScaled((double)fscale, (double)fscale, (double)1.0);
            fontRenderer.func_78261_a(text, 0, 0, 0xFFFFFF);
            GL11.glPopMatrix();
        }
        if (this.showHeading) {
            float heading = (this.playerRotationYaw + 180.0f) % 360.0f;
            if (heading < 0.0f) {
                heading += 360.0f;
            }
            text = String.format("%03d'", (int)heading);
            int width = fontRenderer.func_78256_a(text);
            int tx = -30 * mapscale + 1 * fscale;
            int ty = -30 * mapscale + 1 * fscale;
            GL11.glTranslatef((float)tx, (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(text, 0, 0, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(-tx), (float)(-ty), (float)0.0f);
        }
        if (this.showClock < 2) {
            int m;
            int h;
            long worldTime;
            if (this.showClock == 1) {
                worldTime = this.theWorld.func_72820_D();
                h = (int)((worldTime + 6000L) % 24000L / 1000L);
                m = (int)(worldTime % 1000L * 60L / 1000L);
                text = new SimpleDateFormat("HH:mm").format(new Date());
            } else {
                worldTime = this.theWorld.func_72820_D();
                h = (int)((worldTime + 6000L) % 24000L / 1000L);
                m = (int)(worldTime % 1000L * 60L / 1000L);
                text = String.format("%02d:%02d", h, m);
            }
            int width = fontRenderer.func_78256_a(text);
            int tx = 30 * mapscale - width * fscale - 1 * fscale;
            int ty = -30 * mapscale + 1 * fscale;
            GL11.glTranslatef((float)tx, (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(text, 0, 0, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(-tx), (float)(-ty), (float)0.0f);
        }
        int ty = 32 * mapscale;
        if (this.showCoordinate) {
            float tx;
            String line2;
            String line1;
            if (this.coordinateType == 0) {
                int posX = MathHelper.func_76128_c((double)this.playerPosX);
                int posY = MathHelper.func_76128_c((double)this.thePlayer.field_70121_D.field_72338_b);
                int posZ = MathHelper.func_76128_c((double)this.playerPosZ);
                line1 = String.format("%+d, %+d", posX, posZ);
                line2 = Integer.toString(posY);
            } else if (this.coordinateType == 1) {
                line1 = String.format("%+1.2f, %+1.2f", this.playerPosX, this.playerPosZ);
                line2 = String.format("%1.2f", this.thePlayer.field_70121_D.field_72338_b);
            } else if (this.coordinateType == 2) {
                line1 = String.format("%+1.2f, %+1.2f", this.playerPosX, this.playerPosZ);
                line2 = String.format("%1.2f (%d)", this.playerPosY, (int)this.thePlayer.field_70121_D.field_72338_b);
            } else {
                line1 = String.format("%s%1.2f, %s%1.2f", this.playerPosZ >= 0.0 ? "S" : "N", this.playerPosZ >= 0.0 ? this.playerPosZ : -this.playerPosZ, this.playerPosX >= 0.0 ? "E" : "W", this.playerPosX >= 0.0 ? this.playerPosX : -this.playerPosX);
                line2 = String.format("%1.2fm", this.thePlayer.field_70121_D.field_72338_b);
            }
            float width1 = (float)fontRenderer.func_78256_a(line1) * 0.5f * (float)fscale;
            float width2 = (float)fontRenderer.func_78256_a(line2) * 0.5f * (float)fscale;
            float f = tx = (float)(37 * mapscale) < width1 ? (float)(37 * mapscale) - width1 : 0.0f;
            if ((this.mapPosition & 2) == 0) {
                tx = -tx;
            }
            GL11.glTranslatef((float)(tx - width1), (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(line1, 0, 2, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(width1 - width2), (float)0.0f, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(line2, 0, 11, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(width2 - tx), (float)(-ty), (float)0.0f);
            ty += 18 * fscale;
        }
        if (this.showMenuKey) {
            String str = String.format("Menu: %s key", KeyInput.MENU_KEY.getKeyName());
            float width = (float)this.mc.field_71466_p.func_78256_a(str) * 0.5f * (float)fscale;
            float tx = (float)(32 * mapscale) - width;
            if ((this.mapPosition & 2) == 0 && (float)(32 * mapscale) < width) {
                tx = (float)(-32 * mapscale) + width;
            }
            GL11.glTranslatef((float)(tx - width), (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(str, 0, 2, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(width - tx), (float)(-ty), (float)0.0f);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderSquareMap() {
        int centerY;
        int mapscale = 1;
        if (this.mapScale == 0) {
            mapscale = this.scaledResolution.func_78325_e();
        } else if (this.mapScale == 1) {
            while (this.scWidth >= (mapscale + 1) * 320 && this.scHeight >= (mapscale + 1) * 240) {
                ++mapscale;
            }
        } else {
            mapscale = this.mapScale - 1;
        }
        int fscale = this.fontScale - 1;
        if (this.fontScale == 0) {
            fscale = this.scaledResolution.func_78325_e() + 1 >> 1;
        } else if (this.fontScale == 1) {
            fscale = mapscale + 1 >> 1;
        }
        int centerX = (this.mapPosition & 2) == 0 ? 37 * mapscale : this.scWidth - 37 * mapscale;
        int n = centerY = (this.mapPosition & 1) == 0 ? 37 * mapscale : this.scHeight - 37 * mapscale;
        if ((this.mapPosition & 1) == 1) {
            centerY -= ((this.showMenuKey | this.showCoordinate ? 2 : 0) + (this.showMenuKey ? 9 : 0) + (this.showCoordinate ? 18 : 0)) * fscale;
        }
        GL11.glTranslated((double)centerX, (double)centerY, (double)0.0);
        GL11.glScalef((float)mapscale, (float)mapscale, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL11.glEnable((int)2929);
        if (this.useStencil) {
            GL11.glAlphaFunc((int)515, (float)0.1f);
            GL11.glClearStencil((int)0);
            GL11.glClear((int)1024);
            GL11.glEnable((int)2960);
            GL11.glStencilFunc((int)519, (int)1, (int)-1);
            GL11.glStencilOp((int)7680, (int)7681, (int)7681);
            GL11.glDepthMask((boolean)false);
        } else {
            GL11.glAlphaFunc((int)516, (float)0.0f);
            GL11.glDepthMask((boolean)true);
        }
        GLTexture.SQUARE_MAP_MASK.bind();
        this.drawCenteringRectangle(0.0, 0.0, 1.001, 64.0, 64.0);
        if (this.useStencil) {
            GL11.glStencilOp((int)7680, (int)7680, (int)7680);
            GL11.glStencilFunc((int)514, (int)1, (int)-1);
        }
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.0f);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthMask((boolean)true);
        double a = 0.25 / this.currentZoom;
        double slideX = (this.playerPosX - (double)this.lastX) * 0.00390625;
        double slideY = (this.playerPosZ - (double)this.lastZ) * 0.00390625;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.mapOpacity);
        this.texture.bind();
        this.startDrawingQuads();
        this.addVertexWithUV(32.0, 32.0, 1.0, 0.5 + a + slideX, 0.5 + a + slideY);
        this.addVertexWithUV(32.0, -32.0, 1.0, 0.5 + a + slideX, 0.5 - a + slideY);
        this.addVertexWithUV(-32.0, -32.0, 1.0, 0.5 - a + slideX, 0.5 - a + slideY);
        this.addVertexWithUV(-32.0, 32.0, 1.0, 0.5 - a + slideX, 0.5 + a + slideY);
        this.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.visibleEntitiesRadar) {
            float dist = this.useStencil ? 34.0f : 31.0f;
            (this.configEntityDirection ? GLTexture.ENTITY2 : GLTexture.ENTITY).bind();
            for (int i = this.visibleEntities.length - 1; i >= 0; --i) {
                int col = this.visibleEntityColor[i];
                List<EntityLivingBase> entityList = this.visibleEntities[i];
                for (EntityLivingBase entity : entityList) {
                    int color = entity.func_70089_S() ? col : (col & 0xFCFCFC) >> 2 | 0xFF000000;
                    double entityPosX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)this.renderPartialTicks;
                    double entityPosZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)this.renderPartialTicks;
                    double entityPosY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)this.renderPartialTicks;
                    if (this.configEntityFilter && entity.field_70163_u < this.playerPosY - 4.0 && !this.getIsInCave((int)this.playerPosX, (int)this.playerPosY, (int)this.playerPosZ) && this.getIsInCave((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) continue;
                    double wayX = this.playerPosX - entityPosX;
                    double wayZ = this.playerPosZ - entityPosZ;
                    wayX = wayX * this.currentZoom * 0.5;
                    wayZ = wayZ * this.currentZoom * 0.5;
                    double distance = Math.max(Math.abs(wayX), Math.abs(wayZ));
                    try {
                        GL11.glPushMatrix();
                        if (!(distance < (double)dist)) continue;
                        float r = (float)(color >> 16 & 0xFF) * 0.003921569f;
                        float g = (float)(color >> 8 & 0xFF) * 0.003921569f;
                        float b = (float)(color & 0xFF) * 0.003921569f;
                        float alpha = (float)Math.max(0.2, 1.0 - Math.abs(this.playerPosY - entity.field_70163_u) * 0.04);
                        float mul = (float)Math.min(1.0, Math.max(0.5, 1.0 - (this.thePlayer.field_70121_D.field_72338_b - entity.field_70121_D.field_72338_b) * 0.1));
                        GL11.glColor4f((float)(r *= mul), (float)(g *= mul), (float)(b *= mul), (float)alpha);
                        float drawRotate = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * this.renderPartialTicks;
                        double drawY = -wayZ;
                        double drawX = -wayX;
                        if (!(entity instanceof EntityDragon)) {
                            drawRotate += 180.0f;
                        }
                        if (this.configEntityDirection) {
                            GL11.glTranslated((double)drawX, (double)drawY, (double)0.0);
                            GL11.glRotatef((float)drawRotate, (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glTranslated((double)(-drawX), (double)(-drawY), (double)0.0);
                        }
                        this.drawCenteringRectangle(drawX, drawY, 1.0, 8.0, 8.0);
                    }
                    finally {
                        GL11.glPopMatrix();
                    }
                }
            }
            if (this.configEntityLightning) {
                for (Entity entity : this.weatherEffects) {
                    if (!(entity instanceof EntityLightningBolt)) continue;
                    double wayX = this.playerPosX - entity.field_70165_t;
                    double wayZ = this.playerPosZ - entity.field_70161_v;
                    wayX = wayX * this.currentZoom * 0.5;
                    wayZ = wayZ * this.currentZoom * 0.5;
                    double distance = Math.max(Math.abs(wayX), Math.abs(wayZ));
                    try {
                        GL11.glPushMatrix();
                        if (!(distance < (double)dist)) continue;
                        float alpha = (float)Math.max(0.2, 1.0 - Math.abs(this.playerPosY - entity.field_70163_u) * 0.04);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                        double drawY = -wayZ;
                        double drawX = -wayX;
                        float drawRotate = entity.field_70177_z + 180.0f;
                        GLTexture.LIGHTNING.bind();
                        this.drawCenteringRectangle(drawX, drawY, 1.0, 8.0, 8.0);
                    }
                    finally {
                        GL11.glPopMatrix();
                    }
                }
            }
        }
        if (this.useStencil) {
            GL11.glDisable((int)2960);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.mapOpacity);
        GLTexture.SQUARE_MAP.bind();
        this.drawCenteringRectangle(0.0, 0.0, 1.0, 64.0, 64.0);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.visibleWaypoints) {
            double scale = this.getVisibleDimensionScale();
            for (Waypoint pt : this.wayPts) {
                if (!pt.enable) continue;
                double wayX = this.playerPosX - (double)pt.x * scale - 0.5;
                double wayZ = this.playerPosZ - (double)pt.z * scale - 0.5;
                wayX = wayX * this.currentZoom * 0.5;
                wayZ = wayZ * this.currentZoom * 0.5;
                float locate = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
                double distance = Math.max(Math.abs(wayX), Math.abs(wayZ));
                try {
                    GL11.glPushMatrix();
                    if (distance < 31.0) {
                        GL11.glColor4f((float)pt.red, (float)pt.green, (float)pt.blue, (float)((float)Math.min(1.0, Math.max(0.4, (distance - 1.0) * 0.5))));
                        Waypoint.FILE[pt.type].bind();
                        this.drawCenteringRectangle(-wayX, -wayZ, 1.0, 8.0 * (double)this.minimapWaypointSize, 8.0 * (double)this.minimapWaypointSize);
                        continue;
                    }
                    double t = 34.0 / distance;
                    double hypot = Math.sqrt((wayX *= t) * wayX + (wayZ *= t) * wayZ);
                    GL11.glColor3f((float)pt.red, (float)pt.green, (float)pt.blue);
                    Waypoint.MARKER[pt.type].bind();
                    GL11.glRotatef((float)(0.0f - locate), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)0.0, (double)(-hypot), (double)0.0);
                    this.drawCenteringRectangle(0.0, 0.0, 1.0, 8.0, 8.0);
                }
                finally {
                    GL11.glPopMatrix();
                }
            }
        }
        try {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GLTexture.MMARROW.bind();
            GL11.glRotatef((float)(this.playerRotationYaw - 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.drawCenteringRectangle(0.0, 0.0, 1.0, 8.0, 8.0);
        }
        catch (Exception e) {
        }
        finally {
            GL11.glPopMatrix();
        }
        GL11.glScaled((double)(1.0 / (double)mapscale), (double)(1.0 / (double)mapscale), (double)1.0);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        int alpha = (int)(this.zoomVisible * 255.0f);
        if (alpha > 0) {
            String text = String.format("%2.2fx", this.currentZoom);
            int width = fontRenderer.func_78256_a(text);
            if (alpha > 255) {
                alpha = 255;
            }
            int tx = 30 * mapscale - width * fscale;
            int ty = 30 * mapscale - 8 * fscale;
            GL11.glTranslatef((float)tx, (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            int rgb = alpha << 24 | 0xFFFFFF;
            fontRenderer.func_78261_a(text, 0, 0, rgb);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(-tx), (float)(-ty), (float)0.0f);
        }
        if (this.visibleWaypoints && this.currentDimension != this.waypointDimension) {
            float tx;
            GL11.glPushMatrix();
            String text = this.getDimensionName(this.waypointDimension);
            float width = (float)fontRenderer.func_78256_a(text) * 0.5f * (float)fscale;
            float f = tx = (float)(37 * mapscale) < width ? (float)(37 * mapscale) - width : 0.0f;
            if ((this.mapPosition & 2) == 0) {
                tx = -tx;
            }
            GL11.glTranslated((double)(tx - width), (double)(-30 * mapscale + 1 * fscale), (double)0.0);
            GL11.glScaled((double)fscale, (double)fscale, (double)1.0);
            fontRenderer.func_78261_a(text, 0, 0, 0xFFFFFF);
            GL11.glPopMatrix();
        }
        if (this.showHeading) {
            float heading = (this.playerRotationYaw + 180.0f) % 360.0f;
            if (heading < 0.0f) {
                heading += 360.0f;
            }
            String text = String.format("%03d'", (int)heading);
            int width = fontRenderer.func_78256_a(text);
            int tx = -30 * mapscale + 1 * fscale;
            int ty = -30 * mapscale + 1 * fscale;
            GL11.glTranslatef((float)tx, (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(text, 0, 0, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(-tx), (float)(-ty), (float)0.0f);
        }
        if (this.showClock < 2) {
            String text;
            int m;
            int h;
            long worldTime;
            if (this.showClock == 1) {
                worldTime = this.theWorld.func_72820_D();
                h = (int)((worldTime + 6000L) % 24000L / 1000L);
                m = (int)(worldTime % 1000L * 60L / 1000L);
                text = new SimpleDateFormat("HH:mm").format(new Date());
            } else {
                worldTime = this.theWorld.func_72820_D();
                h = (int)((worldTime + 6000L) % 24000L / 1000L);
                m = (int)(worldTime % 1000L * 60L / 1000L);
                text = String.format("%02d:%02d", h, m);
            }
            int width = fontRenderer.func_78256_a(text);
            int tx = 30 * mapscale - width * fscale - 1 * fscale;
            int ty = -30 * mapscale + 1 * fscale;
            GL11.glTranslatef((float)tx, (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(text, 0, 0, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(-tx), (float)(-ty), (float)0.0f);
        }
        int ty = 32 * mapscale;
        if (this.showCoordinate) {
            float tx;
            String line2;
            String line1;
            if (this.coordinateType == 0) {
                int posX = MathHelper.func_76128_c((double)this.playerPosX);
                int posY = MathHelper.func_76128_c((double)this.thePlayer.field_70121_D.field_72338_b);
                int posZ = MathHelper.func_76128_c((double)this.playerPosZ);
                line1 = String.format("%+d, %+d", posX, posZ);
                line2 = Integer.toString(posY);
            } else if (this.coordinateType == 1) {
                line1 = String.format("%+1.2f, %+1.2f", this.playerPosX, this.playerPosZ);
                line2 = String.format("%1.2f", this.thePlayer.field_70121_D.field_72338_b);
            } else if (this.coordinateType == 2) {
                line1 = String.format("%+1.2f, %+1.2f", this.playerPosX, this.playerPosZ);
                line2 = String.format("%1.2f (%d)", this.playerPosY, (int)this.thePlayer.field_70121_D.field_72338_b);
            } else {
                line1 = String.format("%s%1.2f, %s%1.2f", this.playerPosZ >= 0.0 ? "S" : "N", this.playerPosZ >= 0.0 ? this.playerPosZ : -this.playerPosZ, this.playerPosX >= 0.0 ? "E" : "W", this.playerPosX >= 0.0 ? this.playerPosX : -this.playerPosX);
                line2 = String.format("%1.2fm", this.thePlayer.field_70121_D.field_72338_b);
            }
            float width1 = (float)fontRenderer.func_78256_a(line1) * 0.5f * (float)fscale;
            float width2 = (float)fontRenderer.func_78256_a(line2) * 0.5f * (float)fscale;
            float f = tx = (float)(37 * mapscale) < width1 ? (float)(37 * mapscale) - width1 : 0.0f;
            if ((this.mapPosition & 2) == 0) {
                tx = -tx;
            }
            GL11.glTranslatef((float)(tx - width1), (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(line1, 0, 2, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(width1 - width2), (float)0.0f, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(line2, 0, 11, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(width2 - tx), (float)(-ty), (float)0.0f);
            ty += 18 * fscale;
        }
        if (this.showMenuKey) {
            String str = String.format("Menu: %s key", KeyInput.MENU_KEY.getKeyName());
            float width = (float)this.mc.field_71466_p.func_78256_a(str) * 0.5f * (float)fscale;
            float tx = (float)(32 * mapscale) - width;
            if ((this.mapPosition & 2) == 0 && (float)(32 * mapscale) < width) {
                tx = (float)(-32 * mapscale) + width;
            }
            GL11.glTranslatef((float)(tx - width), (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(str, 0, 2, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(width - tx), (float)(-ty), (float)0.0f);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderFullMap() {
        int mapscale;
        if (this.largeMapScale == 0) {
            mapscale = this.scaledResolution.func_78325_e();
        } else {
            int max;
            int n = max = this.largeMapScale == 1 ? 1000 : this.largeMapScale - 1;
            for (mapscale = 1; mapscale < max && this.scWidth >= (mapscale + 1) * 240 && this.scHeight >= (mapscale + 1) * 240; ++mapscale) {
            }
        }
        int fscale = this.fontScale - 1;
        if (this.fontScale == 0) {
            fscale = this.scaledResolution.func_78325_e() + 1 >> 1;
        } else if (this.fontScale == 1) {
            fscale = mapscale + 1 >> 1;
        }
        GL11.glTranslated((double)((double)this.scWidth * 0.5), (double)((double)this.scHeight * 0.5), (double)0.0);
        GL11.glScalef((float)mapscale, (float)mapscale, (float)0.0f);
        double a = 0.234375 / this.currentZoom;
        double slideX = (this.playerPosX - (double)this.lastX) * 0.00390625;
        double slideY = (this.playerPosZ - (double)this.lastZ) * 0.00390625;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)false);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.texture.bind();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.largeMapOpacity);
        this.startDrawingQuads();
        this.addVertexWithUV(120.0, 120.0, 1.0, 0.5 + a + slideX, 0.5 + a + slideY);
        this.addVertexWithUV(120.0, -120.0, 1.0, 0.5 + a + slideX, 0.5 - a + slideY);
        this.addVertexWithUV(-120.0, -120.0, 1.0, 0.5 - a + slideX, 0.5 - a + slideY);
        this.addVertexWithUV(-120.0, 120.0, 1.0, 0.5 - a + slideX, 0.5 + a + slideY);
        this.draw();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.visibleEntitiesRadar) {
            (this.configEntityDirection ? GLTexture.ENTITY2 : GLTexture.ENTITY).bind();
            for (int i = this.visibleEntities.length - 1; i >= 0; --i) {
                int col = this.visibleEntityColor[i];
                List<EntityLivingBase> entityList = this.visibleEntities[i];
                for (EntityLivingBase entity : entityList) {
                    int color = entity.func_70089_S() ? col : (col & 0xFCFCFC) >> 2 | 0xFF000000;
                    double entityPosX = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)this.renderPartialTicks;
                    double entityPosZ = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)this.renderPartialTicks;
                    double entityPosY = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)this.renderPartialTicks;
                    if (this.configEntityFilter && entity.field_70163_u < this.playerPosY - 4.0 && !this.getIsInCave((int)this.playerPosX, (int)this.playerPosY, (int)this.playerPosZ) && this.getIsInCave((int)entity.field_70165_t, (int)entity.field_70163_u, (int)entity.field_70161_v)) continue;
                    double wayX = this.playerPosX - entityPosX;
                    double wayZ = this.playerPosZ - entityPosZ;
                    wayX = wayX * this.currentZoom * 2.0;
                    wayZ = wayZ * this.currentZoom * 2.0;
                    double distance = Math.max(Math.abs(wayX), Math.abs(wayZ));
                    try {
                        GL11.glPushMatrix();
                        if (!(distance < 114.0)) continue;
                        float r = (float)(color >> 16 & 0xFF) * 0.003921569f;
                        float g = (float)(color >> 8 & 0xFF) * 0.003921569f;
                        float b = (float)(color & 0xFF) * 0.003921569f;
                        float alpha = (float)Math.max(0.2, 1.0 - Math.abs(this.playerPosY - entity.field_70163_u) * 0.04);
                        float mul = (float)Math.min(1.0, Math.max(0.5, 1.0 - (this.thePlayer.field_70121_D.field_72338_b - entity.field_70121_D.field_72338_b) * 0.1));
                        GL11.glColor4f((float)(r *= mul), (float)(g *= mul), (float)(b *= mul), (float)alpha);
                        float drawRotate = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * this.renderPartialTicks;
                        double drawY = -wayZ;
                        double drawX = -wayX;
                        if (!(entity instanceof EntityDragon)) {
                            drawRotate += 180.0f;
                        }
                        if (this.configEntityDirection) {
                            GL11.glTranslated((double)drawX, (double)drawY, (double)0.0);
                            GL11.glRotatef((float)drawRotate, (float)0.0f, (float)0.0f, (float)1.0f);
                            GL11.glTranslated((double)(-drawX), (double)(-drawY), (double)0.0);
                        }
                        this.drawCenteringRectangle(drawX, drawY, 1.0, 8.0, 8.0);
                    }
                    finally {
                        GL11.glPopMatrix();
                    }
                }
            }
            if (this.configEntityLightning) {
                for (Entity entity : this.weatherEffects) {
                    if (!(entity instanceof EntityLightningBolt)) continue;
                    double wayX = this.playerPosX - entity.field_70165_t;
                    double wayZ = this.playerPosZ - entity.field_70161_v;
                    wayX = wayX * this.currentZoom * 2.0;
                    wayZ = wayZ * this.currentZoom * 2.0;
                    double distance = Math.max(Math.abs(wayX), Math.abs(wayZ));
                    try {
                        GL11.glPushMatrix();
                        if (!(distance < 114.0)) continue;
                        float alpha = (float)Math.max(0.2, 1.0 - Math.abs(this.playerPosY - entity.field_70163_u) * 0.04);
                        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                        double drawY = -wayZ;
                        double drawX = -wayX;
                        float drawRotate = entity.field_70177_z + 180.0f;
                        GLTexture.LIGHTNING.bind();
                        this.drawCenteringRectangle(drawX, drawY, 1.0, 8.0, 8.0);
                    }
                    finally {
                        GL11.glPopMatrix();
                    }
                }
            }
        }
        if (this.visibleWaypoints) {
            for (Waypoint pt : this.wayPts) {
                double scale = this.getVisibleDimensionScale();
                if (!pt.enable) continue;
                double wayX = this.playerPosX - (double)pt.x * scale - 0.5;
                double wayZ = this.playerPosZ - (double)pt.z * scale - 0.5;
                wayX = wayX * this.currentZoom * 2.0;
                wayZ = wayZ * this.currentZoom * 2.0;
                float locate = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
                double distance = Math.max(Math.abs(wayX), Math.abs(wayZ));
                try {
                    GL11.glPushMatrix();
                    if (distance < 114.0) {
                        GL11.glScalef((float)(1.0f / (float)mapscale * (float)fscale), (float)(1.0f / (float)mapscale * (float)fscale), (float)1.0f);
                        GL11.glColor4f((float)pt.red, (float)pt.green, (float)pt.blue, (float)((float)Math.min(1.0, Math.max(0.4, (distance - 1.0) * 0.5))));
                        Waypoint.FILE[pt.type].bind();
                        double ry = -wayZ * (double)mapscale / (double)fscale;
                        double rx = -wayX * (double)mapscale / (double)fscale;
                        this.drawCenteringRectangle(rx, ry, 1.0, 8.0 * (double)mapscale / (double)fscale, 8.0 * (double)mapscale / (double)fscale);
                        if (this.largeMapLabel && pt.name != null && !pt.name.isEmpty()) {
                            GL11.glDisable((int)3553);
                            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
                            int width = this.mc.field_71466_p.func_78256_a(pt.name);
                            int _x = (int)rx;
                            int _y = (int)ry;
                            int x1 = _x - (width >> 1);
                            int x2 = x1 + width;
                            int y1 = _y - 17;
                            int y2 = _y - 7;
                            this.tessellator.func_78382_b();
                            this.tessellator.func_78377_a((double)(x1 - 1), (double)y2, 1.0);
                            this.tessellator.func_78377_a((double)(x2 + 1), (double)y2, 1.0);
                            this.tessellator.func_78377_a((double)(x2 + 1), (double)y1, 1.0);
                            this.tessellator.func_78377_a((double)(x1 - 1), (double)y1, 1.0);
                            this.tessellator.func_78381_a();
                            GL11.glEnable((int)3553);
                            this.mc.field_71466_p.func_78261_a(pt.name, x1, y1 + 1, pt.type == 0 ? -1 : -65536);
                        }
                        GL11.glScaled((double)((double)mapscale / (double)fscale), (double)((double)mapscale / (double)fscale), (double)1.0);
                        continue;
                    }
                    double t = 117.0 / distance;
                    double hypot = Math.sqrt((wayX *= t) * wayX + (wayZ *= t) * wayZ);
                    GL11.glColor3f((float)pt.red, (float)pt.green, (float)pt.blue);
                    Waypoint.MARKER[pt.type].bind();
                    GL11.glRotatef((float)(0.0f - locate), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)0.0, (double)(-hypot), (double)0.0);
                    this.drawCenteringRectangle(0.0, 0.0, 1.0, 8.0, 8.0);
                }
                finally {
                    GL11.glPopMatrix();
                }
            }
        }
        try {
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GLTexture.MMARROW.bind();
            GL11.glRotatef((float)(this.playerRotationYaw - 180.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            this.drawCenteringRectangle(0.0, 0.0, 1.0, 8.0, 8.0);
        }
        catch (Exception e) {
        }
        finally {
            GL11.glPopMatrix();
        }
        if (this.renderType == 1) {
            GL11.glScaled((double)(1.0 / (double)mapscale), (double)(1.0 / (double)mapscale), (double)1.0);
            GL11.glTranslated((double)((double)this.scWidth * -0.5), (double)((double)this.scHeight * -0.5), (double)0.0);
            GL11.glScaled((double)fscale, (double)fscale, (double)1.0);
            int width = 0;
            int height = 4;
            for (BiomeData biome : biomeList) {
                width = Math.max(width, this.mc.field_71466_p.func_78256_a(biome.name));
                height += 10;
            }
            int xpos = (this.mapPosition & 2) == 0 ? 2 : this.scWidth / fscale - 2 - (width += 16);
            int ypos = (this.mapPosition & 1) == 0 ? 2 : this.scHeight / fscale - 2 - height;
            GL11.glDisable((int)3553);
            GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.6f);
            this.tessellator.func_78382_b();
            this.tessellator.func_78377_a((double)xpos, (double)(ypos + height), 1.0);
            this.tessellator.func_78377_a((double)(xpos + width), (double)(ypos + height), 1.0);
            this.tessellator.func_78377_a((double)(xpos + width), (double)ypos, 1.0);
            this.tessellator.func_78377_a((double)xpos, (double)ypos, 1.0);
            this.tessellator.func_78381_a();
            int len = this.sortedBiomes ? BiomeData.sortedBiomes.length : biomeList.length;
            for (int i = 0; i < len; ++i) {
                BiomeData biome = this.sortedBiomes ? BiomeData.biomes[BiomeData.sortedBiomes[i]] : biomeList[i];
                int color = BiomeData.getColor(biome.index);
                String name = biome.name;
                GL11.glEnable((int)3553);
                this.mc.field_71466_p.func_78261_a(name, xpos + 14, ypos + 3 + i * 10, 0xFFFFFF);
                GL11.glDisable((int)3553);
                float r = (float)(color >> 16 & 0xFF) * 0.003921569f;
                float g = (float)(color >> 8 & 0xFF) * 0.003921569f;
                float b = (float)(color & 0xFF) * 0.003921569f;
                GL11.glColor3f((float)r, (float)g, (float)b);
                this.tessellator.func_78382_b();
                this.tessellator.func_78377_a((double)(xpos + 2), (double)(ypos + i * 10 + 12), 1.0);
                this.tessellator.func_78377_a((double)(xpos + 12), (double)(ypos + i * 10 + 12), 1.0);
                this.tessellator.func_78377_a((double)(xpos + 12), (double)(ypos + i * 10 + 2), 1.0);
                this.tessellator.func_78377_a((double)(xpos + 2), (double)(ypos + i * 10 + 2), 1.0);
                this.tessellator.func_78381_a();
            }
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslated((double)((double)this.scWidth * 0.5), (double)((double)this.scHeight * 0.5), (double)0.0);
            GL11.glScaled((double)mapscale, (double)mapscale, (double)1.0);
            GL11.glEnable((int)3553);
        } else if (this.renderType == 2 || this.renderType == 3) {
            // empty if block
        }
        GL11.glScalef((float)(1.0f / (float)mapscale), (float)(1.0f / (float)mapscale), (float)1.0f);
        int alpha = (int)(this.zoomVisible * 255.0f);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        if (alpha > 0) {
            String text = String.format("%2.2fx", this.currentZoom);
            int width = fontRenderer.func_78256_a(text);
            if (alpha > 255) {
                alpha = 255;
            }
            int tx = 120 * mapscale - (width + 2) * fscale;
            int ty = 120 * mapscale - 10 * fscale;
            GL11.glTranslatef((float)tx, (float)ty, (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            int rgb = alpha << 24 | 0xFFFFFF;
            fontRenderer.func_78261_a(text, 0, 0, rgb);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)(-tx), (float)(-ty), (float)0.0f);
        }
        if (this.visibleWaypoints && this.currentDimension != this.waypointDimension) {
            String text = this.getDimensionName(this.waypointDimension);
            float width = (float)(fontRenderer.func_78256_a(text) * fscale) * 0.5f;
            GL11.glTranslatef((float)(-width), (float)-32.0f, (float)0.0f);
            GL11.glScaled((double)fscale, (double)fscale, (double)1.0);
            fontRenderer.func_78261_a(text, 0, 0, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)width, (float)32.0f, (float)0.0f);
        }
        if (this.showHeading) {
            float heading = (this.playerRotationYaw + 180.0f) % 360.0f;
            if (heading < 0.0f) {
                heading += 360.0f;
            }
            String text = String.format("%03d'", (int)heading);
            int ty = 120 * mapscale - 10 * fscale;
            GL11.glTranslatef((float)0.0f, (float)(120.0f * (float)mapscale - (float)(10 * fscale)), (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            fontRenderer.func_78261_a(text, (int)((float)fontRenderer.func_78256_a(text) * -0.5f), 0, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)0.0f, (float)(-120.0f * (float)mapscale + (float)(10 * fscale)), (float)0.0f);
        }
        if (this.showCoordinate) {
            String line2;
            String line1;
            GL11.glTranslatef((float)0.0f, (float)(-120.0f * (float)mapscale + 2.0f), (float)0.0f);
            GL11.glScalef((float)fscale, (float)fscale, (float)1.0f);
            if (this.coordinateType == 0) {
                int posX = MathHelper.func_76128_c((double)this.playerPosX);
                int posY = MathHelper.func_76128_c((double)this.thePlayer.field_70121_D.field_72338_b);
                int posZ = MathHelper.func_76128_c((double)this.playerPosZ);
                line1 = String.format("%+d, %+d", posX, posZ);
                line2 = Integer.toString(posY);
            } else if (this.coordinateType == 1) {
                line1 = String.format("%+1.2f, %+1.2f", this.playerPosX, this.playerPosZ);
                line2 = String.format("%1.2f", this.thePlayer.field_70121_D.field_72338_b);
            } else if (this.coordinateType == 2) {
                line1 = String.format("%+1.2f, %+1.2f", this.playerPosX, this.playerPosZ);
                line2 = String.format("%1.2f (%d)", this.playerPosY, (int)this.thePlayer.field_70121_D.field_72338_b);
            } else {
                line1 = String.format("%s%1.2f, %s%1.2f", this.playerPosZ >= 0.0 ? "S" : "N", this.playerPosZ >= 0.0 ? this.playerPosZ : -this.playerPosZ, this.playerPosX >= 0.0 ? "E" : "W", this.playerPosX >= 0.0 ? this.playerPosX : -this.playerPosX);
                line2 = String.format("%1.2fm", this.thePlayer.field_70121_D.field_72338_b);
            }
            fontRenderer.func_78261_a(line1, (int)((float)fontRenderer.func_78256_a(line1) * -0.5f), 2, 0xFFFFFF);
            fontRenderer.func_78261_a(line2, (int)((float)fontRenderer.func_78256_a(line2) * -0.5f), 12, 0xFFFFFF);
            GL11.glScaled((double)(1.0 / (double)fscale), (double)(1.0 / (double)fscale), (double)1.0);
            GL11.glTranslatef((float)0.0f, (float)(120.0f * (float)mapscale - 2.0f), (float)0.0f);
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
    }

    public void setOption(EnumOption option, EnumOptionValue value) {
        block0 : switch (option) {
            case MINIMAP: {
                this.enable = EnumOptionValue.bool(value);
                break;
            }
            case SHOW_MENU_KEY: {
                this.showMenuKey = EnumOptionValue.bool(value);
                break;
            }
            case MASK_TYPE: {
                this.useStencil = value == EnumOptionValue.STENCIL;
                break;
            }
            case MAP_SHAPE: {
                this.roundmap = value == EnumOptionValue.ROUND;
                break;
            }
            case TEXTURE: {
                this.textureView = Math.max(0, option.getValue(value));
                switch (this.textureView) {
                    case 0: {
                        GLTexture.setPack("/assets/reifnsk/textures/minimap/");
                        break block0;
                    }
                }
                break;
            }
            case MAP_POSITION: {
                this.mapPosition = Math.max(0, option.getValue(value));
                break;
            }
            case MAP_SCALE: {
                this.mapScale = option.getValue(value);
                break;
            }
            case MAP_OPACITY: {
                switch (value) {
                    default: {
                        this.mapOpacity = 1.0f;
                        break block0;
                    }
                    case PERCENT75: {
                        this.mapOpacity = 0.75f;
                        break block0;
                    }
                    case PERCENT50: {
                        this.mapOpacity = 0.5f;
                        break block0;
                    }
                    case PERCENT25: 
                }
                this.mapOpacity = 0.25f;
                break;
            }
            case LARGE_MAP_SCALE: {
                this.largeMapScale = option.getValue(value);
                break;
            }
            case LARGE_MAP_OPACITY: {
                switch (value) {
                    default: {
                        this.largeMapOpacity = 1.0f;
                        break block0;
                    }
                    case PERCENT75: {
                        this.largeMapOpacity = 0.75f;
                        break block0;
                    }
                    case PERCENT50: {
                        this.largeMapOpacity = 0.5f;
                        break block0;
                    }
                    case PERCENT25: 
                }
                this.largeMapOpacity = 0.25f;
                break;
            }
            case LARGE_MAP_LABEL: {
                this.largeMapLabel = EnumOptionValue.bool(value);
                break;
            }
            case SORT_BIOMES: {
                this.sortedBiomes = EnumOptionValue.bool(value);
                break;
            }
            case FILTERING: {
                this.filtering = EnumOptionValue.bool(value);
                break;
            }
            case SHOW_CLOCK: {
                this.showClock = Math.max(0, option.getValue(value));
                break;
            }
            case SHOW_COORDINATES: {
                this.coordinateType = Math.max(0, option.getValue(value));
                this.showCoordinate = value != EnumOptionValue.DISABLE;
                break;
            }
            case SHOW_HEADING: {
                this.showHeading = EnumOptionValue.bool(value);
                break;
            }
            case FONT_SCALE: {
                this.fontScale = Math.max(0, option.getValue(value));
                break;
            }
            case UPDATE_FREQUENCY: {
                this.updateFrequencySetting = Math.max(0, option.getValue(value));
                break;
            }
            case THREADING: {
                this.threading = EnumOptionValue.bool(value);
                break;
            }
            case THREAD_PRIORITY: {
                this.threadPriority = Math.max(0, option.getValue(value));
                if (this.activeThread == null || !this.activeThread.isAlive()) break;
                this.activeThread.setPriority(3 + this.threadPriority);
                break;
            }
            case PRELOADED_CHUNKS: {
                this.preloadedChunks = EnumOptionValue.bool(value);
                break;
            }
            case LIGHTING: {
                this.lightmap = Math.max(0, option.getValue(value));
                break;
            }
            case LIGHTING_TYPE: {
                this.lightType = Math.max(0, option.getValue(value));
                break;
            }
            case TERRAIN_UNDULATE: {
                this.undulate = Math.max(0, option.getValue(value));
                break;
            }
            case TERRAIN_SLOPING_DIRECTION: {
                this.terrainSlopingDirection = Math.max(0, option.getValue(value));
                break;
            }
            case TERRAIN_DEPTH: {
                this.heightmap = EnumOptionValue.bool(value);
                break;
            }
            case TRANSPARENCY: {
                this.transparency = EnumOptionValue.bool(value);
                break;
            }
            case WATER_TRANSPARENCY: {
                this.waterTransparency = EnumOptionValue.bool(value);
                break;
            }
            case ENVIRONMENT_COLOR: {
                this.environmentColor = EnumOptionValue.bool(value);
                break;
            }
            case OMIT_HEIGHT_CALC: {
                this.omitHeightCalc = EnumOptionValue.bool(value);
                break;
            }
            case HIDE_SNOW: {
                this.hideSnow = EnumOptionValue.bool(value);
                break;
            }
            case SHOW_CHUNK_GRID: {
                this.showChunkGrid = EnumOptionValue.bool(value);
                break;
            }
            case SHOW_SLIME_CHUNK: {
                this.showSlimeChunk = EnumOptionValue.bool(value);
                break;
            }
            case RENDER_TYPE: {
                this.renderType = Math.max(0, option.getValue(value));
                break;
            }
            case ENTITIES_RADAR: {
                this.configEntitiesRadar = EnumOptionValue.bool(value);
                break;
            }
            case MINIMAP_OPTION: {
                this.mc.func_147108_a((GuiScreen)new GuiOptionScreen(1));
                break;
            }
            case LARGE_MAP_OPTION: {
                this.mc.func_147108_a((GuiScreen)new GuiOptionScreen(2));
                break;
            }
            case SURFACE_MAP_OPTION: {
                this.mc.func_147108_a((GuiScreen)new GuiOptionScreen(3));
                break;
            }
            case ABOUT_MINIMAP: {
                this.mc.func_147108_a((GuiScreen)new GuiOptionScreen(6));
                break;
            }
            case ENTITIES_RADAR_OPTION: {
                this.mc.func_147108_a((GuiScreen)new GuiOptionScreen(4));
                break;
            }
            case DEATH_POINT: {
                this.deathPoint = EnumOptionValue.bool(value);
                break;
            }
            case CAVE_MAP_OPTION: {
                this.caveMapping = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_PLAYER: {
                this.configEntityPlayer = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_ANIMAL: {
                this.configEntityAnimal = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_MOB: {
                this.configEntityMob = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_SLIME: {
                this.configEntitySlime = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_SQUID: {
                this.configEntitySquid = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_AMBIENT: {
                this.configEntityAmbient = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_LIVING: {
                this.configEntityLiving = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_LIGHTNING: {
                this.configEntityLightning = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_DIRECTION: {
                this.configEntityDirection = EnumOptionValue.bool(value);
                break;
            }
            case ENTITY_FILTER: {
                this.configEntityFilter = EnumOptionValue.bool(value);
                break;
            }
            case MARKER_OPTION: {
                this.mc.func_147108_a((GuiScreen)new GuiOptionScreen(5));
                break;
            }
            case MARKER: {
                this.marker = EnumOptionValue.bool(value);
                break;
            }
            case MARKER_ICON: {
                this.markerIcon = EnumOptionValue.bool(value);
                break;
            }
            case MARKER_LABEL: {
                this.markerLabel = Math.max(0, option.getValue(value));
                break;
            }
            case MARKER_BEAM: {
                this.markerBeam = EnumOptionValue.bool(value);
                break;
            }
            case MARKER_DISTANCE: {
                this.markerDistance = EnumOptionValue.bool(value);
                break;
            }
            case MARKER_TRANSPARENCY: {
                switch (value) {
                    default: {
                        this.markerOpacity = 1.0f;
                        break block0;
                    }
                    case PERCENT25: {
                        this.markerOpacity = 0.25f;
                        break block0;
                    }
                    case PERCENT50: {
                        this.markerOpacity = 0.5f;
                        break block0;
                    }
                    case PERCENT75: 
                }
                this.markerOpacity = 0.75f;
                break;
            }
            case DEFAULT_ZOOM: {
                this.defaultZoom = Math.max(0, option.getValue(value));
                break;
            }
            case WAYPOINT_SIZE: {
                this.minimapWaypointSize = value == EnumOptionValue.PERCENT50 ? 0.5f : 1.0f;
            }
        }
    }

    public EnumOptionValue getOption(EnumOption option) {
        switch (option) {
            case MINIMAP: {
                return EnumOptionValue.bool(this.enable);
            }
            case SHOW_MENU_KEY: {
                return EnumOptionValue.bool(this.showMenuKey);
            }
            case MASK_TYPE: {
                return this.useStencil ? EnumOptionValue.STENCIL : EnumOptionValue.DEPTH;
            }
            case MAP_SHAPE: {
                return this.roundmap ? EnumOptionValue.ROUND : EnumOptionValue.SQUARE;
            }
            case TEXTURE: {
                return option.getValue(this.textureView);
            }
            case MAP_POSITION: {
                return option.getValue(this.mapPosition);
            }
            case MAP_SCALE: {
                return option.getValue(this.mapScale);
            }
            case MAP_OPACITY: {
                return this.mapOpacity == 0.25f ? EnumOptionValue.PERCENT25 : (this.mapOpacity == 0.5f ? EnumOptionValue.PERCENT50 : (this.mapOpacity == 0.75f ? EnumOptionValue.PERCENT75 : EnumOptionValue.PERCENT100));
            }
            case LARGE_MAP_SCALE: {
                return option.getValue(this.largeMapScale);
            }
            case LARGE_MAP_OPACITY: {
                return this.largeMapOpacity == 0.25f ? EnumOptionValue.PERCENT25 : (this.largeMapOpacity == 0.5f ? EnumOptionValue.PERCENT50 : (this.largeMapOpacity == 0.75f ? EnumOptionValue.PERCENT75 : EnumOptionValue.PERCENT100));
            }
            case LARGE_MAP_LABEL: {
                return EnumOptionValue.bool(this.largeMapLabel);
            }
            case SORT_BIOMES: {
                return EnumOptionValue.bool(this.sortedBiomes);
            }
            case FILTERING: {
                return EnumOptionValue.bool(this.filtering);
            }
            case SHOW_CLOCK: {
                return option.getValue(this.showClock);
            }
            case SHOW_COORDINATES: {
                return option.getValue(this.coordinateType);
            }
            case SHOW_HEADING: {
                return EnumOptionValue.bool(this.showHeading);
            }
            case FONT_SCALE: {
                return option.getValue(this.fontScale);
            }
            case UPDATE_FREQUENCY: {
                return option.getValue(this.updateFrequencySetting);
            }
            case THREADING: {
                return EnumOptionValue.bool(this.threading);
            }
            case THREAD_PRIORITY: {
                return option.getValue(this.threadPriority);
            }
            case PRELOADED_CHUNKS: {
                return EnumOptionValue.bool(this.preloadedChunks);
            }
            case LIGHTING: {
                return option.getValue(this.lightmap);
            }
            case LIGHTING_TYPE: {
                return option.getValue(this.lightType);
            }
            case TERRAIN_UNDULATE: {
                return option.getValue(this.undulate);
            }
            case TERRAIN_SLOPING_DIRECTION: {
                return option.getValue(this.terrainSlopingDirection);
            }
            case TERRAIN_DEPTH: {
                return EnumOptionValue.bool(this.heightmap);
            }
            case TRANSPARENCY: {
                return EnumOptionValue.bool(this.transparency);
            }
            case WATER_TRANSPARENCY: {
                return EnumOptionValue.bool(this.waterTransparency);
            }
            case ENVIRONMENT_COLOR: {
                return EnumOptionValue.bool(this.environmentColor);
            }
            case OMIT_HEIGHT_CALC: {
                return EnumOptionValue.bool(this.omitHeightCalc);
            }
            case HIDE_SNOW: {
                return EnumOptionValue.bool(this.hideSnow);
            }
            case SHOW_CHUNK_GRID: {
                return EnumOptionValue.bool(this.showChunkGrid);
            }
            case SHOW_SLIME_CHUNK: {
                return EnumOptionValue.bool(this.showSlimeChunk);
            }
            case RENDER_TYPE: {
                return option.getValue(this.renderType);
            }
            case ENTITIES_RADAR: {
                return EnumOptionValue.bool(this.configEntitiesRadar);
            }
            default: {
                return option.getValue(0);
            }
            case DEATH_POINT: {
                return EnumOptionValue.bool(this.deathPoint);
            }
            case CAVE_MAP_OPTION: {
                return EnumOptionValue.bool(this.caveMapping);
            }
            case ENTITY_PLAYER: {
                return EnumOptionValue.bool(this.configEntityPlayer);
            }
            case ENTITY_ANIMAL: {
                return EnumOptionValue.bool(this.configEntityAnimal);
            }
            case ENTITY_MOB: {
                return EnumOptionValue.bool(this.configEntityMob);
            }
            case ENTITY_SLIME: {
                return EnumOptionValue.bool(this.configEntitySlime);
            }
            case ENTITY_SQUID: {
                return EnumOptionValue.bool(this.configEntitySquid);
            }
            case ENTITY_AMBIENT: {
                return EnumOptionValue.bool(this.configEntityAmbient);
            }
            case ENTITY_LIVING: {
                return EnumOptionValue.bool(this.configEntityLiving);
            }
            case ENTITY_LIGHTNING: {
                return EnumOptionValue.bool(this.configEntityLightning);
            }
            case ENTITY_DIRECTION: {
                return EnumOptionValue.bool(this.configEntityDirection);
            }
            case ENTITY_FILTER: {
                return EnumOptionValue.bool(this.configEntityFilter);
            }
            case MARKER: {
                return EnumOptionValue.bool(this.marker);
            }
            case MARKER_ICON: {
                return EnumOptionValue.bool(this.markerIcon);
            }
            case MARKER_LABEL: {
                return option.getValue(this.markerLabel);
            }
            case MARKER_DISTANCE: {
                return EnumOptionValue.bool(this.markerDistance);
            }
            case MARKER_BEAM: {
                return EnumOptionValue.bool(this.markerBeam);
            }
            case MARKER_TRANSPARENCY: {
                return this.markerOpacity == 0.25f ? EnumOptionValue.PERCENT25 : (this.markerOpacity == 0.5f ? EnumOptionValue.PERCENT50 : (this.markerOpacity == 0.75f ? EnumOptionValue.PERCENT75 : EnumOptionValue.PERCENT100));
            }
            case DEFAULT_ZOOM: {
                return option.getValue(this.defaultZoom);
            }
            case WAYPOINT_SIZE: 
        }
        return this.minimapWaypointSize == 0.5f ? EnumOptionValue.PERCENT50 : EnumOptionValue.PERCENT100;
    }

    public void setNumericOption(EnumOption option, String value) {
        switch (option) {
            case TERRAIN_SLOPING_HEIGHT: {
                this.terrainSlopingHeight = Math.max(0.0f, Math.min(0.8f, Float.parseFloat(value)));
                break;
            }
            case CURRENT_ZOOM: {
                this.flagZoom = this.defaultZoom == 6 ? Math.max(0, Math.min(5, Integer.parseInt(value))) : this.defaultZoom;
                break;
            }
            case MARKER_RANGE: {
                this.markerRange = Math.max(0.0, Double.parseDouble(value));
                break;
            }
            case MARKER_BEAM_RANGE: {
                this.markerBeamRange = Math.max(0.0, Double.parseDouble(value));
            }
        }
    }

    public String getNumericOption(EnumOption option) {
        switch (option) {
            case TERRAIN_SLOPING_HEIGHT: {
                return String.valueOf(this.terrainSlopingHeight);
            }
            case CURRENT_ZOOM: {
                return String.valueOf(this.flagZoom);
            }
            case MARKER_RANGE: {
                return String.valueOf(this.markerRange);
            }
            case MARKER_BEAM_RANGE: {
                return String.valueOf(this.markerBeamRange);
            }
        }
        return String.valueOf(0);
    }

    protected void saveOptions() {
        File file = new File(mcDataDir, "config" + File.separatorChar + "ReiMinimap.cfg");
        try {
            PrintWriter out = new PrintWriter(file, "UTF-8");
            for (EnumOption option : EnumOption.values()) {
                if (this.getOption(option) == EnumOptionValue.SUB_OPTION || this.getOption(option) == EnumOptionValue.VERSION || this.getOption(option) == EnumOptionValue.AUTHOR) continue;
                if (option == EnumOption.TERRAIN_SLOPING_HEIGHT || option == EnumOption.CURRENT_ZOOM || option == EnumOption.MARKER_RANGE || option == EnumOption.MARKER_BEAM_RANGE) {
                    out.printf("%s: %s%n", ReiMinimap.capitalize(option.toString()), this.getNumericOption(option));
                    continue;
                }
                out.printf("%s: %s%n", ReiMinimap.capitalize(option.toString()), ReiMinimap.capitalize(this.getOption(option).toString()));
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadOptions() {
        File file = new File(mcDataDir, "config" + File.separatorChar + "ReiMinimap.cfg");
        if (file.exists()) {
            boolean error = false;
            try {
                Scanner in = new Scanner(file, "UTF-8");
                while (in.hasNextLine()) {
                    try {
                        String[] strs = in.nextLine().split(":");
                        EnumOption option = EnumOption.valueOf(ReiMinimap.toUpperCase(strs[0].trim()));
                        if (option == EnumOption.TERRAIN_SLOPING_HEIGHT || option == EnumOption.CURRENT_ZOOM || option == EnumOption.MARKER_RANGE || option == EnumOption.MARKER_BEAM_RANGE) {
                            this.setNumericOption(option, strs[1].trim());
                            continue;
                        }
                        this.setOption(option, EnumOptionValue.valueOf(ReiMinimap.toUpperCase(strs[1].trim())));
                    }
                    catch (Exception e) {
                        System.err.println(e.getMessage());
                        error = true;
                    }
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (error) {
                this.saveOptions();
            }
        }
    }

    public List<Waypoint> getWaypoints() {
        return this.wayPts;
    }

    protected void saveWaypoints() {
        File waypointFile = new File(optionsDir, this.currentLevelName + ".DIM" + this.waypointDimension + ".points");
        if (waypointFile.isDirectory()) {
            this.chatInfo("\u00a7e[Rei's Minimap] Error Saving Waypoints");
            ReiMinimap.error("[Rei's Minimap] Error Saving Waypoints: (" + waypointFile + ") is directory.");
        } else {
            try {
                PrintWriter out = new PrintWriter(waypointFile, "UTF-8");
                for (Waypoint pt : this.wayPts) {
                    out.println(pt);
                }
                out.flush();
                out.close();
            }
            catch (Exception e) {
                this.chatInfo("\u00a7e[Rei's Minimap] Error Saving Waypoints");
                ReiMinimap.error("Error Saving Waypoints", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadWaypoints() {
        this.wayPts = null;
        this.wayPtsMap.clear();
        Pattern pattern = Pattern.compile(Pattern.quote(this.currentLevelName) + "\\.DIM(-?[0-9])\\.points");
        int load = 0;
        int dim = 0;
        for (String file : optionsDir.list()) {
            Matcher m = pattern.matcher(file);
            if (!m.matches()) continue;
            ++dim;
            int dimension = Integer.parseInt(m.group(1));
            ArrayList<Waypoint> list = new ArrayList<Waypoint>();
            Scanner in = null;
            try {
                in = new Scanner(new File(optionsDir, file), "UTF-8");
                while (in.hasNextLine()) {
                    Waypoint wp = Waypoint.load(in.nextLine());
                    if (wp == null) continue;
                    list.add(wp);
                    ++load;
                }
            }
            catch (Exception e) {
            }
            finally {
                if (in != null) {
                    in.close();
                }
            }
            this.wayPtsMap.put(dimension, list);
            if (dimension != this.currentDimension) continue;
            this.wayPts = list;
        }
        if (this.wayPts == null) {
            this.wayPts = new ArrayList<Waypoint>();
        }
        if (load != 0) {
            this.chatInfo("\u00a7e[Rei's Minimap] " + load + " Waypoints loaded for " + this.currentLevelName);
        }
    }

    protected void chatInfo(String s) {
        this.ingameGUI.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(s));
    }

    private float[] generateLightBrightnessTable(float f) {
        float[] result = new float[16];
        for (int i = 0; i <= 15; ++i) {
            float f1 = 1.0f - (float)i / 15.0f;
            result[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
        }
        return result;
    }

    private int calculateSkylightSubtracted(long time, float f) {
        float f1 = this.calculateCelestialAngle(time, f);
        float f2 = Math.max(0.0f, Math.min(1.0f, 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.5f)));
        f2 = 1.0f - f2;
        f2 = (float)((double)f2 * (1.0 - (double)(this.theWorld.func_72867_j(1.0f) * 5.0f) / 16.0));
        f2 = (float)((double)f2 * (1.0 - (double)(this.theWorld.func_72819_i(1.0f) * 5.0f) / 16.0));
        f2 = 1.0f - f2;
        return (int)(f2 * 11.0f);
    }

    private void updateLightmap(long time, float f) {
        float sunBrightness = this.getSunBrightness(time, f);
        for (int i = 0; i < 256; ++i) {
            float f2 = sunBrightness * 0.95f + 0.05f;
            float sky = this.theWorld.field_73011_w.field_76573_f[i / 16] * f2;
            float block = this.theWorld.field_73011_w.field_76573_f[i % 16] * 1.55f;
            if (this.theWorld.field_73016_r > 0) {
                sky = this.theWorld.field_73011_w.field_76573_f[i / 16];
            }
            float skyR = sky * (sunBrightness * 0.65f + 0.35f);
            float skyG = sky * (sunBrightness * 0.65f + 0.35f);
            float blockG = block * ((block * 0.6f + 0.4f) * 0.6f + 0.4f);
            float blockB = block * (block * block * 0.6f + 0.4f);
            float red = skyR + block;
            float green = skyG + blockG;
            float blue = sky + blockB;
            red = Math.min(1.0f, red * 0.96f + 0.03f);
            green = Math.min(1.0f, green * 0.96f + 0.03f);
            blue = Math.min(1.0f, blue * 0.96f + 0.03f);
            float gamma = this.mc.field_71474_y.field_74333_Y;
            float red2 = 1.0f - red;
            float green2 = 1.0f - green;
            float blue2 = 1.0f - blue;
            red2 = 1.0f - red2 * red2 * red2 * red2;
            green2 = 1.0f - green2 * green2 * green2 * green2;
            blue2 = 1.0f - blue2 * blue2 * blue2 * blue2;
            red = red * (1.0f - gamma) + red2 * gamma;
            green = green * (1.0f - gamma) + green2 * gamma;
            blue = blue * (1.0f - gamma) + blue2 * gamma;
            this.lightmapRed[i] = Math.max(0.0f, Math.min(1.0f, red * 0.96f + 0.03f));
            this.lightmapGreen[i] = Math.max(0.0f, Math.min(1.0f, green * 0.96f + 0.03f));
            this.lightmapBlue[i] = Math.max(0.0f, Math.min(1.0f, blue * 0.96f + 0.03f));
        }
    }

    private float getSunBrightness(long time, float f) {
        float f1 = this.calculateCelestialAngle(time, f);
        float f2 = Math.max(0.0f, Math.min(1.0f, 1.0f - (MathHelper.func_76134_b((float)(f1 * (float)Math.PI * 2.0f)) * 2.0f + 0.2f)));
        f2 = 1.0f - f2;
        f2 *= 1.0f - this.theWorld.func_72867_j(f) * 5.0f * 0.0625f;
        return (f2 *= 1.0f - this.theWorld.func_72819_i(f) * 5.0f * 0.0625f) * 0.8f + 0.2f;
    }

    private float calculateCelestialAngle(long time, float f) {
        if (ReiMinimap.classExists("sedridor.B3M.B3M_Core")) {
            return B3M_Core.instance.calculateCelestialAngle(time, f);
        }
        return this.theWorld.field_73011_w.func_76563_a(time, f);
    }

    private float getSunAngle() {
        float sunAngle = this.calculateCelestialAngle(this.theWorld.func_72820_D(), 0.0f) * -360.0f;
        return sunAngle;
    }

    private void drawCenteringRectangle(double centerX, double centerY, double z, double w, double h) {
        this.startDrawingQuads();
        this.addVertexWithUV(centerX - (w *= 0.5), centerY + (h *= 0.5), z, 0.0, 1.0);
        this.addVertexWithUV(centerX + w, centerY + h, z, 1.0, 1.0);
        this.addVertexWithUV(centerX + w, centerY - h, z, 1.0, 0.0);
        this.addVertexWithUV(centerX - w, centerY - h, z, 0.0, 0.0);
        this.draw();
    }

    private static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static String capitalize(String src) {
        if (src == null) {
            return null;
        }
        boolean title = true;
        char[] cs = src.toCharArray();
        int j = cs.length;
        for (int i = 0; i < j; ++i) {
            char c = cs[i];
            if (c == '_') {
                c = ' ';
            }
            cs[i] = title ? Character.toTitleCase(c) : Character.toLowerCase(c);
            title = Character.isWhitespace(c);
        }
        return new String(cs);
    }

    public static String toUpperCase(String src) {
        return src == null ? null : src.replace(' ', '_').toUpperCase(Locale.ENGLISH);
    }

    private static boolean checkGuiScreen(GuiScreen gui) {
        return true;
    }

    protected String getDimensionName(int dim) {
        String name = this.dimensionName.get(dim);
        return name == null ? "DIM:" + dim : name;
    }

    protected int getWaypointDimension() {
        return this.waypointDimension;
    }

    protected int getCurrentDimension() {
        return this.currentDimension;
    }

    private double getDimensionScale(int dim) {
        Double d = this.dimensionScale.get(dim);
        return d == null ? 1.0 : d;
    }

    protected double getVisibleDimensionScale() {
        return this.getDimensionScale(this.waypointDimension) / this.getDimensionScale(this.currentDimension);
    }

    protected void prevDimension() {
        Map.Entry<Integer, List<Waypoint>> entry = this.wayPtsMap.lowerEntry(this.waypointDimension);
        if (entry == null) {
            entry = this.wayPtsMap.lowerEntry(Integer.MAX_VALUE);
        }
        if (entry != null) {
            this.waypointDimension = entry.getKey();
            this.wayPts = entry.getValue();
        }
    }

    protected void nextDimension() {
        Map.Entry<Integer, List<Waypoint>> entry = this.wayPtsMap.higherEntry(this.waypointDimension);
        if (entry == null) {
            entry = this.wayPtsMap.higherEntry(Integer.MIN_VALUE);
        }
        if (entry != null) {
            this.waypointDimension = entry.getKey();
            this.wayPts = entry.getValue();
        }
    }

    private int getHeightValue(Chunk chunk, int x, int z) {
        Block block;
        int height = chunk.func_76611_b(x, z);
        for (int i = (height >> 4) * 16 + 15; i < this.worldHeight; i += 16) {
            block = this.theWorld.func_147439_a((chunk.field_76635_g << 4) + x, i, (chunk.field_76647_h << 4) + z);
            if (block.func_149717_k() <= 0) continue;
            height = i + 1;
        }
        if (this.shouldMapCaves() && height >= this.posY && this.posY <= 126) {
            int y = this.posY;
            block = this.theWorld.func_147439_a((chunk.field_76635_g << 4) + x, y, (chunk.field_76647_h << 4) + z);
            if (block.func_149717_k() == 0 && block.func_149688_o() != Material.field_151587_i) {
                while (block.func_149717_k() == 0 && block.func_149688_o() != Material.field_151587_i && y >= 0) {
                    if (y == 0) {
                        return y;
                    }
                    block = this.theWorld.func_147439_a((chunk.field_76635_g << 4) + x, y - 1, (chunk.field_76647_h << 4) + z);
                    --y;
                }
                return y + 1;
            }
            while (y <= this.posY + 10 && y < (this.posY <= 126 ? 127 : 255)) {
                if ((block = this.theWorld.func_147439_a((chunk.field_76635_g << 4) + x, ++y, (chunk.field_76647_h << 4) + z)).func_149717_k() != 0 || block.func_149688_o() == Material.field_151587_i) continue;
                return y;
            }
            return -1;
        }
        return height;
    }

    private boolean shouldMapCaves() {
        return this.currentDimension == -1 || this.getIsInCave(this.posX, this.posY, this.posZ) && this.caveMapping && this.allowCavemap;
    }

    private boolean getIsInCave(int x, int y, int z) {
        int i;
        Block block = this.theWorld.func_147439_a(x, y, z);
        for (i = y; (block.func_149688_o() == Material.field_151586_h || block.func_149688_o() == Material.field_151587_i || block.func_149688_o() == Material.field_151584_j) && i < 255; ++i) {
            block = this.theWorld.func_147439_a(x, i + 1, z);
        }
        return this.theWorld.func_72938_d(x, z).func_76614_a(EnumSkyBlock.Sky, x & 0xF, Math.max(Math.min(i, 255), 0), z & 0xF) <= 0;
    }

    private boolean canBlockSeeTheSky(int x, int y, int z) {
        int i;
        Block block = this.theWorld.func_147439_a(x, y, z);
        for (i = y; (block.func_149688_o() == Material.field_151586_h || block.func_149688_o() == Material.field_151587_i || block.func_149688_o() == Material.field_151584_j) && i < 255; ++i) {
            block = this.theWorld.func_147439_a(x, i + 1, z);
        }
        return this.theWorld.func_72938_d(x, z).func_76614_a(EnumSkyBlock.Sky, x & 0xF, Math.max(Math.min(i, 255), 0), z & 0xF) > 0;
    }

    private static SocketAddress getRemoteSocketAddress(EntityPlayer player) {
        NetHandlerPlayClient netClientHandler = ((EntityClientPlayerMP)player).field_71174_a;
        NetworkManager networkManager = netClientHandler.func_147298_b();
        return networkManager == null ? null : networkManager.func_74430_c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void error(String str, Exception e) {
        File file = new File(optionsDir, "error.txt");
        PrintWriter out = null;
        try {
            FileOutputStream fos = new FileOutputStream(file, true);
            out = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            ReiMinimap.information(out);
            out.println(str);
            e.printStackTrace(out);
            out.println();
            out.flush();
        }
        catch (Exception ex) {
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void error(String str) {
        File file = new File(optionsDir, "error.txt");
        PrintWriter out = null;
        try {
            FileOutputStream fos = new FileOutputStream(file, true);
            out = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            ReiMinimap.information(out);
            out.println(str);
            out.println();
            out.flush();
        }
        catch (Exception exception) {
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private static final void information(PrintWriter out) {
        out.printf("--- %1$tF %1$tT %1$tZ ---%n", System.currentTimeMillis());
        out.printf("Rei's Minimap %s [%s]%n", "v3.6", "1.7.10");
        out.printf("OS: %s (%s) version %s%n", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"));
        out.printf("Java: %s, %s%n", System.getProperty("java.version"), System.getProperty("java.vendor"));
        out.printf("VM: %s (%s), %s%n", System.getProperty("java.vm.name"), System.getProperty("java.vm.info"), System.getProperty("java.vm.vendor"));
        out.printf("LWJGL: %s%n", Sys.getVersion());
        out.printf("OpenGL: %s version %s, %s%n", GL11.glGetString((int)7937), GL11.glGetString((int)7938), GL11.glGetString((int)7936));
    }

    protected boolean isMinecraftThread() {
        return Thread.currentThread() == this.mcThread;
    }

    protected static final int version(int i, int major, int minor, int revision) {
        return (i & 0xFF) << 24 | (major & 0xFF) << 16 | (minor & 0xFF) << 8 | (revision & 0xFF) << 0;
    }

    protected int getWorldHeight() {
        return this.worldHeight;
    }

    private static void close(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int getEntityColor(Entity entity) {
        if (entity == this.thePlayer) {
            return 0;
        }
        if (entity instanceof EntityPlayer) {
            return this.visibleEntityPlayer ? -16723457 : 0;
        }
        if (entity instanceof EntitySquid) {
            return this.visibleEntitySquid ? -16760704 : 0;
        }
        if (entity instanceof EntityAnimal) {
            return this.visibleEntityAnimal ? -1 : 0;
        }
        if (entity instanceof EntitySlime) {
            return this.visibleEntitySlime ? -10444704 : 0;
        }
        if (entity instanceof EntityAmbientCreature) {
            return this.visibleEntityAmbient ? -256 : 0;
        }
        if (!(entity instanceof EntityMob) && !(entity instanceof EntityGhast)) {
            if (entity instanceof EntityLivingBase) {
                return this.visibleEntityLiving ? -12533632 : 0;
            }
            return 0;
        }
        return this.visibleEntityMob ? -65536 : 0;
    }

    private int getVisibleEntityType(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            if (entity == this.thePlayer) {
                return -1;
            }
            if (entity instanceof EntityPlayer) {
                return this.visibleEntityPlayer ? 0 : -1;
            }
            if (entity instanceof EntitySquid) {
                return this.visibleEntitySquid ? 3 : -1;
            }
            if (entity instanceof EntityAnimal) {
                return this.visibleEntityAnimal ? 2 : -1;
            }
            if (entity instanceof EntitySlime) {
                return this.visibleEntitySlime ? 4 : -1;
            }
            if (!(entity instanceof EntityMob) && !(entity instanceof EntityGhast)) {
                if (entity instanceof EntityAmbientCreature) {
                    return this.visibleEntityAmbient ? 6 : -1;
                }
                return this.visibleEntityLiving ? 5 : -1;
            }
            return this.visibleEntityMob ? 1 : -1;
        }
        return -1;
    }

    protected boolean getMarker() {
        return this.marker & (this.markerIcon | this.markerLabel < 2 | this.markerDistance);
    }

    protected boolean getMarkerIcon() {
        return this.markerIcon;
    }

    protected int getMarkerLabel() {
        return this.markerLabel;
    }

    protected boolean getMarkerBeam() {
        return this.markerBeam;
    }

    protected boolean getMarkerDistance() {
        return this.markerDistance;
    }

    protected float getMarkerOpacity() {
        return this.markerOpacity;
    }

    protected double getMarkerRange() {
        if (this.markerRange < 100.0) {
            return Double.MAX_VALUE;
        }
        return this.markerRange;
    }

    protected double getMarkerBeamRange() {
        if (this.markerBeamRange < 100.0) {
            return Double.MAX_VALUE;
        }
        return this.markerBeamRange;
    }

    protected int getUpdateCount() {
        return this.updateCount;
    }

    protected Minecraft getMinecraft() {
        return this.mc;
    }

    protected World getWorld() {
        return this.theWorld;
    }

    public void func_110549_a(IResourceManager resourceManager) {
        BlockDataPack.calcTexture();
    }

    static {
        int i;
        version = String.format("%s [%s]", MOD_VERSION, "1.7.10");
        mcDataDir = Minecraft.func_71410_x().field_71412_D;
        optionsDir = new File(Minecraft.func_71410_x().field_71412_D, "config" + File.separatorChar + "rei_minimap");
        updateFrequencys = new int[]{2, 5, 10, 20, 40};
        instance = new ReiMinimap();
        LinkedList<BiomeData> list = new LinkedList<BiomeData>();
        for (BiomeData b : BiomeData.biomes) {
            if (b == null) continue;
            list.add(b);
        }
        biomeList = list.toArray(new BiomeData[0]);
        InputStream in = GuiIngame.class.getResourceAsStream(GuiIngame.class.getSimpleName() + ".class");
        if (in != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while (true) {
                    int read;
                    if ((read = in.read(buffer)) == -1) {
                        in.close();
                        String str = new String(out.toByteArray(), "UTF-8").toLowerCase(Locale.ENGLISH);
                        if (str.indexOf("\u00a70\u00a70") != -1 && str.indexOf("\u00a7e\u00a7f") != -1) {
                            ReiMinimap.instance.errorString = "serious error";
                            ReiMinimap.instance.texture.unregister();
                            ReiMinimap.instance.texture = null;
                        }
                        break;
                    }
                    out.write(buffer, 0, read);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ZOOM_LIST = new double[]{0.5, 1.0, 1.5, 2.0, 4.0, 8.0};
        temp = new float[10];
        float f = 0.0f;
        for (i = 0; i < temp.length; ++i) {
            ReiMinimap.temp[i] = (float)(1.0 / Math.sqrt(i + 1));
            f += temp[i];
        }
        f = 0.3f / f;
        i = 0;
        while (i < temp.length) {
            int n = i++;
            temp[n] = temp[n] * f;
        }
        f = 0.0f;
        for (i = 0; i < 10; ++i) {
            f += temp[i];
        }
    }
}

