/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import reifnsk.minimap.ReiMinimap;
import reifnsk.minimap.Waypoint;

public class WaypointEntityRender
extends Render {
    protected static final ReiMinimap rm = ReiMinimap.instance;
    protected final Minecraft mc;
    protected double far = 1.0;
    protected double _d = 1.0;

    public WaypointEntityRender(Minecraft mc) {
        this.mc = mc;
    }

    public void func_76986_a(Entity par1Entity, double par2, double par4, double par6, float par8, float par9) {
        this.doRenderWaypoints(par1Entity, par2, par4, par6, par8, par9);
    }

    public void doRenderWaypoints(Entity entity, double par2, double par4, double par6, float par8, float par9) {
        this.far = (double)this.mc.field_71474_y.field_151451_c * 12.8;
        this._d = 1.6 / this.far;
        double dscale = rm.getVisibleDimensionScale();
        ArrayList<ViewWaypoint> list = new ArrayList<ViewWaypoint>();
        if (rm.getMarker()) {
            for (Waypoint w : rm.getWaypoints()) {
                if (!w.enable) continue;
                list.add(new ViewWaypoint(w, dscale));
            }
            if (!list.isEmpty()) {
                Collections.sort(list);
                this.mc.field_71460_t.func_78483_a(0.0);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2912);
                int func = GL11.glGetInteger((int)3009);
                float ref = GL11.glGetFloat((int)3010);
                GL11.glAlphaFunc((int)516, (float)0.0f);
                for (ViewWaypoint w : list) {
                    if (rm.getMarkerBeam() && w.distance <= rm.getMarkerBeamRange()) {
                        this.renderBeam(w, par8, par9);
                    }
                    if (!(w.distance <= rm.getMarkerRange())) continue;
                    this.draw(w, par8, par9);
                }
                GL11.glAlphaFunc((int)func, (float)ref);
                GL11.glEnable((int)2912);
                GL11.glEnable((int)2896);
                this.mc.field_71460_t.func_78463_b(0.0);
                this.field_76989_e = 0.0f;
            }
        }
    }

    protected void draw(ViewWaypoint w, float par2, float par4) {
        int j;
        float alpha = (float)Math.max(0.0, 1.0 - w.distance * this._d);
        FontRenderer fontrenderer = this.func_76983_a();
        GL11.glPushMatrix();
        StringBuilder sb = new StringBuilder();
        if (rm.getMarkerLabel() < 2 && w.name != null) {
            sb.append(w.name);
            if (rm.getMarkerDistance()) {
                if (sb.length() != 0) {
                    sb.append(" ");
                }
                if (w.distance >= 100000.0) {
                    sb.append(String.format("[%1.2fkm]", w.distance * 0.001));
                } else {
                    sb.append(String.format("[%1.2fm]", w.distance));
                }
            }
        }
        String str = sb.toString();
        double scale = (w.dl * 0.1 + 1.0) * 0.02666666666666667;
        int slideY = rm.getMarkerIcon() ? -16 : 0;
        GL11.glTranslated((double)w.dx, (double)w.dy, (double)w.dz);
        GL11.glRotatef((float)(-this.field_76990_c.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(this.mc.field_71474_y.field_74320_O == 2 ? -this.field_76990_c.field_78732_j : this.field_76990_c.field_78732_j), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glScaled((double)(-scale), (double)(-scale), (double)scale);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        Tessellator tessellator = Tessellator.field_78398_a;
        if (rm.getMarkerIcon()) {
            GL11.glEnable((int)3553);
            GL11.glDisable((int)2929);
            GL11.glDepthMask((boolean)false);
            Waypoint.FILE[w.type].bind();
            tessellator.func_78382_b();
            tessellator.func_78369_a(w.red, w.green, w.blue, 0.4f);
            tessellator.func_78374_a(-8.0, -8.0, 0.0, 0.0, 0.0);
            tessellator.func_78374_a(-8.0, 8.0, 0.0, 0.0, 1.0);
            tessellator.func_78374_a(8.0, 8.0, 0.0, 1.0, 1.0);
            tessellator.func_78374_a(8.0, -8.0, 0.0, 1.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)2929);
            GL11.glDepthMask((boolean)true);
            tessellator.func_78382_b();
            tessellator.func_78369_a(w.red, w.green, w.blue, alpha);
            tessellator.func_78374_a(-8.0, -8.0, 0.0, 0.0, 0.0);
            tessellator.func_78374_a(-8.0, 8.0, 0.0, 0.0, 1.0);
            tessellator.func_78374_a(8.0, 8.0, 0.0, 1.0, 1.0);
            tessellator.func_78374_a(8.0, -8.0, 0.0, 1.0, 0.0);
            tessellator.func_78381_a();
        }
        if ((j = fontrenderer.func_78256_a(str) >> 1) != 0) {
            alpha = (float)Math.min(1.0, Math.max(0.0, 1.0 + this._d * 900.0 - w.distance * this._d));
            if (rm.getMarkerLabel() == 1) {
                GL11.glDisable((int)3553);
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)false);
                if (w.distance < this.far) {
                    GL11.glDepthMask((boolean)true);
                }
                GL11.glEnable((int)32823);
                GL11.glPolygonOffset((float)1.0f, (float)3.0f);
                tessellator.func_78382_b();
                tessellator.func_78369_a(w.red, w.green, w.blue, Math.min(1.0f, 0.1f + rm.getMarkerOpacity()));
                tessellator.func_78377_a((double)(-j - 2), (double)(slideY - 2), 0.0);
                tessellator.func_78377_a((double)(-j - 2), (double)(slideY + 9), 0.0);
                tessellator.func_78377_a((double)(j + 2), (double)(slideY + 9), 0.0);
                tessellator.func_78377_a((double)(j + 2), (double)(slideY - 2), 0.0);
                tessellator.func_78381_a();
                GL11.glPolygonOffset((float)1.0f, (float)1.0f);
                tessellator.func_78382_b();
                tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.15f);
                tessellator.func_78377_a((double)(-j - 1), (double)(slideY - 1), 0.0);
                tessellator.func_78377_a((double)(-j - 1), (double)(slideY + 8), 0.0);
                tessellator.func_78377_a((double)(j + 1), (double)(slideY + 8), 0.0);
                tessellator.func_78377_a((double)(j + 1), (double)(slideY - 1), 0.0);
                tessellator.func_78381_a();
                GL11.glDisable((int)2929);
                GL11.glDepthMask((boolean)false);
                GL11.glPolygonOffset((float)1.0f, (float)7.0f);
                tessellator.func_78382_b();
                tessellator.func_78369_a(w.red, w.green, w.blue, 0.15f);
                tessellator.func_78377_a((double)(-j - 2), (double)(slideY - 2), 0.0);
                tessellator.func_78377_a((double)(-j - 2), (double)(slideY + 9), 0.0);
                tessellator.func_78377_a((double)(j + 2), (double)(slideY + 9), 0.0);
                tessellator.func_78377_a((double)(j + 2), (double)(slideY - 2), 0.0);
                tessellator.func_78381_a();
                GL11.glPolygonOffset((float)1.0f, (float)5.0f);
                tessellator.func_78382_b();
                tessellator.func_78369_a(0.0f, 0.0f, 0.0f, 0.15f);
                tessellator.func_78377_a((double)(-j - 1), (double)(slideY - 1), 0.0);
                tessellator.func_78377_a((double)(-j - 1), (double)(slideY + 8), 0.0);
                tessellator.func_78377_a((double)(j + 1), (double)(slideY + 8), 0.0);
                tessellator.func_78377_a((double)(j + 1), (double)(slideY - 1), 0.0);
                tessellator.func_78381_a();
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3553);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                fontrenderer.func_78276_b(str, -j, slideY, w.type == 0 ? 0x60FFFFFF : 0x60FF0000);
                int a = (int)(255.0f * alpha);
                if (a > 8) {
                    fontrenderer.func_78276_b(str, -j, slideY, (w.type == 0 ? 0xFFFFFF : 0xFF0000) | a << 24);
                }
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
            } else {
                GL11.glDisable((int)3553);
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)false);
                if (w.distance < this.far) {
                    GL11.glDepthMask((boolean)true);
                }
                GL11.glEnable((int)32823);
                GL11.glPolygonOffset((float)1.0f, (float)1.0f);
                tessellator.func_78382_b();
                tessellator.func_78369_a(0.0f, 0.0f, 0.0f, rm.getMarkerOpacity());
                tessellator.func_78377_a((double)(-j - 1), (double)(slideY - 1), 0.0);
                tessellator.func_78377_a((double)(-j - 1), (double)(slideY + 8), 0.0);
                tessellator.func_78377_a((double)(j + 1), (double)(slideY + 8), 0.0);
                tessellator.func_78377_a((double)(j + 1), (double)(slideY - 1), 0.0);
                tessellator.func_78381_a();
                GL11.glDisable((int)32823);
                GL11.glEnable((int)3553);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                fontrenderer.func_78276_b(str, -j, slideY, w.type == 0 ? 0x60FFFFFF : 0x60FF0000);
                int a = (int)(255.0f * alpha);
                if (a > 8) {
                    fontrenderer.func_78276_b(str, -j, slideY, (w.type == 0 ? 0xFFFFFF : 0xFF0000) | a << 24);
                }
                GL11.glEnable((int)2929);
                GL11.glDepthMask((boolean)true);
            }
        }
        GL11.glDisable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    protected void renderBeam(ViewWaypoint w, float par2, float par4) {
        Tessellator tesselator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        int height = rm.getWorldHeight();
        float brightness = 0.05f;
        double widthFactor = 1.0;
        for (int width = 0; width < 5; ++width) {
            tesselator.func_78371_b(5);
            if (w.type == 1) {
                tesselator.func_78369_a(1.0f * brightness, 0.0f * brightness, 0.0f * brightness, 0.8f);
            } else {
                tesselator.func_78369_a(w.red * brightness, w.green * brightness, w.blue * brightness, 0.8f);
            }
            double radius = 0.1 + (double)width * 0.1;
            radius *= widthFactor;
            for (int side = 0; side < 5; ++side) {
                double vertexX = w.dx - radius;
                double vertexZ = w.dz - radius;
                if (side == 1 || side == 2) {
                    vertexX += radius * 2.0;
                }
                if (side == 2 || side == 3) {
                    vertexZ += radius * 2.0;
                }
                tesselator.func_78377_a(vertexX, w.dy - 1.5, vertexZ);
                tesselator.func_78377_a(vertexX, w.dy + (double)height, vertexZ);
            }
            tesselator.func_78381_a();
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return null;
    }

    private class ViewWaypoint
    extends Waypoint
    implements Comparable<ViewWaypoint> {
        protected double dx;
        protected double dz;
        protected double dy;
        protected double dl;
        protected double distance;

        protected ViewWaypoint(Waypoint w, double dscale) {
            super(w);
            this.dx = (double)w.x * dscale - RenderManager.field_78725_b + 0.5;
            this.dz = (double)w.z * dscale - RenderManager.field_78723_d + 0.5;
            this.dy = (double)w.y - RenderManager.field_78726_c + 0.5;
            this.dl = this.distance = Math.sqrt(this.dx * this.dx + this.dz * this.dz + this.dy * this.dy);
            if (this.dl > WaypointEntityRender.this.far) {
                double d = WaypointEntityRender.this.far / this.dl;
                this.dx *= d;
                this.dz *= d;
                this.dy *= d;
                this.dl = WaypointEntityRender.this.far;
            }
        }

        @Override
        public int compareTo(ViewWaypoint o) {
            return o.distance < this.distance ? -1 : (o.distance > this.distance ? 1 : 0);
        }
    }
}

