/*
 * Decompiled with CFR 0.152.
 */
import org.lwjgl.opengl.GL11;

public class Lagometer {
    private static bsu mc;
    private static bto gameSettings;
    private static uw profiler;
    public static boolean active;
    public static TimerNano timerTick;
    public static TimerNano timerScheduledExecutables;
    public static TimerNano timerChunkUpload;
    public static TimerNano timerChunkUpdate;
    public static TimerNano timerVisibility;
    public static TimerNano timerTerrain;
    private static long[] timesFrame;
    private static long[] timesTick;
    private static long[] timesScheduledExecutables;
    private static long[] timesChunkUpload;
    private static long[] timesChunkUpdate;
    private static long[] timesVisibility;
    private static long[] timesTerrain;
    private static boolean[] gcs;
    private static int numRecordedFrameTimes;
    private static long prevFrameTimeNano;
    private static long lastMemoryUsed;
    private static long timeStartMs;
    private static long memStart;
    private static long timeLast;
    private static long memLast;
    private static long timeDiffMs;
    private static long memDiff;

    public static void debugMemoryAllocation() {
        long timeNowMs = System.currentTimeMillis();
        long memNow = Lagometer.getMemoryUsed();
        if (memNow < memLast) {
            double memDiffMb = (double)memDiff / 1000000.0;
            double timeDiffSec = (double)timeDiffMs / 1000.0;
            int memMbSec = (int)(memDiffMb / timeDiffSec);
            Config.dbg("Memory allocation: " + memMbSec + " MB/s");
            timeStartMs = timeNowMs;
            memStart = memNow;
            timeDiffMs = 0L;
            memDiff = 0L;
        } else {
            timeDiffMs = timeNowMs - timeStartMs;
            memDiff = memNow - memStart;
        }
        timeLast = timeNowMs;
        memLast = memNow;
    }

    private static long getMemoryUsed() {
        Runtime r = Runtime.getRuntime();
        return r.totalMemory() - r.freeMemory();
    }

    public static void showLagometer() {
        if (mc == null) {
            mc = bsu.z();
            gameSettings = Lagometer.mc.t;
            profiler = Lagometer.mc.y;
        }
        if (!Lagometer.gameSettings.ay || !Lagometer.gameSettings.ofLagometer) {
            active = false;
            prevFrameTimeNano = -1L;
            return;
        }
        active = true;
        long timeNowNano = System.nanoTime();
        if (prevFrameTimeNano == -1L) {
            prevFrameTimeNano = timeNowNano;
            return;
        }
        int frameIndex = numRecordedFrameTimes & timesFrame.length - 1;
        ++numRecordedFrameTimes;
        long memUsed = Lagometer.getMemoryUsed();
        boolean gc = memUsed < lastMemoryUsed;
        lastMemoryUsed = memUsed;
        Lagometer.timesFrame[frameIndex] = timeNowNano - prevFrameTimeNano;
        Lagometer.timesTick[frameIndex] = Lagometer.timerTick.timeNano;
        Lagometer.timesScheduledExecutables[frameIndex] = Lagometer.timerScheduledExecutables.timeNano;
        Lagometer.timesChunkUpload[frameIndex] = Lagometer.timerChunkUpload.timeNano;
        Lagometer.timesChunkUpdate[frameIndex] = Lagometer.timerChunkUpdate.timeNano;
        Lagometer.timesVisibility[frameIndex] = Lagometer.timerVisibility.timeNano;
        Lagometer.timesTerrain[frameIndex] = Lagometer.timerTerrain.timeNano;
        Lagometer.gcs[frameIndex] = gc;
        Lagometer.timerTick.reset();
        Lagometer.timerScheduledExecutables.reset();
        Lagometer.timerVisibility.reset();
        Lagometer.timerChunkUpdate.reset();
        Lagometer.timerChunkUpload.reset();
        Lagometer.timerTerrain.reset();
        GL11.glClear((int)256);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glEnable((int)2903);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)Lagometer.mc.d, (double)Lagometer.mc.e, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-2000.0f);
        GL11.glLineWidth((float)1.0f);
        GL11.glDisable((int)3553);
        ckx tess = ckx.a();
        civ tessellator = tess.c();
        tessellator.a(1);
        for (int frameNum = 0; frameNum < timesFrame.length; ++frameNum) {
            int lum = (frameNum - numRecordedFrameTimes & timesFrame.length - 1) * 100 / timesFrame.length;
            float baseHeight = Lagometer.mc.e;
            long heightFrame = 0L;
            heightFrame = gcs[frameNum] ? Lagometer.renderTime(frameNum, timesFrame[frameNum], lum, lum / 2, 0, baseHeight, tessellator) : Lagometer.renderTime(frameNum, timesFrame[frameNum], lum += 155, lum, lum, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesTerrain[frameNum], 0, lum, 0, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesVisibility[frameNum], lum, lum, 0, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesChunkUpdate[frameNum], lum, 0, 0, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesChunkUpload[frameNum], lum, 0, lum, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesScheduledExecutables[frameNum], 0, 0, lum, baseHeight, tessellator);
            baseHeight -= (float)Lagometer.renderTime(frameNum, timesTick[frameNum], 0, lum, lum, baseHeight, tessellator);
        }
        tess.b();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glEnable((int)3553);
        prevFrameTimeNano = System.nanoTime();
    }

    private static long renderTime(int frameNum, long time, int r, int g, int b2, float baseHeight, civ tessellator) {
        long heightTime = time / 200000L;
        if (heightTime < 3L) {
            return 0L;
        }
        tessellator.b(r, g, b2, 255);
        tessellator.b((double)((float)frameNum + 0.5f), (double)(baseHeight - (float)heightTime + 0.5f), 0.0);
        tessellator.b((double)((float)frameNum + 0.5f), (double)(baseHeight + 0.5f), 0.0);
        return heightTime;
    }

    public static boolean isActive() {
        return active;
    }

    static {
        active = false;
        timerTick = new TimerNano();
        timerScheduledExecutables = new TimerNano();
        timerChunkUpload = new TimerNano();
        timerChunkUpdate = new TimerNano();
        timerVisibility = new TimerNano();
        timerTerrain = new TimerNano();
        timesFrame = new long[512];
        timesTick = new long[512];
        timesScheduledExecutables = new long[512];
        timesChunkUpload = new long[512];
        timesChunkUpdate = new long[512];
        timesVisibility = new long[512];
        timesTerrain = new long[512];
        gcs = new boolean[512];
        numRecordedFrameTimes = 0;
        prevFrameTimeNano = -1L;
        lastMemoryUsed = Lagometer.getMemoryUsed();
        timeStartMs = System.currentTimeMillis();
        memStart = Lagometer.getMemoryUsed();
        timeLast = timeStartMs;
        memLast = memStart;
        timeDiffMs = 1L;
        memDiff = 0L;
    }

    public static class TimerNano {
        public long timeStartNano = 0L;
        public long timeNano = 0L;

        public void start() {
            if (!active) {
                return;
            }
            if (this.timeStartNano == 0L) {
                this.timeStartNano = System.nanoTime();
            }
        }

        public void end() {
            if (!active) {
                return;
            }
            if (this.timeStartNano != 0L) {
                this.timeNano += System.nanoTime() - this.timeStartNano;
                this.timeStartNano = 0L;
            }
        }

        private void reset() {
            this.timeNano = 0L;
            this.timeStartNano = 0L;
        }
    }
}

