/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.client.render;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityBeamOutput;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class NetworkRenderer {
    public static void renderNetworks(World world, float partialTicks) {
        ArrayList<TileEntityBeamOutput> nodes = new ArrayList<TileEntityBeamOutput>();
        for (Object o : world.field_147482_g) {
            if (!(o instanceof TileEntityBeamOutput)) continue;
            nodes.add((TileEntityBeamOutput)((Object)o));
        }
        if (nodes.isEmpty()) {
            return;
        }
        Tessellator tess = Tessellator.field_78398_a;
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        double interpPosX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        double interpPosY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        double interpPosZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        for (TileEntityBeamOutput tileEntity : nodes) {
            if (tileEntity.getTarget() == null) continue;
            GL11.glPushMatrix();
            Vector3 outputPoint = tileEntity.getOutputPoint(true);
            Vector3 targetInputPoint = tileEntity.getTarget().getInputPoint();
            Vector3 direction = Vector3.subtract((Vector3)outputPoint, (Vector3)targetInputPoint);
            float directionLength = (float)direction.getMagnitude();
            float posX = (float)((double)tileEntity.field_145851_c - interpPosX);
            float posY = (float)((double)tileEntity.field_145848_d - interpPosY);
            float posZ = (float)((double)tileEntity.field_145849_e - interpPosZ);
            GL11.glTranslatef((float)posX, (float)posY, (float)posZ);
            GL11.glTranslatef((float)(outputPoint.floatX() - (float)tileEntity.field_145851_c), (float)(outputPoint.floatY() - (float)tileEntity.field_145848_d), (float)(outputPoint.floatZ() - (float)tileEntity.field_145849_e));
            GL11.glRotatef((float)(tileEntity.yaw + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)(-tileEntity.pitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(tileEntity.ticks * 10L), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glColor4f((float)tileEntity.getColor().floatX(), (float)tileEntity.getColor().floatY(), (float)tileEntity.getColor().floatZ(), (float)1.0f);
            tess.func_78371_b(1);
            for (ForgeDirection dir : ForgeDirection.values()) {
                tess.func_78377_a((double)((float)dir.offsetX / 40.0f), (double)((float)dir.offsetY / 40.0f), (double)((float)dir.offsetZ / 40.0f));
                tess.func_78377_a((double)((float)dir.offsetX / 40.0f), (double)((float)dir.offsetY / 40.0f), (double)(directionLength + (float)dir.offsetZ / 40.0f));
            }
            tess.func_78381_a();
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2884);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

