/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.nio.channels.FileChannel;

public class CopyFile {
    public static File file(String path) {
        return new File(path);
    }

    public static void copy(File source, File destination) {
        try {
            FileInputStream fileInputStream = new FileInputStream(source);
            FileOutputStream fileOutputStream = new FileOutputStream(destination);
            FileChannel inputChannel = fileInputStream.getChannel();
            FileChannel outputChannel = fileOutputStream.getChannel();
            CopyFile.transfer(inputChannel, outputChannel, source.length(), 0x2000000L, true, true);
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void transfer(FileChannel fileChannel, ByteChannel byteChannel, long lengthInBytes, long chunckSizeInBytes, boolean verbose, boolean fromFile) throws IOException {
        long overallBytesTransfered = 0L;
        long time = -System.currentTimeMillis();
        while (overallBytesTransfered < lengthInBytes) {
            long bytesTransfered = 0L;
            bytesTransfered = fromFile ? fileChannel.transferTo(0L, Math.min(chunckSizeInBytes, lengthInBytes - overallBytesTransfered), byteChannel) : fileChannel.transferFrom(byteChannel, overallBytesTransfered, Math.min(chunckSizeInBytes, lengthInBytes - overallBytesTransfered));
            overallBytesTransfered += bytesTransfered;
            if (!verbose) continue;
            System.out.printf("overall bytes transfered: %s progress %s%%\n", overallBytesTransfered, Math.round((double)overallBytesTransfered / (double)lengthInBytes * 100.0));
        }
        time += System.currentTimeMillis();
        if (verbose) {
            System.out.printf("Transfered: %s bytes in: %s s -> %s kbytes/s", overallBytesTransfered, time / 1000L, (double)overallBytesTransfered / 1024.0 / ((double)time / 1000.0));
        }
        System.out.println();
    }
}

