/*
 * Decompiled with CFR 0.152.
 */
package org.csdgn.maru;

import java.awt.Component;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.CRC32;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;

public class AppToolkit {
    private static File directory = null;
    private static ArrayList<Image> icons = null;

    public static File getLocalDirectory() {
        if (directory != null) {
            return directory;
        }
        String codePath = AppToolkit.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        File codeFile = new File(codePath);
        if (codeFile.exists() && codePath != null) {
            String last;
            codePath = codeFile.toString();
            int len = codePath.length();
            if (len > 3 && ((last = codePath.substring(len - 3).toLowerCase()).equals("jar") || last.equals("bin"))) {
                directory = codeFile.getParentFile();
                if ("lib".equalsIgnoreCase(directory.getName())) {
                    directory = directory.getParentFile();
                }
                return directory;
            }
            if (directory == null) {
                directory = codeFile;
            }
            while (!directory.isDirectory()) {
                directory = directory.getParentFile();
            }
            if ("lib".equalsIgnoreCase(directory.getName())) {
                directory = directory.getParentFile();
            }
            return directory;
        }
        directory = new File(".");
        return directory;
    }

    public static ArrayList<Image> getAppIconImages() {
        if (icons != null) {
            return icons;
        }
        icons = new ArrayList();
        int[] nArray = new int[]{16, 32, 48};
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int val = nArray[n2];
            String iconString = String.format("icon%d.png", val);
            InputStream stream = AppToolkit.getLocalResource(iconString);
            if (stream != null) {
                try {
                    icons.add(ImageIO.read(stream));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return icons;
    }

    public static InputStream getLocalResource(String resource) {
        try {
            File file = new File(AppToolkit.getLocalDirectory(), resource);
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (Exception file) {
            // empty catch block
        }
        InputStream stream = ClassLoader.getSystemResourceAsStream(resource);
        if (stream != null) {
            return stream;
        }
        try {
            File file = new File(AppToolkit.getLocalDirectory(), "resource/" + resource);
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static long calculateChecksum(byte[] data) {
        if (data == null) {
            return -1L;
        }
        CRC32 crc = new CRC32();
        crc.update(data);
        return crc.getValue();
    }

    public static void error(Component owner, String message) {
        AppToolkit.error(owner, message, "Error");
    }

    public static void error(Component owner, String message, String title) {
        JOptionPane.showMessageDialog(null, message, title, 0);
    }

    public static void warning(Component owner, String message, String title) {
        JOptionPane.showMessageDialog(null, message, title, 2);
    }

    public static void info(Component owner, String message, String title) {
        JOptionPane.showMessageDialog(null, message, title, 1);
    }

    public static boolean yesno(Component owner, String message, String title) {
        return JOptionPane.showConfirmDialog(owner, message, title, 0, 3) == 0;
    }

    public static boolean yesnow(Component owner, String message, String title) {
        return JOptionPane.showConfirmDialog(owner, message, title, 0, 2) == 0;
    }

    public static Object option(Component owner, String message, String title, Object[] options, Object initial) {
        return JOptionPane.showInputDialog(owner, message, title, 3, null, options, initial);
    }
}

