/*
 * Decompiled with CFR 0.152.
 */
package org.csdgn.maru;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.StandardCopyOption;

public class Files {
    private static final int IO_BUFFER_SIZE = 16384;

    public static void copyFile(File from, File to) throws IOException {
        if (from == null || to == null || !from.exists()) {
            return;
        }
        java.nio.file.Files.copy(from.toPath(), to.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static byte[] getAndClose(InputStream stream) throws IOException {
        if (stream != null) {
            try {
                BufferedInputStream input = new BufferedInputStream(stream);
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] reader = new byte[16384];
                int r = 0;
                while ((r = input.read(reader, 0, 16384)) != -1) {
                    buffer.write(reader, 0, r);
                }
                buffer.flush();
                byte[] byArray = buffer.toByteArray();
                return byArray;
            }
            finally {
                stream.close();
            }
        }
        return null;
    }

    public static final String getAndClose(Reader reader) throws IOException {
        if (reader != null) {
            try {
                BufferedReader input = new BufferedReader(reader);
                StringBuilder buffer = new StringBuilder();
                char[] read = new char[16384];
                int r = 0;
                while ((r = input.read(read, 0, 16384)) != -1) {
                    buffer.append(read, 0, r);
                }
                String string = buffer.toString();
                return string;
            }
            finally {
                reader.close();
            }
        }
        return null;
    }

    public static byte[] getFileContents(File file) {
        try {
            return Files.getAndClose(new FileInputStream(file));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getFileContents(File file, Charset cs) {
        try {
            return Files.getAndClose(new InputStreamReader((InputStream)new FileInputStream(file), cs));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean setFileContents(File file, byte[] contents) {
        OutputStream fos = null;
        try {
            fos = new BufferedOutputStream(new FileOutputStream(file));
            fos.write(contents);
            fos.flush();
            return true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    public static boolean setFileContents(File file, String contents) {
        FileWriter fw = null;
        try {
            fw = new FileWriter(file);
            fw.write(contents);
            return true;
        }
        catch (IOException iOException) {
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }

    private Files() {
    }
}

