/*
 * Decompiled with CFR 0.152.
 */
package org.csdgn.maru;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class Strings {
    public static final String escape(String string) {
        return Strings.escape(string, true);
    }

    public static final String escape(String string, boolean quotes) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\u0000': {
                    sb.append("\\0");
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\\': {
                    sb.append("\\\\");
                    break;
                }
                case '\"': {
                    if (quotes) {
                        sb.append("\\\"");
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case '\'': {
                    if (quotes) {
                        sb.append("\\'");
                        break;
                    }
                }
                default: {
                    sb.append(c);
                }
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String join(String[] parts, String delimiter) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (!first) {
                buf.append(delimiter);
            }
            first = false;
            buf.append(part);
            ++n2;
        }
        return buf.toString();
    }

    public static String join(Collection<String> parts, String delimiter) {
        StringBuilder buf = new StringBuilder();
        boolean first = true;
        for (String part : parts) {
            if (!first) {
                buf.append(delimiter);
            }
            first = false;
            buf.append(part);
        }
        return buf.toString();
    }

    public static String repeat(String string, int count) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < count) {
            sb.append(string);
            ++i;
        }
        return sb.toString();
    }

    public static final String[] split(String src, char delim) {
        ArrayList<String> output = new ArrayList<String>();
        int index = 0;
        int lindex = 0;
        while ((index = src.indexOf(delim, lindex)) != -1) {
            output.add(src.substring(lindex, index));
            lindex = index + 1;
        }
        output.add(src.substring(lindex));
        return output.toArray(new String[output.size()]);
    }

    public static final String[] split(String src, String delim) {
        ArrayList<String> output = new ArrayList<String>();
        int len = delim.length();
        int index = 0;
        int lindex = 0;
        while ((index = src.indexOf(delim, lindex)) != -1) {
            output.add(src.substring(lindex, index));
            lindex = index + len;
        }
        output.add(src.substring(lindex));
        return output.toArray(new String[output.size()]);
    }

    public static final String[] splitWords(String src) {
        ArrayList<String> output = new ArrayList<String>();
        StringBuilder buf = new StringBuilder();
        for (char c : Strings.getIterable(src)) {
            if (c != ' ' && c != '\t') {
                buf.append(c);
                continue;
            }
            output.add(buf.toString());
            buf.setLength(0);
        }
        if (buf.length() > 0) {
            output.add(buf.toString());
        }
        return output.toArray(new String[output.size()]);
    }

    public static final String[] lines(String src) {
        ArrayList<String> output = new ArrayList<String>();
        int index = -1;
        while (index < src.length()) {
            int r = src.indexOf(13, index + 1);
            int n = src.indexOf(10, index + 1);
            if (n == r + 1) {
                output.add(src.substring(index + 1, r));
                index = n;
            } else if (n != -1) {
                output.add(src.substring(index + 1, n));
                index = n;
            } else {
                if (r == -1) break;
                output.add(src.substring(index + 1, r));
                index = r;
            }
            if (index != -1) continue;
        }
        if (index != -1 && index < src.length()) {
            output.add(src.substring(index + 1));
        }
        return output.toArray(new String[output.size()]);
    }

    public static final int count(String src, char chr) {
        int count = 0;
        int index = 0;
        while ((index = src.indexOf(chr, index)) != -1) {
            ++index;
            ++count;
        }
        return count;
    }

    public static final Iterable<Character> getIterable(final String string) {
        return new Iterable<Character>(){

            @Override
            public Iterator<Character> iterator() {
                return Strings.getIterator(string);
            }
        };
    }

    public static final Iterator<Character> getIterator(final String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        return new Iterator<Character>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < string.length();
            }

            @Override
            public Character next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return Character.valueOf(string.charAt(this.index++));
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static final String unescape(String string) {
        StringBuilder sb = new StringBuilder();
        boolean wasEscape = false;
        boolean unicode = false;
        int count = 0;
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (unicode) {
                sb.append(c);
                if (++count == 4) {
                    int s = sb.length() - 4;
                    String code = sb.substring(s);
                    sb.setLength(s);
                    try {
                        int ncode = Integer.parseInt(code, 16);
                        sb.append((char)ncode);
                    }
                    catch (NumberFormatException e) {
                        sb.append("\\u");
                        sb.append(code);
                    }
                    unicode = false;
                }
            } else if (wasEscape) {
                switch (c) {
                    case '0': {
                        sb.append('\u0000');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case 'u': {
                        unicode = true;
                        count = 0;
                        break;
                    }
                    default: {
                        sb.append('\\');
                        sb.append(c);
                    }
                }
                wasEscape = false;
            } else if (c == '\\') {
                wasEscape = true;
            } else {
                sb.append(c);
            }
            ++n2;
        }
        if (unicode) {
            int s = sb.length() - count;
            String code = sb.substring(s);
            sb.setLength(s);
            sb.append("\\u");
            sb.append(code);
        }
        if (wasEscape) {
            sb.append('\\');
        }
        return sb.toString();
    }
}

