/*
 * Decompiled with CFR 0.152.
 */
package org.csdgn.minecraft;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.UIManager;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;
import org.csdgn.maru.AppToolkit;
import org.csdgn.maru.Files;
import org.csdgn.maru.Strings;
import org.csdgn.minecraft.Version;
import org.csdgn.minecraft.VersionFile;

public class Installer {
    private static String APP_NAME = "Fast Build 2.0.0";
    private static String APP_SHORT_NAME = "FB2.0.0";

    private static int getBestInitialVersion(String[] options, String mod) {
        int initial = 0;
        int i = 0;
        while (i < options.length) {
            if (options[i].startsWith(mod)) {
                initial = i;
                break;
            }
            ++i;
        }
        return initial;
    }

    private static String[] getInstalledVersionList(File base) {
        ArrayList<String> list = new ArrayList<String>();
        File[] fileArray = base.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            File file = fileArray[n2];
            if (file.isDirectory() && !(name = file.getName()).endsWith(APP_SHORT_NAME)) {
                list.add(file.getName());
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    private static File getMinecraftDirectory() {
        switch (Installer.getOperatingSystemType()) {
            case WINDOWS: {
                return new File(String.valueOf(System.getenv("appdata")) + "\\.minecraft");
            }
            case MAC: {
                return new File(String.valueOf(System.getProperty("user.home")) + "/.minecraft");
            }
            case LINUX: {
                return new File(String.valueOf(System.getProperty("user.home")) + "/Library/Application Support/minecraft");
            }
        }
        return null;
    }

    private static OS getOperatingSystemType() {
        String opsys = System.getProperty("os.name", "generic").toLowerCase();
        if (opsys.indexOf("mac") >= 0 || opsys.indexOf("darwin") >= 0) {
            return OS.MAC;
        }
        if (opsys.indexOf("win") >= 0) {
            return OS.WINDOWS;
        }
        if (opsys.indexOf("nux") >= 0) {
            return OS.LINUX;
        }
        return OS.OTHER;
    }

    protected static int versionToNumber(String version) {
        char c0 = version.charAt(0);
        if (c0 == 'a') {
            version = "0" + version.substring(1);
        } else if (c0 == 'b') {
            version = "1" + version.substring(1);
        } else if (c0 == '1') {
            version = "2" + version;
        }
        version = version.replace("b", ".2");
        version = version.replace("a", ".1");
        String[] parts = Strings.split(version.replace('_', '.'), '.');
        int[] scale = new int[]{1000000, 10000, 100, 1};
        int out = 0;
        int i = 0;
        while (i < parts.length) {
            out += Integer.parseInt(parts[i]) * scale[i];
            ++i;
        }
        return out;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Locale.setDefault(Locale.US);
        Installer installer = new Installer();
        try {
            installer.install();
        }
        catch (Exception e) {
            AppToolkit.error(null, e.getMessage());
        }
    }

    public void install() throws Exception {
        File file = Installer.getMinecraftDirectory();
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("Could not find minecraft!");
        }
        File base = new File(file, "versions");
        Object[] installed = Installer.getInstalledVersionList(base);
        Object[] versions = Version.getVersions();
        if (AppToolkit.yesno(null, "Would you like to automatically install " + APP_NAME + "?", "Automatic Install")) {
            boolean didAttempt = false;
            boolean didInstall = false;
            Object[] objectArray = versions;
            int n = versions.length;
            int n2 = 0;
            while (n2 < n) {
                Version version = objectArray[n2];
                Object[] objectArray2 = installed;
                int n3 = installed.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object install = objectArray2[n4];
                    if (version.gameVersion.equals(install)) {
                        didAttempt = true;
                        if (this.installVersion(base, version, (String)install)) {
                            didInstall = true;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
            if (didInstall) {
                AppToolkit.info(null, String.valueOf(APP_NAME) + " successfully installed.", "Install Completed");
                return;
            }
            if (!didAttempt) {
                AppToolkit.warning(null, "Could not find any automatically supported versions.", "Install Failed");
            }
        }
        if (!AppToolkit.yesno(null, "Would you like to attempt a custom install?\nThis is where you can choose your minecraft and mod version.", "Custom Install")) {
            AppToolkit.info(null, "Did not install " + APP_NAME + ".", "Install Canceled");
            return;
        }
        if (versions.length == 0) {
            throw new Exception("No mods to install.");
        }
        String game = null;
        if (installed.length > 1) {
            int initial = Installer.getBestInitialVersion((String[])installed, versions[0].gameVersion);
            game = (String)AppToolkit.option(null, "Select the game version to install too.", "Select game version", installed, installed[initial]);
        }
        if (game == null) {
            throw new Exception("Invalid game version.");
        }
        Version mod = versions[0];
        if (versions.length > 1 && (mod = (Version)AppToolkit.option(null, "Please select the mod version for your minecraft version.", "Select mod version", versions, versions[0])) == null) {
            throw new Exception("Invalid mod version.");
        }
        if (!game.startsWith(mod.gameVersion) && !AppToolkit.yesnow(null, "Are you sure you want to install " + mod.gameVersion + " on Minecraft " + game + "?\n" + "It is unlikely they are compatible.", "Sanity Check Failed!")) {
            AppToolkit.info(null, "Did not install " + APP_NAME + ".", "Install Canceled");
            return;
        }
        if (this.installVersion(base, mod, game)) {
            AppToolkit.info(null, String.valueOf(APP_NAME) + " successfully installed.", "Install Completed");
        }
    }

    public boolean installVersion(File root, Version mod, String sourceId) throws Exception {
        String targetId = String.valueOf(sourceId) + "-" + APP_SHORT_NAME;
        File source = new File(root, sourceId);
        File target = new File(root, targetId);
        if (target.exists()) {
            AppToolkit.error(null, "Mod for " + sourceId + " already installed!");
            return false;
        }
        if (!AppToolkit.yesno(null, "We will now install the mod " + APP_NAME + " on Minecraft " + sourceId + ".\nIs that okay?", "Confirm install")) {
            AppToolkit.info(null, "Did not install " + APP_NAME + ".", "Install Canceled");
            return false;
        }
        VersionFile[] versionFileArray = mod.getFiles();
        int n = versionFileArray.length;
        int n2 = 0;
        while (n2 < n) {
            VersionFile vf = versionFileArray[n2];
            InputStream is = AppToolkit.getLocalResource(String.valueOf(mod.gameVersion) + "/" + vf.filename);
            if (is == null) {
                throw new FileNotFoundException("Could not find required mod file " + mod.gameVersion + "/" + vf.filename);
            }
            vf.data = Files.getAndClose(is);
            if (vf.checksum != -1L && vf.checksum != AppToolkit.calculateChecksum(vf.data)) {
                throw new Exception("Required mod file " + mod.gameVersion + "/" + vf.filename + " is corrupted!");
            }
            ++n2;
        }
        if (!target.mkdir()) {
            throw new IOException("Failed to create mod directory! Check minecraft version folder permissions!");
        }
        File jar = new File(target, String.valueOf(targetId) + ".jar");
        try {
            Files.copyFile(new File(source, String.valueOf(sourceId) + ".jar"), jar);
            String json = Files.getFileContents(new File(source, String.valueOf(sourceId) + ".json"), StandardCharsets.UTF_8);
            json = json.replace("\"id\": \"" + sourceId + "\",", "\"id\": \"" + targetId + "\",");
            Files.setFileContents(new File(target, String.valueOf(targetId) + ".json"), json);
        }
        catch (IOException e) {
            throw new IOException("Failed to copy required minecraft files!");
        }
        try {
            ZipFile zip = new ZipFile(jar);
            zip.removeFile("META-INF/MANIFEST.MF");
            zip.removeFile("META-INF/MOJANGCS.RSA");
            zip.removeFile("META-INF/MOJANGCS.SF");
            VersionFile[] versionFileArray2 = mod.getFiles();
            int n3 = versionFileArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                VersionFile vf = versionFileArray2[n4];
                ZipParameters param = new ZipParameters();
                param.setCompressionMethod(8);
                param.setCompressionLevel(5);
                param.setFileNameInZip(vf.filename);
                param.setSourceExternalStream(true);
                if (vf.checksum != -1L) {
                    param.setSourceFileCRC((int)vf.checksum);
                }
                zip.addStream((InputStream)new ByteArrayInputStream(vf.data), param);
                ++n4;
            }
        }
        catch (ZipException e) {
            throw new Exception("Failed to modify jar!");
        }
        return true;
    }

    private static enum OS {
        LINUX,
        MAC,
        OTHER,
        WINDOWS;

    }
}

