/*
 * Decompiled with CFR 0.152.
 */
package org.csdgn.minecraft;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Comparator;
import org.csdgn.maru.AppToolkit;
import org.csdgn.maru.Files;
import org.csdgn.minecraft.Installer;

public class VersionsSourceBuilder {
    public static void main(String[] args) {
        System.out.println(VersionsSourceBuilder.buildGetVersions());
    }

    private static String buildGetVersions() {
        StringBuilder sb = new StringBuilder();
        sb.append("\tprotected static Version[] getVersions() {\n");
        File base = AppToolkit.getLocalDirectory();
        String[] list = base.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                char n = name.charAt(0);
                if (n >= '0' && n <= '9') {
                    return true;
                }
                n = name.charAt(1);
                return n >= '0' && n <= '9';
            }
        });
        Arrays.sort(list, new Comparator<String>(){

            @Override
            public int compare(String a, String b) {
                int an = Installer.versionToNumber(a);
                int bn = Installer.versionToNumber(b);
                return bn - an;
            }
        });
        sb.append("\t\tVersion[] v = new Version[");
        sb.append(list.length);
        sb.append("];\n");
        int i = 0;
        while (i < list.length) {
            String str = list[i];
            sb.append("\t\tv[");
            sb.append(i);
            sb.append("] = new Version(\"");
            sb.append(str);
            sb.append("\");\n");
            File sub = new File(base, str);
            File[] fileArray = sub.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                if (name.endsWith(".class")) {
                    sb.append("\t\tv[");
                    sb.append(i);
                    sb.append("].addFile(\"");
                    sb.append(name);
                    sb.append("\", ");
                    long sum = AppToolkit.calculateChecksum(Files.getFileContents(file));
                    sb.append(sum);
                    sb.append("L);\n");
                }
                ++n2;
            }
            ++i;
        }
        sb.append("\t\treturn v;\n");
        sb.append("\t}\n");
        return sb.toString();
    }
}

