import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.Properties;

import org.lwjgl.input.Keyboard;

public class FastBuild {
	private static int key = Keyboard.KEY_LCONTROL;
	private static HashMap<Thread, FastBuild> lock = new HashMap<Thread, FastBuild>();
	private static int maxXZ = 24;
	private static int maxY = 12;

	private static final void error(String value) {
		System.out.println("[FastBuild/ERROR]: " + value);
	}

	private static final void info(String value) {
		System.out.println("[FastBuild/INFO]: " + value);
	}

	protected static final void init(File minecraftDirectory) {
		info("Loading configuration.");
		/* get base directory here */
		File file = new File(minecraftDirectory.getAbsolutePath() + File.separator + "config" + File.separator + "fastbuild.cfg");
		Properties config;
		if(file.exists()) {
			config = new Properties();
			try {
				config.load(new FileInputStream(file));
				try {
					maxXZ = Integer.parseInt(config.getProperty("max_stack_build_num").trim());
					if(maxXZ < 1) {
						maxXZ = 1;
					}
					if(maxXZ > 64) {
						maxXZ = 64;
					}
				} catch(Exception ex) {
					/* We don't care if we fail. */
					warning("Failed to parse max_stack_build_num! Defaulting to " + maxXZ + ".");
				}

				try {
					maxY = Integer.parseInt(config.getProperty("max_stack_vertical_build_num").trim());
					if(maxY < 1) {
						maxY = 1;
					}
					if(maxY > 64) {
						maxY = 64;
					}
				} catch(Exception ex) {
					maxY = maxXZ;
					warning("Failed to parse max_stack_vertical_build_num! Setting to the same as max_stack_build_num.");
				}

				info("Max XZ set to " + maxXZ + ".");
				info("Max Y set to " + maxY + ".");

				try {
					String bkey = config.getProperty("build_key");
					if(bkey != null && bkey.startsWith("KEY_")) {
						key = Keyboard.getKeyIndex(bkey.substring(4));
					}
				} catch(Exception ex) {
					warning("Failed to parse build_key! Setting to default.");
				}

				info("Using build key '" + Keyboard.getKeyName(key) + "'.");

			} catch(Exception ex) {
				/* Yet yet again. We don't care if we fail. */
			}
		} else {
			warning("Config not found, creating it instead.");
			config = new Properties();
			config.put("build_key", "KEY_LCONTROL");
			config.put("max_stack_build_num", "" + maxXZ);
			config.put("max_stack_vertical_build_num", "" + maxY);
			try {
				/* Make any required directories. */
				file.getParentFile().mkdirs();
				config.store(new FileOutputStream(file),
						" \n#Any KEY_ value from http://www.lwjgl.org/javadoc/org/lwjgl/input/Keyboard.html, 'should' work.\n"
								+ "# Warning: Conflicts with built in key bindings is possible!\n#");
			} catch(Exception ex) {
				error("Failed to create config file or folder.");
			}
		}
	}

	protected static final boolean canStart() {
		if(lock.containsKey(Thread.currentThread())) {
			return false;
		}
		/* If we already started doing it in one thread, we HAVE to do it in the other too! */
		if(!lock.isEmpty()) {
			return true;
		}
		return Keyboard.isKeyDown(FastBuild.key);
	}

	protected static final FastBuild start() {
		FastBuild fb = new FastBuild();
		lock.put(Thread.currentThread(), fb);
		return fb;
	}

	protected static final void stop() {
		lock.remove(Thread.currentThread());
	}

	private static final void warning(String value) {
		System.out.println("[FastBuild/WARNING]: " + value);
	}

	private int built = 0;
	protected int x, y, z;

	protected final boolean canBuild() {
		if(y != 0) {
			return built < maxY;
		}
		return built < maxXZ;
	}

	protected final void increment() {
		++built;
	}

	protected final void reset(int rot) {
		x = y = z = 0;
		if(rot == 0) {
			--y;
		}
		if(rot == 1) {
			++y;
		}
		if(rot == 2) {
			--z;
		}
		if(rot == 3) {
			++z;
		}
		if(rot == 4) {
			--x;
		}
		if(rot == 5) {
			++x;
		}
		built = 0;
	}
}