/*
 * Decompiled with CFR 0.152.
 */
package com.slatebit.paintball.common;

import com.slatebit.paintball.common.ItemMetadataBlock;
import com.slatebit.paintball.common.ItemPaintbrush;
import com.slatebit.paintball.common.Paintball;
import com.slatebit.paintball.common.SoundBlock;
import com.slatebit.paintball.common.TileEntityC4;
import com.slatebit.paintball.common.TileEntityClaymore;
import com.slatebit.paintball.common.TileEntityFlag;
import com.slatebit.paintball.common.TileEntityGearRack;
import com.slatebit.paintball.common.TileEntityMedKit;
import com.slatebit.paintball.common.TileEntityObject;
import com.slatebit.paintball.common.TileEntityPod;
import com.slatebit.paintball.common.TileEntityWeaponRack;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockObject
extends BlockContainer {
    private IIcon[] icons;
    private String type;

    public BlockObject(String type) {
        super(Material.field_151575_d);
        if (type != "Flag") {
            this.func_149711_c(2.5f);
        } else {
            this.func_149711_c(0.0f);
        }
        this.func_149647_a(Paintball.TAB);
        GameRegistry.registerBlock((Block)this, ItemMetadataBlock.class, (String)(type + " (C)"));
        this.type = type;
        if (type == "Claymore") {
            this.func_149672_a(new SoundBlock(Paintball.CLAYMORE_PLACE, 1.0f, 1.0f));
        } else if (type == "C4") {
            this.func_149672_a(new SoundBlock(Paintball.C4_PLACE, 1.0f, 1.0f));
        }
    }

    public TileEntity func_149915_a(World world, int i) {
        if (this.type == "Claymore") {
            return new TileEntityClaymore();
        }
        if (this.type == "C4") {
            return new TileEntityC4();
        }
        if (this.type == "Pod") {
            return new TileEntityPod();
        }
        if (this.type == "Med Kit") {
            return new TileEntityMedKit();
        }
        if (this.type == "Weapon Rack") {
            return new TileEntityWeaponRack();
        }
        if (this.type == "Gear Rack") {
            return new TileEntityGearRack();
        }
        if (this.type == "Flag") {
            return new TileEntityFlag();
        }
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float xOffset, float yOffset, float zOffset) {
        InventoryPlayer inventory = entityPlayer.field_71071_by;
        boolean isCreative = entityPlayer.field_71075_bZ.field_75098_d;
        int metadata = world.func_72805_g(x, y, z);
        if (this.type == "Pod") {
            TileEntityPod tileEntityPod = (TileEntityPod)world.func_147438_o(x, y, z);
            if (!(inventory == null || inventory.field_70460_b == null || inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemPaintbrush)) {
                boolean isSameTeam = Paintball.isSameTeam(metadata, inventory.field_70460_b);
                if (isSameTeam && (isCreative || tileEntityPod.cooldown == 0)) {
                    boolean add1 = inventory.func_70441_a(new ItemStack(Paintball.pellet, 64, metadata));
                    boolean add2 = inventory.func_70441_a(new ItemStack(Paintball.pellet, 64, metadata));
                    boolean add3 = inventory.func_70441_a(new ItemStack(Paintball.pellet, 64, metadata));
                    if (add1 || add2 || add3) {
                        if (!isCreative) {
                            tileEntityPod.cooldown = 1200;
                        }
                        world.func_72956_a((Entity)entityPlayer, "random.pop", 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    }
                } else if (!world.field_72995_K && !isSameTeam) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You aren't on the " + Paintball.COLOR_MAP.get(metadata).toLowerCase() + " team."));
                }
                return true;
            }
        } else if (this.type == "Med Kit") {
            TileEntityMedKit tileEntityMedKit = (TileEntityMedKit)world.func_147438_o(x, y, z);
            if (!(inventory == null || inventory.field_70460_b == null || inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemPaintbrush)) {
                boolean isSameTeam = Paintball.isSameTeam(metadata, inventory.field_70460_b);
                if (isSameTeam && (isCreative || tileEntityMedKit.cooldown == 0 && entityPlayer.func_110143_aJ() < 20.0f)) {
                    entityPlayer.func_70691_i(10.0f);
                    if (!isCreative) {
                        tileEntityMedKit.cooldown = 1200;
                    }
                    world.func_72956_a((Entity)entityPlayer, "random.pop", 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                } else if (!world.field_72995_K && !isSameTeam) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You aren't on the " + Paintball.COLOR_MAP.get(metadata).toLowerCase() + " team."));
                }
                return true;
            }
        } else if (this.type == "Weapon Rack") {
            TileEntityWeaponRack tileEntityWeaponRack = (TileEntityWeaponRack)world.func_147438_o(x, y, z);
            if (!(inventory == null || inventory.field_70460_b == null || inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemPaintbrush)) {
                boolean isSameTeam = Paintball.isSameTeam(metadata, inventory.field_70460_b);
                if (isSameTeam && (isCreative || tileEntityWeaponRack.cooldown == 0)) {
                    boolean add1 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.remote, 1, metadata));
                    boolean add2 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.pistol, 1, metadata));
                    boolean add3 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.shotgun, 1, metadata));
                    boolean add4 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.rifle, 1, metadata));
                    boolean add5 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.sniper, 1, metadata));
                    boolean add6 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.launcher, 1, metadata));
                    boolean add7 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.grenade, 2, metadata));
                    boolean add8 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.claymore, 2, metadata));
                    boolean add9 = entityPlayer.field_71071_by.func_70441_a(new ItemStack(Paintball.c4, 2, metadata));
                    if (add1 || add2 || add3 || add4 || add5 || add6 || add7 || add8 || add9) {
                        if (!isCreative) {
                            tileEntityWeaponRack.cooldown = 1200;
                        }
                        world.func_72956_a((Entity)entityPlayer, "random.pop", 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    }
                } else if (!world.field_72995_K && !isSameTeam) {
                    entityPlayer.func_145747_a((IChatComponent)new ChatComponentText("You aren't on the " + Paintball.COLOR_MAP.get(metadata).toLowerCase() + " team."));
                }
                return true;
            }
        } else if (this.type == "Gear Rack") {
            TileEntityGearRack tileEntityGearRack = (TileEntityGearRack)world.func_147438_o(x, y, z);
            if (!(inventory == null || inventory.field_70460_b == null || inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemPaintbrush)) {
                if (tileEntityGearRack.cooldown == 0) {
                    Item[] armor = new Item[]{Paintball.shoes, Paintball.pants, Paintball.chest, Paintball.helmet};
                    boolean[] success = new boolean[4];
                    for (int i = 3; i > -1; --i) {
                        ItemStack itemStack = new ItemStack(armor[i], 1, metadata);
                        if (inventory.func_70440_f(i) == null) {
                            entityPlayer.func_70062_b(i + 1, itemStack);
                            success[i] = true;
                            continue;
                        }
                        success[i] = entityPlayer.field_71071_by.func_70441_a(itemStack);
                    }
                    if (success[0] || success[1] || success[2] || success[3]) {
                        if (!isCreative) {
                            tileEntityGearRack.cooldown = 1200;
                        }
                        world.func_72956_a((Entity)entityPlayer, "random.pop", 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 0.8f));
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        TileEntityObject tileEntityObject = (TileEntityObject)world.func_147438_o(x, y, z);
        if (this.type == "Claymore") {
            tileEntityObject.direction = MathHelper.func_76128_c((double)((double)((entityLivingBase.field_70177_z + 180.0f) * 16.0f / 360.0f) + 0.5)) & 0xF;
            tileEntityObject.owner = (EntityPlayer)entityLivingBase;
        } else {
            tileEntityObject.direction = MathHelper.func_76128_c((double)((double)(entityLivingBase.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        }
    }

    public void func_149719_a(IBlockAccess iBlockAccess, int x, int y, int z) {
        if (this.type == "Claymore") {
            this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.5f, 0.75f);
        } else if (this.type == "C4") {
            this.func_149676_a(0.25f, 0.0f, 0.25f, 0.75f, 0.25f, 0.75f);
        } else if (this.type == "Pod") {
            this.func_149676_a(0.34375f, 0.0f, 0.34375f, 0.65625f, 0.5625f, 0.65625f);
        } else if (this.type == "Med Kit") {
            this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 0.6875f, 0.875f);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighbor) {
        if (!world.func_147439_a(x, y - 1, z).func_149688_o().func_76220_a()) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return World.func_147466_a((IBlockAccess)world, (int)x, (int)(y - 1), (int)z);
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int metadata = world.func_72805_g(x, y, z);
        return this.icons[metadata];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return this.icons[metadata];
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        for (int i = 0; i < 6; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.icons = new IIcon[6];
        for (int i = 0; i < 6; ++i) {
            this.icons[i] = iconRegister.func_94245_a("paintball:" + Paintball.COLOR_MAP.get(i).toLowerCase() + "/" + this.type);
        }
    }
}

