/*
 * Decompiled with CFR 0.152.
 */
package com.slatebit.paintball.minecraft;

import com.slatebit.paintball.common.CommonProxy;
import com.slatebit.paintball.common.EntityGrenade;
import com.slatebit.paintball.common.EntityPellet;
import com.slatebit.paintball.common.ItemGun;
import com.slatebit.paintball.common.Paintball;
import com.slatebit.paintball.common.TileEntityC4;
import com.slatebit.paintball.common.TileEntityClaymore;
import com.slatebit.paintball.common.TileEntityFlag;
import com.slatebit.paintball.common.TileEntityGearRack;
import com.slatebit.paintball.common.TileEntityMedKit;
import com.slatebit.paintball.common.TileEntityPod;
import com.slatebit.paintball.common.TileEntityWeaponRack;
import com.slatebit.paintball.minecraft.ModelC4;
import com.slatebit.paintball.minecraft.ModelClaymore;
import com.slatebit.paintball.minecraft.ModelFlag;
import com.slatebit.paintball.minecraft.ModelMedKit;
import com.slatebit.paintball.minecraft.ModelPod;
import com.slatebit.paintball.minecraft.ModelRack;
import com.slatebit.paintball.minecraft.RenderObject;
import com.slatebit.paintball.minecraft.RenderProjectile;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;

public class ClientProxy
extends CommonProxy {
    private ResourceLocation hitMarker = new ResourceLocation("paintball", "textures/overlays/Hit Marker.png");

    @Override
    public void addRenders() {
        Paintball.mouseSensitivity = Minecraft.func_71410_x().field_71474_y.field_74341_c;
        Paintball.armorRender = RenderingRegistry.addNewArmourRendererPrefix((String)"Paintball");
        RenderingRegistry.registerEntityRenderingHandler(EntityPellet.class, (Render)new RenderProjectile());
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (Render)new RenderProjectile());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityClaymore.class, (TileEntitySpecialRenderer)new RenderObject(new ModelClaymore(), "Claymore"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityC4.class, (TileEntitySpecialRenderer)new RenderObject(new ModelC4(), "C4"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFlag.class, (TileEntitySpecialRenderer)new RenderObject(new ModelFlag(), "Flag"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityPod.class, (TileEntitySpecialRenderer)new RenderObject(new ModelPod(), "Pod"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWeaponRack.class, (TileEntitySpecialRenderer)new RenderObject(new ModelRack(), "Weapon Rack"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGearRack.class, (TileEntitySpecialRenderer)new RenderObject(new ModelRack(), "Gear Rack"));
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityMedKit.class, (TileEntitySpecialRenderer)new RenderObject(new ModelMedKit(), "Med Kit"));
    }

    @Override
    public void renderHitMarker() {
        if (Paintball.hitMarker > 0) {
            --Paintball.hitMarker;
            Minecraft client = FMLClientHandler.instance().getClient();
            ScaledResolution scale = new ScaledResolution(client, client.field_71443_c, client.field_71440_d);
            int xCenter = scale.func_78326_a() / 2;
            int offset = scale.func_78328_b() * 2;
            client.func_110434_K().func_110577_a(this.hitMarker);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(xCenter - offset), (double)scale.func_78328_b(), 1.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(xCenter + offset), (double)scale.func_78328_b(), 1.0, 1.0, 1.0);
            tessellator.func_78374_a((double)(xCenter + offset), 0.0, 1.0, 1.0, 0.0);
            tessellator.func_78374_a((double)(xCenter - offset), 0.0, 1.0, 0.0, 0.0);
            tessellator.func_78381_a();
        }
    }

    @Override
    public void renderSight() {
        Minecraft client = FMLClientHandler.instance().getClient();
        if (client.field_71439_g != null) {
            InventoryPlayer inventory = client.field_71439_g.field_71071_by;
            if (Mouse.isButtonDown((int)0) && inventory.func_70448_g() != null && inventory.func_70448_g().func_77973_b() instanceof ItemGun && client.field_71462_r == null) {
                ItemGun gun = (ItemGun)inventory.func_70448_g().func_77973_b();
                float newZoom = gun.type != "Sniper" ? 2.5f : 5.0f;
                if (Paintball.zoomLevel <= newZoom) {
                    Paintball.zoomLevel = (float)((double)Paintball.zoomLevel + 0.25);
                }
                if (Paintball.zoomLevel > newZoom) {
                    Paintball.zoomLevel = (float)((double)Paintball.zoomLevel - 0.25);
                }
                client.field_71474_y.field_74341_c = (float)((double)Paintball.mouseSensitivity / (1.0 + ((double)Paintball.zoomLevel - 1.0) / (double)Paintball.zoomLevel));
                ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)client.field_71460_t, (Object)Float.valueOf(Paintball.zoomLevel), (String[])new String[]{"cameraZoom", "field_78503_V"});
                ScaledResolution scale = new ScaledResolution(client, client.field_71443_c, client.field_71440_d);
                int xCenter = scale.func_78326_a() / 2;
                int offset = scale.func_78328_b() * 2;
                client.func_110434_K().func_110577_a(new ResourceLocation("paintball", "textures/overlays/" + gun.type + " Sight.png"));
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)(xCenter - offset), (double)scale.func_78328_b(), -100.0, 0.0, 1.0);
                tessellator.func_78374_a((double)(xCenter + offset), (double)scale.func_78328_b(), -100.0, 1.0, 1.0);
                tessellator.func_78374_a((double)(xCenter + offset), 0.0, -100.0, 1.0, 0.0);
                tessellator.func_78374_a((double)(xCenter - offset), 0.0, -100.0, 0.0, 0.0);
                tessellator.func_78381_a();
            } else {
                if ((double)Paintball.zoomLevel >= 1.0) {
                    Paintball.zoomLevel = (float)((double)Paintball.zoomLevel - 0.25);
                }
                if ((double)Paintball.zoomLevel < 1.0) {
                    Paintball.zoomLevel = 1.0f;
                }
                client.field_71474_y.field_74341_c = (float)((double)Paintball.mouseSensitivity / (1.0 + ((double)Paintball.zoomLevel - 1.0) / (double)Paintball.zoomLevel));
                ObfuscationReflectionHelper.setPrivateValue(EntityRenderer.class, (Object)client.field_71460_t, (Object)Float.valueOf(Paintball.zoomLevel), (String[])new String[]{"cameraZoom", "field_78503_V"});
            }
        }
    }
}

