/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.bezier;

import ivorius.ivtoolkit.bezier.IvBezierPath3D;
import ivorius.ivtoolkit.bezier.IvBezierPoint3DCachedStep;
import ivorius.ivtoolkit.math.IvMathHelper;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import org.lwjgl.opengl.GL11;

public class IvBezierPath3DRendererText {
    private FontRenderer fontRenderer;
    private String text;
    private boolean spreadToFill;
    private double shift;
    private boolean inwards;
    private double capBottom;
    private double capTop = 1.0;

    public FontRenderer getFontRenderer() {
        return this.fontRenderer;
    }

    public void setFontRenderer(FontRenderer fontRenderer) {
        this.fontRenderer = fontRenderer;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isSpreadToFill() {
        return this.spreadToFill;
    }

    public void setSpreadToFill(boolean spreadToFill) {
        this.spreadToFill = spreadToFill;
    }

    public double getShift() {
        return this.shift;
    }

    public void setShift(double shift) {
        this.shift = shift;
    }

    public boolean isInwards() {
        return this.inwards;
    }

    public void setInwards(boolean inwards) {
        this.inwards = inwards;
    }

    public double getCapBottom() {
        return this.capBottom;
    }

    public void setCapBottom(double capBottom) {
        this.capBottom = capBottom;
    }

    public double getCapTop() {
        return this.capTop;
    }

    public void setCapTop(double capTop) {
        this.capTop = capTop;
    }

    public void render(IvBezierPath3D path) {
        int i;
        if (path.isDirty()) {
            path.buildDistances();
        }
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        String plainText = "";
        ArrayList<String> modifiers = new ArrayList<String>();
        modifiers.add("");
        for (i = 0; i < this.text.length(); ++i) {
            char character = this.text.charAt(i);
            if (character == '\u00a7' && i + 1 < this.text.length()) {
                modifiers.set(modifiers.size() - 1, (String)modifiers.get(modifiers.size() - 1) + this.text.substring(i, i + 2));
                ++i;
                continue;
            }
            plainText = plainText + character;
            modifiers.add((String)modifiers.get(modifiers.size() - 1));
        }
        for (i = 0; i < plainText.length(); ++i) {
            double totalProgress;
            double finalProgress;
            int charIndex = this.inwards ? i : plainText.length() - i - 1;
            char character = plainText.charAt(charIndex);
            if (character == ' ' || !((finalProgress = ((totalProgress = (this.spreadToFill ? (double)i / (double)this.text.length() : (double)i * 0.5) + this.shift) % 1.0 + 1.0) % 1.0) >= this.capBottom) || !(finalProgress <= this.capTop)) continue;
            IvBezierPoint3DCachedStep cachedStep = path.getCachedStep(finalProgress);
            double[] position = cachedStep.getPosition();
            double[] rotation = path.getNaturalRotation(cachedStep, 0.01);
            double red = IvMathHelper.mix(cachedStep.getLeftPoint().getRed(), cachedStep.getRightPoint().getRed(), cachedStep.getInnerProgress());
            double green = IvMathHelper.mix(cachedStep.getLeftPoint().getGreen(), cachedStep.getRightPoint().getGreen(), cachedStep.getInnerProgress());
            double blue = IvMathHelper.mix(cachedStep.getLeftPoint().getBlue(), cachedStep.getRightPoint().getBlue(), cachedStep.getInnerProgress());
            double alpha = IvMathHelper.mix(cachedStep.getLeftPoint().getAlpha(), cachedStep.getRightPoint().getAlpha(), cachedStep.getInnerProgress());
            double textSize = IvMathHelper.mix(cachedStep.getLeftPoint().getFontSize(), cachedStep.getRightPoint().getFontSize(), cachedStep.getInnerProgress());
            GL11.glPushMatrix();
            GL11.glTranslated((double)position[0], (double)position[1], (double)position[2]);
            GL11.glScaled((double)(-textSize / 12.0), (double)(-textSize / 12.0), (double)(-textSize / 12.0));
            GL11.glRotatef((float)((float)rotation[0] + (this.inwards ? 0.0f : 180.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)((float)rotation[1]), (float)1.0f, (float)0.0f, (float)0.0f);
            this.fontRenderer.func_78276_b((String)modifiers.get(charIndex) + character, 0, 0, ((int)(red * 255.0) << 16) + ((int)(green * 255.0) << 8) + (int)(blue * 255.0));
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
    }
}

