/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.blocks;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockCoord
implements Cloneable {
    public final int x;
    public final int y;
    public final int z;

    public BlockCoord(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockCoord(TileEntity tileEntity) {
        this(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public BlockCoord(NBTTagCompound compound, String keyBase) {
        this.x = compound.func_74762_e(keyBase + "_x");
        this.y = compound.func_74762_e(keyBase + "_y");
        this.z = compound.func_74762_e(keyBase + "_z");
    }

    public BlockCoord(ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
    }

    public static void writeCoordToNBT(String keyBase, BlockCoord coord, NBTTagCompound compound) {
        if (coord != null) {
            coord.writeToNBT(compound, keyBase);
        }
    }

    public static BlockCoord readCoordFromNBT(String keyBase, NBTTagCompound compound) {
        if (compound.func_74764_b(keyBase + "_x") && compound.func_74764_b(keyBase + "_y") && compound.func_74764_b(keyBase + "_z")) {
            return new BlockCoord(compound, keyBase);
        }
        return null;
    }

    public static void writeCoordToBuffer(BlockCoord coord, ByteBuf buffer) {
        buffer.writeBoolean(coord != null);
        if (coord != null) {
            coord.writeToBuffer(buffer);
        }
    }

    public static BlockCoord readCoordFromBuffer(ByteBuf buffer) {
        if (buffer.readBoolean()) {
            return new BlockCoord(buffer);
        }
        return null;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public BlockCoord add(int x, int y, int z) {
        return new BlockCoord(this.x + x, this.y + y, this.z + z);
    }

    public BlockCoord add(BlockCoord coord) {
        return new BlockCoord(this.x + coord.x, this.y + coord.y, this.z + coord.z);
    }

    public BlockCoord subtract(int x, int y, int z) {
        return new BlockCoord(this.x - x, this.y - y, this.z - z);
    }

    public BlockCoord subtract(BlockCoord coord) {
        return new BlockCoord(this.x - coord.x, this.y - coord.y, this.z - coord.z);
    }

    public BlockCoord getLowerCorner(BlockCoord coord) {
        return new BlockCoord(Math.min(this.x, coord.x), Math.min(this.y, coord.y), Math.min(this.z, coord.z));
    }

    public BlockCoord getHigherCorner(BlockCoord coord) {
        return new BlockCoord(Math.max(this.x, coord.x), Math.max(this.y, coord.y), Math.max(this.z, coord.z));
    }

    public void writeToNBT(NBTTagCompound compound, String keyBase) {
        compound.func_74768_a(keyBase + "_x", this.x);
        compound.func_74768_a(keyBase + "_y", this.y);
        compound.func_74768_a(keyBase + "_z", this.z);
    }

    public void writeToBuffer(ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
    }

    public String toString() {
        return "BlockCoord{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockCoord that = (BlockCoord)o;
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        return this.z == that.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public BlockCoord invert() {
        return new BlockCoord(-this.x, -this.y, -this.z);
    }

    public Block getBlock(World world) {
        return world.func_147439_a(this.x, this.y, this.z);
    }

    public int getMetadata(World world) {
        return world.func_72805_g(this.x, this.y, this.z);
    }

    public TileEntity getTileEntity(World world) {
        return world.func_147438_o(this.x, this.y, this.z);
    }
}

