/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.items;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.opengl.GL11;

public class IvItemRendererModelCustom
implements IItemRenderer {
    public ItemModelRenderer model;
    public ResourceLocation texture;
    public float modelSize;
    public float[] translation;
    public float[] rotation;

    public IvItemRendererModelCustom(ItemModelRenderer model, ResourceLocation texture, float modelSize, float[] translation, float[] rotation) {
        this.model = model;
        this.texture = texture;
        this.modelSize = modelSize;
        this.translation = translation;
        this.rotation = rotation;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        GL11.glPushMatrix();
        if (type == IItemRenderer.ItemRenderType.ENTITY) {
            GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
        } else if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            GL11.glTranslated((double)0.0, (double)0.3, (double)0.0);
        } else {
            GL11.glTranslated((double)0.5, (double)1.0, (double)0.5);
        }
        GL11.glTranslatef((float)this.translation[0], (float)(this.translation[1] + 1.0f), (float)this.translation[2]);
        if (type != IItemRenderer.ItemRenderType.ENTITY) {
            float modelScale = 1.0f / this.modelSize;
            GL11.glScalef((float)modelScale, (float)modelScale, (float)modelScale);
        }
        GL11.glRotatef((float)this.rotation[0], (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)this.rotation[1], (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)this.rotation[2], (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        this.model.render(item);
        GL11.glPopMatrix();
    }

    public static class ItemModelRendererSimple
    implements ItemModelRenderer {
        public IModelCustom model;
        public String[] renderParts;
        public boolean additive;

        public ItemModelRendererSimple(IModelCustom model) {
            this.model = model;
        }

        public ItemModelRendererSimple(IModelCustom model, String[] renderParts, boolean additive) {
            this.model = model;
            this.renderParts = renderParts;
            this.additive = additive;
        }

        @Override
        public void render(ItemStack stack) {
            if (this.renderParts != null) {
                if (this.additive) {
                    this.model.renderOnly(this.renderParts);
                } else {
                    this.model.renderAllExcept(this.renderParts);
                }
            } else {
                this.model.renderAll();
            }
        }
    }

    public static interface ItemModelRenderer {
        public void render(ItemStack var1);
    }
}

