/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.math;

import ivorius.ivtoolkit.blocks.BlockCoord;
import net.minecraft.block.Block;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AxisAlignedTransform2D {
    public static final AxisAlignedTransform2D ORIGINAL = new AxisAlignedTransform2D(0, false);
    private final int rotation;
    private final boolean mirrorX;

    public AxisAlignedTransform2D(int rotation, boolean mirrorX) {
        this.rotation = (rotation % 4 + 4) % 4;
        this.mirrorX = mirrorX;
    }

    public static AxisAlignedTransform2D transform(int rotationClockwise, boolean flipX) {
        return flipX ? ORIGINAL.rotateClockwise(rotationClockwise).flipX() : ORIGINAL.rotateClockwise(rotationClockwise);
    }

    public static AxisAlignedTransform2D transform(AxisAlignedTransform2D original, int rotationClockwise, boolean flipX) {
        return flipX ? original.rotateClockwise(rotationClockwise).flipX() : original.rotateClockwise(rotationClockwise);
    }

    public AxisAlignedTransform2D rotateClockwise(int steps) {
        return new AxisAlignedTransform2D(this.rotation + steps, this.mirrorX);
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isMirrorX() {
        return this.mirrorX;
    }

    public AxisAlignedTransform2D rotateClockwise() {
        return new AxisAlignedTransform2D(this.rotation + 1, this.mirrorX);
    }

    public AxisAlignedTransform2D rotateCounterClockwise(int steps) {
        return new AxisAlignedTransform2D(this.rotation - steps, this.mirrorX);
    }

    public AxisAlignedTransform2D rotateCounterClockwise() {
        return new AxisAlignedTransform2D(this.rotation - 1, this.mirrorX);
    }

    public AxisAlignedTransform2D flipX() {
        return new AxisAlignedTransform2D(this.rotation, !this.mirrorX);
    }

    public AxisAlignedTransform2D flipZ() {
        return new AxisAlignedTransform2D(this.rotation + 2, !this.mirrorX);
    }

    public BlockCoord apply(BlockCoord position, int[] size) {
        int positionX = this.mirrorX ? size[0] - 1 - position.x : position.x;
        switch (this.rotation) {
            case 0: {
                return new BlockCoord(positionX, position.y, position.z);
            }
            case 1: {
                return new BlockCoord(size[2] - 1 - position.z, position.y, positionX);
            }
            case 2: {
                return new BlockCoord(size[0] - 1 - positionX, position.y, size[2] - 1 - position.z);
            }
            case 3: {
                return new BlockCoord(position.z, position.y, size[0] - 1 - positionX);
            }
        }
        throw new InternalError();
    }

    public ChunkCoordinates apply(ChunkCoordinates position, int[] size) {
        int positionX = this.mirrorX ? size[0] - 1 - position.field_71574_a : position.field_71574_a;
        switch (this.rotation) {
            case 0: {
                return new ChunkCoordinates(positionX, position.field_71572_b, position.field_71573_c);
            }
            case 1: {
                return new ChunkCoordinates(size[2] - 1 - position.field_71573_c, position.field_71572_b, positionX);
            }
            case 2: {
                return new ChunkCoordinates(size[0] - 1 - positionX, position.field_71572_b, size[2] - 1 - position.field_71573_c);
            }
            case 3: {
                return new ChunkCoordinates(position.field_71573_c, position.field_71572_b, size[0] - 1 - positionX);
            }
        }
        throw new InternalError();
    }

    public double[] apply(double[] position, int[] size) {
        double positionX = this.mirrorX ? (double)(size[0] - 1) - position[0] : position[0];
        switch (this.rotation) {
            case 0: {
                return new double[]{positionX, position[1], position[2]};
            }
            case 1: {
                return new double[]{(double)(size[2] - 1) - position[2], position[1], positionX};
            }
            case 2: {
                return new double[]{(double)(size[0] - 1) - positionX, position[1], (double)(size[2] - 1) - position[2]};
            }
            case 3: {
                return new double[]{position[2], position[1], (double)(size[0] - 1) - positionX};
            }
        }
        throw new InternalError();
    }

    public int[] apply(int[] position, int[] size) {
        int positionX = this.mirrorX ? size[0] - 1 - position[0] : position[0];
        switch (this.rotation) {
            case 0: {
                return new int[]{positionX, position[1], position[2]};
            }
            case 1: {
                return new int[]{size[2] - 1 - position[2], position[1], positionX};
            }
            case 2: {
                return new int[]{size[0] - 1 - positionX, position[1], size[2] - 1 - position[2]};
            }
            case 3: {
                return new int[]{position[2], position[1], size[0] - 1 - positionX};
            }
        }
        throw new InternalError();
    }

    public void rotateBlock(World world, BlockCoord coord, Block block) {
        for (int i = 0; i < this.rotation; ++i) {
            block.rotateBlock(world, coord.x, coord.y, coord.z, ForgeDirection.UP);
        }
    }
}

