/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.MazeCoordinate;
import ivorius.ivtoolkit.maze.MazeCoordinateDirect;
import ivorius.ivtoolkit.maze.MazePath;
import ivorius.ivtoolkit.maze.MazeRoom;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class Maze {
    private static TIntObjectMap<MazeRoom[]> cachedNeighborRoomsBlueprints = new TIntObjectHashMap();
    private static TIntObjectMap<MazePath[]> cachedNeighborPathBlueprints = new TIntObjectHashMap();
    public static final byte NULL = 0;
    public static final byte INVALID = 1;
    public static final byte WALL = 2;
    public static final byte ROOM = 3;
    public final int[] dimensions;
    public final byte[] blocks;
    private List<MazeRoom> cachedRooms;
    private List<MazePath> cachedPaths;

    public Maze(int ... dimensions) {
        int fullLength = 1;
        for (int dimension : dimensions) {
            if (dimension % 2 == 0) {
                throw new IllegalArgumentException("Maze must have enclosing walls! (Odd dimension numbers)");
            }
            fullLength *= dimension;
        }
        this.dimensions = dimensions;
        this.blocks = new byte[fullLength];
    }

    public boolean contains(MazeCoordinate coordinate) {
        int[] position = coordinate.getMazeCoordinates();
        for (int i = 0; i < position.length; ++i) {
            if (position[i] >= 0 && position[i] < this.dimensions[i]) continue;
            return false;
        }
        return true;
    }

    public byte get(MazeCoordinate coordinate) {
        return this.contains(coordinate) ? this.blocks[this.getArrayPosition(coordinate.getMazeCoordinates())] : (byte)1;
    }

    public void set(byte val, MazeCoordinate coordinates) {
        if (this.contains(coordinates)) {
            this.blocks[this.getArrayPosition((int[])coordinates.getMazeCoordinates())] = val;
        }
    }

    public static int[] getMazeSize(int[] size, int[] pathLengths, int[] roomSize) {
        int[] returnSize = new int[size.length];
        for (int i = 0; i < returnSize.length; ++i) {
            returnSize[i] = (size[i] - pathLengths[i]) / (pathLengths[i] + roomSize[i]) * 2 + 1;
        }
        return returnSize;
    }

    public static int[] getRoomPosition(MazeCoordinate coordinate, int[] pathLengths, int[] roomSize) {
        int[] mazePosition = coordinate.getMazeCoordinates();
        int[] returnPos = new int[pathLengths.length];
        for (int i = 0; i < returnPos.length; ++i) {
            returnPos[i] = mazePosition[i] / 2 * roomSize[i] + (mazePosition[i] + 1) / 2 * pathLengths[i];
        }
        return returnPos;
    }

    public static int[] getRoomSize(int[] rooms, int[] pathLengths, int[] roomSize) {
        int[] returnSize = new int[pathLengths.length];
        for (int i = 0; i < returnSize.length; ++i) {
            returnSize[i] = rooms[i] * roomSize[i] + rooms[i] / 2 * pathLengths[i];
        }
        return returnSize;
    }

    public int[] getCompleteMazeSize(int[] pathLengths, int[] roomWidths) {
        return Maze.getRoomPosition(new MazeRoom(this.dimensions), pathLengths, roomWidths);
    }

    public int[] getRoomSize(MazeCoordinate coordinate, int[] pathLengths, int[] roomWidths) {
        int[] returnSize = new int[this.dimensions.length];
        boolean[] isRoomPath = Maze.coordPathFlags(coordinate);
        for (int i = 0; i < returnSize.length; ++i) {
            returnSize[i] = isRoomPath[i] ? pathLengths[i] : roomWidths[i];
        }
        return returnSize;
    }

    public static boolean isCoordValidRoom(MazeCoordinate coordinate) {
        boolean[] isRoomPath;
        for (boolean b : isRoomPath = Maze.coordPathFlags(coordinate)) {
            if (!b) continue;
            return false;
        }
        return true;
    }

    public static int getPathDimensionIfPath(MazeCoordinate coordinate) {
        boolean[] pathFlags = Maze.coordPathFlags(coordinate);
        int curDimension = -1;
        for (int dim = 0; dim < pathFlags.length; ++dim) {
            if (!pathFlags[dim]) continue;
            if (curDimension >= 0) {
                return -1;
            }
            curDimension = dim;
        }
        return curDimension;
    }

    public static boolean[] coordPathFlags(MazeCoordinate coordinate) {
        int[] mazePosition = coordinate.getMazeCoordinates();
        boolean[] flags = new boolean[mazePosition.length];
        for (int i = 0; i < flags.length; ++i) {
            flags[i] = mazePosition[i] % 2 == 0;
        }
        return flags;
    }

    public boolean isPathPointingOutside(MazeCoordinate coordinate) {
        int[] mazePosition = coordinate.getMazeCoordinates();
        for (int dim = 0; dim < this.dimensions.length; ++dim) {
            if (mazePosition[dim] != 0 && mazePosition[dim] != this.dimensions[dim] - 1) continue;
            return true;
        }
        return false;
    }

    public int[] getCoordPosition(int arrayPosition) {
        int[] coordPosition = new int[this.dimensions.length];
        for (int dimension = 0; dimension < this.dimensions.length; ++dimension) {
            coordPosition[dimension] = arrayPosition % this.dimensions[dimension];
            arrayPosition /= this.dimensions[dimension];
        }
        return coordPosition;
    }

    public int getArrayPosition(int ... coordPosition) {
        int arrayPosition = 0;
        int multiplier = 1;
        for (int dimension = 0; dimension < this.dimensions.length; ++dimension) {
            arrayPosition += coordPosition[dimension] * multiplier;
            multiplier *= this.dimensions[dimension];
        }
        return arrayPosition;
    }

    public void logMaze2D(Logger logger, int dimension1, int dimension2, MazeCoordinate layerPositon) {
        int[] layerPositionArray = layerPositon.getMazeCoordinates();
        StringBuilder mazeString = new StringBuilder();
        for (int dim = 0; dim < this.dimensions.length; ++dim) {
            if (dim == dimension1 || dim == dimension2 || dim >= 0 && layerPositionArray[dim] < this.dimensions[dim]) continue;
            throw new IllegalArgumentException();
        }
        for (int x = 0; x < this.dimensions[dimension1]; ++x) {
            if (x > 0) {
                mazeString.append("\n");
            }
            for (int y = 0; y < this.dimensions[dimension2]; ++y) {
                layerPositionArray[dimension1] = x;
                layerPositionArray[dimension2] = y;
                byte type = this.blocks[this.getArrayPosition(layerPositionArray)];
                if (type == 2) {
                    mazeString.append("#");
                    continue;
                }
                if (type == 1) {
                    mazeString.append("*");
                    continue;
                }
                if (type == 0) {
                    mazeString.append("+");
                    continue;
                }
                if (type == 3) {
                    if (this.dimensions.length <= 2) continue;
                    int curDominantDimension = -1;
                    boolean dominantGoesUp = false;
                    for (int refDim = 0; refDim < this.dimensions.length; ++refDim) {
                        if (refDim == dimension1 || refDim == dimension2) continue;
                        int[] abovePos = (int[])layerPositionArray.clone();
                        int n = refDim;
                        abovePos[n] = abovePos[n] + 1;
                        int[] belowPos = (int[])layerPositionArray.clone();
                        int n2 = refDim;
                        belowPos[n2] = belowPos[n2] - 1;
                        byte above = this.get(new MazeCoordinateDirect(abovePos));
                        byte below = this.get(new MazeCoordinateDirect(belowPos));
                        if (above != 3 && below != 3) continue;
                        if (curDominantDimension >= 0 || above == below) {
                            curDominantDimension = -2;
                            break;
                        }
                        curDominantDimension = refDim;
                        dominantGoesUp = above == 3;
                    }
                    switch (curDominantDimension) {
                        case -2: {
                            mazeString.append('?');
                            break;
                        }
                        case -1: {
                            mazeString.append(' ');
                            break;
                        }
                        default: {
                            mazeString.append((char)((dominantGoesUp ? 65 : 97) + curDominantDimension));
                            break;
                        }
                    }
                    continue;
                }
                mazeString.append(" ");
            }
        }
        logger.info(mazeString.toString());
    }

    public static MazeRoom[] getNeighborRooms(int dimensions) {
        if (!cachedNeighborRoomsBlueprints.containsKey(dimensions)) {
            MazePath[] neighborPaths = Maze.getNeighborPaths(dimensions);
            MazeRoom[] neighbors = new MazeRoom[neighborPaths.length];
            for (int i = 0; i < neighborPaths.length; ++i) {
                neighbors[i] = neighborPaths[i].getDestinationRoom();
            }
            cachedNeighborRoomsBlueprints.put(dimensions, (Object)neighbors);
            return (MazeRoom[])neighbors.clone();
        }
        return (MazeRoom[])((MazeRoom[])cachedNeighborRoomsBlueprints.get(dimensions)).clone();
    }

    public static MazePath[] getNeighborPaths(int dimensions) {
        if (!cachedNeighborPathBlueprints.containsKey(dimensions)) {
            MazePath[] neighbors = new MazePath[dimensions * 2];
            for (int i = 0; i < dimensions; ++i) {
                neighbors[i * 2] = new MazePath(new MazeRoom(new int[dimensions]), i, true);
                neighbors[i * 2 + 1] = new MazePath(new MazeRoom(new int[dimensions]), i, false);
            }
            cachedNeighborPathBlueprints.put(dimensions, (Object)neighbors);
            return neighbors;
        }
        return (MazePath[])cachedNeighborPathBlueprints.get(dimensions);
    }

    public static MazePath[] getNeighborPaths(int dimensions, MazeRoom mazeRoom) {
        MazePath[] blueprints = Maze.getNeighborPaths(dimensions);
        MazePath[] neighbors = new MazePath[blueprints.length];
        for (int i = 0; i < blueprints.length; ++i) {
            neighbors[i] = new MazePath(blueprints[i].pathDimension, blueprints[i].pathGoesUp, IvVecMathHelper.add(blueprints[i].sourceRoom.coordinates, mazeRoom.coordinates));
        }
        return neighbors;
    }

    public static MazeRoom coordToRoom(MazeCoordinate coordinate) {
        if (Maze.isCoordValidRoom(coordinate)) {
            int[] roomCoord = coordinate.getMazeCoordinates();
            for (int dim = 0; dim < roomCoord.length; ++dim) {
                roomCoord[dim] = (roomCoord[dim] - 1) / 2;
            }
            return new MazeRoom(roomCoord);
        }
        return null;
    }

    public static MazePath coordToPath(MazeCoordinate coordinate) {
        int pathDim = Maze.getPathDimensionIfPath(coordinate);
        return pathDim >= 0 ? Maze.coordToPath(coordinate, pathDim) : null;
    }

    public static MazePath coordToPath(MazeCoordinate coordinate, int pathDim) {
        int[] roomCoord = coordinate.getMazeCoordinates();
        boolean goesUp = true;
        for (int dim = 0; dim < roomCoord.length; ++dim) {
            if (roomCoord[dim] == 0) {
                goesUp = false;
                continue;
            }
            roomCoord[dim] = (roomCoord[dim] - 1) / 2;
        }
        return new MazePath(pathDim, goesUp, roomCoord);
    }

    public List<MazeRoom> allRooms() {
        if (this.cachedRooms == null) {
            ArrayList<MazeRoom> coordinates = new ArrayList<MazeRoom>();
            for (int i = 0; i < this.blocks.length; ++i) {
                int[] coord = this.getCoordPosition(i);
                MazeRoom room = Maze.coordToRoom(new MazeCoordinateDirect(coord));
                if (room == null) continue;
                coordinates.add(room);
            }
            this.cachedRooms = coordinates;
        }
        return this.cachedRooms;
    }

    public List<MazePath> allPaths() {
        if (this.cachedPaths == null) {
            ArrayList<MazePath> coordinates = new ArrayList<MazePath>();
            for (int i = 0; i < this.blocks.length; ++i) {
                int[] coord = this.getCoordPosition(i);
                MazePath path = Maze.coordToPath(new MazeCoordinateDirect(coord));
                if (path == null) continue;
                coordinates.add(path);
            }
            this.cachedPaths = coordinates;
        }
        return this.cachedPaths;
    }
}

