/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import ivorius.ivtoolkit.math.IvVecMathHelper;
import ivorius.ivtoolkit.maze.MazePath;
import ivorius.ivtoolkit.maze.MazeRoom;
import ivorius.ivtoolkit.random.WeightedSelector;
import ivorius.ivtoolkit.tools.NBTCompoundObject;
import ivorius.ivtoolkit.tools.NBTTagCompounds;
import ivorius.ivtoolkit.tools.NBTTagLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class MazeComponent
implements WeightedSelector.Item,
NBTCompoundObject {
    protected NBTTagCompound identifierCompound;
    protected NBTCompoundObject identifier;
    protected double weight;
    protected List<MazeRoom> rooms = new ArrayList<MazeRoom>();
    protected List<MazePath> exitPaths = new ArrayList<MazePath>();

    public MazeComponent() {
    }

    public MazeComponent(double weight, NBTCompoundObject identifier, List<MazeRoom> rooms, List<MazePath> exitPaths) {
        this.weight = weight;
        this.identifier = identifier;
        this.rooms.addAll(rooms);
        this.exitPaths.addAll(exitPaths);
    }

    public NBTCompoundObject getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(NBTCompoundObject identifier) {
        this.identifier = identifier;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    public List<MazeRoom> getRooms() {
        return Collections.unmodifiableList(this.rooms);
    }

    public void setRooms(List<MazeRoom> rooms) {
        this.rooms.clear();
        this.rooms.addAll(rooms);
    }

    public List<MazePath> getExitPaths() {
        return Collections.unmodifiableList(this.exitPaths);
    }

    public void setExitPaths(List<MazePath> exitPaths) {
        this.exitPaths.clear();
        this.exitPaths.addAll(exitPaths);
    }

    public int[] getSize() {
        int[] lowest = (int[])this.rooms.get((int)0).coordinates.clone();
        int[] highest = (int[])this.rooms.get((int)0).coordinates.clone();
        for (MazeRoom room : this.rooms) {
            for (int i = 0; i < room.coordinates.length; ++i) {
                if (room.coordinates[i] < lowest[i]) {
                    lowest[i] = room.coordinates[i];
                    continue;
                }
                if (room.coordinates[i] <= highest[i]) continue;
                highest[i] = room.coordinates[i];
            }
        }
        int[] size = IvVecMathHelper.sub(highest, new int[][]{lowest});
        int i = 0;
        while (i < size.length) {
            int n = i++;
            size[n] = size[n] + 1;
        }
        return size;
    }

    @Override
    public void readFromNBT(final NBTTagCompound compound) {
        this.identifierCompound = compound.func_74775_l("identifier");
        this.weight = compound.func_74769_h("weight");
        this.rooms.clear();
        this.rooms.addAll(Lists.transform(NBTTagLists.intArrays(compound, "rooms"), (Function)new Function<int[], MazeRoom>(){

            @Nullable
            public MazeRoom apply(int[] input) {
                return new MazeRoom(input);
            }
        }));
        this.exitPaths.clear();
        this.exitPaths.addAll(Lists.transform(NBTTagLists.compounds(compound, "exitPaths"), (Function)new Function<NBTTagCompound, MazePath>(){

            @Nullable
            public MazePath apply(@Nullable NBTTagCompound input) {
                return NBTTagCompounds.read(compound, MazePath.class);
            }
        }));
    }

    public void readIdentifier(Class<? extends NBTCompoundObject> iClass) {
        this.identifier = NBTTagCompounds.read(this.identifierCompound, iClass);
        this.identifierCompound = null;
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74782_a("identifier", (NBTBase)NBTTagCompounds.write(this.identifier));
        compound.func_74780_a("weight", this.weight);
        compound.func_74782_a("rooms", (NBTBase)NBTTagLists.storeIntArrays(Lists.transform(this.rooms, (Function)new Function<MazeRoom, int[]>(){

            @Nullable
            public int[] apply(@Nullable MazeRoom input) {
                return input.coordinates;
            }
        })));
        compound.func_74782_a("exitPaths", (NBTBase)NBTTagLists.storeCompounds(Lists.transform(this.exitPaths, (Function)new Function<MazePath, NBTTagCompound>(){

            @Nullable
            public NBTTagCompound apply(@Nullable MazePath input) {
                return NBTTagCompounds.write(input);
            }
        })));
    }
}

