/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.maze;

import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.maze.Maze;
import ivorius.ivtoolkit.maze.MazeCoordinateDirect;
import ivorius.ivtoolkit.maze.MazePath;
import ivorius.ivtoolkit.maze.MazeRoom;
import ivorius.ivtoolkit.random.WeightedSelector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import java.util.Stack;

public class MazeGenerator {
    public static void generateStartPathsForEnclosedMaze(Maze maze, Iterable<MazePath> startPoints, Iterable<MazeRoom> blockedRooms, AxisAlignedTransform2D transform) {
        int[] mazeSizeInRooms = new int[maze.dimensions.length];
        for (int i = 0; i < mazeSizeInRooms.length; ++i) {
            mazeSizeInRooms[i] = (maze.dimensions[i] - 1) / 2;
        }
        for (MazePath path : maze.allPaths()) {
            if (!maze.isPathPointingOutside(path)) continue;
            maze.set((byte)2, path);
        }
        for (MazeRoom blockedRoom : blockedRooms) {
            blockedRoom = MazeGenerator.rotatedRoom(blockedRoom, transform, mazeSizeInRooms);
            maze.set((byte)2, blockedRoom);
            for (int dim = 0; dim < maze.dimensions.length; ++dim) {
                maze.set((byte)2, new MazePath(blockedRoom, dim, true));
                maze.set((byte)2, new MazePath(blockedRoom, dim, false));
            }
        }
        for (MazePath startPoint : startPoints) {
            maze.set((byte)3, MazeGenerator.rotatedPath(startPoint, transform, mazeSizeInRooms));
        }
    }

    public static MazePath randomEmptyPathInMaze(Random rand, Maze maze, Collection<Integer> applicableDimensions) {
        ArrayList<MazePath> paths = new ArrayList<MazePath>(maze.allPaths());
        Iterator iterator = paths.iterator();
        while (iterator.hasNext()) {
            MazePath path = (MazePath)iterator.next();
            if (maze.get(path) == 0 && applicableDimensions.contains(path.pathDimension)) continue;
            iterator.remove();
        }
        if (paths.size() > 0) {
            return (MazePath)paths.get(rand.nextInt(paths.size()));
        }
        return null;
    }

    @Deprecated
    public static MazeRoom randomRoomInMaze(Random rand, Maze maze, int ... distanceFromOutside) {
        int[] position = new int[maze.dimensions.length];
        for (int i = 0; i < maze.dimensions.length; ++i) {
            position[i] = rand.nextInt(maze.dimensions[i] / 2 - distanceFromOutside[i]);
        }
        return new MazeRoom(position);
    }

    @Deprecated
    public static MazePath randomPathInMaze(Random rand, Maze maze, int ... distanceFromOutside) {
        ArrayList dimensionWeights = new ArrayList();
        for (int dim = 0; dim < maze.dimensions.length; ++dim) {
            int dimLength = maze.dimensions[dim] / 2 + 1 - (distanceFromOutside[dim] + 1) / 2 * 2;
            dimensionWeights.add(new WeightedSelector.SimpleItem<Integer>(Math.max(0, dimLength), dim));
        }
        int usedDimension = (Integer)WeightedSelector.select(rand, dimensionWeights);
        int[] roomDistanceFromOutside = new int[distanceFromOutside.length];
        for (int i = 0; i < roomDistanceFromOutside.length; ++i) {
            roomDistanceFromOutside[i] = distanceFromOutside[i] / 2;
        }
        MazeRoom refRoom = MazeGenerator.randomRoomInMaze(rand, maze, roomDistanceFromOutside);
        int[] pathCoord = refRoom.getMazeCoordinates();
        int availablePaths = (distanceFromOutside[usedDimension] + 1) / 2 * 2;
        pathCoord[usedDimension] = rand.nextInt(availablePaths) * 2 + (maze.dimensions[usedDimension] / 2 + 1 - availablePaths) / 2;
        return Maze.coordToPath(new MazeCoordinateDirect(pathCoord), usedDimension);
    }

    public static void generatePaths(Random rand, Maze maze, int[] pathWeights, MazeRoom startPoint) {
        for (int i = 0; i < maze.dimensions.length; ++i) {
            if (maze.dimensions[i] >= 3) continue;
            return;
        }
        MazeRoom position = startPoint.clone();
        maze.set((byte)3, position);
        Stack<MazeRoom> positionStack = new Stack<MazeRoom>();
        ArrayList<MazePath> validRoomNeighbors = new ArrayList<MazePath>();
        while (true) {
            MazePath[] neighbors;
            validRoomNeighbors.clear();
            for (MazePath neighbor : Maze.getNeighborPaths(maze.dimensions.length, position)) {
                if (maze.get(neighbor.getDestinationRoom()) != 0) continue;
                for (int n = 0; n < pathWeights[neighbor.pathDimension]; ++n) {
                    validRoomNeighbors.add(neighbor);
                }
            }
            if (validRoomNeighbors.size() == 0) {
                if (positionStack.empty()) break;
                position = (MazeRoom)positionStack.pop();
                continue;
            }
            positionStack.push(position.clone());
            MazePath usedPath = (MazePath)validRoomNeighbors.get(rand.nextInt(validRoomNeighbors.size()));
            MazeRoom destRoom = usedPath.getDestinationRoom();
            maze.set((byte)3, usedPath);
            maze.set((byte)3, destRoom);
            for (MazePath neighbor : neighbors = Maze.getNeighborPaths(maze.dimensions.length, position)) {
                if (maze.get(neighbor) != 0) continue;
                maze.set((byte)2, neighbor);
            }
            position = destRoom;
        }
        for (int i = 0; i < maze.blocks.length; ++i) {
            if (maze.blocks[i] != 1 && maze.blocks[i] != 0) continue;
            maze.blocks[i] = 2;
        }
    }

    @Deprecated
    public static void addRandomPaths(Maze maze, int paths, Random rand) {
        for (int i = 0; i < maze.dimensions.length; ++i) {
            if ((maze.dimensions[i] - 2) / 2 > 0) continue;
            return;
        }
        int[] distFromOutside = new int[maze.dimensions.length];
        while (paths > 0) {
            MazePath position = MazeGenerator.randomPathInMaze(rand, maze, distFromOutside);
            maze.set((byte)3, position);
            --paths;
        }
    }

    @Deprecated
    public static void generateStartPathsForEnclosedMaze(Maze maze, MazePath ... startPoints) {
        for (MazePath path : maze.allPaths()) {
            if (!maze.isPathPointingOutside(path)) continue;
            maze.set((byte)2, path);
        }
        for (MazePath startPoint : startPoints) {
            maze.set((byte)3, startPoint);
        }
    }

    public static MazeRoom rotatedRoom(MazeRoom room, AxisAlignedTransform2D transform, int[] size) {
        int[] roomPosition = room.coordinates;
        BlockCoord transformedRoom = transform.apply(new BlockCoord(roomPosition[0], roomPosition[1], roomPosition[2]), size);
        return new MazeRoom(transformedRoom.x, transformedRoom.y, transformedRoom.z);
    }

    public static MazePath rotatedPath(MazePath path, AxisAlignedTransform2D transform, int[] size) {
        int[] sourceCoords = path.getSourceRoom().coordinates;
        int[] destCoords = path.getDestinationRoom().coordinates;
        BlockCoord transformedSource = transform.apply(new BlockCoord(sourceCoords[0], sourceCoords[1], sourceCoords[2]), size);
        BlockCoord transformedDest = transform.apply(new BlockCoord(destCoords[0], destCoords[1], destCoords[2]), size);
        return MazePath.pathFromSourceAndDest(new MazeRoom(transformedSource.x, transformedSource.y, transformedSource.z), new MazeRoom(transformedDest.x, transformedDest.y, transformedDest.z));
    }
}

