/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.rendering;

import java.nio.ByteBuffer;
import net.minecraft.client.renderer.OpenGlHelper;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

public class IvDepthBuffer {
    public Logger logger;
    private boolean setUp;
    private int depthTextureIndex;
    private int depthFB;
    private int parentFB;
    private int textureWidth;
    private int textureHeight;

    public IvDepthBuffer(int width, int height, Logger logger) {
        this.setParentFB(0);
        this.setSize(width, height);
        this.logger = logger;
    }

    public boolean allocate() {
        this.deallocate();
        if (OpenGlHelper.field_148823_f && this.textureWidth > 0 && this.textureHeight > 0) {
            this.depthTextureIndex = IvDepthBuffer.genDefaultDepthTexture(this.textureWidth, this.textureHeight);
            this.depthFB = OpenGlHelper.func_153165_e();
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.depthFB);
            OpenGlHelper.func_153188_a((int)OpenGlHelper.field_153198_e, (int)OpenGlHelper.field_153201_h, (int)3553, (int)this.depthTextureIndex, (int)0);
            GL11.glDrawBuffer((int)0);
            GL11.glReadBuffer((int)0);
            int status = OpenGlHelper.func_153167_i((int)OpenGlHelper.field_153198_e);
            if (status != OpenGlHelper.field_153202_i) {
                this.logger.error("Depth FBO failed setting up! (" + IvDepthBuffer.getFramebufferStatusString(status) + ")");
            } else {
                this.setUp = true;
            }
            this.unbind();
        }
        return this.setUp;
    }

    public static int genDefaultDepthTexture(int textureWidth, int textureHeight) {
        int depthTextureIndex = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)depthTextureIndex);
        GL11.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)34891, (int)32841);
        GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
        GL11.glTexParameteri((int)3553, (int)34893, (int)515);
        GL11.glTexImage2D((int)3553, (int)0, (int)33190, (int)textureWidth, (int)textureHeight, (int)0, (int)6402, (int)5126, (ByteBuffer)null);
        return depthTextureIndex;
    }

    public void deallocate() {
        this.setUp = false;
        if (this.depthTextureIndex > 0) {
            GL11.glDeleteTextures((int)this.depthTextureIndex);
            this.depthTextureIndex = 0;
        }
        if (this.depthFB > 0) {
            OpenGlHelper.func_153174_h((int)this.depthFB);
            this.depthFB = 0;
        }
    }

    public int getDepthFBObject() {
        return this.isAllocated() ? this.depthFB : 0;
    }

    public int getDepthTextureIndex() {
        return this.isAllocated() ? this.depthTextureIndex : 0;
    }

    public void bind() {
        if (this.isAllocated()) {
            this.bindTextureForDestination();
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.depthFB);
            GL11.glDrawBuffer((int)0);
            GL11.glReadBuffer((int)0);
        }
    }

    public void unbind() {
        if (this.isAllocated()) {
            OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)0);
            GL11.glDrawBuffer((int)1029);
            GL11.glReadBuffer((int)1029);
            if (this.parentFB > 0) {
                OpenGlHelper.func_153171_g((int)OpenGlHelper.field_153198_e, (int)this.parentFB);
            }
        }
    }

    public boolean isAllocated() {
        return this.setUp;
    }

    public void setSize(int width, int height) {
        if (this.textureWidth != width || this.textureHeight != height) {
            this.textureWidth = width;
            this.textureHeight = height;
            if (this.isAllocated()) {
                this.allocate();
            }
        }
    }

    public int getParentFB() {
        return this.parentFB;
    }

    public void setParentFB(int parentFB) {
        this.parentFB = parentFB > 0 ? parentFB : 0;
    }

    public static void bindTextureForSource(int glTexture, int textureIndex) {
        GL11.glBindTexture((int)3553, (int)textureIndex);
        GL11.glTexParameteri((int)3553, (int)34892, (int)0);
        GL11.glTexParameteri((int)3553, (int)34891, (int)6409);
        OpenGlHelper.func_77473_a((int)glTexture);
        GL11.glBindTexture((int)3553, (int)textureIndex);
        OpenGlHelper.func_77473_a((int)33984);
    }

    public static void bindTextureForDestination(int textureIndex) {
        GL11.glBindTexture((int)3553, (int)textureIndex);
        GL11.glTexParameteri((int)3553, (int)34892, (int)34894);
        GL11.glTexParameteri((int)3553, (int)34891, (int)32841);
    }

    public void bindTextureForSource(int glTexture) {
        IvDepthBuffer.bindTextureForSource(glTexture, this.getDepthTextureIndex());
    }

    public void bindTextureForDestination() {
        IvDepthBuffer.bindTextureForDestination(this.getDepthTextureIndex());
    }

    public int getTextureWidth() {
        return this.textureWidth;
    }

    public int getTextureHeight() {
        return this.textureHeight;
    }

    public static String getFramebufferStatusString(int code) {
        return code + ": " + GLU.gluErrorString((int)code);
    }
}

