/*
 * Decompiled with CFR 0.152.
 */
package ivorius.ivtoolkit.tools;

import ivorius.ivtoolkit.IvToolkitCoreContainer;
import ivorius.ivtoolkit.blocks.BlockArea;
import ivorius.ivtoolkit.blocks.BlockCoord;
import ivorius.ivtoolkit.blocks.IvBlockCollection;
import ivorius.ivtoolkit.math.AxisAlignedTransform2D;
import ivorius.ivtoolkit.tools.EntityCreatureAccessor;
import ivorius.ivtoolkit.tools.MCRegistry;
import ivorius.ivtoolkit.tools.Movable;
import ivorius.ivtoolkit.tools.Transformable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class IvWorldData {
    public static final String ID_FIX_TAG_KEY = "SG_ID_FIX_TAG";
    public IvBlockCollection blockCollection;
    public List<TileEntity> tileEntities;
    public List<Entity> entities;

    public IvWorldData(IvBlockCollection blockCollection, List<TileEntity> tileEntities, List<Entity> entities) {
        this.blockCollection = blockCollection;
        this.tileEntities = tileEntities;
        this.entities = entities;
    }

    public IvWorldData(World world, BlockArea blockArea, boolean captureEntities) {
        int[] size = blockArea.areaSize();
        this.blockCollection = new IvBlockCollection(size[0], size[1], size[2]);
        this.tileEntities = new ArrayList<TileEntity>();
        for (BlockCoord worldCoord : blockArea) {
            BlockCoord dataCoord = worldCoord.subtract(blockArea.getLowerCorner());
            this.blockCollection.setBlock(dataCoord, world.func_147439_a(worldCoord.x, worldCoord.y, worldCoord.z));
            this.blockCollection.setMetadata(dataCoord, (byte)world.func_72805_g(worldCoord.x, worldCoord.y, worldCoord.z));
            TileEntity tileEntity = world.func_147438_o(worldCoord.x, worldCoord.y, worldCoord.z);
            if (tileEntity == null) continue;
            this.tileEntities.add(tileEntity);
        }
        this.entities = captureEntities ? world.func_94576_a(null, blockArea.asAxisAlignedBB(), (IEntitySelector)new EntitySelectorSaveable()) : Collections.emptyList();
    }

    public IvWorldData(NBTTagCompound compound, World world, MCRegistry registry) {
        compound = (NBTTagCompound)compound.func_74737_b();
        this.blockCollection = new IvBlockCollection(compound.func_74775_l("blockCollection"), registry);
        NBTTagList teList = compound.func_150295_c("tileEntities", 10);
        this.tileEntities = new ArrayList<TileEntity>(teList.func_74745_c());
        for (int i = 0; i < teList.func_74745_c(); ++i) {
            NBTTagCompound teCompound = teList.func_150305_b(i);
            IvWorldData.recursivelyApplyIDFixTags(teCompound, registry);
            TileEntity tileEntity = registry.loadTileEntity(teCompound);
            if (tileEntity == null) continue;
            this.tileEntities.add(tileEntity);
        }
        if (world != null) {
            NBTTagList entityList = compound.func_150295_c("entities", 10);
            this.entities = new ArrayList<Entity>(entityList.func_74745_c());
            for (int i = 0; i < entityList.func_74745_c(); ++i) {
                NBTTagCompound entityCompound = entityList.func_150305_b(i);
                IvWorldData.recursivelyApplyIDFixTags(entityCompound, registry);
                Entity entity = EntityList.func_75615_a((NBTTagCompound)entityCompound, (World)world);
                if (entity == null) continue;
                this.entities.add(entity);
            }
        }
    }

    public NBTTagCompound createTagCompound(BlockCoord referenceCoord) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("blockCollection", (NBTBase)this.blockCollection.createTagCompound());
        NBTTagList teList = new NBTTagList();
        for (TileEntity tileEntity : this.tileEntities) {
            NBTTagCompound teCompound = new NBTTagCompound();
            IvWorldData.moveTileEntityForGeneration(tileEntity, referenceCoord.invert());
            tileEntity.func_145841_b(teCompound);
            IvWorldData.moveTileEntityForGeneration(tileEntity, referenceCoord);
            IvWorldData.recursivelyInjectIDFixTags(teCompound);
            teList.func_74742_a((NBTBase)teCompound);
        }
        compound.func_74782_a("tileEntities", (NBTBase)teList);
        NBTTagList entityList = new NBTTagList();
        for (Entity entity : this.entities) {
            NBTTagCompound entityCompound = new NBTTagCompound();
            IvWorldData.moveEntityForGeneration(entity, referenceCoord.invert());
            entity.func_70039_c(entityCompound);
            IvWorldData.moveEntityForGeneration(entity, referenceCoord);
            IvWorldData.recursivelyInjectIDFixTags(entityCompound);
            entityList.func_74742_a((NBTBase)entityCompound);
        }
        compound.func_74782_a("entities", (NBTBase)entityList);
        return compound;
    }

    public static void moveTileEntityForGeneration(TileEntity tileEntity, BlockCoord coord) {
        if (tileEntity instanceof Movable) {
            ((Movable)tileEntity).move(coord.x, coord.y, coord.z);
        } else {
            tileEntity.field_145851_c += coord.x;
            tileEntity.field_145848_d += coord.y;
            tileEntity.field_145849_e += coord.z;
        }
    }

    public static void setTileEntityPosForGeneration(TileEntity tileEntity, BlockCoord coord) {
        IvWorldData.moveTileEntityForGeneration(tileEntity, coord.subtract(new BlockCoord(tileEntity)));
    }

    public static void transformTileEntityPosForGeneration(TileEntity tileEntity, AxisAlignedTransform2D transform, int[] size) {
        if (tileEntity instanceof Transformable) {
            ((Transformable)tileEntity).transform(transform.getRotation(), transform.isMirrorX(), size);
        } else {
            IvWorldData.setTileEntityPosForGeneration(tileEntity, transform.apply(new BlockCoord(tileEntity), size));
        }
    }

    public static void moveEntityForGeneration(Entity entity, BlockCoord coord) {
        if (entity instanceof Movable) {
            ((Movable)entity).move(coord.x, coord.y, coord.z);
        } else {
            entity.func_70107_b(entity.field_70165_t + (double)coord.x, entity.field_70163_u + (double)coord.y, entity.field_70161_v + (double)coord.z);
            if (entity instanceof EntityHanging) {
                EntityHanging entityHanging = (EntityHanging)entity;
                entityHanging.field_146063_b += coord.x;
                entityHanging.field_146064_c += coord.y;
                entityHanging.field_146062_d += coord.z;
                entityHanging.func_82328_a(entityHanging.field_82332_a);
            }
            if (entity instanceof EntityCreature) {
                EntityCreature entityCreature = (EntityCreature)entity;
                ChunkCoordinates homePosition = entityCreature.func_110172_bL();
                EntityCreatureAccessor.setHomePosition(entityCreature, homePosition.field_71574_a + coord.x, homePosition.field_71572_b + coord.y, homePosition.field_71573_c + coord.z);
            }
        }
    }

    public static void transformEntityPosForGeneration(Entity entity, AxisAlignedTransform2D transform, int[] size) {
        if (entity instanceof Transformable) {
            ((Transformable)entity).transform(transform.getRotation(), transform.isMirrorX(), size);
        } else {
            double[] newEntityPos = transform.apply(new double[]{entity.field_70165_t, entity.field_70163_u, entity.field_70161_v}, size);
            entity.func_70107_b(newEntityPos[0], newEntityPos[1], newEntityPos[2]);
            if (entity instanceof EntityHanging) {
                EntityHanging entityHanging = (EntityHanging)entity;
                BlockCoord hangingCoord = new BlockCoord(entityHanging.field_146063_b, entityHanging.field_146064_c, entityHanging.field_146062_d);
                BlockCoord newHangingCoord = transform.apply(hangingCoord, size);
                entityHanging.field_146063_b = newHangingCoord.x;
                entityHanging.field_146064_c = newHangingCoord.y;
                entityHanging.field_146062_d = newHangingCoord.z;
                entityHanging.func_82328_a(entityHanging.field_82332_a);
            }
            if (entity instanceof EntityCreature) {
                EntityCreature entityCreature = (EntityCreature)entity;
                ChunkCoordinates homePosition = entityCreature.func_110172_bL();
                ChunkCoordinates newHomePosition = transform.apply(homePosition, size);
                EntityCreatureAccessor.setHomePosition(entityCreature, newHomePosition.field_71574_a, newHomePosition.field_71572_b, newHomePosition.field_71573_c);
            }
        }
    }

    public static void recursivelyInjectIDFixTags(NBTTagCompound compound) {
        IvWorldData.injectIDFixTags(compound);
        for (Object key : compound.func_150296_c()) {
            String keyString = (String)key;
            NBTBase innerCompound = compound.func_74781_a(keyString);
            if (innerCompound instanceof NBTTagCompound) {
                IvWorldData.recursivelyInjectIDFixTags((NBTTagCompound)innerCompound);
                continue;
            }
            if (!(innerCompound instanceof NBTTagList)) continue;
            IvWorldData.recursivelyInjectIDFixTags((NBTTagList)innerCompound);
        }
    }

    public static void recursivelyInjectIDFixTags(NBTTagList list) {
        int tagType = list.func_150303_d();
        switch (tagType) {
            case 10: {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    IvWorldData.recursivelyInjectIDFixTags(list.func_150305_b(i));
                }
                break;
            }
        }
    }

    private static boolean hasPrimitive(NBTTagCompound compound, String key) {
        return compound.func_74764_b(key) && compound.func_74781_a(key) instanceof NBTBase.NBTPrimitive;
    }

    public static void injectTEBlockFixTags(NBTTagCompound compound, String tileEntityID, NBTTagList list, String ... keys) {
        if (tileEntityID.equals(compound.func_74779_i("id"))) {
            for (String key : keys) {
                if (!IvWorldData.hasPrimitive(compound, key)) continue;
                IvWorldData.addBlockTag(compound.func_74762_e(key), list, key);
            }
        }
    }

    public static void injectIDFixTags(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        if (IvWorldData.hasPrimitive(compound, "id") && IvWorldData.hasPrimitive(compound, "Count") && IvWorldData.hasPrimitive(compound, "Damage")) {
            IvWorldData.addItemTag(compound.func_74762_e("id"), list, "id");
        }
        IvWorldData.injectTEBlockFixTags(compound, "vanishingTileEntity", list, "BlockID");
        IvWorldData.injectTEBlockFixTags(compound, "fenceGateTileEntity", list, "camoBlock");
        IvWorldData.injectTEBlockFixTags(compound, "mixedBlockTileEntity", list, "block1", "block2");
        IvWorldData.injectTEBlockFixTags(compound, "customDoorTileEntity", list, "frame", "topMaterial", "bottomMaterial");
        if (list.func_74745_c() > 0) {
            compound.func_74782_a(ID_FIX_TAG_KEY, (NBTBase)list);
        }
    }

    public static void addItemTag(int itemID, NBTTagList tagList, String tagDest) {
        Item item = Item.func_150899_d((int)itemID);
        if (item != null) {
            String stringID = Item.field_150901_e.func_148750_c((Object)item);
            NBTTagCompound idCompound = new NBTTagCompound();
            idCompound.func_74778_a("type", "item");
            idCompound.func_74778_a("tagDest", tagDest);
            idCompound.func_74778_a("itemID", stringID);
            tagList.func_74742_a((NBTBase)idCompound);
        } else {
            IvToolkitCoreContainer.logger.warn("Failed to apply item tag for structure with ID '" + itemID + "'");
        }
    }

    public static void addBlockTag(int blockID, NBTTagList tagList, String tagDest) {
        Block block = Block.func_149729_e((int)blockID);
        if (block != null) {
            String stringID = Block.field_149771_c.func_148750_c((Object)block);
            NBTTagCompound idCompound = new NBTTagCompound();
            idCompound.func_74778_a("type", "block");
            idCompound.func_74778_a("tagDest", tagDest);
            idCompound.func_74778_a("blockID", stringID);
            tagList.func_74742_a((NBTBase)idCompound);
        } else {
            IvToolkitCoreContainer.logger.warn("Failed to apply block tag for structure with ID '" + blockID + "'");
        }
    }

    public static void recursivelyApplyIDFixTags(NBTTagCompound compound, MCRegistry registry) {
        IvWorldData.applyIDFixTags(compound, registry);
        compound.func_82580_o(ID_FIX_TAG_KEY);
        for (Object key : compound.func_150296_c()) {
            String keyString = (String)key;
            NBTBase innerCompound = compound.func_74781_a(keyString);
            if (innerCompound instanceof NBTTagCompound) {
                IvWorldData.recursivelyApplyIDFixTags((NBTTagCompound)innerCompound, registry);
                continue;
            }
            if (!(innerCompound instanceof NBTTagList)) continue;
            IvWorldData.recursivelyApplyIDFixTags((NBTTagList)innerCompound, registry);
        }
    }

    public static void recursivelyApplyIDFixTags(NBTTagList list, MCRegistry registry) {
        int tagType = list.func_150303_d();
        switch (tagType) {
            case 10: {
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    IvWorldData.recursivelyApplyIDFixTags(list.func_150305_b(i), registry);
                }
                break;
            }
        }
    }

    public static void applyIDFixTags(NBTTagCompound compound, MCRegistry registry) {
        if (compound.func_74764_b(ID_FIX_TAG_KEY)) {
            NBTTagList list = compound.func_150295_c(ID_FIX_TAG_KEY, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                IvWorldData.applyIDFixTag(compound, registry, list.func_150305_b(i));
            }
        }
    }

    public static void applyIDFixTag(NBTTagCompound compound, MCRegistry registry, NBTTagCompound fixTag) {
        String type;
        switch (type = fixTag.func_74779_i("type")) {
            case "item": {
                String dest = fixTag.func_74779_i("tagDest");
                String stringID = fixTag.func_74779_i("itemID");
                Item item = registry.itemFromID(stringID);
                if (item != null) {
                    compound.func_74768_a(dest, Item.func_150891_b((Item)item));
                } else {
                    IvToolkitCoreContainer.logger.warn("Failed to fix item tag from structure with ID '" + stringID + "'");
                }
                registry.modifyItemStackCompound(compound, stringID);
                break;
            }
            case "block": {
                String dest = fixTag.func_74779_i("tagDest");
                String stringID = fixTag.func_74779_i("blockID");
                Block block = registry.blockFromID(stringID);
                if (block != null) {
                    compound.func_74768_a(dest, Block.func_149682_b((Block)block));
                    break;
                }
                IvToolkitCoreContainer.logger.warn("Failed to fix block tag from structure with ID '" + stringID + "'");
                break;
            }
            default: {
                IvToolkitCoreContainer.logger.warn("Unrecognized ID fix tag in structure with type '" + type + "'");
            }
        }
    }

    public static class EntitySelectorSaveable
    implements IEntitySelector {
        public boolean func_82704_a(Entity entity) {
            return !(entity instanceof EntityPlayer);
        }
    }
}

