/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.base;

import java.text.DecimalFormat;
import net.halalaboos.client.main.Client;

public class Value {
    private String name;
    private float value;
    private float min;
    private float max;
    private float def;
    private float widestOutcome;

    public Value(String valName, float defaultVal, float minVal, float maxVal) {
        this.name = valName;
        this.value = defaultVal;
        this.def = defaultVal;
        this.min = minVal;
        this.max = maxVal;
        this.widestOutcome = (float)this.getWidestPossibleOutcome();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public float getMin() {
        return this.min;
    }

    public void setMin(float min) {
        this.min = min;
    }

    public float getMax() {
        return this.max;
    }

    public void setMax(float max) {
        this.max = max;
    }

    public float getDef() {
        return this.def;
    }

    public String getName() {
        return this.name;
    }

    public float getWidestOutcome() {
        return this.widestOutcome;
    }

    public double getWidestPossibleOutcome() {
        DecimalFormat f2 = new DecimalFormat("#.#");
        double widest = 0.0;
        for (double d2 = (double)this.getMin(); d2 <= (double)this.getMax(); d2 += 0.1) {
            if (Client.getFR().getStringWidth(f2.format(d2)) <= Client.getFR().getStringWidth(f2.format(widest))) continue;
            widest = d2;
        }
        this.widestOutcome = (float)widest;
        return widest;
    }
}

