/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.main;

import net.halalaboos.client.base.Manager;
import net.halalaboos.client.event.EventHandler;
import net.halalaboos.client.event.events.EventTick;
import net.halalaboos.client.main.ClientWrapper;
import net.halalaboos.client.manager.CommandManager;
import net.halalaboos.client.manager.FileManager;
import net.halalaboos.client.manager.GuiManager;
import net.halalaboos.client.manager.ModManager;
import net.halalaboos.client.manager.ValueManager;
import net.halalaboos.client.manager.WindowManager;
import net.halalaboos.client.mods.ModLoader;
import net.halalaboos.client.utils.ClientUtils;
import net.halalaboos.client.utils.RenderUtils;
import net.halalaboos.client.utils.TextureUtils;
import net.halalaboos.client.utils.font.CFontRenderer;
import net.minecraft.client.Minecraft;

public class Client {
    public static final String CLIENT_TITLE = "Huzuni";
    public static final String CLIENT_VERSION = "1.11";
    private static Minecraft mc;
    private static CFontRenderer fontRenderer;
    private static EventHandler eventHandler;
    private static RenderUtils renderUtils;
    private static ClientUtils clientUtils;
    private static TextureUtils textureUtils;
    private static ClientWrapper wrapper;
    private static ModLoader modLoader;

    public Client(Minecraft mc2) {
        mc = mc2;
        wrapper = new ClientWrapper(mc2);
        renderUtils = new RenderUtils(mc2);
        clientUtils = new ClientUtils(mc2);
        fontRenderer = new CFontRenderer(mc2, "Verdana", 18);
    }

    public void onStartup() {
        eventHandler = new EventHandler();
        new ValueManager();
        new CommandManager();
        new ModManager();
        new WindowManager();
        new GuiManager();
        new FileManager();
        modLoader = new ModLoader();
        for (Manager m2 : Manager.getManagers()) {
            try {
                m2.onStartup();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void onEnd() {
        for (Manager m2 : Manager.getManagers()) {
            try {
                m2.onEnd();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    public void addChatMessage(String msg) {
        Client.mc.g.b("[\u00a7a\u00a7lHuzuni\u00a7r] " + msg);
    }

    public void onTick() {
        eventHandler.call(new EventTick(this));
    }

    public static EventHandler getEventHandler() {
        return eventHandler;
    }

    public static RenderUtils getRenderUtils() {
        return renderUtils;
    }

    public static ClientUtils getClientUtils() {
        return clientUtils;
    }

    public static TextureUtils getTextureUtils() {
        return textureUtils;
    }

    public static ClientWrapper getWrapper() {
        return wrapper;
    }

    public static CFontRenderer getFR() {
        return fontRenderer;
    }

    public static void setFR(CFontRenderer fontRenderer) {
        Client.fontRenderer = fontRenderer;
    }

    public static ModLoader getModLoader() {
        return modLoader;
    }
}

