/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.mods.pvp;

import net.halalaboos.client.base.Value;
import net.halalaboos.client.event.Event;
import net.halalaboos.client.event.Listener;
import net.halalaboos.client.event.events.EventMovement;
import net.halalaboos.client.event.events.EventServerUpdate;
import net.halalaboos.client.files.FriendsFile;
import net.halalaboos.client.manager.ModManager;
import net.halalaboos.client.manager.ValueManager;
import net.halalaboos.client.mods.Mod;
import net.halalaboos.client.mods.SideMod;
import net.halalaboos.client.utils.ClientUtils;
import net.minecraft.client.Minecraft;

public class KillAura
extends Mod
implements Listener {
    private mp currentEntity;
    private long lastHitMS = 0L;
    private Value speed;
    private SideMod players;
    private SideMod mobs;
    private SideMod animals;

    public KillAura() {
        super("Kill Aura", 19);
        this.setType(Mod.Type.PVP);
        this.setDescription("Kills entities around you.");
        this.speed = new Value("Kill Aura Speed", 11.0f, 5.0f, 15.0f);
        ValueManager.add(this.speed);
        this.players = new SideMod("Players");
        ModManager.getMods().add(this.players);
        this.players.setState(true);
        this.mobs = new SideMod("Mobs");
        ModManager.getMods().add(this.mobs);
        this.animals = new SideMod("Animals");
        ModManager.getMods().add(this.animals);
    }

    @Override
    public void onEvent(Event event) {
        if (event instanceof EventMovement) {
            EventMovement mEvent = (EventMovement)event;
            if (mEvent.getType().equals((Object)EventMovement.EventType.PRE_UPDATE)) {
                this.preUpdate();
            } else if (mEvent.getType().equals((Object)EventMovement.EventType.POST_UPDATE)) {
                this.postUpdate();
            }
        } else if (event instanceof EventServerUpdate) {
            EventServerUpdate rEvent = (EventServerUpdate)event;
            if (this.fakeRotation()) {
                Minecraft minecraft = this.mc;
                float[] rotations = minecraft.theClient.getClientUtils().getRotation(this.currentEntity.u, this.currentEntity.v + (double)this.currentEntity.e(), this.currentEntity.w);
                rEvent.setRotationYaw(rotations[0]);
                rEvent.setRotationPitch(rotations[1]);
            }
        }
    }

    public void preUpdate() {
        if (!this.isHittableNotNull(this.currentEntity, true)) {
            this.currentEntity = this.findEntity();
        } else {
            this.mc.g.c(false);
        }
    }

    public void postUpdate() {
        if ((float)(ClientUtils.getSystemTime() - this.lastHitMS) >= 1000.0f / this.speed.getValue() && this.isHittableNotNull(this.currentEntity, false)) {
            this.mc.g.bK();
            this.mc.b.a(this.mc.g, this.currentEntity);
            this.lastHitMS = ClientUtils.getSystemTime();
            this.currentEntity = null;
        }
    }

    public mp findEntity() {
        mp closest = null;
        for (Object o2 : this.mc.e.e) {
            mp entity = (mp)o2;
            if (!this.isHittableNotNull(entity, true) || !this.isOnList(entity)) continue;
            if (closest == null) {
                closest = entity;
                continue;
            }
            if (!(this.mc.g.d(entity) < this.mc.g.d(closest))) continue;
            closest = entity;
        }
        return closest;
    }

    public boolean fakeRotation() {
        return this.isHittableNotNull(this.currentEntity, true);
    }

    @Override
    public void onToggle() {
    }

    public boolean isHittableNotNull(mp entity, boolean justLook) {
        return entity == null ? false : (double)this.mc.g.d(entity) < (justLook ? 6.5 : 4.0) && !entity.M && entity instanceof ng && entity != this.mc.g && (!(entity instanceof sq) || !FriendsFile.contains(entity.am()));
    }

    public boolean isOnList(mp entity) {
        if (entity instanceof sq && this.players.isState()) {
            return true;
        }
        if (entity instanceof qh && this.animals.isState()) {
            return true;
        }
        return entity instanceof sb && this.mobs.isState();
    }

    @Override
    public void onEnable() {
        this.eventHandler.registerListener(EventServerUpdate.class, this);
        this.eventHandler.registerListener(EventMovement.class, this);
    }

    @Override
    public void onDisable() {
        this.eventHandler.unRegisterListener(EventServerUpdate.class, this);
        this.eventHandler.unRegisterListener(EventMovement.class, this);
    }
}

