/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.ui.tabbed.components;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.halalaboos.client.main.Client;
import net.halalaboos.client.ui.tabbed.components.Button;

public class Tab {
    protected List buttons;
    protected String title;
    protected int selectedButton = 0;
    protected boolean opened;

    public Tab(String title) {
        this.title = title;
        this.buttons = new ArrayList();
    }

    public void render(boolean selected, int posX, int posY, int width) {
        Client.getRenderUtils().drawHalRect(posX, posY, posX + width, posY + 12, selected, this.opened);
        Client.getFR().drawStringWithShadow(this.title, posX + 2, posY + 2, 0xFFFFFF);
        if (selected && this.opened) {
            Iterator i$ = this.buttons.iterator();
            while (i$.hasNext()) {
                Button button;
                int index = this.buttons.indexOf(button = (Button)i$.next());
                button.render(this.selectedButton == index, posX + width + 1, posY + index * 11, width);
            }
        }
    }

    public void recieveInput(String input) {
        if (input.equalsIgnoreCase("UP")) {
            this.movePosition(-1);
        } else if (input.equalsIgnoreCase("DOWN")) {
            this.movePosition(1);
        } else if (input.equalsIgnoreCase("ENTER")) {
            ((Button)this.buttons.get(this.selectedButton)).toggle();
        } else if (input.equalsIgnoreCase("LEFT")) {
            this.opened = false;
        }
    }

    public boolean isEmpty() {
        return this.buttons.size() == 0;
    }

    public void movePosition(int ammount) {
        this.selectedButton += ammount;
        if (this.selectedButton > this.buttons.size() - 1) {
            this.selectedButton = 0;
        } else if (this.selectedButton < 0) {
            this.selectedButton = this.buttons.size() - 1;
        }
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void toggleOpen() {
        this.opened = !this.opened;
    }

    public void add(Button button) {
        this.buttons.add(0, button);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public List getButtons() {
        return this.buttons;
    }
}

