/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.ui.window.elements;

import java.text.DecimalFormat;
import net.halalaboos.client.base.Value;
import net.halalaboos.client.ui.window.WElement;
import net.halalaboos.client.ui.window.Window;
import net.halalaboos.client.ui.window.WindowTheme;
import net.halalaboos.client.utils.Bounds;
import org.lwjgl.input.Mouse;

public class WSlider
extends WElement {
    private int x;
    private int y;
    private int width;
    private float sliderValue;
    private Value mod;
    private boolean dragging;
    private boolean scaleToWindow;
    private DecimalFormat format;

    public WSlider(Value m2, int x2, int y2, int w2) {
        this.mod = m2;
        this.x = x2;
        this.y = y2;
        this.width = w2;
        this.format = new DecimalFormat("#.#");
    }

    @Override
    public int getObjectWidth() {
        return this.getX() + this.width;
    }

    @Override
    public int getObjectHeight() {
        return this.getY() + 13;
    }

    @Override
    public void drawObject(Window p2, WindowTheme theme, boolean isMouseAround) {
        WSlider wSlider = this;
        WSlider wSlider2 = this;
        this.drag(p2, wSlider.cl.getClientUtils().getMouseX(), wSlider2.cl.getClientUtils().getMouseY());
        double renderWidth = this.isScaleToWindow() ? (double)(p2.getWidth() - 2) : (double)this.getWidth();
        theme.renderElement(p2.getX() + this.x, p2.getY() + this.y, renderWidth - 2.0, 11.0, isMouseAround || this.isDragging(), false);
        WSlider wSlider3 = this;
        wSlider3.cl.getFR().drawString(this.getMod().getName(), p2.getX() + this.x + 2, p2.getY() + this.y + 1, isMouseAround || this.isDragging() ? 0xFFFF66 : 0xFFFFFF);
        WSlider wSlider4 = this;
        WSlider wSlider5 = this;
        wSlider4.cl.getFR().drawString(this.format.format(this.getMod().getValue()), (int)((double)p2.getX() + renderWidth - (double)wSlider5.cl.getFR().getStringWidth(this.format.format(this.getMod().getValue())) - 2.0), p2.getY() + this.y + 2, isMouseAround || this.isDragging() ? 0xFFFF66 : 0xFFFFFF);
        theme.renderElement(this.getXFromValue(p2, this.sliderValue) + 1, p2.getY() + this.y + 1, 6.0, 9.0, isMouseAround, true);
    }

    @Override
    public boolean onMouseClicked(Window p2, int mouseX, int mouseY) {
        this.dragging = this.getPointBounds(p2).isPointInside(mouseX, mouseY);
        return this.getObjectBounds(p2).isPointInside(mouseX, mouseY);
    }

    public void drag(Window p2, int mouseX, int mouseY) {
        if (Mouse.isButtonDown((int)0) && this.dragging) {
            double renderWidth = this.isScaleToWindow() ? (double)(p2.getWidth() - 2) : (double)this.getWidth();
            this.sliderValue = (float)(mouseX - (p2.getX() + this.x + 6)) / (float)((double)this.x + (renderWidth - 12.0));
            if (this.sliderValue < 0.0f) {
                this.sliderValue = 0.0f;
            }
            if (this.sliderValue > 1.0f) {
                this.sliderValue = 1.0f;
            }
            this.mod.setValue(this.sliderValue * (this.mod.getMax() - this.mod.getMin()) + this.mod.getMin());
        } else {
            this.sliderValue = (this.mod.getValue() - this.mod.getMin()) / (this.mod.getMax() - this.mod.getMin());
            this.dragging = false;
        }
    }

    @Override
    public Bounds getObjectBounds(Window p2) {
        double renderWidth = this.isScaleToWindow() ? (double)(p2.getWidth() - 2) : (double)this.getWidth();
        return new Bounds(p2.getX() + this.getX(), p2.getY() + this.getY(), renderWidth, 11.0);
    }

    public Bounds getPointBounds(Window p2) {
        return new Bounds(this.getXFromValue(p2, this.sliderValue) + 1, p2.getY() + this.getY(), 7.0, 11.0);
    }

    @Override
    public void keyTyped(Window p2, char charICTOR, int key) {
    }

    public int getXFromValue(Window p2, float sliderValue) {
        double renderWidth = this.isScaleToWindow() ? (double)(p2.getWidth() - 2) : (double)this.getWidth();
        return p2.getX() + this.x + (int)(sliderValue * (float)((double)this.x + (renderWidth - 12.0)));
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x2) {
        this.x = x2;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y2) {
        this.y = y2;
    }

    public float getSliderValue() {
        return this.sliderValue;
    }

    public void setSliderValue(float sliderValue) {
        this.sliderValue = sliderValue;
    }

    public Value getMod() {
        return this.mod;
    }

    public void setMod(Value mod) {
        this.mod = mod;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public boolean isScaleToWindow() {
        return this.scaleToWindow;
    }

    public void setScaleToWindow(boolean scaleToWindow) {
        this.scaleToWindow = scaleToWindow;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public String renderTooltip(Window window, WindowTheme theme) {
        return null;
    }
}

