/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.utils.font;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class CFont {
    private int texID;
    private final int[] xPos;
    private final int[] yPos;
    private final int startChar;
    private final FontMetrics metrics;
    public static ArrayList fontList = new ArrayList();
    public static boolean flag = true;
    private final Minecraft mc = Minecraft.x();

    public void getFont() {
        String[] fontTypes;
        GraphicsEnvironment enviro = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (String fontType : fontTypes = enviro.getAvailableFontFamilyNames()) {
            fontList.add(fontType);
        }
        System.out.println("System Fonts Loaded");
    }

    public CFont(Minecraft mc2, Font font) {
        this(mc2, font, 32, 126);
    }

    public CFont(Minecraft mc2, Font font, int startChar, int endChar) {
        this.startChar = startChar;
        this.xPos = new int[endChar - startChar];
        this.yPos = new int[endChar - startChar];
        BufferedImage img = new BufferedImage(256, 256, 2);
        Graphics g2 = img.getGraphics();
        Graphics2D g1 = (Graphics2D)g2;
        g1.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setFont(font);
        g2.setColor(new Color(255, 255, 255, 0));
        g2.fillRect(0, 0, 256, 256);
        g2.setColor(Color.white);
        this.metrics = g2.getFontMetrics();
        int x2 = 2;
        int y2 = 2;
        for (int i2 = startChar; i2 < endChar; ++i2) {
            g2.drawString("" + (char)i2, x2, y2 + g2.getFontMetrics().getAscent());
            this.xPos[i2 - startChar] = x2;
            this.yPos[i2 - startChar] = y2 - this.metrics.getMaxDescent() + 2;
            if ((x2 += this.metrics.stringWidth("" + (char)i2) + 2) < 250 - this.metrics.getMaxAdvance()) continue;
            x2 = 2;
            y2 += this.metrics.getMaxAscent() + this.metrics.getMaxDescent() + g2.getFont().getSize() / 2;
        }
        try {
            this.texID = mc2.p.a(img);
        }
        catch (NullPointerException e2) {
            e2.printStackTrace();
        }
    }

    public final void drawChar(awx gui, char c2, double x2, double y2) throws ArrayIndexOutOfBoundsException {
        Rectangle2D bounds = this.metrics.getStringBounds(Character.toString(c2), null);
        try {
            gui.b((int)x2, (int)y2, this.xPos[(byte)c2 - this.startChar], this.yPos[(byte)c2 - this.startChar], (int)bounds.getWidth(), (int)bounds.getHeight() + this.metrics.getMaxDescent());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public final void drawString(awx gui, String text, double x2, double y2, Color color, boolean renderColorCode) {
        awv fr2 = this.mc.q;
        x2 *= 2.0;
        y2 = y2 * 2.0 - 6.0;
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glHint((int)3155, (int)4354);
        GL11.glScaled((double)0.5, (double)0.5, (double)0.5);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.texID);
        this.glColor(renderColorCode ? color : color.darker().darker().darker().darker().darker());
        double startX = x2;
        int size = text.length();
        for (int indexInString = 0; indexInString < size; ++indexInString) {
            char character = this.filterChar(text.charAt(indexInString));
            this.drawChar(gui, character, x2, y2);
            x2 += this.metrics.getStringBounds(Character.toString(character), null).getWidth();
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    private final char filterChar(char c2) {
        if (c2 == '\u00e5') {
            c2 = (char)97;
        }
        if (c2 == '\u00e4') {
            c2 = (char)97;
        }
        if (c2 == '\u00f6') {
            c2 = (char)111;
        }
        if (c2 == '\u00f8') {
            c2 = (char)111;
        }
        if (c2 == '\u00d8') {
            c2 = (char)79;
        }
        if (c2 == '\u00d6') {
            c2 = (char)79;
        }
        if (c2 == '\u00c4') {
            c2 = (char)65;
        }
        if (c2 == '\u00c5') {
            c2 = (char)65;
        }
        if (c2 == '~') {
            c2 = (char)45;
        }
        return c2;
    }

    public void glColor(Color color) {
        float red = (float)color.getRed() / 255.0f;
        float green = (float)color.getGreen() / 255.0f;
        float blue = (float)color.getBlue() / 255.0f;
        float alpha = (float)color.getAlpha() / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)alpha);
    }

    public Color getColor(int colorCode) {
        return new Color((float)(colorCode >> 16) / 255.0f, (float)(colorCode >> 8 & 0xFF) / 255.0f, (float)(colorCode & 0xFF) / 255.0f);
    }

    private final Rectangle getBounds(String text) {
        int w2 = 0;
        int h2 = 0;
        int tw2 = 0;
        int size = text.length();
        for (int i2 = 0; i2 < size; ++i2) {
            char c2 = text.charAt(i2);
            if (c2 == '\\') {
                char type;
                try {
                    type = text.charAt(i2 + 1);
                }
                catch (StringIndexOutOfBoundsException e2) {
                    break;
                }
                if (type == 'n') {
                    h2 += this.metrics.getAscent() + 2;
                    if (tw2 > w2) {
                        w2 = tw2;
                    }
                    tw2 = 0;
                }
                ++i2;
                continue;
            }
            tw2 += this.metrics.stringWidth(Character.toString(c2));
        }
        if (tw2 > w2) {
            w2 = tw2;
        }
        return new Rectangle(0, 0, w2, h2 += this.metrics.getAscent());
    }

    public FontMetrics getMetrics() {
        return this.metrics;
    }

    public int getStringHeight(String text) {
        return (int)this.getBounds(text).getHeight() / 2;
    }

    public int getStringWidth(String text) {
        if (text == null) {
            return 0;
        }
        return (int)this.getBounds(text).getWidth() / 2;
    }
}

