/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.utils.font;

import java.awt.Color;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.halalaboos.client.main.Client;
import net.halalaboos.client.utils.font.CFont;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class CFontRenderer {
    public CFont font;
    public CFont boldFont;
    public CFont italicFont;
    public CFont boldItalicFont;
    private Minecraft mc;
    private Random fontRandom = new Random();

    public CFontRenderer(Minecraft mc2, String fontName, int fontSize) {
        this.mc = mc2;
        this.font = new CFont(mc2, new Font(fontName, 0, fontSize));
        this.boldFont = new CFont(mc2, new Font(fontName, 1, fontSize));
        this.italicFont = new CFont(mc2, new Font(fontName, 2, fontSize));
        this.boldItalicFont = new CFont(mc2, new Font(fontName, 3, fontSize));
    }

    public void drawString(String s2, double x2, double y2, int color) {
        this.drawString(s2, x2, y2, color, true);
    }

    public void drawStringWithShadow(String s2, double x2, double y2, int color) {
        this.drawString(s2, x2 + 1.0, y2 + 1.0, color, false);
        this.drawString(s2, x2, y2, color, true);
    }

    private void drawString(String text, double x2, double y2, int color, boolean renderColorCode) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)x2, (double)y2, (double)0.0);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        Color c2 = new Color(red, green, blue);
        if (text.contains("\u00a7")) {
            String[] parts = text.split("\u00a7");
            Color currentColor = c2;
            CFont currentFont = this.font;
            int width = 0;
            boolean randomCase = false;
            boolean bold = false;
            boolean italic = false;
            boolean strikethrough = false;
            boolean underline = false;
            for (int index = 0; index < parts.length; ++index) {
                if (index == 0) {
                    this.font.drawString(this.mc.w, parts[index], width, 0.0, currentColor, renderColorCode);
                    width += this.getStringWidth(parts[index]);
                    continue;
                }
                String words = parts[index].substring(1);
                char type = parts[index].charAt(0);
                int colorIndex = "0123456789abcdefklmnor".indexOf(type);
                if (colorIndex != -1) {
                    if (colorIndex < 16) {
                        int colorcode = this.mc.q.getColorCode()[colorIndex];
                        currentColor = this.font.getColor(colorcode);
                        bold = false;
                        italic = false;
                        randomCase = false;
                        underline = false;
                        strikethrough = false;
                    } else if (colorIndex == 16) {
                        randomCase = true;
                    } else if (colorIndex == 17) {
                        bold = true;
                    } else if (colorIndex == 18) {
                        strikethrough = true;
                    } else if (colorIndex == 19) {
                        underline = true;
                    } else if (colorIndex == 20) {
                        italic = true;
                    } else if (colorIndex == 21) {
                        bold = false;
                        italic = false;
                        randomCase = false;
                        underline = false;
                        strikethrough = false;
                        currentColor = c2;
                    }
                }
                if (bold && italic) {
                    this.boldItalicFont.drawString(this.mc.w, randomCase ? this.toRandom(currentFont, words) : words, width, 0.0, currentColor, renderColorCode);
                    currentFont = this.boldItalicFont;
                } else if (bold) {
                    this.boldFont.drawString(this.mc.w, randomCase ? this.toRandom(currentFont, words) : words, width, 0.0, currentColor, renderColorCode);
                    currentFont = this.boldFont;
                } else if (italic) {
                    this.italicFont.drawString(this.mc.w, randomCase ? this.toRandom(currentFont, words) : words, width, 0.0, currentColor, renderColorCode);
                    currentFont = this.italicFont;
                } else {
                    this.font.drawString(this.mc.w, randomCase ? this.toRandom(currentFont, words) : words, width, 0.0, currentColor, renderColorCode);
                    currentFont = this.font;
                }
                if (strikethrough) {
                    GL11.glDisable((int)3553);
                    Client.getRenderUtils().drawLine(width, currentFont.getStringHeight(words) / 2 + 1, width + currentFont.getStringWidth(words), currentFont.getStringHeight(words) / 2 + 1, 1.5f);
                    GL11.glEnable((int)3553);
                }
                if (underline) {
                    GL11.glDisable((int)3553);
                    Client.getRenderUtils().drawLine(width, currentFont.getStringHeight(words), width + currentFont.getStringWidth(words), currentFont.getStringHeight(words), 1.5f);
                    GL11.glEnable((int)3553);
                }
                width += currentFont.getStringWidth(words);
            }
        } else {
            this.font.drawString(this.mc.w, text, 0.0, 0.0, c2, renderColorCode);
        }
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
    }

    public String toRandom(CFont font, String text) {
        return text;
    }

    public int getStringWidth(String text) {
        if (text.contains("\u00a7")) {
            String[] parts = text.split("\u00a7");
            CFont currentFont = this.font;
            int width = 0;
            boolean randomCase = false;
            boolean bold = false;
            boolean italic = false;
            boolean strikethrough = false;
            boolean underline = false;
            for (int index = 0; index < parts.length; ++index) {
                if (index == 0) {
                    width += this.getStringWidth(parts[index]);
                    continue;
                }
                String words = parts[index].substring(1);
                char type = parts[index].charAt(0);
                int colorIndex = "0123456789abcdefklmnor".indexOf(type);
                if (colorIndex != -1) {
                    if (colorIndex < 16) {
                        bold = false;
                        italic = false;
                        randomCase = false;
                        underline = false;
                        strikethrough = false;
                    } else if (colorIndex == 16) {
                        randomCase = true;
                    } else if (colorIndex == 17) {
                        bold = true;
                    } else if (colorIndex == 18) {
                        strikethrough = true;
                    } else if (colorIndex == 19) {
                        underline = true;
                    } else if (colorIndex == 20) {
                        italic = true;
                    } else if (colorIndex == 21) {
                        bold = false;
                        italic = false;
                        randomCase = false;
                        underline = false;
                        strikethrough = false;
                    }
                }
                currentFont = bold && italic ? this.boldItalicFont : (bold ? this.boldFont : (italic ? this.italicFont : this.font));
                width += currentFont.getStringWidth(words);
            }
            return width;
        }
        return this.font.getStringWidth(text);
    }

    public CFont getFont() {
        return this.font;
    }

    public List wrapWords(String text, double width) {
        ArrayList<String> finalWords = new ArrayList<String>();
        if ((double)this.getStringWidth(text) > width) {
            String[] words = text.split(" ");
            String currentWord = "";
            int stringCount = 0;
            for (String word : words) {
                StringBuilder stringBuilder = new StringBuilder();
                if ((double)this.getStringWidth(stringBuilder.append(currentWord).append(word).append(" ").toString()) < width) {
                    currentWord = currentWord + word + " ";
                    continue;
                }
                finalWords.add(currentWord);
                currentWord = word + " ";
                ++stringCount;
            }
            if (!currentWord.equals("")) {
                if ((double)this.getStringWidth(currentWord) < width) {
                    finalWords.add(currentWord);
                    currentWord = "";
                    ++stringCount;
                } else {
                    List formattedWord = this.formatString(currentWord, width);
                    for (String s2 : formattedWord) {
                        finalWords.add(s2);
                    }
                }
            }
        } else {
            finalWords.add(text);
        }
        return finalWords;
    }

    public List formatString(String s2, double width) {
        ArrayList<String> finalWords = new ArrayList<String>();
        String currentWord = "";
        int charCount = 0;
        for (char c2 : s2.toCharArray()) {
            String character = String.valueOf(c2);
            StringBuilder stringBuilder = new StringBuilder();
            if ((double)this.getStringWidth(stringBuilder.append(currentWord).append(character).toString()) < width) {
                currentWord = currentWord + character;
                continue;
            }
            finalWords.add(currentWord);
            currentWord = character;
            ++charCount;
        }
        if (charCount == 0 && currentWord.length() > 0) {
            finalWords.add(currentWord);
        }
        return finalWords;
    }
}

