/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.mods;

import net.halalaboos.client.base.Binding;
import net.halalaboos.client.event.EventHandler;
import net.halalaboos.client.event.events.EventKeyPressed;
import net.halalaboos.client.main.Client;
import net.halalaboos.client.ui.window.WindowCategory;
import net.minecraft.client.Minecraft;

public abstract class Mod {
    private boolean renderIngame;
    private boolean state = false;
    private String name;
    private String description = null;
    public EventHandler eventHandler = Client.getWrapper().getEH();
    private Binding keyBind;
    public Minecraft mc = Client.getWrapper().getMC();
    public WindowCategory category;
    public Type type;

    public Mod() {
        this("", -1, false);
    }

    public Mod(String name, int keyCode) {
        this(name, keyCode, true);
    }

    public Mod(String name, int keyCode, boolean renderIngame) {
        this.name = name;
        this.keyBind = new ModBind(keyCode, this);
        this.renderIngame = renderIngame;
        this.eventHandler.registerListener(EventKeyPressed.class, this.keyBind);
    }

    public abstract void onToggle();

    public abstract void onEnable();

    public abstract void onDisable();

    public void toggle() {
        this.setState(!this.isState());
        this.onToggle();
    }

    public boolean isRenderIngame() {
        return this.renderIngame;
    }

    public void setRenderIngame(boolean renderIngame) {
        this.renderIngame = renderIngame;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isState() {
        return this.state;
    }

    public void setState(boolean state) {
        this.state = state;
        if (state) {
            this.onEnable();
        } else {
            this.onDisable();
        }
    }

    public String getKeyName() {
        return this.getKeyBind().getKeyName();
    }

    public Binding getKeyBind() {
        return this.keyBind;
    }

    public void setKey(int keyCode) {
        this.keyBind.setKeyCode(keyCode);
    }

    public WindowCategory getCategory() {
        return this.category;
    }

    public void setCategory(WindowCategory category) {
        this.category = category;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public class ModBind
    extends Binding {
        private Mod mod;

        public ModBind(int keyCode, Mod mod2) {
            super(mod2.getName(), keyCode);
            this.mod = mod2;
        }

        @Override
        public void onPressed() {
            this.mod.toggle();
        }
    }

    public static enum Type {
        PVP(0x992222),
        PLAYER(0x3399FF),
        WORLD(0xFFFF99),
        RENDER(0xFF6600),
        MOVEMENT(39219),
        MINING(0xCC0033),
        FLUID(26265);

        private int color;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Type() {
            void color;
            this.color = color;
        }

        public int getColor() {
            return this.color;
        }
    }
}

