/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.ui.tabbed;

import java.util.ArrayList;
import java.util.List;
import net.halalaboos.client.base.Binding;
import net.halalaboos.client.event.events.EventKeyPressed;
import net.halalaboos.client.main.Client;
import net.halalaboos.client.manager.GuiManager;
import net.halalaboos.client.manager.ModManager;
import net.halalaboos.client.mods.Mod;
import net.halalaboos.client.ui.Gui;
import net.halalaboos.client.ui.tabbed.components.Button;
import net.halalaboos.client.ui.tabbed.components.Tab;
import net.halalaboos.client.ui.window.WindowCategory;
import net.minecraft.client.Minecraft;

public class TabbedController
extends Gui {
    private List tabs = new ArrayList();
    private Input up = new Input("UP", 200);
    private Input down = new Input("DOWN", 208);
    private Input right;
    private Input left = new Input("LEFT", 203);
    private Input enter;
    private Tab selectedTab = null;
    private int maxWidth;

    public TabbedController() {
        this.right = new Input("RIGHT", 205);
        this.enter = new Input("ENTER", 28);
    }

    public void initialize() {
        for (WindowCategory category : WindowCategory.values()) {
            Tab tab = new Tab(category.getName());
            if (this.selectedTab == null) {
                this.selectedTab = tab;
            }
            for (Mod mod : ModManager.getMods()) {
                if (!mod.isRenderIngame() || mod.category != category) continue;
                tab.add(new Button(mod));
            }
            if (tab.isEmpty()) continue;
            this.tabs.add(tab);
        }
        int maxWidth = 0;
        for (Tab tab : this.tabs) {
            if (Client.getFR().getStringWidth(tab.getTitle()) <= maxWidth) continue;
            maxWidth = Client.getFR().getStringWidth(tab.getTitle()) * 4;
        }
        this.maxWidth = maxWidth;
    }

    @Override
    public void render(int screenWidth, int screenHeight) {
        int startY = 12;
        int startX = 2;
        int width = this.maxWidth;
        Client.getRenderUtils().drawHalRect(startX + 2, startY + 2, startX + width - 2, startY + 13, false, true);
        Client.getFR().drawStringWithShadow("Tab GUI", startX + 4, startY + 3, 0xFFFFFF);
        startY += 10;
        for (Tab tab : this.tabs) {
            int index = this.tabs.indexOf(tab);
            tab.render(this.selectedTab == tab, startX + 2, startY + index * 12 + 3, width - 4);
        }
    }

    private void recieveUserInput(Input keyBind) {
        if (this.selectedTab != null) {
            if (this.selectedTab.isOpened()) {
                this.selectedTab.recieveInput(keyBind.getName());
                return;
            }
            if (keyBind == this.up) {
                this.movePosition(-1);
            } else if (keyBind == this.down) {
                this.movePosition(1);
            } else if (keyBind == this.right || keyBind == this.left) {
                this.selectedTab.toggleOpen();
            }
        }
    }

    public void movePosition(int ammount) {
        int index = this.tabs.indexOf(this.selectedTab) + ammount;
        if (index > this.tabs.size() - 1) {
            index = 0;
        } else if (index < 0) {
            index = this.tabs.size() - 1;
        }
        this.selectedTab = (Tab)this.tabs.get(index);
    }

    private class Input
    extends Binding {
        public Input(String name, int keyCode) {
            super(name, keyCode);
            Minecraft minecraft = this.mc;
            minecraft.theClient.getEventHandler().registerListener(EventKeyPressed.class, this);
        }

        @Override
        public void onPressed() {
            if (GuiManager.getGuiStyle() == GuiManager.Type.TABBED) {
                TabbedController.this.recieveUserInput(this);
            }
        }
    }
}

