/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.ui.window;

import java.awt.Color;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.halalaboos.client.main.Client;
import net.halalaboos.client.manager.ModManager;
import net.halalaboos.client.mods.Mod;
import net.halalaboos.client.ui.window.WElement;
import net.halalaboos.client.ui.window.Window;
import net.halalaboos.client.ui.window.elements.WButton;

public class WManager {
    private List windows = new CopyOnWriteArrayList();
    private List renderList = new CopyOnWriteArrayList();
    private Color primaryColor = new Color(0.1f, 0.1f, 0.1f);

    public void onMouseClicked(int mouseX, int mouseY) {
        try {
            for (Window p2 : this.renderList) {
                if (!p2.clickPanel(mouseX, mouseY)) continue;
                this.pushToTop(p2);
                break;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void renderWindows(int mouseX, int mouseY) {
        try {
            for (int x2 = this.renderList.size() - 1; x2 >= 0; --x2) {
                Window p2 = (Window)this.renderList.get(x2);
                p2.drawPanel(mouseX, mouseY);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void renderWindowsIngame(int mouseX, int mouseY) {
        try {
            for (int x2 = this.renderList.size() - 1; x2 >= 0; --x2) {
                Window p2 = (Window)this.renderList.get(x2);
                if (!p2.isPinned()) continue;
                p2.drawPanel(mouseX, mouseY);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void onKeyTyped(char par1, int par2) {
        try {
            for (Window p2 : this.renderList) {
                if (!this.isTopWindow(p2)) continue;
                p2.keyTyped(par1, par2);
                break;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void updateWindows() {
        for (Window p2 : this.getWindows()) {
            p2.updatePanel();
            block1: for (WElement o2 : p2.objects) {
                if (!(o2 instanceof WButton)) continue;
                WButton b2 = (WButton)o2;
                for (Mod m2 : ModManager.getMods()) {
                    if (!b2.getText().equalsIgnoreCase(m2.getName())) continue;
                    b2.setEnabled(m2.isState());
                    continue block1;
                }
            }
        }
    }

    public void pushToTop(Window p2) {
        this.renderList.remove(p2);
        this.renderList.add(0, p2);
    }

    public boolean isTopWindow(Window p2) {
        return this.renderList.get(0) == p2;
    }

    public boolean isWindowOverObject(Window currentPanel, WElement object) {
        int mouseX = Client.getClientUtils().getMouseX();
        int mouseY = Client.getClientUtils().getMouseY();
        for (Window p2 : this.renderList) {
            if (p2 == currentPanel || !p2.getTop().isPointInside(mouseX, mouseY) && (!p2.getBody().isPointInside(mouseX, mouseY) || !p2.shouldRenderBody()) || this.renderList.indexOf(p2) >= this.renderList.indexOf(currentPanel)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindowAbove(Window currentPanel) {
        for (Window p1 : this.renderList) {
            if (!this.isWindowAbove(currentPanel, p1)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindowAbove(Window currentPanel, int mouseX, int mouseY) {
        for (Window p1 : this.renderList) {
            if ((!p1.getBody().isPointInside(mouseX, mouseY) || !p1.shouldRenderBody()) && !p1.getTop().isPointInside(mouseX, mouseY) || this.renderList.indexOf(p1) >= this.renderList.indexOf(currentPanel)) continue;
            return true;
        }
        return false;
    }

    public boolean isWindowAbove(Window currentPanel, Window p2) {
        return (p2.shouldRenderBody() && currentPanel.shouldRenderBody() && currentPanel.getBody().compare(p2.getBody()) || currentPanel.getTop().compare(p2.getTop())) && this.renderList.indexOf(p2) < this.renderList.indexOf(currentPanel);
    }

    public void add(Window p2) {
        this.windows.add(p2);
        this.renderList.add(p2);
    }

    public void clear() {
        this.windows.clear();
        this.renderList.clear();
    }

    public Window getWindow(String name) {
        for (Window p2 : this.getWindows()) {
            if (!p2.getName().equalsIgnoreCase(name)) continue;
            return p2;
        }
        return null;
    }

    public List getWindows() {
        return this.windows;
    }

    public void setWindows(List panels) {
        this.windows = panels;
    }

    public Color getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(Color primaryColor) {
        this.primaryColor = primaryColor;
    }
}

