/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.ui.window;

import java.awt.Color;
import java.util.ArrayList;
import net.halalaboos.client.main.Client;
import net.halalaboos.client.manager.ModManager;
import net.halalaboos.client.ui.window.WElement;
import net.halalaboos.client.ui.window.WManager;
import net.halalaboos.client.ui.window.WindowTheme;
import net.halalaboos.client.ui.window.elements.WButton;
import net.halalaboos.client.ui.window.theme.Default;
import net.halalaboos.client.utils.Bounds;
import net.halalaboos.client.utils.Counter;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;

public class Window {
    public Minecraft mc = Client.getWrapper().getMC();
    public Client cl = Client.getWrapper().getCL();
    public ArrayList objects = new ArrayList();
    private String name;
    private int x;
    private int y;
    private int width;
    private int height;
    private int mXOff;
    private int mYOff;
    private int xOffset;
    private int yOffset;
    private int widthOffset;
    private int heightOffset;
    private int lastMouseY;
    private int lastMouseX;
    private boolean dragging;
    private boolean resizing;
    private boolean allowResizing;
    private boolean allowClosing;
    private boolean closed;
    private boolean keepPanelFormatted;
    private boolean pinned = false;
    private boolean pinnable;
    private WElement mousedObject = null;
    private WManager manager;
    private WindowTheme wTheme;
    private Counter tooltipCounter = new Counter(750L, 0);

    public Window(String n2, int x2, int y2, int width, int height, WManager manager) {
        this.name = n2;
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
        this.manager = manager;
        this.wTheme = new Default();
        this.init();
        this.formatPanel();
        this.setResizable(false);
        this.setClosable(true);
    }

    public void init() {
    }

    public void drawPanel(int mouseX, int mouseY) {
        Window window = this;
        if (this.width < window.cl.getFR().getStringWidth(this.name) + 16) {
            Window window2 = this;
            this.width = window2.cl.getFR().getStringWidth(this.name) + 16;
        }
        this.dragPanel(mouseX, mouseY);
        if (this.isResizable()) {
            this.resizePanel(mouseX, mouseY);
        }
        Color c2 = this.getManager().getPrimaryColor();
        this.wTheme.renderPanel(this.x, this.y, this.width, 13.0);
        Window window3 = this;
        window3.cl.getFR().drawStringWithShadow("\u00a7l" + this.getName(), this.x + 2, this.y + 2, 0xFFFFFF);
        if (this.shouldRenderBody()) {
            this.wTheme.renderPanel(this.x, this.y + 12, this.width, this.height - 12);
            this.drawPanelObjects(mouseX, mouseY);
        }
        Bounds resizer = this.getResizer();
        Bounds closeButton = this.getCloseButton();
        Bounds pinButton = this.getPinButton();
        if (this.isResizable() && this.shouldRenderBody() && (this.getBody().isPointInside(mouseX, mouseY) || this.getResizer().isPointInside(mouseX, mouseY) || this.resizing)) {
            this.wTheme.renderElement(resizer.getX(), resizer.getY(), resizer.getWidth(), resizer.getHeight(), resizer.isPointInside(mouseX, mouseY), resizer.isPointInside(mouseX, mouseY) && Mouse.isButtonDown((int)0));
        }
        if (this.isClosable()) {
            this.wTheme.renderElement(closeButton.getX(), closeButton.getY(), closeButton.getWidth(), closeButton.getHeight(), closeButton.isPointInside(mouseX, mouseY), !this.isClosed());
        }
        if (this.isPinnable()) {
            this.wTheme.renderElement(pinButton.getX(), pinButton.getY(), pinButton.getWidth(), pinButton.getHeight(), pinButton.isPointInside(mouseX, mouseY), this.isPinned());
        }
    }

    public boolean shouldRenderBody() {
        if (this.isClosable()) {
            return !this.isClosed();
        }
        return true;
    }

    public boolean clickPanel(int mouseX, int mouseY) {
        if (this.isClosable() && this.getCloseButton().isPointInside(mouseX, mouseY)) {
            this.setClosed(!this.isClosed());
            return true;
        }
        if (this.isPinnable() && this.getPinButton().isPointInside(mouseX, mouseY)) {
            this.setPinned(!this.isPinned());
            return true;
        }
        if (this.shouldRenderBody()) {
            for (int o2 = this.objects.size() - 1; o2 >= 0; --o2) {
                WElement element = (WElement)this.objects.get(o2);
                if (!element.onMouseClicked(this, mouseX, mouseY)) continue;
                this.getManager().updateWindows();
                return true;
            }
        }
        if (this.getResizer().isPointInside(mouseX, mouseY) && this.isResizable() && this.shouldRenderBody()) {
            this.mXOff = mouseX;
            this.mYOff = mouseY;
            this.widthOffset = this.width;
            this.heightOffset = this.height;
            this.resizing = true;
            return true;
        }
        this.resizing = false;
        if (this.getTop().isPointInside(mouseX, mouseY) || this.getBody().isPointInside(mouseX, mouseY) && this.shouldRenderBody()) {
            this.mXOff = mouseX;
            this.mYOff = mouseY;
            this.xOffset = this.x;
            this.yOffset = this.y;
            this.dragging = true;
            return true;
        }
        this.dragging = false;
        return false;
    }

    public void onObjectClicked(WElement o2) {
        if (o2 instanceof WButton) {
            WButton b2 = (WButton)o2;
            if (ModManager.getMod(b2.getText()) != null) {
                ModManager.getMod(b2.getText()).toggle();
            } else {
                this.mc.B.a("random.click", 1.0f, 1.0f);
            }
        }
        if (this.isKeepPanelFormatted()) {
            this.formatPanel();
        }
    }

    public void onObjectTyped(WElement o2) {
    }

    public void keyTyped(char par1, int par2) {
        for (WElement o2 : this.objects) {
            o2.keyTyped(this, par1, par2);
        }
    }

    private void dragPanel(int mouseX, int mouseY) {
        if (this.dragging && Mouse.isButtonDown((int)0)) {
            this.x = mouseX - (this.mXOff - this.xOffset);
            this.y = mouseY - (this.mYOff - this.yOffset);
        } else {
            this.dragging = false;
        }
    }

    private void resizePanel(int mouseX, int mouseY) {
        if (this.resizing && Mouse.isButtonDown((int)0)) {
            this.width = mouseX - (this.mXOff - this.widthOffset);
            this.height = mouseY - (this.mYOff - this.heightOffset);
            this.keepPanelSafe();
        } else {
            this.resizing = false;
        }
    }

    public Bounds getBody() {
        return new Bounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public Bounds getTop() {
        return new Bounds(this.getX(), this.getY(), this.getWidth(), 13.0);
    }

    public Bounds getResizer() {
        double offset = 3.0;
        return new Bounds((double)(this.getX() + this.getWidth()) - offset, (double)(this.getY() + this.getHeight()) - offset, offset * 2.0, offset * 2.0);
    }

    public Bounds getCloseButton() {
        return new Bounds(this.getX() + this.getWidth() - 11, this.getY() + 2, 9.0, 9.0);
    }

    public Bounds getPinButton() {
        return new Bounds(this.getX() + this.getWidth() - 20, this.getY() + 2, 8.0, 8.0);
    }

    public void add(WElement object) {
        this.objects.add(object);
        object.setWindow(this);
        if (object.getObjectWidth() > this.width) {
            this.width = object.getObjectWidth();
        }
        if (object.getObjectHeight() > this.height) {
            this.height = object.getObjectHeight();
        }
    }

    public boolean mouseOverBody(int mouseX, int mouseY) {
        return this.getBody().isPointInside(mouseX, mouseY) && this.shouldRenderBody();
    }

    public void drawPanelObjects(int mouseX, int mouseY) {
        String text;
        if (this.mousedObject != null && !this.mousedObject.getObjectBounds(this).isPointInside(mouseX, mouseY)) {
            this.mousedObject = null;
            this.tooltipCounter.reset();
        }
        for (WElement o2 : this.objects) {
            if (o2.getObjectBounds(this).isPointInside(mouseX, mouseY) && this.mousedObject == null && !this.getManager().isWindowOverObject(this, o2) && !this.isObjectOverObject(o2, mouseX, mouseY)) {
                this.mousedObject = o2;
            }
            o2.drawObject(this, this.wTheme, this.mousedObject == o2);
        }
        if (this.mousedObject != null && (text = this.mousedObject.renderTooltip(this, this.getTheme())) != null) {
            this.tooltipCounter.count();
            if (this.tooltipCounter.getCount() > 1) {
                Minecraft minecraft = this.mc;
                this.getTheme().renderElement(mouseX + 2, mouseY + 6, minecraft.theClient.getFR().getStringWidth(text) + 4, 12.0, false, true);
                Window window = this;
                window.cl.getFR().drawStringWithShadow(text, mouseX + 4, mouseY + 8, 0xFFFFFF);
            }
        }
    }

    public boolean isObjectOverObject(WElement currentObject, int mouseX, int mouseY) {
        for (WElement o2 : this.objects) {
            if (!currentObject.getObjectBounds(this).isPointInside(mouseX, mouseY) || !o2.getObjectBounds(this).isPointInside(mouseX, mouseY) || this.objects.indexOf(o2) <= this.objects.indexOf(currentObject)) continue;
            return true;
        }
        return false;
    }

    public void keepPanelSafe() {
        Window window = this;
        if (this.width < window.cl.getFR().getStringWidth(this.name) + 16) {
            Window window2 = this;
            this.width = window2.cl.getFR().getStringWidth(this.name) + 16;
        }
        for (WElement o2 : this.objects) {
            if (o2.getObjectWidth() > this.width) {
                this.width = o2.getObjectWidth();
            }
            if (o2.getObjectHeight() <= this.height) continue;
            this.height = o2.getObjectHeight();
        }
    }

    public void formatPanel() {
        this.setWidth(0);
        this.setHeight(16);
        this.keepPanelSafe();
    }

    public void updatePanel() {
    }

    public boolean isResizable() {
        return this.allowResizing;
    }

    public void setResizable(boolean shouldAllowResizing) {
        this.allowResizing = shouldAllowResizing;
    }

    public boolean isClosable() {
        return this.allowClosing;
    }

    public void setClosable(boolean allowClosing) {
        this.allowClosing = allowClosing;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x2) {
        this.x = x2;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y2) {
        this.y = y2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WManager getManager() {
        return this.manager;
    }

    public void setManager(WManager manager) {
        this.manager = manager;
    }

    public boolean isKeepPanelFormatted() {
        return this.keepPanelFormatted;
    }

    public void setKeepPanelFormatted(boolean keepPanelFormatted) {
        this.keepPanelFormatted = keepPanelFormatted;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public boolean isPinnable() {
        return this.pinnable;
    }

    public void setPinnable(boolean pinnable) {
        this.pinnable = pinnable;
    }

    public WindowTheme getTheme() {
        return this.wTheme;
    }

    public void setTheme(WindowTheme wTheme) {
        this.wTheme = wTheme;
    }

    private boolean hasMouseMoved(int mouseX, int mouseY) {
        boolean moved;
        boolean bl2 = moved = mouseX - this.lastMouseX != 0 || mouseY - this.lastMouseY != 0;
        if (moved) {
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
        }
        return moved;
    }
}

