/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.ui.window.elements;

import net.halalaboos.client.manager.ModManager;
import net.halalaboos.client.mods.Mod;
import net.halalaboos.client.ui.window.WElement;
import net.halalaboos.client.ui.window.Window;
import net.halalaboos.client.ui.window.WindowTheme;
import net.halalaboos.client.utils.Bounds;

public class WButton
extends WElement {
    private int x;
    private int y;
    private String text;
    private String description = null;
    private boolean enabled;
    private Mod mod = null;

    public WButton(Mod m2, int x2, int y2) {
        this(m2.getName(), m2.getDescription(), x2, y2);
        this.mod = m2;
    }

    public WButton(String text, String description, int x2, int y2) {
        this.text = text;
        this.description = description;
        this.x = x2;
        this.y = y2;
        this.mod = ModManager.getMod(text);
    }

    @Override
    public int getObjectWidth() {
        WButton wButton = this;
        return this.getX() + wButton.cl.getFR().getStringWidth(this.text) + 20;
    }

    @Override
    public int getObjectHeight() {
        return this.getY() + 13;
    }

    @Override
    public void drawObject(Window p2, WindowTheme theme, boolean isMouseAround) {
        theme.renderElement(this.getObjectBounds(p2).getX(), this.getObjectBounds(p2).getY(), this.getObjectBounds(p2).getWidth(), this.getObjectBounds(p2).getHeight(), isMouseAround, this.enabled);
        WButton wButton = this;
        WButton wButton2 = this;
        wButton.cl.getFR().drawString(this.text, p2.getX() + this.getX() + (this.getWindow().getWidth() / 2 - 2 - wButton2.cl.getFR().getStringWidth(this.text) / 2), p2.getY() + this.getY() + 1, this.enabled ? 0xEEEEEE : 0xAAAAAA);
    }

    @Override
    public boolean onMouseClicked(Window p2, int mouseX, int mouseY) {
        if (this.getObjectBounds(p2).isPointInside(mouseX, mouseY)) {
            p2.onObjectClicked(this);
            return true;
        }
        return false;
    }

    @Override
    public Bounds getObjectBounds(Window p2) {
        return new Bounds(p2.getX() + this.getX(), p2.getY() + this.getY(), this.getWindow().getWidth() - 4, 11.0);
    }

    @Override
    public void keyTyped(Window p2, char charICTOR, int key) {
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x2) {
        this.x = x2;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y2) {
        this.y = y2;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public String renderTooltip(Window window, WindowTheme theme) {
        return this.description;
    }
}

