/*
 * Decompiled with CFR 0.152.
 */
package net.halalaboos.client.ui.window.elements;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.halalaboos.client.ui.window.WElement;
import net.halalaboos.client.ui.window.Window;
import net.halalaboos.client.ui.window.WindowTheme;
import net.halalaboos.client.utils.Bounds;
import net.minecraft.client.Minecraft;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class WTextArea
extends WElement {
    private int x;
    private int y;
    private int width;
    private int height;
    private int stringColor = 0xFFFFFF;
    private int begindexWithinList = 0;
    private int maxLines = -1;
    private boolean scrolling;
    private boolean autoScroll = true;
    private boolean scaleHeightToWindow;
    private boolean scaleWidthToWindow;
    private boolean renderBackground = true;
    private CopyOnWriteArrayList strings = new CopyOnWriteArrayList();

    public WTextArea(int x2, int y2, int width, int height) {
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getObjectWidth() {
        return this.x + this.width + 2;
    }

    @Override
    public int getObjectHeight() {
        return this.y + this.height + 2;
    }

    @Override
    public void drawObject(Window w2, WindowTheme wTheme, boolean isMouseAround) {
        List list = this.formattedStrings(w2, this.getStrings());
        this.scroll(w2, list);
        this.adjustPosition(w2, isMouseAround, list);
        this.keepTextRendered(list);
        double x2 = this.getObjectBounds(w2).getX();
        double y2 = this.getObjectBounds(w2).getY();
        double y1 = this.getObjectBounds(w2).getY() + this.getObjectBounds(w2).getHeight();
        double x1 = this.getObjectBounds(w2).getX() + this.getObjectBounds(w2).getWidth();
        GL11.glPushMatrix();
        if (this.isRenderBackground()) {
            wTheme.renderElement(x2, y2, x1 - x2, y1 - y2, false, false);
        }
        Minecraft minecraft = this.mc;
        minecraft.theClient.getRenderUtils().prepareScissorBox((float)x2 + 1.0f, (float)y2 + 1.0f, (float)x1 - 1.0f, (float)y1 - 1.0f);
        GL11.glEnable((int)3089);
        int yindex = 0;
        for (int index = this.getBegindexWithinList(); index <= this.getBegindexWithinList() + this.getMaxRenderableLines() && index < list.size(); ++index) {
            Minecraft minecraft2 = this.mc;
            minecraft2.theClient.getFR().drawStringWithShadow((String)list.get(index), x2 + 2.0, y2 + (double)yindex + 1.0, this.getStringColor());
            Minecraft minecraft3 = this.mc;
            yindex += minecraft3.theClient.getFR().getFont().getStringHeight((String)list.get(index));
        }
        Bounds b2 = this.getSliderBounds(w2, list);
        wTheme.renderElement(b2.getX(), b2.getY(), b2.getWidth(), b2.getHeight(), isMouseAround, false);
        GL11.glDisable((int)3089);
        GL11.glPopMatrix();
    }

    public void adjustPosition(Window p2, boolean isMouseAround, List stwings) {
        if (isMouseAround && !Mouse.isButtonDown((int)0) && Mouse.hasWheel() && this.mc.s != null && Mouse.next()) {
            int l2 = Mouse.getEventDWheel();
            if (l2 > 0) {
                l2 = -1;
            } else if (l2 < 0) {
                l2 = 1;
            }
            this.setBegindexWithinList(this.getBegindexWithinList() + l2, stwings);
        }
    }

    public void scroll(Window p2, List list) {
        if (this.scrolling && Mouse.isButtonDown((int)0)) {
            Minecraft minecraft = this.mc;
            double percent = ((double)minecraft.theClient.getClientUtils().getMouseY() - this.getObjectBounds(p2).getY()) / this.getObjectBounds(p2).getHeight();
            this.setBegindexWithinList((int)(percent * (double)(list.size() - 1)), list);
        } else {
            this.scrolling = false;
        }
    }

    @Override
    public boolean onMouseClicked(Window p2, int mouseX, int mouseY) {
        if (this.getSliderBounds(p2).isPointInside(mouseX, mouseY)) {
            this.scrolling = true;
            return true;
        }
        this.scrolling = false;
        if (this.getObjectBounds(p2).isPointInside(mouseX, mouseY)) {
            p2.onObjectClicked(this);
            return true;
        }
        return false;
    }

    @Override
    public void keyTyped(Window p2, char charICTOR, int key) {
    }

    @Override
    public Bounds getObjectBounds(Window p2) {
        return new Bounds(p2.getX() + this.getX(), p2.getY() + this.getY(), this.isScaleWidthToWindow() ? (double)(p2.getWidth() - 4) : (double)this.getWidth(), this.isScaleHeightToWindow() ? (double)(p2.getHeight() - this.getY() - 2) : (double)this.getHeight());
    }

    public int getSliderY(Window p2, List list) {
        double percent = (double)this.getBegindexWithinList() / (double)(list.size() - this.getMaxRenderableLines());
        Minecraft minecraft = this.mc;
        return (int)(percent * (this.getObjectBounds(p2).getHeight() - (double)minecraft.theClient.getFR().getFont().getStringHeight("|")));
    }

    public Bounds getSliderBounds(Window p2) {
        List list = this.formattedStrings(p2, this.strings);
        return this.getSliderBounds(p2, list);
    }

    public Bounds getSliderBounds(Window p2, List list) {
        Bounds box = this.getObjectBounds(p2);
        return new Bounds(box.getX() + box.getWidth() - 7.0, box.getY() + (double)this.getSliderY(p2, list) + 2.0, 5.0, 8.0);
    }

    public List formattedStrings(Window p2, CopyOnWriteArrayList strings) {
        ArrayList<String> l2 = new ArrayList<String>();
        for (String s2 : strings) {
            Minecraft minecraft = this.mc;
            List goml = minecraft.theClient.getFR().wrapWords(s2, this.getObjectBounds(p2).getWidth());
            for (String s1 : goml) {
                l2.add(s1);
            }
        }
        return l2;
    }

    public void append(String args) {
        boolean as2 = false;
        if (this.isAutoScroll() && this.getBegindexWithinList() == this.getMaxIndex()) {
            as2 = true;
        }
        if (this.getStrings().size() > this.getMaxLines() && this.getMaxLines() != -1) {
            this.getStrings().remove(0);
        }
        this.getStrings().add(args);
        if (as2) {
            this.setBegindexWithinList(this.getMaxIndex());
        }
    }

    public int getMaxRenderableLines() {
        Minecraft minecraft = this.mc;
        return (int)(this.getObjectBounds(this.getWindow()).getHeight() / (double)minecraft.theClient.getFR().getFont().getStringHeight("|"));
    }

    public int getMaxIndex() {
        return this.formattedStrings(this.getWindow(), this.strings).size() - this.getMaxRenderableLines();
    }

    public int getMaxIndex(List l2) {
        return l2.size() - this.getMaxRenderableLines();
    }

    public void trimList() {
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x2) {
        this.x = x2;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y2) {
        this.y = y2;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getStringColor() {
        return this.stringColor;
    }

    public void setStringColor(int stringColor) {
        this.stringColor = stringColor;
    }

    public int getBegindexWithinList() {
        return this.begindexWithinList;
    }

    public void setBegindexWithinList(int begindexWithinList) {
        List list = this.formattedStrings(this.getWindow(), this.strings);
        this.setBegindexWithinList(begindexWithinList, list);
    }

    public void setBegindexWithinList(int begindexWithinList, List list) {
        this.begindexWithinList = begindexWithinList;
        if (!this.keepTextRendered(list)) {
            return;
        }
    }

    public boolean keepTextRendered(List list) {
        if (this.begindexWithinList < 0) {
            this.begindexWithinList = 0;
        }
        if (list.size() - this.getMaxRenderableLines() > 0) {
            if (this.begindexWithinList > list.size() - this.getMaxRenderableLines()) {
                this.begindexWithinList = list.size() - this.getMaxRenderableLines();
            }
            return true;
        }
        this.begindexWithinList = 0;
        return false;
    }

    public void clearLines() {
        this.strings.clear();
    }

    public CopyOnWriteArrayList getStrings() {
        return this.strings;
    }

    public void setStrings(CopyOnWriteArrayList strings) {
        this.strings = strings;
    }

    public boolean isScrolling() {
        return this.scrolling;
    }

    public void setScrolling(boolean scrolling) {
        this.scrolling = scrolling;
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    public boolean isScaleHeightToWindow() {
        return this.scaleHeightToWindow;
    }

    public void setScaleHeightToWindow(boolean scaleHeightToWindow) {
        this.scaleHeightToWindow = scaleHeightToWindow;
    }

    public boolean isScaleWidthToWindow() {
        return this.scaleWidthToWindow;
    }

    public void setScaleWidthToWindow(boolean scaleWidthToWindow) {
        this.scaleWidthToWindow = scaleWidthToWindow;
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = maxLines;
    }

    public boolean isRenderBackground() {
        return this.renderBackground;
    }

    public void setRenderBackground(boolean renderBackground) {
        this.renderBackground = renderBackground;
    }

    @Override
    public String renderTooltip(Window window, WindowTheme theme) {
        return null;
    }
}

