/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.ConcurrentModificationException;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiButtonLanguage;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiLanguage;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiOptions;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSelectWorld;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.realms.RealmsBridge;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.demo.DemoWorldServer;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.WorldInfo;
import org.apache.commons.io.Charsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.util.glu.Project;
import tk.wurst_client.WurstClient;
import tk.wurst_client.utils.MiscUtils;

public class GuiMainMenu
extends GuiScreen
implements GuiYesNoCallback {
    private static final AtomicInteger field_175373_f = new AtomicInteger(0);
    private static final Logger logger = LogManager.getLogger();
    private static final Random field_175374_h = new Random();
    private float updateCounter;
    public static String splashText;
    private GuiButton buttonResetDemo;
    private int panoramaTimer;
    private DynamicTexture viewportTexture;
    private boolean field_175375_v;
    private final Object field_104025_t;
    private String field_92025_p;
    private String field_146972_A;
    private String field_104024_v;
    private static final ResourceLocation splashTexts;
    private static final ResourceLocation minecraftTitleTextures;
    private ArrayList<String> newsItems;
    private static final ResourceLocation[] titlePanoramaPaths;
    public static final String field_96138_a;
    private int field_92024_r;
    private int field_92023_s;
    private int field_92022_t;
    private int field_92021_u;
    private int field_92020_v;
    private int field_92019_w;
    private ResourceLocation field_110351_G;
    private GuiButton field_175372_K;
    private static final String __OBFID = "CL_00001154";

    static {
        splashTexts = new ResourceLocation("texts/splashes.txt");
        minecraftTitleTextures = new ResourceLocation("wurst/wurst_380.png");
        titlePanoramaPaths = new ResourceLocation[]{new ResourceLocation("textures/gui/title/background/panorama_0.png"), new ResourceLocation("textures/gui/title/background/panorama_1.png"), new ResourceLocation("textures/gui/title/background/panorama_2.png"), new ResourceLocation("textures/gui/title/background/panorama_3.png"), new ResourceLocation("textures/gui/title/background/panorama_4.png"), new ResourceLocation("textures/gui/title/background/panorama_5.png")};
        field_96138_a = "Please click " + (Object)((Object)EnumChatFormatting.UNDERLINE) + "here" + (Object)((Object)EnumChatFormatting.RESET) + " for more information.";
    }

    public GuiMainMenu() {
        block18: {
            this.field_175375_v = true;
            this.field_104025_t = new Object();
            this.newsItems = new ArrayList();
            this.field_146972_A = field_96138_a;
            splashText = "missingno";
            BufferedReader var1 = null;
            try {
                try {
                    String var3;
                    ArrayList var2 = Lists.newArrayList();
                    var1 = new BufferedReader(new InputStreamReader(Minecraft.getMinecraft().getResourceManager().getResource(splashTexts).getInputStream(), Charsets.UTF_8));
                    while ((var3 = var1.readLine()) != null) {
                        if ((var3 = var3.trim()).isEmpty()) continue;
                        var2.add(var3);
                    }
                    if (!var2.isEmpty()) {
                        while ((splashText = (String)var2.get(field_175374_h.nextInt(var2.size()))).hashCode() == 125780783) {
                        }
                    }
                }
                catch (IOException iOException) {
                    if (var1 != null) {
                        try {
                            var1.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (var1 != null) {
                    try {
                        var1.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (var1 != null) {
                try {
                    var1.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        this.updateCounter = field_175374_h.nextFloat();
        this.field_92025_p = "";
        if (!GLContext.getCapabilities().OpenGL20 && !OpenGlHelper.areShadersSupported()) {
            this.field_92025_p = I18n.format("title.oldgl1", new Object[0]);
            this.field_146972_A = I18n.format("title.oldgl2", new Object[0]);
            this.field_104024_v = "https://help.mojang.com/customer/portal/articles/325948?ref=game";
        }
    }

    @Override
    public void updateScreen() {
        ++this.panoramaTimer;
    }

    @Override
    public boolean doesGuiPauseGame() {
        return false;
    }

    @Override
    protected void keyTyped(char typedChar, int keyCode) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initGui() {
        this.viewportTexture = new DynamicTexture(256, 256);
        this.field_110351_G = mc.getTextureManager().getDynamicTextureLocation("background", this.viewportTexture);
        Calendar var1 = Calendar.getInstance();
        var1.setTime(new Date());
        if (var1.get(2) + 1 == 11 && var1.get(5) == 9) {
            splashText = "Happy birthday, ez!";
        } else if (var1.get(2) + 1 == 6 && var1.get(5) == 1) {
            splashText = "Happy birthday, Notch!";
        } else if (var1.get(2) + 1 == 12 && var1.get(5) == 24) {
            splashText = "Merry X-mas!";
        } else if (var1.get(2) + 1 == 1 && var1.get(5) == 1) {
            splashText = "Happy new year!";
        } else if (var1.get(2) + 1 == 10 && var1.get(5) == 31) {
            splashText = "OOoooOOOoooo! Spooky!";
        } else if (var1.get(2) + 1 == 2 && var1.get(5) == 9) {
            splashText = "Happy birthday, Alexander01998!";
        }
        WurstClient.INSTANCE.currentServerIP = "127.0.0.1:25565";
        boolean var2 = true;
        int var3 = this.height / 4 + 48;
        if (mc.isDemo()) {
            this.addDemoButtons(var3, 24);
        } else {
            this.addSingleplayerMultiplayerButtons(var3, 24);
        }
        this.buttonList.add(new GuiButton(0, this.width / 2 - 100, var3 + 72 + 24, 98, 20, I18n.format("menu.options", new Object[0])));
        this.buttonList.add(new GuiButton(4, this.width / 2 + 2, var3 + 72 + 24, 98, 20, I18n.format("menu.quit", new Object[0])));
        this.buttonList.add(new GuiButtonLanguage(5, this.width / 2 - 124, var3 + 72 + 24));
        Object var4 = this.field_104025_t;
        Object object = this.field_104025_t;
        synchronized (object) {
            this.field_92023_s = this.fontRendererObj.getStringWidth(this.field_92025_p);
            this.field_92024_r = this.fontRendererObj.getStringWidth(this.field_146972_A);
            int var5 = Math.max(this.field_92023_s, this.field_92024_r);
            this.field_92022_t = (this.width - var5) / 2;
            this.field_92021_u = ((GuiButton)this.buttonList.get((int)0)).yPosition - 24;
            this.field_92020_v = this.field_92022_t + var5;
            this.field_92019_w = this.field_92021_u + 24;
        }
    }

    private void addSingleplayerMultiplayerButtons(int p_73969_1_, int p_73969_2_) {
        this.buttonList.add(new GuiButton(1, this.width / 2 - 100, p_73969_1_, I18n.format("menu.singleplayer", new Object[0])));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 100, p_73969_1_ + p_73969_2_ * 1, I18n.format("menu.multiplayer", new Object[0])));
        this.buttonList.add(new GuiButton(3, this.width / 2 - 100, p_73969_1_ + p_73969_2_ * 2, "Alt Manager"));
    }

    private void addDemoButtons(int p_73972_1_, int p_73972_2_) {
        this.buttonList.add(new GuiButton(11, this.width / 2 - 100, p_73972_1_, I18n.format("menu.playdemo", new Object[0])));
        this.buttonResetDemo = new GuiButton(12, this.width / 2 - 100, p_73972_1_ + p_73972_2_ * 1, I18n.format("menu.resetdemo", new Object[0]));
        this.buttonList.add(this.buttonResetDemo);
        ISaveFormat var3 = mc.getSaveLoader();
        WorldInfo var4 = var3.getWorldInfo("Demo_World");
        if (var4 == null) {
            this.buttonResetDemo.enabled = false;
        }
    }

    @Override
    protected void actionPerformed(GuiButton button) throws IOException {
        ISaveFormat var2;
        WorldInfo var3;
        if (button.id == 0) {
            mc.displayGuiScreen(new GuiOptions(this, GuiMainMenu.mc.gameSettings));
        }
        if (button.id == 5) {
            mc.displayGuiScreen(new GuiLanguage(this, GuiMainMenu.mc.gameSettings, mc.getLanguageManager()));
        }
        if (button.id == 1) {
            mc.displayGuiScreen(new GuiSelectWorld(this));
        }
        if (button.id == 2) {
            mc.displayGuiScreen(new GuiMultiplayer(this));
        }
        if (button.id == 14 && this.field_175372_K.visible) {
            this.switchToRealms();
        }
        if (button.id == 4) {
            mc.shutdown();
        }
        if (button.id == 11) {
            mc.launchIntegratedServer("Demo_World", "Demo_World", DemoWorldServer.demoWorldSettings);
        }
        if (button.id == 12 && (var3 = (var2 = mc.getSaveLoader()).getWorldInfo("Demo_World")) != null) {
            GuiYesNo var4 = GuiSelectWorld.func_152129_a(this, var3.getWorldName(), 12);
            mc.displayGuiScreen(var4);
        }
    }

    private void switchToRealms() {
        RealmsBridge var1 = new RealmsBridge();
        var1.switchToRealms(this);
    }

    @Override
    public void confirmClicked(boolean result, int id) {
        if (result && id == 12) {
            ISaveFormat var6 = mc.getSaveLoader();
            var6.flushCache();
            var6.deleteWorldDirectory("Demo_World");
            mc.displayGuiScreen(this);
        } else if (id == 13) {
            if (result) {
                try {
                    Class<?> var3 = Class.forName("java.awt.Desktop");
                    Object var4 = var3.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
                    var3.getMethod("browse", URI.class).invoke(var4, new URI(this.field_104024_v));
                }
                catch (Throwable var5) {
                    logger.error("Couldn't open link", var5);
                }
            }
            mc.displayGuiScreen(this);
        }
        if (id == 1) {
            if (result) {
                MiscUtils.openLink("https://www.youtube.com/watch?v=_Gf8oaC9QKM");
                WurstClient.INSTANCE.analytics.trackEvent("christmas easter egg", "play christmas song");
                mc.shutdown();
            } else {
                mc.displayGuiScreen(this);
                WurstClient.INSTANCE.analytics.trackEvent("christmas easter egg", "grief on christmas");
            }
        }
    }

    private void drawPanorama(int p_73970_1_, int p_73970_2_, float p_73970_3_) {
        Tessellator var4 = Tessellator.getInstance();
        WorldRenderer var5 = var4.getWorldRenderer();
        GlStateManager.matrixMode(5889);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        Project.gluPerspective((float)120.0f, (float)1.0f, (float)0.05f, (float)10.0f);
        GlStateManager.matrixMode(5888);
        GlStateManager.pushMatrix();
        GlStateManager.loadIdentity();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.rotate(180.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.rotate(90.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
        GlStateManager.disableCull();
        GlStateManager.depthMask(false);
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        int var6 = 8;
        int var7 = 0;
        while (var7 < var6 * var6) {
            GlStateManager.pushMatrix();
            float var8 = ((float)(var7 % var6) / (float)var6 - 0.5f) / 64.0f;
            float var9 = ((float)(var7 / var6) / (float)var6 - 0.5f) / 64.0f;
            float var10 = 0.0f;
            GlStateManager.translate(var8, var9, var10);
            GlStateManager.rotate(MathHelper.sin(((float)this.panoramaTimer + p_73970_3_) / 400.0f) * 25.0f + 20.0f, 1.0f, 0.0f, 0.0f);
            GlStateManager.rotate(-((float)this.panoramaTimer + p_73970_3_) * 0.1f, 0.0f, 1.0f, 0.0f);
            int var11 = 0;
            while (var11 < 6) {
                GlStateManager.pushMatrix();
                if (var11 == 1) {
                    GlStateManager.rotate(90.0f, 0.0f, 1.0f, 0.0f);
                }
                if (var11 == 2) {
                    GlStateManager.rotate(180.0f, 0.0f, 1.0f, 0.0f);
                }
                if (var11 == 3) {
                    GlStateManager.rotate(-90.0f, 0.0f, 1.0f, 0.0f);
                }
                if (var11 == 4) {
                    GlStateManager.rotate(90.0f, 1.0f, 0.0f, 0.0f);
                }
                if (var11 == 5) {
                    GlStateManager.rotate(-90.0f, 1.0f, 0.0f, 0.0f);
                }
                mc.getTextureManager().bindTexture(titlePanoramaPaths[var11]);
                var5.startDrawingQuads();
                var5.setColorRGBA_I(0xFFFFFF, 255 / (var7 + 1));
                float var12 = 0.0f;
                var5.addVertexWithUV(-1.0, -1.0, 1.0, 0.0f + var12, 0.0f + var12);
                var5.addVertexWithUV(1.0, -1.0, 1.0, 1.0f - var12, 0.0f + var12);
                var5.addVertexWithUV(1.0, 1.0, 1.0, 1.0f - var12, 1.0f - var12);
                var5.addVertexWithUV(-1.0, 1.0, 1.0, 0.0f + var12, 1.0f - var12);
                var4.draw();
                GlStateManager.popMatrix();
                ++var11;
            }
            GlStateManager.popMatrix();
            GlStateManager.colorMask(true, true, true, false);
            ++var7;
        }
        var5.setTranslation(0.0, 0.0, 0.0);
        GlStateManager.colorMask(true, true, true, true);
        GlStateManager.matrixMode(5889);
        GlStateManager.popMatrix();
        GlStateManager.matrixMode(5888);
        GlStateManager.popMatrix();
        GlStateManager.depthMask(true);
        GlStateManager.enableCull();
        GlStateManager.enableDepth();
    }

    private void rotateAndBlurSkybox(float p_73968_1_) {
        mc.getTextureManager().bindTexture(this.field_110351_G);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)256, (int)256);
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate(770, 771, 1, 0);
        GlStateManager.colorMask(true, true, true, false);
        Tessellator var2 = Tessellator.getInstance();
        WorldRenderer var3 = var2.getWorldRenderer();
        var3.startDrawingQuads();
        GlStateManager.disableAlpha();
        int var4 = 3;
        int var5 = 0;
        while (var5 < var4) {
            var3.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f / (float)(var5 + 1));
            int var6 = this.width;
            int var7 = this.height;
            float var8 = (float)(var5 - var4 / 2) / 256.0f;
            var3.addVertexWithUV(var6, var7, this.zLevel, 0.0f + var8, 1.0);
            var3.addVertexWithUV(var6, 0.0, this.zLevel, 1.0f + var8, 1.0);
            var3.addVertexWithUV(0.0, 0.0, this.zLevel, 1.0f + var8, 0.0);
            var3.addVertexWithUV(0.0, var7, this.zLevel, 0.0f + var8, 0.0);
            ++var5;
        }
        var2.draw();
        GlStateManager.enableAlpha();
        GlStateManager.colorMask(true, true, true, true);
    }

    protected void renderSkybox(int p_73971_1_, int p_73971_2_, float p_73971_3_) {
        mc.getFramebuffer().unbindFramebuffer();
        GlStateManager.viewport(0, 0, 256, 256);
        this.drawPanorama(p_73971_1_, p_73971_2_, p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        this.rotateAndBlurSkybox(p_73971_3_);
        mc.getFramebuffer().bindFramebuffer(true);
        GlStateManager.viewport(0, 0, GuiMainMenu.mc.displayWidth, GuiMainMenu.mc.displayHeight);
        Tessellator var4 = Tessellator.getInstance();
        WorldRenderer var5 = var4.getWorldRenderer();
        var5.startDrawingQuads();
        float var6 = this.width > this.height ? 120.0f / (float)this.width : 120.0f / (float)this.height;
        float var7 = (float)this.height * var6 / 256.0f;
        float var8 = (float)this.width * var6 / 256.0f;
        var5.setColorRGBA_F(1.0f, 1.0f, 1.0f, 1.0f);
        int var9 = this.width;
        int var10 = this.height;
        var5.addVertexWithUV(0.0, var10, this.zLevel, 0.5f - var7, 0.5f + var8);
        var5.addVertexWithUV(var9, var10, this.zLevel, 0.5f - var7, 0.5f - var8);
        var5.addVertexWithUV(var9, 0.0, this.zLevel, 0.5f + var7, 0.5f - var8);
        var5.addVertexWithUV(0.0, 0.0, this.zLevel, 0.5f + var7, 0.5f + var8);
        var4.draw();
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        GlStateManager.disableAlpha();
        this.renderSkybox(mouseX, mouseY, partialTicks);
        GlStateManager.enableAlpha();
        Tessellator var4 = Tessellator.getInstance();
        WorldRenderer var5 = var4.getWorldRenderer();
        int var6 = 256;
        int var7 = this.width / 2 - var6 / 2;
        int var8 = 30;
        this.drawGradientRect(0, 0, this.width, this.height, -2130706433, 0xFFFFFF);
        this.drawGradientRect(0, 0, this.width, this.height, 0, Integer.MIN_VALUE);
        mc.getTextureManager().bindTexture(minecraftTitleTextures);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        double x = var7;
        double y = var8;
        double h = 64.0;
        double w = 256.0;
        double fw = 256.0;
        double fh = 256.0;
        double u = 0.0;
        double v = 0.0;
        if (splashText.equals("umop-apisdn!")) {
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.width), (float)((float)(-h - 60.0)), (float)0.0f);
        }
        if ((double)this.updateCounter < 1.0E-4) {
            var5.startDrawingQuads();
            var5.addVertexWithUV(x + 0.0, y + h, this.zLevel, (float)(u + 0.0) * 0.00390625f, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + 120.0, y + h, this.zLevel, (float)(u + 120.0) * 0.00390625f, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + 120.0, y + 0.0, this.zLevel, (float)(u + 120.0) * 0.00390625f, (float)(v + 0.0) * 0.00390625f);
            var5.addVertexWithUV(x + 0.0, y + 0.0, this.zLevel, (float)(u + 0.0) * 0.00390625f, (float)(v + 0.0) * 0.00390625f);
            var4.draw();
            var5.startDrawingQuads();
            var5.addVertexWithUV(x + 120.0, y + h, this.zLevel, 0.625, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + 120.0 + 38.0, y + h, this.zLevel, 0.7734375, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + 120.0 + 38.0, y + 0.0, this.zLevel, 0.7734375, (float)(v + 0.0) * 0.00390625f);
            var5.addVertexWithUV(x + 120.0 + 0.0, y + 0.0, this.zLevel, 0.625, (float)(v + 0.0) * 0.00390625f);
            var4.draw();
            var5.startDrawingQuads();
            var5.addVertexWithUV(x + 158.0 + 0.0, y + h, this.zLevel, 0.46875, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + 158.0 + 40.0, y + h, this.zLevel, 0.625, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + 158.0 + 40.0, y + 0.0, this.zLevel, 0.625, (float)(v + 0.0) * 0.00390625f);
            var5.addVertexWithUV(x + 158.0 + 0.0, y + 0.0, this.zLevel, 0.46875, (float)(v + 0.0) * 0.00390625f);
            var4.draw();
            var5.startDrawingQuads();
            var5.addVertexWithUV(x + 198.0 + 0.0, y + h, this.zLevel, 0.7734375, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + 198.0 + 58.0, y + h, this.zLevel, 1.0, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + 198.0 + 58.0, y + 0.0, this.zLevel, 1.0, (float)(v + 0.0) * 0.00390625f);
            var5.addVertexWithUV(x + 198.0 + 0.0, y + 0.0, this.zLevel, 0.7734375, (float)(v + 0.0) * 0.00390625f);
            var4.draw();
        } else {
            var5.startDrawingQuads();
            var5.addVertexWithUV(x + 0.0, y + h, this.zLevel, (float)(u + 0.0) * 0.00390625f, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + w, y + h, this.zLevel, (float)(u + fw) * 0.00390625f, (float)(v + fh) * 0.00390625f);
            var5.addVertexWithUV(x + w, y + 0.0, this.zLevel, (float)(u + fw) * 0.00390625f, (float)(v + 0.0) * 0.00390625f);
            var5.addVertexWithUV(x + 0.0, y + 0.0, this.zLevel, (float)(u + 0.0) * 0.00390625f, (float)(v + 0.0) * 0.00390625f);
            var4.draw();
        }
        if (splashText.equals("umop-apisdn!")) {
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)(-this.width), (float)((float)(-h - 60.0)), (float)0.0f);
        }
        var5.setColorOpaque_I(-1);
        GlStateManager.pushMatrix();
        GlStateManager.translate(this.width / 2 + 90, 70.0f, 0.0f);
        GlStateManager.rotate(-20.0f, 0.0f, 0.0f, 1.0f);
        float var9 = 1.8f - MathHelper.abs(MathHelper.sin((float)(Minecraft.getSystemTime() % 1000L) / 1000.0f * (float)Math.PI * 2.0f) * 0.1f);
        var9 = var9 * 100.0f / (float)(this.fontRendererObj.getStringWidth(splashText) + 32);
        GlStateManager.scale(var9, var9, var9);
        this.drawCenteredString(this.fontRendererObj, splashText, 0, 0, -256);
        GlStateManager.popMatrix();
        String var10 = "Minecraft 1.8";
        String wurst10 = "Wurst v" + "2.5";
        if (mc.isDemo()) {
            var10 = String.valueOf(var10) + " Demo";
        }
        this.drawString(this.fontRendererObj, var10, this.width - this.fontRendererObj.getStringWidth(var10) - 2, 2, -1);
        this.drawString(this.fontRendererObj, wurst10, 2, 2, -1);
        String var11 = "Copyright Mojang AB";
        String wurst11 = "Copyright Alexander01998";
        this.drawString(this.fontRendererObj, wurst11, 2, 12, -1);
        this.drawString(this.fontRendererObj, var11, this.width - this.fontRendererObj.getStringWidth(var11) - 2, 12, -1);
        String var12 = "Do not distribute!";
        String wurst12 = "All rights reserved.";
        this.drawString(this.fontRendererObj, wurst12, 2, 22, -1);
        this.drawString(this.fontRendererObj, var12, this.width - this.fontRendererObj.getStringWidth(var12) - 2, 22, -1);
        String news = "";
        try {
            for (String item : this.newsItems) {
                news = String.valueOf(news) + item + "\u00a7e+++\u00a7r";
            }
        }
        catch (ConcurrentModificationException item) {
            // empty catch block
        }
        int newsWidth = this.fontRendererObj.getStringWidth(news);
        while (this.fontRendererObj.getStringWidth(news) < Math.max(this.width * 2, newsWidth * 2) && !news.isEmpty()) {
            news = String.valueOf(news) + news;
        }
        if (!news.isEmpty()) {
            this.drawCenteredString(this.fontRendererObj, "\u00a7nWurst News", this.width / 2, this.height - 20, -1);
            this.drawString(this.fontRendererObj, news, -((int)(mc.getSystemTime() / 50L % (long)newsWidth)), this.height - 10, -1);
        }
        if (this.field_92025_p != null && this.field_92025_p.length() > 0) {
            GuiMainMenu.drawRect(this.field_92022_t - 2, this.field_92021_u - 2, this.field_92020_v + 2, this.field_92019_w - 1, 0x55200000);
            this.drawString(this.fontRendererObj, this.field_92025_p, this.field_92022_t, this.field_92021_u, -1);
            this.drawString(this.fontRendererObj, this.field_146972_A, (this.width - this.field_92024_r) / 2, ((GuiButton)this.buttonList.get((int)0)).yPosition - 12, -1);
        }
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        Object var4 = this.field_104025_t;
        Object object = this.field_104025_t;
        synchronized (object) {
            if (this.field_92025_p.length() > 0 && mouseX >= this.field_92022_t && mouseX <= this.field_92020_v && mouseY >= this.field_92021_u && mouseY <= this.field_92019_w) {
                GuiConfirmOpenLink var5 = new GuiConfirmOpenLink((GuiYesNoCallback)this, this.field_104024_v, 13, true);
                var5.disableSecurityWarning();
                mc.displayGuiScreen(var5);
            }
        }
    }
}

