/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.stream;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.stream.GuiTwitchUserMode;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.stream.BroadcastController;
import net.minecraft.client.stream.ChatController;
import net.minecraft.client.stream.IStream;
import net.minecraft.client.stream.IngestServerTester;
import net.minecraft.client.stream.Metadata;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.opengl.GL11;
import tv.twitch.AuthToken;
import tv.twitch.ErrorCode;
import tv.twitch.broadcast.EncodingCpuUsage;
import tv.twitch.broadcast.FrameBuffer;
import tv.twitch.broadcast.GameInfo;
import tv.twitch.broadcast.IngestList;
import tv.twitch.broadcast.IngestServer;
import tv.twitch.broadcast.StreamInfo;
import tv.twitch.broadcast.VideoParams;
import tv.twitch.chat.ChatRawMessage;
import tv.twitch.chat.ChatTokenizedMessage;
import tv.twitch.chat.ChatUserInfo;
import tv.twitch.chat.ChatUserMode;
import tv.twitch.chat.ChatUserSubscription;

public class TwitchStream
implements BroadcastController.BroadcastListener,
ChatController.ChatListener,
IngestServerTester.IngestTestListener,
IStream {
    private static final Logger field_152950_b = LogManager.getLogger();
    public static final Marker field_152949_a = MarkerManager.getMarker((String)"STREAM");
    private final BroadcastController broadcastController;
    private final ChatController field_152952_d;
    private String field_176029_e;
    private final Minecraft field_152953_e;
    private final IChatComponent field_152954_f = new ChatComponentText("Twitch");
    private final Map field_152955_g = Maps.newHashMap();
    private Framebuffer field_152956_h;
    private boolean field_152957_i;
    private int field_152958_j = 30;
    private long field_152959_k = 0L;
    private boolean field_152960_l = false;
    private boolean field_152961_m;
    private boolean field_152962_n;
    private boolean field_152963_o;
    private IStream.AuthFailureReason field_152964_p = IStream.AuthFailureReason.ERROR;
    private static boolean field_152965_q;
    private static final String __OBFID = "CL_00001812";

    static {
        try {
            if (Util.getOSType() == Util.EnumOS.WINDOWS) {
                System.loadLibrary("avutil-ttv-51");
                System.loadLibrary("swresample-ttv-0");
                System.loadLibrary("libmp3lame-ttv");
                if (System.getProperty("os.arch").contains("64")) {
                    System.loadLibrary("libmfxsw64");
                } else {
                    System.loadLibrary("libmfxsw32");
                }
            }
            field_152965_q = true;
        }
        catch (Throwable var1) {
            field_152965_q = false;
        }
    }

    public TwitchStream(Minecraft mcIn, final Property p_i46057_2_) {
        this.field_152953_e = mcIn;
        this.broadcastController = new BroadcastController();
        this.field_152952_d = new ChatController();
        this.broadcastController.func_152841_a(this);
        this.field_152952_d.func_152990_a(this);
        this.broadcastController.func_152842_a("nmt37qblda36pvonovdkbopzfzw3wlq");
        this.field_152952_d.func_152984_a("nmt37qblda36pvonovdkbopzfzw3wlq");
        this.field_152954_f.getChatStyle().setColor(EnumChatFormatting.DARK_PURPLE);
        if (p_i46057_2_ != null && !Strings.isNullOrEmpty((String)p_i46057_2_.getValue()) && OpenGlHelper.framebufferSupported) {
            Thread var3 = new Thread("Twitch authenticator"){
                private static final String __OBFID = "CL_00001811";

                @Override
                public void run() {
                    try {
                        URL var1 = new URL("https://api.twitch.tv/kraken?oauth_token=" + URLEncoder.encode(p_i46057_2_.getValue(), "UTF-8"));
                        String var2 = HttpUtil.get(var1);
                        JsonObject var3 = JsonUtils.getElementAsJsonObject(new JsonParser().parse(var2), "Response");
                        JsonObject var4 = JsonUtils.getJsonObject(var3, "token");
                        if (JsonUtils.getJsonObjectBooleanFieldValue(var4, "valid")) {
                            String var5 = JsonUtils.getJsonObjectStringFieldValue(var4, "user_name");
                            field_152950_b.debug(field_152949_a, "Authenticated with twitch; username is {}", new Object[]{var5});
                            AuthToken var6 = new AuthToken();
                            var6.data = p_i46057_2_.getValue();
                            TwitchStream.this.broadcastController.func_152818_a(var5, var6);
                            TwitchStream.this.field_152952_d.func_152998_c(var5);
                            TwitchStream.this.field_152952_d.func_152994_a(var6);
                            Runtime.getRuntime().addShutdownHook(new Thread("Twitch shutdown hook"){
                                private static final String __OBFID = "CL_00001810";

                                @Override
                                public void run() {
                                    TwitchStream.this.shutdownStream();
                                }
                            });
                            TwitchStream.this.broadcastController.func_152817_A();
                            TwitchStream.this.field_152952_d.func_175984_n();
                        } else {
                            TwitchStream.this.field_152964_p = IStream.AuthFailureReason.INVALID_TOKEN;
                            field_152950_b.error(field_152949_a, "Given twitch access token is invalid");
                        }
                    }
                    catch (IOException var7) {
                        TwitchStream.this.field_152964_p = IStream.AuthFailureReason.ERROR;
                        field_152950_b.error(field_152949_a, "Could not authenticate with twitch", (Throwable)var7);
                    }
                }
            };
            var3.setDaemon(true);
            var3.start();
        }
    }

    @Override
    public void shutdownStream() {
        field_152950_b.debug(field_152949_a, "Shutdown streaming");
        this.broadcastController.statCallback();
        this.field_152952_d.func_175988_p();
    }

    @Override
    public void func_152935_j() {
        boolean var3;
        int var1 = this.field_152953_e.gameSettings.streamChatEnabled;
        boolean var2 = this.field_176029_e != null && this.field_152952_d.func_175990_d(this.field_176029_e);
        boolean bl = var3 = this.field_152952_d.func_153000_j() == ChatController.ChatState.Initialized && (this.field_176029_e == null || this.field_152952_d.func_175989_e(this.field_176029_e) == ChatController.EnumChannelState.Disconnected);
        if (var1 == 2) {
            if (var2) {
                field_152950_b.debug(field_152949_a, "Disconnecting from twitch chat per user options");
                this.field_152952_d.func_175991_l(this.field_176029_e);
            }
        } else if (var1 == 1) {
            if (var3 && this.broadcastController.func_152849_q()) {
                field_152950_b.debug(field_152949_a, "Connecting to twitch chat per user options");
                this.func_152942_I();
            }
        } else if (var1 == 0) {
            if (var2 && !this.func_152934_n()) {
                field_152950_b.debug(field_152949_a, "Disconnecting from twitch chat as user is no longer streaming");
                this.field_152952_d.func_175991_l(this.field_176029_e);
            } else if (var3 && this.func_152934_n()) {
                field_152950_b.debug(field_152949_a, "Connecting to twitch chat as user is streaming");
                this.func_152942_I();
            }
        }
        this.broadcastController.func_152821_H();
        this.field_152952_d.func_152997_n();
    }

    protected void func_152942_I() {
        String var2;
        ChatController.ChatState var1 = this.field_152952_d.func_153000_j();
        this.field_176029_e = var2 = this.broadcastController.func_152843_l().name;
        if (var1 != ChatController.ChatState.Initialized) {
            field_152950_b.warn("Invalid twitch chat state {}", new Object[]{var1});
        } else if (this.field_152952_d.func_175989_e(this.field_176029_e) == ChatController.EnumChannelState.Disconnected) {
            this.field_152952_d.func_152986_d(var2);
        } else {
            field_152950_b.warn("Invalid twitch chat state {}", new Object[]{var1});
        }
    }

    @Override
    public void func_152922_k() {
        if (this.broadcastController.isBroadcasting() && !this.broadcastController.isBroadcastPaused()) {
            long var3;
            boolean var7;
            long var1 = System.nanoTime();
            long var5 = var1 - this.field_152959_k;
            boolean bl = var7 = var5 >= (var3 = (long)(1000000000 / this.field_152958_j));
            if (var7) {
                FrameBuffer var8 = this.broadcastController.func_152822_N();
                Framebuffer var9 = this.field_152953_e.getFramebuffer();
                this.field_152956_h.bindFramebuffer(true);
                GlStateManager.matrixMode(5889);
                GlStateManager.pushMatrix();
                GlStateManager.loadIdentity();
                GlStateManager.ortho(0.0, this.field_152956_h.framebufferWidth, this.field_152956_h.framebufferHeight, 0.0, 1000.0, 3000.0);
                GlStateManager.matrixMode(5888);
                GlStateManager.pushMatrix();
                GlStateManager.loadIdentity();
                GlStateManager.translate(0.0f, 0.0f, -2000.0f);
                GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
                GlStateManager.viewport(0, 0, this.field_152956_h.framebufferWidth, this.field_152956_h.framebufferHeight);
                GlStateManager.func_179098_w();
                GlStateManager.disableAlpha();
                GlStateManager.disableBlend();
                float var10 = this.field_152956_h.framebufferWidth;
                float var11 = this.field_152956_h.framebufferHeight;
                float var12 = (float)var9.framebufferWidth / (float)var9.framebufferTextureWidth;
                float var13 = (float)var9.framebufferHeight / (float)var9.framebufferTextureHeight;
                var9.bindFramebufferTexture();
                GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
                GL11.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
                Tessellator var14 = Tessellator.getInstance();
                WorldRenderer var15 = var14.getWorldRenderer();
                var15.startDrawingQuads();
                var15.addVertexWithUV(0.0, var11, 0.0, 0.0, var13);
                var15.addVertexWithUV(var10, var11, 0.0, var12, var13);
                var15.addVertexWithUV(var10, 0.0, 0.0, var12, 0.0);
                var15.addVertexWithUV(0.0, 0.0, 0.0, 0.0, 0.0);
                var14.draw();
                var9.unbindFramebufferTexture();
                GlStateManager.popMatrix();
                GlStateManager.matrixMode(5889);
                GlStateManager.popMatrix();
                GlStateManager.matrixMode(5888);
                this.broadcastController.func_152846_a(var8);
                this.field_152956_h.unbindFramebuffer();
                this.broadcastController.func_152859_b(var8);
                this.field_152959_k = var1;
            }
        }
    }

    @Override
    public boolean func_152936_l() {
        return this.broadcastController.func_152849_q();
    }

    @Override
    public boolean func_152924_m() {
        return this.broadcastController.func_152857_n();
    }

    @Override
    public boolean func_152934_n() {
        return this.broadcastController.isBroadcasting();
    }

    @Override
    public void func_152911_a(Metadata p_152911_1_, long p_152911_2_) {
        if (this.func_152934_n() && this.field_152957_i) {
            long var4 = this.broadcastController.func_152844_x();
            if (!this.broadcastController.func_152840_a(p_152911_1_.func_152810_c(), var4 + p_152911_2_, p_152911_1_.func_152809_a(), p_152911_1_.func_152806_b())) {
                field_152950_b.warn(field_152949_a, "Couldn't send stream metadata action at {}: {}", new Object[]{var4 + p_152911_2_, p_152911_1_});
            } else {
                field_152950_b.debug(field_152949_a, "Sent stream metadata action at {}: {}", new Object[]{var4 + p_152911_2_, p_152911_1_});
            }
        }
    }

    @Override
    public void func_176026_a(Metadata p_176026_1_, long p_176026_2_, long p_176026_4_) {
        if (this.func_152934_n() && this.field_152957_i) {
            long var6 = this.broadcastController.func_152844_x();
            String var8 = p_176026_1_.func_152809_a();
            String var9 = p_176026_1_.func_152806_b();
            long var10 = this.broadcastController.func_177946_b(p_176026_1_.func_152810_c(), var6 + p_176026_2_, var8, var9);
            if (var10 < 0L) {
                field_152950_b.warn(field_152949_a, "Could not send stream metadata sequence from {} to {}: {}", new Object[]{var6 + p_176026_2_, var6 + p_176026_4_, p_176026_1_});
            } else if (this.broadcastController.func_177947_a(p_176026_1_.func_152810_c(), var6 + p_176026_4_, var10, var8, var9)) {
                field_152950_b.debug(field_152949_a, "Sent stream metadata sequence from {} to {}: {}", new Object[]{var6 + p_176026_2_, var6 + p_176026_4_, p_176026_1_});
            } else {
                field_152950_b.warn(field_152949_a, "Half-sent stream metadata sequence from {} to {}: {}", new Object[]{var6 + p_176026_2_, var6 + p_176026_4_, p_176026_1_});
            }
        }
    }

    @Override
    public boolean isPaused() {
        return this.broadcastController.isBroadcastPaused();
    }

    @Override
    public void func_152931_p() {
        if (this.broadcastController.func_152830_D()) {
            field_152950_b.debug(field_152949_a, "Requested commercial from Twitch");
        } else {
            field_152950_b.warn(field_152949_a, "Could not request commercial from Twitch");
        }
    }

    @Override
    public void func_152916_q() {
        this.broadcastController.func_152847_F();
        this.field_152962_n = true;
        this.func_152915_s();
    }

    @Override
    public void func_152933_r() {
        this.broadcastController.func_152854_G();
        this.field_152962_n = false;
        this.func_152915_s();
    }

    @Override
    public void func_152915_s() {
        if (this.func_152934_n()) {
            float var1 = this.field_152953_e.gameSettings.streamGameVolume;
            boolean var2 = this.field_152962_n || var1 <= 0.0f;
            this.broadcastController.func_152837_b(var2 ? 0.0f : var1);
            this.broadcastController.func_152829_a(this.func_152929_G() ? 0.0f : this.field_152953_e.gameSettings.streamMicVolume);
        }
    }

    @Override
    public void func_152930_t() {
        GameSettings var1 = this.field_152953_e.gameSettings;
        VideoParams var2 = this.broadcastController.func_152834_a(TwitchStream.func_152946_b(var1.streamKbps), TwitchStream.func_152948_a(var1.streamFps), TwitchStream.func_152947_c(var1.streamBytesPerPixel), (float)this.field_152953_e.displayWidth / (float)this.field_152953_e.displayHeight);
        switch (var1.streamCompression) {
            case 0: {
                var2.encodingCpuUsage = EncodingCpuUsage.TTV_ECU_LOW;
                break;
            }
            case 1: {
                var2.encodingCpuUsage = EncodingCpuUsage.TTV_ECU_MEDIUM;
                break;
            }
            case 2: {
                var2.encodingCpuUsage = EncodingCpuUsage.TTV_ECU_HIGH;
            }
        }
        if (this.field_152956_h == null) {
            this.field_152956_h = new Framebuffer(var2.outputWidth, var2.outputHeight, false);
        } else {
            this.field_152956_h.createBindFramebuffer(var2.outputWidth, var2.outputHeight);
        }
        if (var1.streamPreferredServer != null && var1.streamPreferredServer.length() > 0) {
            IngestServer[] var3 = this.func_152925_v();
            int var4 = var3.length;
            int var5 = 0;
            while (var5 < var4) {
                IngestServer var6 = var3[var5];
                if (var6.serverUrl.equals(var1.streamPreferredServer)) {
                    this.broadcastController.func_152824_a(var6);
                    break;
                }
                ++var5;
            }
        }
        this.field_152958_j = var2.targetFps;
        this.field_152957_i = var1.streamSendMetadata;
        this.broadcastController.func_152836_a(var2);
        field_152950_b.info(field_152949_a, "Streaming at {}/{} at {} kbps to {}", new Object[]{var2.outputWidth, var2.outputHeight, var2.maxKbps, this.broadcastController.func_152833_s().serverUrl});
        this.broadcastController.func_152828_a(null, "Minecraft", null);
    }

    @Override
    public void func_152914_u() {
        if (this.broadcastController.func_152819_E()) {
            field_152950_b.info(field_152949_a, "Stopped streaming to Twitch");
        } else {
            field_152950_b.warn(field_152949_a, "Could not stop streaming to Twitch");
        }
    }

    @Override
    public void func_152900_a(ErrorCode p_152900_1_, AuthToken p_152900_2_) {
    }

    @Override
    public void func_152897_a(ErrorCode p_152897_1_) {
        if (ErrorCode.succeeded((ErrorCode)p_152897_1_)) {
            field_152950_b.debug(field_152949_a, "Login attempt successful");
            this.field_152961_m = true;
        } else {
            field_152950_b.warn(field_152949_a, "Login attempt unsuccessful: {} (error code {})", new Object[]{ErrorCode.getString((ErrorCode)p_152897_1_), p_152897_1_.getValue()});
            this.field_152961_m = false;
        }
    }

    @Override
    public void func_152898_a(ErrorCode p_152898_1_, GameInfo[] p_152898_2_) {
    }

    @Override
    public void func_152891_a(BroadcastController.BroadcastState p_152891_1_) {
        field_152950_b.debug(field_152949_a, "Broadcast state changed to {}", new Object[]{p_152891_1_});
        if (p_152891_1_ == BroadcastController.BroadcastState.Initialized) {
            this.broadcastController.func_152827_a(BroadcastController.BroadcastState.Authenticated);
        }
    }

    @Override
    public void func_152895_a() {
        field_152950_b.info(field_152949_a, "Logged out of twitch");
    }

    @Override
    public void func_152894_a(StreamInfo p_152894_1_) {
        field_152950_b.debug(field_152949_a, "Stream info updated; {} viewers on stream ID {}", new Object[]{p_152894_1_.viewers, p_152894_1_.streamId});
    }

    @Override
    public void func_152896_a(IngestList p_152896_1_) {
    }

    @Override
    public void func_152893_b(ErrorCode p_152893_1_) {
        field_152950_b.warn(field_152949_a, "Issue submitting frame: {} (Error code {})", new Object[]{ErrorCode.getString((ErrorCode)p_152893_1_), p_152893_1_.getValue()});
        this.field_152953_e.ingameGUI.getChatGUI().printChatMessageWithOptionalDeletion(new ChatComponentText("Issue streaming frame: " + p_152893_1_ + " (" + ErrorCode.getString((ErrorCode)p_152893_1_) + ")"), 2);
    }

    @Override
    public void func_152899_b() {
        this.func_152915_s();
        field_152950_b.info(field_152949_a, "Broadcast to Twitch has started");
    }

    @Override
    public void func_152901_c() {
        field_152950_b.info(field_152949_a, "Broadcast to Twitch has stopped");
    }

    @Override
    public void func_152892_c(ErrorCode p_152892_1_) {
        if (p_152892_1_ == ErrorCode.TTV_EC_SOUNDFLOWER_NOT_INSTALLED) {
            ChatComponentTranslation var2 = new ChatComponentTranslation("stream.unavailable.soundflower.chat.link", new Object[0]);
            var2.getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://help.mojang.com/customer/portal/articles/1374877-configuring-soundflower-for-streaming-on-apple-computers"));
            var2.getChatStyle().setUnderlined(true);
            ChatComponentTranslation var3 = new ChatComponentTranslation("stream.unavailable.soundflower.chat", var2);
            var3.getChatStyle().setColor(EnumChatFormatting.DARK_RED);
            this.field_152953_e.ingameGUI.getChatGUI().printChatMessage(var3);
        } else {
            ChatComponentTranslation var2 = new ChatComponentTranslation("stream.unavailable.unknown.chat", ErrorCode.getString((ErrorCode)p_152892_1_));
            var2.getChatStyle().setColor(EnumChatFormatting.DARK_RED);
            this.field_152953_e.ingameGUI.getChatGUI().printChatMessage(var2);
        }
    }

    @Override
    public void func_152907_a(IngestServerTester p_152907_1_, IngestServerTester.IngestTestState p_152907_2_) {
        field_152950_b.debug(field_152949_a, "Ingest test state changed to {}", new Object[]{p_152907_2_});
        if (p_152907_2_ == IngestServerTester.IngestTestState.Finished) {
            this.field_152960_l = true;
        }
    }

    public static int func_152948_a(float p_152948_0_) {
        return MathHelper.floor_float(10.0f + p_152948_0_ * 50.0f);
    }

    public static int func_152946_b(float p_152946_0_) {
        return MathHelper.floor_float(230.0f + p_152946_0_ * 3270.0f);
    }

    public static float func_152947_c(float p_152947_0_) {
        return 0.1f + p_152947_0_ * 0.1f;
    }

    @Override
    public IngestServer[] func_152925_v() {
        return this.broadcastController.func_152855_t().getServers();
    }

    @Override
    public void func_152909_x() {
        IngestServerTester var1 = this.broadcastController.func_152838_J();
        if (var1 != null) {
            var1.func_153042_a(this);
        }
    }

    @Override
    public IngestServerTester func_152932_y() {
        return this.broadcastController.isReady();
    }

    @Override
    public boolean func_152908_z() {
        return this.broadcastController.isIngestTesting();
    }

    @Override
    public int func_152920_A() {
        return this.func_152934_n() ? this.broadcastController.func_152816_j().viewers : 0;
    }

    @Override
    public void func_176023_d(ErrorCode p_176023_1_) {
        if (ErrorCode.failed((ErrorCode)p_176023_1_)) {
            field_152950_b.error(field_152949_a, "Chat failed to initialize");
        }
    }

    @Override
    public void func_176022_e(ErrorCode p_176022_1_) {
        if (ErrorCode.failed((ErrorCode)p_176022_1_)) {
            field_152950_b.error(field_152949_a, "Chat failed to shutdown");
        }
    }

    @Override
    public void func_176017_a(ChatController.ChatState p_176017_1_) {
    }

    @Override
    public void func_180605_a(String p_180605_1_, ChatRawMessage[] p_180605_2_) {
        ChatRawMessage[] var3 = p_180605_2_;
        int var4 = p_180605_2_.length;
        int var5 = 0;
        while (var5 < var4) {
            ChatRawMessage var6 = var3[var5];
            this.func_176027_a(var6.userName, var6);
            if (this.func_176028_a(var6.modes, var6.subscriptions, this.field_152953_e.gameSettings.streamChatUserFilter)) {
                ChatComponentText var7 = new ChatComponentText(var6.userName);
                ChatComponentTranslation var8 = new ChatComponentTranslation("chat.stream." + (var6.action ? "emote" : "text"), this.field_152954_f, var7, EnumChatFormatting.getTextWithoutFormattingCodes(var6.message));
                if (var6.action) {
                    var8.getChatStyle().setItalic(true);
                }
                ChatComponentText var9 = new ChatComponentText("");
                var9.appendSibling(new ChatComponentTranslation("stream.userinfo.chatTooltip", new Object[0]));
                for (IChatComponent var11 : GuiTwitchUserMode.func_152328_a(var6.modes, var6.subscriptions, null)) {
                    var9.appendText("\n");
                    var9.appendSibling(var11);
                }
                var7.getChatStyle().setChatHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, var9));
                var7.getChatStyle().setChatClickEvent(new ClickEvent(ClickEvent.Action.TWITCH_USER_INFO, var6.userName));
                this.field_152953_e.ingameGUI.getChatGUI().printChatMessage(var8);
            }
            ++var5;
        }
    }

    @Override
    public void func_176025_a(String p_176025_1_, ChatTokenizedMessage[] p_176025_2_) {
    }

    private void func_176027_a(String p_176027_1_, ChatRawMessage p_176027_2_) {
        ChatUserInfo var3 = (ChatUserInfo)this.field_152955_g.get(p_176027_1_);
        if (var3 == null) {
            var3 = new ChatUserInfo();
            var3.displayName = p_176027_1_;
            this.field_152955_g.put(p_176027_1_, var3);
        }
        var3.subscriptions = p_176027_2_.subscriptions;
        var3.modes = p_176027_2_.modes;
        var3.nameColorARGB = p_176027_2_.nameColorARGB;
    }

    private boolean func_176028_a(Set p_176028_1_, Set p_176028_2_, int p_176028_3_) {
        return p_176028_1_.contains(ChatUserMode.TTV_CHAT_USERMODE_BANNED) ? false : (p_176028_1_.contains(ChatUserMode.TTV_CHAT_USERMODE_ADMINSTRATOR) ? true : (p_176028_1_.contains(ChatUserMode.TTV_CHAT_USERMODE_MODERATOR) ? true : (p_176028_1_.contains(ChatUserMode.TTV_CHAT_USERMODE_STAFF) ? true : (p_176028_3_ == 0 ? true : (p_176028_3_ == 1 ? p_176028_2_.contains(ChatUserSubscription.TTV_CHAT_USERSUB_SUBSCRIBER) : false)))));
    }

    @Override
    public void func_176018_a(String p_176018_1_, ChatUserInfo[] p_176018_2_, ChatUserInfo[] p_176018_3_, ChatUserInfo[] p_176018_4_) {
        ChatUserInfo var8;
        ChatUserInfo[] var5 = p_176018_3_;
        int var6 = p_176018_3_.length;
        int var7 = 0;
        while (var7 < var6) {
            var8 = var5[var7];
            this.field_152955_g.remove(var8.displayName);
            ++var7;
        }
        var5 = p_176018_4_;
        var6 = p_176018_4_.length;
        var7 = 0;
        while (var7 < var6) {
            var8 = var5[var7];
            this.field_152955_g.put(var8.displayName, var8);
            ++var7;
        }
        var5 = p_176018_2_;
        var6 = p_176018_2_.length;
        var7 = 0;
        while (var7 < var6) {
            var8 = var5[var7];
            this.field_152955_g.put(var8.displayName, var8);
            ++var7;
        }
    }

    @Override
    public void func_180606_a(String p_180606_1_) {
        field_152950_b.debug(field_152949_a, "Chat connected");
    }

    @Override
    public void func_180607_b(String p_180607_1_) {
        field_152950_b.debug(field_152949_a, "Chat disconnected");
        this.field_152955_g.clear();
    }

    @Override
    public void func_176019_a(String p_176019_1_, String p_176019_2_) {
    }

    @Override
    public void func_176021_d() {
    }

    @Override
    public void func_176024_e() {
    }

    @Override
    public void func_176016_c(String p_176016_1_) {
    }

    @Override
    public void func_176020_d(String p_176020_1_) {
    }

    @Override
    public boolean func_152927_B() {
        return this.field_176029_e != null && this.field_176029_e.equals(this.broadcastController.func_152843_l().name);
    }

    @Override
    public String func_152921_C() {
        return this.field_176029_e;
    }

    @Override
    public ChatUserInfo func_152926_a(String p_152926_1_) {
        return (ChatUserInfo)this.field_152955_g.get(p_152926_1_);
    }

    @Override
    public void func_152917_b(String p_152917_1_) {
        this.field_152952_d.func_175986_a(this.field_176029_e, p_152917_1_);
    }

    @Override
    public boolean func_152928_D() {
        return field_152965_q && this.broadcastController.func_152858_b();
    }

    @Override
    public ErrorCode func_152912_E() {
        return !field_152965_q ? ErrorCode.TTV_EC_OS_TOO_OLD : this.broadcastController.func_152852_P();
    }

    @Override
    public boolean func_152913_F() {
        return this.field_152961_m;
    }

    @Override
    public void func_152910_a(boolean p_152910_1_) {
        this.field_152963_o = p_152910_1_;
        this.func_152915_s();
    }

    @Override
    public boolean func_152929_G() {
        boolean var1;
        boolean bl = var1 = this.field_152953_e.gameSettings.streamMicToggleBehavior == 1;
        return this.field_152962_n || this.field_152953_e.gameSettings.streamMicVolume <= 0.0f || var1 != this.field_152963_o;
    }

    @Override
    public IStream.AuthFailureReason func_152918_H() {
        return this.field_152964_p;
    }
}

