/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CryptManager {
    private static final Logger field_180198_a = LogManager.getLogger();
    private static final String __OBFID = "CL_00001483";

    public static SecretKey createNewSharedKey() {
        try {
            KeyGenerator var0 = KeyGenerator.getInstance("AES");
            var0.init(128);
            return var0.generateKey();
        }
        catch (NoSuchAlgorithmException var1) {
            throw new Error(var1);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator var0 = KeyPairGenerator.getInstance("RSA");
            var0.initialize(1024);
            return var0.generateKeyPair();
        }
        catch (NoSuchAlgorithmException var1) {
            var1.printStackTrace();
            field_180198_a.error("Key pair generation failed!");
            return null;
        }
    }

    public static byte[] getServerIdHash(String input, PublicKey publicKey, SecretKey secretKey) {
        try {
            return CryptManager.digestOperation("SHA-1", input.getBytes("ISO_8859_1"), secretKey.getEncoded(), publicKey.getEncoded());
        }
        catch (UnsupportedEncodingException var4) {
            var4.printStackTrace();
            return null;
        }
    }

    private static byte[] digestOperation(String algorithm, byte[] ... p_75893_1_) {
        try {
            MessageDigest var2 = MessageDigest.getInstance(algorithm);
            byte[][] var3 = p_75893_1_;
            int var4 = p_75893_1_.length;
            int var5 = 0;
            while (var5 < var4) {
                byte[] var6 = var3[var5];
                var2.update(var6);
                ++var5;
            }
            return var2.digest();
        }
        catch (NoSuchAlgorithmException var7) {
            var7.printStackTrace();
            return null;
        }
    }

    public static PublicKey decodePublicKey(byte[] p_75896_0_) {
        try {
            X509EncodedKeySpec var1 = new X509EncodedKeySpec(p_75896_0_);
            KeyFactory var2 = KeyFactory.getInstance("RSA");
            return var2.generatePublic(var1);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            // empty catch block
        }
        field_180198_a.error("Public key reconstitute failed!");
        return null;
    }

    public static SecretKey decryptSharedKey(PrivateKey privateKey, byte[] input) {
        return new SecretKeySpec(CryptManager.decryptData(privateKey, input), "AES");
    }

    public static byte[] encryptData(Key p_75894_0_, byte[] p_75894_1_) {
        return CryptManager.cipherOperation(1, p_75894_0_, p_75894_1_);
    }

    public static byte[] decryptData(Key privateKey, byte[] input) {
        return CryptManager.cipherOperation(2, privateKey, input);
    }

    private static byte[] cipherOperation(int opmode, Key key, byte[] input) {
        try {
            return CryptManager.createTheCipherInstance(opmode, key.getAlgorithm(), key).doFinal(input);
        }
        catch (IllegalBlockSizeException var4) {
            var4.printStackTrace();
        }
        catch (BadPaddingException var5) {
            var5.printStackTrace();
        }
        field_180198_a.error("Cipher data failed!");
        return null;
    }

    private static Cipher createTheCipherInstance(int opmode, String transformation, Key key) {
        try {
            Cipher var3 = Cipher.getInstance(transformation);
            var3.init(opmode, key);
            return var3;
        }
        catch (InvalidKeyException var4) {
            var4.printStackTrace();
        }
        catch (NoSuchAlgorithmException var5) {
            var5.printStackTrace();
        }
        catch (NoSuchPaddingException var6) {
            var6.printStackTrace();
        }
        field_180198_a.error("Cipher creation failed!");
        return null;
    }

    public static Cipher getAESCipher(int opmode, Key sharedKey) {
        try {
            Cipher var2 = Cipher.getInstance("AES/CFB8/NoPadding");
            var2.init(opmode, sharedKey, new IvParameterSpec(sharedKey.getEncoded()));
            return var2;
        }
        catch (GeneralSecurityException var3) {
            throw new RuntimeException(var3);
        }
    }
}

