/*
 * Decompiled with CFR 0.152.
 */
package org.darkstorm.minecraft.gui.theme.wurst;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import net.minecraft.client.gui.FontRenderer;
import org.darkstorm.minecraft.gui.component.Container;
import org.darkstorm.minecraft.gui.component.Slider;
import org.darkstorm.minecraft.gui.theme.AbstractComponentUI;
import org.darkstorm.minecraft.gui.theme.wurst.WurstTheme;
import org.darkstorm.minecraft.gui.util.RenderUtil;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class WurstSliderUI
extends AbstractComponentUI<Slider> {
    private WurstTheme theme;

    public WurstSliderUI(WurstTheme theme) {
        super(Slider.class);
        this.theme = theme;
        this.foreground = Color.WHITE;
        this.background = new Color(128, 128, 128, 192);
    }

    @Override
    protected void renderComponent(Slider component) {
        this.translateComponent(component, false);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2884);
        Rectangle area = component.getArea();
        int fontSize = this.theme.getFontRenderer().FONT_HEIGHT;
        FontRenderer fontRenderer = this.theme.getFontRenderer();
        fontRenderer.drawString(component.getText(), 0, 0, RenderUtil.toRGBA(component.getForegroundColor()));
        String content = null;
        switch (component.getValueDisplay()) {
            case DECIMAL: {
                content = Double.toString((double)(Math.round(component.getValue() / component.getIncrement()) * 1000000L * (long)(component.getIncrement() * 1000000.0)) / 1000000.0 / 1000000.0);
                break;
            }
            case INTEGER: {
                content = String.format("%,d", Math.round(component.getValue()));
                break;
            }
            case PERCENTAGE: {
                int percent = (int)Math.round((component.getValue() - component.getMinimumValue()) / (component.getMaximumValue() - component.getMinimumValue()) * 100.0);
                content = String.format("%d%%", percent);
            }
        }
        if (content != null) {
            String suffix = component.getContentSuffix();
            if (suffix != null && !suffix.trim().isEmpty()) {
                content = content.concat(" ").concat(suffix);
            }
            fontRenderer.drawString(content, component.getWidth() - fontRenderer.getStringWidth(content), 0, RenderUtil.toRGBA(component.getForegroundColor()));
        }
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.03125f, (float)0.03125f, (float)0.03125f, (float)0.25f);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)1.0, (double)(fontSize + 4));
        GL11.glVertex2d((double)(area.width - 1), (double)(fontSize + 4));
        GL11.glVertex2d((double)(area.width - 1), (double)(area.height - 2));
        GL11.glVertex2d((double)1.0, (double)(area.height - 2));
        GL11.glEnd();
        GL11.glLineWidth((float)1.0f);
        GL11.glColor4f((float)0.125f, (float)0.125f, (float)0.125f, (float)0.5f);
        GL11.glBegin((int)2);
        GL11.glVertex2d((double)1.0, (double)(fontSize + 4));
        GL11.glVertex2d((double)(area.width - 1), (double)(fontSize + 4));
        GL11.glVertex2d((double)(area.width - 1), (double)(area.height - 2));
        GL11.glVertex2d((double)1.0, (double)(area.height - 2));
        GL11.glEnd();
        double sliderPercentage = (component.getValue() - component.getMinimumValue()) / (component.getMaximumValue() - component.getMinimumValue());
        GL11.glColor4f((float)(0.0f + (float)sliderPercentage), (float)(1.0f - (float)sliderPercentage), (float)0.0f, (float)0.5f);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)((double)(area.width - 6) * sliderPercentage - 1.0), (double)(fontSize + 1));
        GL11.glVertex2d((double)((double)(area.width - 6) * sliderPercentage + 7.0), (double)(fontSize + 1));
        GL11.glVertex2d((double)((double)(area.width - 6) * sliderPercentage + 7.0), (double)(area.height + 1));
        GL11.glVertex2d((double)((double)(area.width - 6) * sliderPercentage - 1.0), (double)(area.height + 1));
        GL11.glEnd();
        RenderUtil.boxShadow((double)(area.width - 6) * sliderPercentage - 1.0, fontSize + 1, (double)(area.width - 6) * sliderPercentage + 7.0, area.height + 1);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        this.translateComponent(component, true);
    }

    @Override
    protected Dimension getDefaultComponentSize(Slider component) {
        return new Dimension(106, 8 + this.theme.getFontRenderer().FONT_HEIGHT);
    }

    @Override
    protected Rectangle[] getInteractableComponentRegions(Slider component) {
        return new Rectangle[]{new Rectangle(0, this.theme.getFontRenderer().FONT_HEIGHT + 2, component.getWidth(), component.getHeight() - this.theme.getFontRenderer().FONT_HEIGHT)};
    }

    @Override
    protected void handleComponentInteraction(Slider component, Point location, int button) {
        if (this.getInteractableComponentRegions(component)[0].contains(location) && button == 0) {
            if (Mouse.isButtonDown((int)button) && !component.isValueChanging()) {
                component.setValueChanging(true);
            } else if (!Mouse.isButtonDown((int)button) && component.isValueChanging()) {
                component.setValueChanging(false);
            }
        }
    }

    @Override
    protected void handleComponentUpdate(Slider component) {
        if (component.isValueChanging()) {
            if (!Mouse.isButtonDown((int)0)) {
                component.setValueChanging(false);
                return;
            }
            Point mouse = RenderUtil.calculateMouseLocation();
            Container parent = component.getParent();
            if (parent != null) {
                mouse.translate(-parent.getX(), -parent.getY());
            }
            double percent = (double)(mouse.x - 4) / (double)(component.getWidth() - 6);
            double value = component.getMinimumValue() + percent * (component.getMaximumValue() - component.getMinimumValue());
            component.setValue(value);
        }
    }
}

