/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.ai;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.PriorityQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.util.BlockPos;
import tk.wurst_client.ai.PathPoint;
import tk.wurst_client.ai.PathUtils;

public class PathFinder {
    private BlockPos goal;
    private PriorityQueue<PathPoint> queue;
    private HashMap<BlockPos, PathPoint> processed = new HashMap();
    private PathPoint lastPoint;

    public PathFinder(BlockPos goal) {
        this(new BlockPos(Minecraft.getMinecraft().thePlayer), goal);
    }

    public PathFinder(BlockPos start, BlockPos goal) {
        this.goal = goal;
        this.queue = new PriorityQueue<PathPoint>(new Comparator<PathPoint>(){

            @Override
            public int compare(PathPoint o1, PathPoint o2) {
                if (o1.getPriority() < o2.getPriority()) {
                    return -1;
                }
                if (o1.getPriority() > o2.getPriority()) {
                    return 1;
                }
                if (PathFinder.this.getDistance(o1.getPos(), PathFinder.this.goal) < PathFinder.this.getDistance(o2.getPos(), PathFinder.this.goal)) {
                    return -1;
                }
                if (PathFinder.this.getDistance(o1.getPos(), PathFinder.this.goal) > PathFinder.this.getDistance(o2.getPos(), PathFinder.this.goal)) {
                    return 1;
                }
                return 0;
            }
        });
        this.addPoint(start, null, 0, 0);
    }

    public boolean find() {
        long startTime = System.currentTimeMillis();
        boolean foundPath = false;
        while (!this.queue.isEmpty()) {
            this.lastPoint = this.queue.poll();
            this.processed.put(this.lastPoint.getPos(), this.lastPoint);
            if (this.lastPoint.getPos().equals(this.goal)) {
                foundPath = true;
                break;
            }
            if ((double)(System.currentTimeMillis() - startTime) > 10000.0) {
                System.err.println("Path finding took more than 10s. Aborting!");
                break;
            }
            for (BlockPos next : this.lastPoint.getNeighbors()) {
                if (!PathUtils.isSafe(next)) continue;
                int nextCost = PathUtils.getCost(this.lastPoint.getPos(), next);
                int newCost = this.lastPoint.getMovementCost() + nextCost;
                if (this.processed.containsKey(next) && this.processed.get(next).getMovementCost() <= newCost) continue;
                this.addPoint(next, this.lastPoint, newCost, newCost + this.getDistance(next, this.goal) * nextCost);
            }
        }
        System.out.println("Processed " + this.processed.size() + " nodes");
        return foundPath;
    }

    private void addPoint(BlockPos pos, PathPoint previous, int movementCost, int priority) {
        this.queue.add(new PathPoint(pos, previous, movementCost, priority));
    }

    private int getDistance(BlockPos a, BlockPos b) {
        return Math.abs(a.getX() - b.getX()) + Math.abs(a.getY() - b.getY()) + Math.abs(a.getZ() - b.getZ());
    }

    public PathPoint getRawPath() {
        return this.lastPoint;
    }

    public ArrayList<BlockPos> formatPath() {
        ArrayList<BlockPos> path = new ArrayList<BlockPos>();
        PathPoint point = this.lastPoint;
        while (point != null) {
            path.add(point.getPos());
            point = point.getPrevious();
        }
        Collections.reverse(path);
        int i = path.size() - 1;
        while (i > 1) {
            if (path.get(i).getX() == path.get(i - 2).getX() && path.get(i).getY() == path.get(i - 2).getY() || path.get(i).getX() == path.get(i - 2).getX() && path.get(i).getZ() == path.get(i - 2).getZ() || path.get(i).getY() == path.get(i - 2).getY() && path.get(i).getZ() == path.get(i - 2).getZ()) {
                path.remove(i - 1);
            }
            --i;
        }
        return path;
    }
}

