/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.ai;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.mods.AntiKnockbackMod;
import tk.wurst_client.mods.FlightMod;
import tk.wurst_client.mods.JesusMod;
import tk.wurst_client.mods.Mod;
import tk.wurst_client.mods.NoFallMod;
import tk.wurst_client.mods.NoSlowdownMod;
import tk.wurst_client.mods.SpiderMod;

public class PathUtils {
    private static PlayerCapabilities playerCaps;
    private static Mod antiKnockbackMod;
    private static Mod flightMod;
    private static Mod jesusMod;
    private static Mod noFallMod;
    private static Mod noSlowdownMod;
    private static Mod spiderMod;

    public static boolean isSafe(BlockPos pos) {
        boolean alwaysSafe;
        Material material = PathUtils.getMaterial(pos);
        int id = PathUtils.getID(pos);
        boolean bl = alwaysSafe = !material.blocksMovement() && id != 132;
        if (PathUtils.isCreative()) {
            return alwaysSafe;
        }
        Material materialBelow = PathUtils.getMaterial(pos.add(0, -1, 0));
        return alwaysSafe && material != Material.lava && materialBelow != Material.cactus && material != Material.fire;
    }

    public static boolean isSolid(BlockPos pos) {
        if (jesusMod == null) {
            jesusMod = WurstClient.INSTANCE.modManager.getModByClass(JesusMod.class);
        }
        return Minecraft.getMinecraft().theWorld.getBlockState(pos).getBlock().getMaterial().blocksMovement() || PathUtils.getMaterial(pos) == Material.water && jesusMod.isEnabled();
    }

    public static boolean isFallable(BlockPos pos) {
        int i = -1;
        while (i >= (PathUtils.isNoFall() ? -256 : -3)) {
            if (PathUtils.isSolid(pos.add(0, i, 0))) {
                return true;
            }
            --i;
        }
        return false;
    }

    public static boolean isClimbable(BlockPos pos) {
        if (spiderMod == null) {
            spiderMod = WurstClient.INSTANCE.modManager.getModByClass(SpiderMod.class);
        }
        return !(!PathUtils.isSolid(pos.add(0, -1, 0)) && !spiderMod.isEnabled() && PathUtils.getID(pos) != 65 && !PathUtils.isFlyable(pos) || !PathUtils.isSolid(pos.add(0, 0, -1)) && !PathUtils.isSolid(pos.add(0, 0, 1)) && !PathUtils.isSolid(pos.add(1, 0, 0)) && !PathUtils.isSolid(pos.add(-1, 0, 0)));
    }

    public static boolean isNoFall() {
        if (noFallMod == null) {
            noFallMod = WurstClient.INSTANCE.modManager.getModByClass(NoFallMod.class);
        }
        return noFallMod.isEnabled() || PathUtils.isCreative();
    }

    public static boolean isCreative() {
        if (playerCaps == null) {
            playerCaps = Minecraft.getMinecraft().thePlayer.capabilities;
        }
        return PathUtils.playerCaps.isCreativeMode;
    }

    public static boolean isFlyable(BlockPos pos) {
        if (flightMod == null) {
            flightMod = WurstClient.INSTANCE.modManager.getModByClass(FlightMod.class);
        }
        if (noSlowdownMod == null) {
            noSlowdownMod = WurstClient.INSTANCE.modManager.getModByClass(NoSlowdownMod.class);
        }
        if (playerCaps == null) {
            playerCaps = Minecraft.getMinecraft().thePlayer.capabilities;
        }
        return flightMod.isEnabled() || PathUtils.playerCaps.isFlying || !noSlowdownMod.isEnabled() && PathUtils.getMaterial(pos) == Material.water;
    }

    public static int getCost(BlockPos current, BlockPos next) {
        Material nextMaterial;
        if (noSlowdownMod == null) {
            noSlowdownMod = WurstClient.INSTANCE.modManager.getModByClass(NoSlowdownMod.class);
        }
        if (antiKnockbackMod == null) {
            antiKnockbackMod = WurstClient.INSTANCE.modManager.getModByClass(AntiKnockbackMod.class);
        }
        if ((nextMaterial = PathUtils.getMaterial(next)) == Material.water) {
            if (noSlowdownMod.isEnabled()) {
                return 1;
            }
            if (antiKnockbackMod.isEnabled()) {
                return 2;
            }
            return 3;
        }
        if (nextMaterial == Material.lava) {
            return 5;
        }
        return 1;
    }

    private static Material getMaterial(BlockPos pos) {
        return Minecraft.getMinecraft().theWorld.getBlockState(pos).getBlock().getMaterial();
    }

    private static int getID(BlockPos pos) {
        return Block.getIdFromBlock(Minecraft.getMinecraft().theWorld.getBlockState(pos).getBlock());
    }
}

