/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.bot.commands;

import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import tk.wurst_client.bot.commands.ChatCmd;
import tk.wurst_client.bot.commands.Command;
import tk.wurst_client.bot.commands.FixmeCmd;
import tk.wurst_client.bot.commands.HelpCmd;
import tk.wurst_client.bot.commands.JoinCmd;
import tk.wurst_client.bot.commands.LoginCmd;
import tk.wurst_client.bot.commands.ProxyCmd;
import tk.wurst_client.bot.commands.StopCmd;

public class CommandManager {
    private final TreeMap<String, Command> commands = new TreeMap(new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    });

    public CommandManager() {
        this.addCommand(new ChatCmd());
        this.addCommand(new FixmeCmd());
        this.addCommand(new HelpCmd());
        this.addCommand(new JoinCmd());
        this.addCommand(new LoginCmd());
        this.addCommand(new ProxyCmd());
        this.addCommand(new StopCmd());
    }

    public Command getCommandByClass(Class<?> commandClass) {
        return this.commands.get(commandClass.getAnnotation(Command.Info.class).name());
    }

    public Command getCommandByName(String name) {
        return this.commands.get(name);
    }

    public Collection<Command> getAllCommands() {
        return this.commands.values();
    }

    public int countCommands() {
        return this.commands.size();
    }

    private void addCommand(Command commmand) {
        this.commands.put(commmand.getName(), commmand);
    }
}

