/*
 * Decompiled with CFR 0.152.
 */
package tk.wurst_client.commands;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockPos;
import tk.wurst_client.WurstClient;
import tk.wurst_client.utils.EntityUtils;
import tk.wurst_client.utils.MiscUtils;

public abstract class Cmd {
    private String name = this.getClass().getAnnotation(Info.class).name();
    private String help = this.getClass().getAnnotation(Info.class).help();
    private String[] syntax = this.getClass().getAnnotation(Info.class).syntax();

    public String getName() {
        return this.name;
    }

    public String getHelp() {
        return this.help;
    }

    public String[] getSyntax() {
        return this.syntax;
    }

    public void printHelp() {
        String[] stringArray = this.help.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            WurstClient.INSTANCE.chat.message(line);
            ++n2;
        }
    }

    public void printSyntax() {
        String output = "\u00a7o." + this.name + "\u00a7r";
        if (this.syntax.length != 0) {
            output = String.valueOf(output) + " " + this.syntax[0];
            int i = 1;
            while (i < this.syntax.length) {
                output = String.valueOf(output) + "\n    " + this.syntax[i];
                ++i;
            }
        }
        String[] stringArray = output.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            WurstClient.INSTANCE.chat.message(line);
            ++n2;
        }
    }

    protected final int[] argsToPos(String ... args) throws Error {
        int[] pos = new int[3];
        if (args.length == 3) {
            int[] playerPos = new int[]{(int)Minecraft.getMinecraft().thePlayer.posX, (int)Minecraft.getMinecraft().thePlayer.posY, (int)Minecraft.getMinecraft().thePlayer.posZ};
            int i = 0;
            while (i < args.length) {
                if (MiscUtils.isInteger(args[i])) {
                    pos[i] = Integer.parseInt(args[i]);
                } else if (args[i].startsWith("~")) {
                    if (args[i].equals("~")) {
                        pos[i] = playerPos[i];
                    } else if (MiscUtils.isInteger(args[i].substring(1))) {
                        pos[i] = playerPos[i] + Integer.parseInt(args[i].substring(1));
                    } else {
                        this.syntaxError("Invalid coordinates.");
                    }
                } else {
                    this.syntaxError("Invalid coordinates.");
                }
                ++i;
            }
        } else if (args.length == 1) {
            EntityLivingBase entity = EntityUtils.searchEntityByNameRaw(args[0]);
            if (entity == null) {
                this.error("Entity \"" + args[0] + "\" could not be found.");
            }
            BlockPos blockPos = new BlockPos(entity);
            pos = new int[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()};
        } else {
            this.syntaxError("Invalid coordinates.");
        }
        return pos;
    }

    protected final void syntaxError() throws SyntaxError {
        throw new SyntaxError();
    }

    protected final void syntaxError(String message) throws SyntaxError {
        throw new SyntaxError(message);
    }

    protected final void error(String message) throws Error {
        throw new Error(message);
    }

    public abstract void execute(String[] var1) throws Error;

    public class Error
    extends Throwable {
        public Error() {
        }

        public Error(String message) {
            super(message);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Info {
        public String name();

        public String help();

        public String[] syntax();
    }

    public class SyntaxError
    extends Error {
        public SyntaxError() {
        }

        public SyntaxError(String message) {
            super(message);
        }
    }
}

